/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.math.BigInteger;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyComplex;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyRational;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.Convert;
import org.jruby.util.Numeric;

@JRubyClass(name={"Numeric"}, include={"Comparable"})
public class RubyNumeric
extends RubyObject {
    protected static final ObjectAllocator NUMERIC_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyNumeric(runtime2, klass);
        }
    };
    public static double DBL_EPSILON = 2.220446049250313E-16;

    public static RubyClass createNumericClass(Ruby runtime2) {
        RubyClass numeric = runtime2.defineClass("Numeric", runtime2.getObject(), NUMERIC_ALLOCATOR);
        runtime2.setNumeric(numeric);
        numeric.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject obj, RubyModule type2) {
                return obj instanceof RubyNumeric;
            }
        };
        numeric.includeModule(runtime2.getComparable());
        numeric.defineAnnotatedMethods(RubyNumeric.class);
        return numeric;
    }

    private static IRubyObject convertToNum(double val, Ruby runtime2) {
        if (val >= 9.223372036854776E18 || val < -9.223372036854776E18) {
            return RubyBignum.newBignum(runtime2, val);
        }
        return RubyFixnum.newFixnum(runtime2, (long)val);
    }

    public RubyNumeric(Ruby runtime2, RubyClass metaClass) {
        super(runtime2, metaClass);
    }

    public RubyNumeric(Ruby runtime2, RubyClass metaClass, boolean useObjectSpace) {
        super(runtime2, metaClass, useObjectSpace);
    }

    public double getDoubleValue() {
        return 0.0;
    }

    public long getLongValue() {
        return 0L;
    }

    public static RubyNumeric newNumeric(Ruby runtime2) {
        return new RubyNumeric(runtime2, runtime2.getNumeric());
    }

    public static int num2int(IRubyObject arg2) {
        long num = RubyNumeric.num2long(arg2);
        RubyNumeric.checkInt(arg2, num);
        return (int)num;
    }

    public static void checkInt(IRubyObject arg2, long num) {
        String s;
        if (num < Integer.MIN_VALUE) {
            s = "small";
        } else if (num > Integer.MAX_VALUE) {
            s = "big";
        } else {
            return;
        }
        throw arg2.getRuntime().newRangeError("integer " + num + " too " + s + " to convert to `int'");
    }

    public static byte num2chr(IRubyObject arg2) {
        String value2;
        if (arg2 instanceof RubyString && (value2 = ((RubyString)arg2).toString()) != null && value2.length() > 0) {
            return (byte)value2.charAt(0);
        }
        return (byte)RubyNumeric.num2int(arg2);
    }

    public static long num2long(IRubyObject arg2) {
        if (arg2 instanceof RubyFixnum) {
            return ((RubyFixnum)arg2).getLongValue();
        }
        if (arg2.isNil()) {
            throw arg2.getRuntime().newTypeError("no implicit conversion from nil to integer");
        }
        if (arg2 instanceof RubyFloat) {
            double aFloat = ((RubyFloat)arg2).getDoubleValue();
            if (aFloat <= 9.223372036854776E18 && aFloat >= -9.223372036854776E18) {
                return (long)aFloat;
            }
            throw arg2.getRuntime().newRangeError("float " + aFloat + " out of range of integer");
        }
        if (arg2 instanceof RubyBignum) {
            return RubyBignum.big2long((RubyBignum)arg2);
        }
        return arg2.convertToInteger().getLongValue();
    }

    public static IRubyObject dbl2num(Ruby runtime2, double val) {
        if (Double.isInfinite(val)) {
            throw runtime2.newFloatDomainError(val < 0.0 ? "-Infinity" : "Infinity");
        }
        if (Double.isNaN(val)) {
            throw runtime2.newFloatDomainError("NaN");
        }
        return RubyNumeric.convertToNum(val, runtime2);
    }

    public static double num2dbl(IRubyObject arg2) {
        if (arg2 instanceof RubyFloat) {
            return ((RubyFloat)arg2).getDoubleValue();
        }
        if (arg2 instanceof RubyString) {
            throw arg2.getRuntime().newTypeError("no implicit conversion to float from string");
        }
        if (arg2 == arg2.getRuntime().getNil()) {
            throw arg2.getRuntime().newTypeError("no implicit conversion to float from nil");
        }
        return arg2.convertToFloat().getDoubleValue();
    }

    public static IRubyObject dbl_cmp(Ruby runtime2, double a, double b) {
        if (Double.isNaN(a) || Double.isNaN(b)) {
            return runtime2.getNil();
        }
        if (a > b) {
            return RubyFixnum.one(runtime2);
        }
        if (a < b) {
            return RubyFixnum.minus_one(runtime2);
        }
        return RubyFixnum.zero(runtime2);
    }

    public static long fix2long(IRubyObject arg2) {
        return ((RubyFixnum)arg2).getLongValue();
    }

    public static int fix2int(IRubyObject arg2) {
        long num = arg2 instanceof RubyFixnum ? RubyNumeric.fix2long(arg2) : RubyNumeric.num2long(arg2);
        RubyNumeric.checkInt(arg2, num);
        return (int)num;
    }

    public static RubyInteger str2inum(Ruby runtime2, RubyString str, int base) {
        return RubyNumeric.str2inum(runtime2, str, base, false);
    }

    public static RubyNumeric int2fix(Ruby runtime2, long val) {
        return RubyFixnum.newFixnum(runtime2, val);
    }

    public static IRubyObject num2fix(IRubyObject val) {
        if (val instanceof RubyFixnum) {
            return val;
        }
        if (val instanceof RubyBignum) {
            throw val.getRuntime().newRangeError("integer " + val + " out of range of fixnum");
        }
        return RubyFixnum.newFixnum(val.getRuntime(), RubyNumeric.num2long(val));
    }

    public static RubyInteger str2inum(Ruby runtime2, RubyString str, int base, boolean strict) {
        if (base != 0 && (base < 2 || base > 36)) {
            throw runtime2.newArgumentError("illegal radix " + base);
        }
        ByteList bytes = str.getByteList();
        try {
            return runtime2.newFixnum(Convert.byteListToLong(bytes, base, strict));
        }
        catch (InvalidIntegerException e) {
            return RubyNumeric.str2inumIIE(strict, runtime2, str);
        }
        catch (NumberTooLargeException e) {
            return RubyNumeric.str2inumNTLE(strict, runtime2, str, bytes, base);
        }
    }

    private static RubyInteger str2inumIIE(boolean strict, Ruby runtime2, RubyString str) throws RaiseException {
        if (strict) {
            throw runtime2.newArgumentError("invalid value for Integer: " + str.callMethod(runtime2.getCurrentContext(), "inspect").toString());
        }
        return RubyFixnum.zero(runtime2);
    }

    private static RubyInteger str2inumNTLE(boolean strict, Ruby runtime2, RubyString str, ByteList bytes, int base) {
        try {
            BigInteger bi = Convert.byteListToBigInteger(bytes, base, strict);
            return new RubyBignum(runtime2, bi);
        }
        catch (InvalidIntegerException e2) {
            return RubyNumeric.str2inumIIE(strict, runtime2, str);
        }
    }

    public static RubyFloat str2fnum(Ruby runtime2, RubyString arg2) {
        return RubyNumeric.str2fnum(runtime2, arg2, false);
    }

    public static RubyFloat str2fnum(Ruby runtime2, RubyString arg2, boolean strict) {
        double ZERO = 0.0;
        try {
            return new RubyFloat(runtime2, Convert.byteListToDouble(arg2.getByteList(), strict));
        }
        catch (NumberFormatException e) {
            if (strict) {
                throw runtime2.newArgumentError("invalid value for Float(): " + arg2.callMethod(runtime2.getCurrentContext(), "inspect").toString());
            }
            return new RubyFloat(runtime2, 0.0);
        }
    }

    protected IRubyObject[] getCoerced(ThreadContext context, IRubyObject other, boolean error) {
        IRubyObject result;
        try {
            result = other.callMethod(context, "coerce", this);
        }
        catch (RaiseException e) {
            if (error) {
                throw this.getRuntime().newTypeError(other.getMetaClass().getName() + " can't be coerced into " + this.getMetaClass().getName());
            }
            return null;
        }
        if (!(result instanceof RubyArray) || ((RubyArray)result).getLength() != 2) {
            throw this.getRuntime().newTypeError("coerce must return [x, y]");
        }
        return ((RubyArray)result).toJavaArray();
    }

    protected IRubyObject callCoerced(ThreadContext context, String method2, IRubyObject other, boolean err) {
        IRubyObject[] args2 = this.getCoerced(context, other, err);
        if (args2 == null) {
            return this.getRuntime().getNil();
        }
        return args2[0].callMethod(context, method2, args2[1]);
    }

    protected IRubyObject callCoerced(ThreadContext context, String method2, IRubyObject other) {
        IRubyObject[] args2 = this.getCoerced(context, other, false);
        if (args2 == null) {
            return this.getRuntime().getNil();
        }
        return args2[0].callMethod(context, method2, args2[1]);
    }

    protected final IRubyObject coerceBody(ThreadContext context, IRubyObject other) {
        return other.callMethod(context, "coerce", this);
    }

    protected final RubyArray doCoerce(ThreadContext context, IRubyObject other, boolean err) {
        IRubyObject result;
        try {
            result = this.coerceBody(context, other);
        }
        catch (RaiseException e) {
            if (err) {
                throw this.getRuntime().newTypeError(other.getMetaClass().getName() + " can't be coerced into " + this.getMetaClass().getName());
            }
            return null;
        }
        if (!(result instanceof RubyArray) || ((RubyArray)result).getLength() != 2) {
            throw this.getRuntime().newTypeError("coerce must return [x, y]");
        }
        return (RubyArray)result;
    }

    protected final IRubyObject coerceBin(ThreadContext context, String method2, IRubyObject other) {
        RubyArray ary = this.doCoerce(context, other, true);
        return ary.eltInternal(0).callMethod(context, method2, ary.eltInternal(1));
    }

    protected final IRubyObject coerceCmp(ThreadContext context, String method2, IRubyObject other) {
        RubyArray ary = this.doCoerce(context, other, false);
        if (ary == null) {
            return this.getRuntime().getNil();
        }
        return ary.eltInternal(0).callMethod(context, method2, ary.eltInternal(1));
    }

    protected final IRubyObject coerceRelOp(ThreadContext context, String method2, IRubyObject other) {
        RubyArray ary = this.doCoerce(context, other, false);
        if (ary == null) {
            return RubyComparable.cmperr(this, other);
        }
        return this.unwrapCoerced(context, method2, other, ary);
    }

    private final IRubyObject unwrapCoerced(ThreadContext context, String method2, IRubyObject other, RubyArray ary) {
        IRubyObject result = ary.eltInternal(0).callMethod(context, method2, ary.eltInternal(1));
        if (result.isNil()) {
            return RubyComparable.cmperr(this, other);
        }
        return result;
    }

    public RubyNumeric asNumeric() {
        return this;
    }

    @JRubyMethod(name={"singleton_method_added"})
    public IRubyObject sadded(IRubyObject name2) {
        throw this.getRuntime().newTypeError("can't define singleton method " + name2 + " for " + this.getType().getName());
    }

    @JRubyMethod(name={"initialize_copy"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject arg2) {
        throw this.getRuntime().newTypeError("can't copy " + this.getType().getName());
    }

    @JRubyMethod(name={"coerce"})
    public IRubyObject coerce(IRubyObject other) {
        if (this.getClass() == other.getClass()) {
            return this.getRuntime().newArray(other, this);
        }
        IRubyObject cdr = RubyKernel.new_float(this, this);
        IRubyObject car = RubyKernel.new_float(this, other);
        return this.getRuntime().newArray(car, cdr);
    }

    @JRubyMethod(name={"+@"})
    public IRubyObject op_uplus() {
        return this;
    }

    @JRubyMethod(name={"-@"})
    public IRubyObject op_uminus(ThreadContext context) {
        RubyFixnum zero = RubyFixnum.zero(this.getRuntime());
        RubyArray ary = zero.doCoerce(context, this, true);
        return ary.eltInternal(0).callMethod(context, MethodIndex.OP_MINUS, "-", ary.eltInternal(1));
    }

    @JRubyMethod(name={"<=>"})
    public IRubyObject op_cmp(IRubyObject other) {
        if (this == other) {
            return RubyFixnum.zero(this.getRuntime());
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"eql?"})
    public IRubyObject eql_p(ThreadContext context, IRubyObject other) {
        if (this.getClass() != other.getClass()) {
            return this.getRuntime().getFalse();
        }
        return RubyNumeric.equalInternal(context, this, other) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"quo"})
    public IRubyObject quo(ThreadContext context, IRubyObject other) {
        return this.callMethod(context, "/", other);
    }

    @JRubyMethod(name={"quo"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject quo_19(ThreadContext context, IRubyObject other) {
        return RubyRational.newRationalRaw(context.getRuntime(), this).callMethod(context, "/", other);
    }

    @JRubyMethod(name={"div"})
    public IRubyObject div(ThreadContext context, IRubyObject other) {
        return this.callMethod(context, "/", other).convertToFloat().floor();
    }

    @JRubyMethod(name={"divmod"})
    public IRubyObject divmod(ThreadContext context, IRubyObject other) {
        return RubyArray.newArray(this.getRuntime(), this.div(context, other), this.modulo(context, other));
    }

    @JRubyMethod(name={"fdiv"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject fdiv(ThreadContext context, IRubyObject other) {
        return RuntimeHelpers.invoke(context, (IRubyObject)this.convertToFloat(), "/", other);
    }

    @JRubyMethod(name={"modulo"})
    public IRubyObject modulo(ThreadContext context, IRubyObject other) {
        return this.callMethod(context, "%", other);
    }

    @JRubyMethod(name={"remainder"})
    public IRubyObject remainder(ThreadContext context, IRubyObject dividend) {
        IRubyObject z = this.callMethod(context, "%", dividend);
        RubyNumeric x = this;
        RubyFixnum zero = RubyFixnum.zero(this.getRuntime());
        if (!RubyNumeric.equalInternal(context, z, zero) && (x.callMethod(context, MethodIndex.OP_LT, "<", zero).isTrue() && dividend.callMethod(context, MethodIndex.OP_GT, ">", zero).isTrue() || x.callMethod(context, MethodIndex.OP_GT, ">", zero).isTrue() && dividend.callMethod(context, MethodIndex.OP_LT, "<", zero).isTrue())) {
            return z.callMethod(context, MethodIndex.OP_MINUS, "-", dividend);
        }
        return z;
    }

    @JRubyMethod(name={"abs"})
    public IRubyObject abs(ThreadContext context) {
        if (this.callMethod(context, MethodIndex.OP_LT, "<", RubyFixnum.zero(this.getRuntime())).isTrue()) {
            return this.callMethod(context, "-@");
        }
        return this;
    }

    @JRubyMethod(name={"to_int"})
    public IRubyObject to_int(ThreadContext context) {
        return RuntimeHelpers.invoke(context, this, "to_i");
    }

    @JRubyMethod(name={"scalar?"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject scalar_p() {
        return this.getRuntime().getTrue();
    }

    @JRubyMethod(name={"integer?"})
    public IRubyObject integer_p() {
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"zero?"})
    public IRubyObject zero_p(ThreadContext context) {
        return RubyNumeric.equalInternal(context, this, RubyFixnum.zero(this.getRuntime())) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"nonzero?"})
    public IRubyObject nonzero_p(ThreadContext context) {
        if (this.callMethod(context, "zero?").isTrue()) {
            return this.getRuntime().getNil();
        }
        return this;
    }

    @JRubyMethod(name={"floor"})
    public IRubyObject floor() {
        return this.convertToFloat().floor();
    }

    @JRubyMethod(name={"ceil"})
    public IRubyObject ceil() {
        return this.convertToFloat().ceil();
    }

    @JRubyMethod(name={"round"})
    public IRubyObject round() {
        return this.convertToFloat().round();
    }

    @JRubyMethod(name={"truncate"})
    public IRubyObject truncate() {
        return this.convertToFloat().truncate();
    }

    @JRubyMethod(name={"step"}, required=1, optional=1, frame=true)
    public IRubyObject step(ThreadContext context, IRubyObject[] args2, Block block) {
        switch (args2.length) {
            case 0: {
                throw context.getRuntime().newArgumentError(0, 1);
            }
            case 1: {
                return this.step(context, args2[0], block);
            }
            case 2: {
                return this.step(context, args2[0], args2[1], block);
            }
        }
        throw context.getRuntime().newArgumentError(args2.length, 2);
    }

    @JRubyMethod(name={"step"}, frame=true)
    public IRubyObject step(ThreadContext context, IRubyObject arg0, Block block) {
        return this.step(context, arg0, RubyFixnum.one(context.getRuntime()), block);
    }

    @JRubyMethod(name={"step"}, frame=true)
    public IRubyObject step(ThreadContext context, IRubyObject to, IRubyObject step2, Block block) {
        if (this instanceof RubyFixnum && to instanceof RubyFixnum && step2 instanceof RubyFixnum) {
            long value2 = this.getLongValue();
            long end2 = ((RubyFixnum)to).getLongValue();
            long diff = ((RubyFixnum)step2).getLongValue();
            if (diff == 0L) {
                throw this.getRuntime().newArgumentError("step cannot be 0");
            }
            if (diff > 0L) {
                for (long i = value2; i <= end2; i += diff) {
                    block.yield(context, RubyFixnum.newFixnum(this.getRuntime(), i));
                }
            } else {
                for (long i = value2; i >= end2; i += diff) {
                    block.yield(context, RubyFixnum.newFixnum(this.getRuntime(), i));
                }
            }
        } else if (this instanceof RubyFloat || to instanceof RubyFloat || step2 instanceof RubyFloat) {
            double beg = RubyNumeric.num2dbl(this);
            double end3 = RubyNumeric.num2dbl(to);
            double unit = RubyNumeric.num2dbl(step2);
            if (unit == 0.0) {
                throw this.getRuntime().newArgumentError("step cannot be 0");
            }
            double n = (end3 - beg) / unit;
            double err = (Math.abs(beg) + Math.abs(end3) + Math.abs(end3 - beg)) / Math.abs(unit) * DBL_EPSILON;
            if (err > 0.5) {
                err = 0.5;
            }
            n = Math.floor(n + err) + 1.0;
            for (double i = 0.0; i < n; i += 1.0) {
                block.yield(context, RubyFloat.newFloat(this.getRuntime(), i * unit + beg));
            }
        } else {
            RubyNumeric i = this;
            int cmp2 = ((RubyBoolean)step2.callMethod(context, MethodIndex.OP_GT, ">", RubyFixnum.zero(this.getRuntime()))).isTrue() ? MethodIndex.OP_GT : MethodIndex.OP_LT;
            String cmpString = MethodIndex.NAMES.get(cmp2);
            while (!i.callMethod(context, cmp2, cmpString, to).isTrue()) {
                block.yield(context, i);
                i = (RubyNumeric)i.callMethod(context, MethodIndex.OP_PLUS, "+", step2);
            }
        }
        return this;
    }

    protected final IRubyObject op_num_equal(ThreadContext context, IRubyObject other) {
        if (this == other) {
            return this.getRuntime().getTrue();
        }
        return other.callMethod(context, MethodIndex.EQUALEQUAL, "==", this);
    }

    @JRubyMethod(name={"numerator"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject numerator(ThreadContext context) {
        return RubyRational.newRationalConvert(context, this).callMethod(context, "numerator");
    }

    @JRubyMethod(name={"denominator"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject denominator(ThreadContext context) {
        return RubyRational.newRationalConvert(context, this).callMethod(context, "denominator");
    }

    @JRubyMethod(name={"to_c"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject to_c(ThreadContext context) {
        return RubyComplex.newComplexCanonicalize(context, this);
    }

    @JRubyMethod(name={"re"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject re(ThreadContext context) {
        return RubyComplex.newComplexConvert(context, this);
    }

    @JRubyMethod(name={"im"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject im(ThreadContext context) {
        return RubyComplex.newComplexConvert(context, RubyFixnum.zero(context.getRuntime()), this);
    }

    @JRubyMethod(name={"real"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject real(ThreadContext context) {
        return this;
    }

    @JRubyMethod(name={"image", "imag"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject image(ThreadContext context) {
        return RubyFixnum.zero(context.getRuntime());
    }

    @JRubyMethod(name={"arg"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject arg(ThreadContext context) {
        if (!Numeric.f_negative_p(context, this)) {
            return RubyFixnum.zero(context.getRuntime());
        }
        return context.getRuntime().getMath().fastFetchConstant("PI");
    }

    @JRubyMethod(name={"polar"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject polar(ThreadContext context) {
        return context.getRuntime().newArray(Numeric.f_abs(context, this), Numeric.f_arg(context, this));
    }

    @JRubyMethod(name={"conjugate"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject conjugate(ThreadContext context) {
        return this;
    }

    public static class NumberTooLargeException
    extends NumberFormatException {
        private static final long serialVersionUID = -1835120694982699449L;

        public NumberTooLargeException() {
        }

        public NumberTooLargeException(String message) {
            super(message);
        }

        public Throwable fillInStackTrace() {
            return this;
        }
    }

    public static class InvalidIntegerException
    extends NumberFormatException {
        private static final long serialVersionUID = 55019452543252148L;

        public InvalidIntegerException() {
        }

        public InvalidIntegerException(String message) {
            super(message);
        }

        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

