/*
 * Decompiled with CFR 0.152.
 */
package org.joni.util;

import org.joni.util.Hash;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntArrayHash<V>
extends Hash<V> {
    public IntArrayHash() {
    }

    public IntArrayHash(int size2) {
        super(size2);
    }

    private int hashCode(int[] key) {
        switch (key.length) {
            case 1: {
                return key[0];
            }
            case 2: {
                return key[0] + key[1];
            }
            case 3: {
                return key[0] + key[1] + key[2];
            }
            case 4: {
                return key[0] + key[1] + key[2] + key[3];
            }
        }
        int h = 0;
        for (int i = 0; i < key.length; ++i) {
            h += key[i];
        }
        return h;
    }

    public V put(int[] key, V value2) {
        this.checkResize();
        int hash2 = IntArrayHash.hashValue(this.hashCode(key));
        int i = IntArrayHash.bucketIndex(hash2, this.table.length);
        OniIntArrayHashEntry entry = (OniIntArrayHashEntry)this.table[i];
        while (entry != null) {
            if (entry.hash == hash2 && entry.equals(key)) {
                entry.value = value2;
                return value2;
            }
            entry = (OniIntArrayHashEntry)entry.next;
        }
        this.table[i] = new OniIntArrayHashEntry<V>(hash2, this.table[i], value2, key);
        ++this.size;
        return null;
    }

    public void putDirect(int[] key, V value2) {
        this.checkResize();
        int hash2 = IntArrayHash.hashValue(this.hashCode(key));
        int i = IntArrayHash.bucketIndex(hash2, this.table.length);
        this.table[i] = new OniIntArrayHashEntry<V>(hash2, this.table[i], value2, key);
        ++this.size;
    }

    public V get(int ... key) {
        int hash2 = IntArrayHash.hashValue(this.hashCode(key));
        OniIntArrayHashEntry entry = (OniIntArrayHashEntry)this.table[IntArrayHash.bucketIndex(hash2, this.table.length)];
        while (entry != null) {
            if (entry.hash == hash2 && entry.equals(key)) {
                return (V)entry.value;
            }
            entry = (OniIntArrayHashEntry)entry.next;
        }
        return null;
    }

    public V delete(int ... key) {
        int hash2 = IntArrayHash.hashValue(this.hashCode(key));
        int i = IntArrayHash.bucketIndex(hash2, this.table.length);
        OniIntArrayHashEntry entry = (OniIntArrayHashEntry)this.table[i];
        if (entry == null) {
            return null;
        }
        if (entry.hash == hash2 && entry.equals(key)) {
            this.table[i] = entry.next;
            --this.size;
            return (V)entry.value;
        }
        while (entry.next != null) {
            Hash.OniHashEntry tmp = entry.next;
            if (tmp.hash == hash2 && entry.equals(key)) {
                entry.next = entry.next.next;
                --this.size;
                return tmp.value;
            }
            entry = (OniIntArrayHashEntry)entry.next;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OniIntArrayHashEntry<V>
    extends Hash.OniHashEntry<V> {
        public final int[] key;

        public OniIntArrayHashEntry(int hash2, Hash.OniHashEntry<V> next2, V value2, int[] key) {
            super(hash2, next2, value2);
            this.key = key;
        }

        public boolean equals(int[] key) {
            if (this.key == key) {
                return true;
            }
            if (this.key.length != key.length) {
                return false;
            }
            switch (key.length) {
                case 1: {
                    return this.key[0] == key[0];
                }
                case 2: {
                    return this.key[0] == key[0] && this.key[1] == key[1];
                }
                case 3: {
                    return this.key[0] == key[0] && this.key[1] == key[1] && this.key[2] == key[2];
                }
                case 4: {
                    return this.key[0] == key[0] && this.key[1] == key[1] && this.key[2] == key[2] && this.key[3] == key[3];
                }
            }
            for (int i = 0; i < key.length; ++i) {
                if (this.key[i] == key[i]) continue;
                return false;
            }
            return true;
        }
    }
}

