/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Callback;
import com.sun.jna.CallbackReference;
import com.sun.jna.FromNativeContext;
import com.sun.jna.FromNativeConverter;
import com.sun.jna.Function;
import com.sun.jna.IntegerType;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.NativeString;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.StructureReadContext;
import com.sun.jna.StructureWriteContext;
import com.sun.jna.ToNativeConverter;
import com.sun.jna.TypeMapper;
import com.sun.jna.Union;
import com.sun.jna.WString;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.Buffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public abstract class Structure {
    private static final boolean REVERSE_FIELDS;
    static final boolean isPPC;
    static final boolean isSPARC;
    public static final int ALIGN_DEFAULT = 0;
    public static final int ALIGN_NONE = 1;
    public static final int ALIGN_GNUC = 2;
    public static final int ALIGN_MSVC = 3;
    private static final int MAX_GNUC_ALIGNMENT;
    protected static final int CALCULATE_SIZE = -1;
    private Pointer memory;
    private int size = -1;
    private int alignType;
    private int structAlignment;
    private Map structFields = new LinkedHashMap();
    private Map nativeStrings = new HashMap();
    private TypeMapper typeMapper;
    private long typeInfo;
    private static Set reading;
    static /* synthetic */ Class class$com$sun$jna$NativeMapped;
    static /* synthetic */ Class class$java$lang$Void;
    static /* synthetic */ Class class$com$sun$jna$Union;

    protected Structure() {
        this(-1);
    }

    protected Structure(int size2) {
        this(size2, 0);
    }

    protected Structure(int size2, int alignment) {
        this.setAlignType(alignment);
        this.setTypeMapper(null);
        this.allocateMemory(size2);
    }

    Map fields() {
        return this.structFields;
    }

    protected void setTypeMapper(TypeMapper mapper) {
        Class<?> declaring;
        if (mapper == null && (declaring = this.getClass().getDeclaringClass()) != null) {
            mapper = Native.getTypeMapper(declaring);
        }
        this.typeMapper = mapper;
        this.size = -1;
        this.memory = null;
    }

    protected void setAlignType(int alignType) {
        if (alignType == 0) {
            Class<?> declaring = this.getClass().getDeclaringClass();
            if (declaring != null) {
                alignType = Native.getStructureAlignment(declaring);
            }
            if (alignType == 0) {
                alignType = Platform.isWindows() ? 3 : 2;
            }
        }
        this.alignType = alignType;
        this.size = -1;
        this.memory = null;
    }

    protected void useMemory(Pointer m) {
        this.useMemory(m, 0);
    }

    protected void useMemory(Pointer m, int offset2) {
        this.memory = m.share(offset2, this.size());
    }

    protected void allocateMemory() {
        this.allocateMemory(this.calculateSize(true));
    }

    protected void allocateMemory(int size2) {
        if (size2 == -1) {
            size2 = this.calculateSize(false);
        } else if (size2 <= 0) {
            throw new IllegalArgumentException("Structure size must be greater than zero: " + size2);
        }
        if (size2 != -1) {
            this.memory = new Memory(size2);
            this.memory.clear(size2);
            this.size = size2;
            if (this instanceof ByValue) {
                this.getTypeInfo();
            }
        }
    }

    public int size() {
        if (this.size == -1) {
            this.allocateMemory();
        }
        return this.size;
    }

    public void clear() {
        this.memory.clear(this.size());
    }

    public Pointer getPointer() {
        return this.memory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read() {
        Set set = reading;
        synchronized (set) {
            if (reading.contains(this)) {
                return;
            }
            reading.add(this);
        }
        Iterator i = this.structFields.values().iterator();
        while (i.hasNext()) {
            this.readField((StructField)i.next());
        }
        set = reading;
        synchronized (set) {
            reading.remove(this);
        }
    }

    public Object readField(String name2) {
        StructField f = (StructField)this.structFields.get(name2);
        if (f == null) {
            throw new IllegalArgumentException("No such field: " + name2);
        }
        return this.readField(f);
    }

    Object getField(StructField structField) {
        try {
            return structField.field.get(this);
        }
        catch (Exception e) {
            throw new Error("Exception reading field '" + structField.name + "' in " + this.getClass() + ": " + e);
        }
    }

    private void setField(StructField structField, Object value2) {
        try {
            structField.field.set(this, value2);
        }
        catch (IllegalAccessException e) {
            throw new Error("Unexpectedly unable to write to field '" + structField.name + "' within " + this.getClass() + ": " + e);
        }
    }

    static Structure updateStructureByReference(Class type2, Structure s, Pointer address2) {
        if (address2 == null) {
            s = null;
        } else {
            if (s == null || !address2.equals(s.getPointer())) {
                s = Structure.newInstance(type2);
                s.useMemory(address2);
            }
            s.read();
        }
        return s;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Object readField(StructField structField) {
        int offset2 = structField.offset;
        Class nativeType = structField.type;
        FromNativeConverter readConverter = structField.readConverter;
        if (readConverter != null) {
            nativeType = readConverter.nativeType();
        }
        Object result = null;
        if (Structure.class.isAssignableFrom(nativeType)) {
            Structure s = (Structure)this.getField(structField);
            if (ByReference.class.isAssignableFrom(nativeType)) {
                s = Structure.updateStructureByReference(nativeType, s, this.memory.getPointer(offset2));
            } else {
                s.useMemory(this.memory, offset2);
                s.read();
            }
            result = s;
        } else if (nativeType == Boolean.TYPE || nativeType == Boolean.class) {
            result = Function.valueOf(this.memory.getInt(offset2) != 0);
        } else if (nativeType == Byte.TYPE || nativeType == Byte.class) {
            result = new Byte(this.memory.getByte(offset2));
        } else if (nativeType == Short.TYPE || nativeType == Short.class) {
            result = new Short(this.memory.getShort(offset2));
        } else if (nativeType == Character.TYPE || nativeType == Character.class) {
            result = new Character(this.memory.getChar(offset2));
        } else if (nativeType == Integer.TYPE || nativeType == Integer.class) {
            result = new Integer(this.memory.getInt(offset2));
        } else if (nativeType == Long.TYPE || nativeType == Long.class) {
            result = new Long(this.memory.getLong(offset2));
        } else if (nativeType == Float.TYPE || nativeType == Float.class) {
            result = new Float(this.memory.getFloat(offset2));
        } else if (nativeType == Double.TYPE || nativeType == Double.class) {
            result = new Double(this.memory.getDouble(offset2));
        } else if (nativeType == Pointer.class) {
            result = this.memory.getPointer(offset2);
        } else if (nativeType == String.class) {
            Pointer p2 = this.memory.getPointer(offset2);
            result = p2 != null ? p2.getString(0L) : null;
        } else if (nativeType == WString.class) {
            Pointer p3 = this.memory.getPointer(offset2);
            result = p3 != null ? new WString(p3.getString(0L, true)) : null;
        } else if (Callback.class.isAssignableFrom(nativeType)) {
            Pointer fp = this.memory.getPointer(offset2);
            if (fp == null) {
                result = null;
            } else {
                Callback cb = (Callback)this.getField(structField);
                Pointer oldfp = CallbackReference.getFunctionPointer(cb);
                if (!fp.equals(oldfp)) {
                    cb = CallbackReference.getCallback(nativeType, fp);
                }
                result = cb;
            }
        } else {
            if (!nativeType.isArray()) throw new IllegalArgumentException("Unsupported field type \"" + nativeType + "\"");
            Class<?> cls = nativeType.getComponentType();
            int length2 = 0;
            Object o = this.getField(structField);
            if (o == null) {
                throw new IllegalStateException("Array field in Structure not initialized");
            }
            length2 = Array.getLength(o);
            result = o;
            if (cls == Byte.TYPE) {
                this.memory.read((long)offset2, (byte[])result, 0, length2);
            } else if (cls == Short.TYPE) {
                this.memory.read((long)offset2, (short[])result, 0, length2);
            } else if (cls == Character.TYPE) {
                this.memory.read((long)offset2, (char[])result, 0, length2);
            } else if (cls == Integer.TYPE) {
                this.memory.read((long)offset2, (int[])result, 0, length2);
            } else if (cls == Long.TYPE) {
                this.memory.read((long)offset2, (long[])result, 0, length2);
            } else if (cls == Float.TYPE) {
                this.memory.read((long)offset2, (float[])result, 0, length2);
            } else if (cls == Double.TYPE) {
                this.memory.read((long)offset2, (double[])result, 0, length2);
            } else if (Pointer.class.isAssignableFrom(cls)) {
                this.memory.read((long)offset2, (Pointer[])result, 0, length2);
            } else {
                if (!Structure.class.isAssignableFrom(cls)) throw new IllegalArgumentException("Array of " + cls + " not supported");
                Structure[] sarray = (Structure[])result;
                if (ByReference.class.isAssignableFrom(cls)) {
                    Pointer[] parray = this.memory.getPointerArray(offset2, sarray.length);
                    for (int i = 0; i < sarray.length; ++i) {
                        sarray[i] = Structure.updateStructureByReference(cls, sarray[i], parray[i]);
                    }
                } else {
                    for (int i = 0; i < sarray.length; ++i) {
                        if (sarray[i] == null) {
                            sarray[i] = Structure.newInstance(cls);
                        }
                        sarray[i].useMemory(this.memory, offset2 + i * sarray[i].size());
                        sarray[i].read();
                    }
                }
            }
        }
        if (readConverter != null) {
            result = readConverter.fromNative(result, structField.context);
        }
        this.setField(structField, result);
        return result;
    }

    public void write() {
        if (this.size == -1) {
            this.allocateMemory();
        }
        if (this instanceof ByValue) {
            this.getTypeInfo();
        }
        Iterator i = this.structFields.values().iterator();
        while (i.hasNext()) {
            StructField sf = (StructField)i.next();
            if (sf.isVolatile) continue;
            this.writeField(sf);
        }
    }

    public void writeField(String name2) {
        StructField f = (StructField)this.structFields.get(name2);
        if (f == null) {
            throw new IllegalArgumentException("No such field: " + name2);
        }
        this.writeField(f);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void writeField(StructField structField) {
        int offset2 = structField.offset;
        Object value2 = this.getField(structField);
        Class nativeType = structField.type;
        ToNativeConverter converter = structField.writeConverter;
        if (converter != null) {
            value2 = converter.toNative(value2, new StructureWriteContext(this, structField.field));
            nativeType = converter.nativeType();
        }
        if (String.class == nativeType || WString.class == nativeType) {
            boolean wide;
            boolean bl = wide = nativeType == WString.class;
            if (value2 != null) {
                NativeString nativeString = new NativeString(value2.toString(), wide);
                this.nativeStrings.put(structField.name, nativeString);
                value2 = nativeString.getPointer();
            } else {
                value2 = null;
            }
        }
        if (nativeType == Boolean.TYPE || nativeType == Boolean.class) {
            this.memory.setInt(offset2, Boolean.TRUE.equals(value2) ? -1 : 0);
            return;
        } else if (nativeType == Byte.TYPE || nativeType == Byte.class) {
            this.memory.setByte(offset2, (Byte)value2);
            return;
        } else if (nativeType == Short.TYPE || nativeType == Short.class) {
            this.memory.setShort(offset2, (Short)value2);
            return;
        } else if (nativeType == Character.TYPE || nativeType == Character.class) {
            this.memory.setChar(offset2, ((Character)value2).charValue());
            return;
        } else if (nativeType == Integer.TYPE || nativeType == Integer.class) {
            this.memory.setInt(offset2, (Integer)value2);
            return;
        } else if (nativeType == Long.TYPE || nativeType == Long.class) {
            this.memory.setLong(offset2, (Long)value2);
            return;
        } else if (nativeType == Float.TYPE || nativeType == Float.class) {
            this.memory.setFloat(offset2, ((Float)value2).floatValue());
            return;
        } else if (nativeType == Double.TYPE || nativeType == Double.class) {
            this.memory.setDouble(offset2, (Double)value2);
            return;
        } else if (nativeType == Pointer.class) {
            this.memory.setPointer(offset2, (Pointer)value2);
            return;
        } else if (nativeType == String.class) {
            this.memory.setPointer(offset2, (Pointer)value2);
            return;
        } else if (nativeType == WString.class) {
            this.memory.setPointer(offset2, (Pointer)value2);
            return;
        } else if (nativeType.isArray()) {
            Class<?> cls = nativeType.getComponentType();
            if (cls == Byte.TYPE) {
                byte[] byArray = (byte[])value2;
                this.memory.write((long)offset2, byArray, 0, byArray.length);
                return;
            } else if (cls == Short.TYPE) {
                short[] sArray = (short[])value2;
                this.memory.write((long)offset2, sArray, 0, sArray.length);
                return;
            } else if (cls == Character.TYPE) {
                char[] cArray = (char[])value2;
                this.memory.write((long)offset2, cArray, 0, cArray.length);
                return;
            } else if (cls == Integer.TYPE) {
                int[] nArray = (int[])value2;
                this.memory.write((long)offset2, nArray, 0, nArray.length);
                return;
            } else if (cls == Long.TYPE) {
                long[] lArray = (long[])value2;
                this.memory.write((long)offset2, lArray, 0, lArray.length);
                return;
            } else if (cls == Float.TYPE) {
                float[] fArray = (float[])value2;
                this.memory.write((long)offset2, fArray, 0, fArray.length);
                return;
            } else if (cls == Double.TYPE) {
                double[] dArray = (double[])value2;
                this.memory.write((long)offset2, dArray, 0, dArray.length);
                return;
            } else if (Pointer.class.isAssignableFrom(cls)) {
                Pointer[] pointerArray = (Pointer[])value2;
                this.memory.write((long)offset2, pointerArray, 0, pointerArray.length);
                return;
            } else {
                if (!Structure.class.isAssignableFrom(cls)) throw new IllegalArgumentException("Inline array of " + cls + " not supported");
                Structure[] structureArray = (Structure[])value2;
                if (ByReference.class.isAssignableFrom(cls)) {
                    Pointer[] buf = new Pointer[structureArray.length];
                    for (int i = 0; i < structureArray.length; ++i) {
                        buf[i] = structureArray[i] == null ? null : structureArray[i].getPointer();
                    }
                    this.memory.write((long)offset2, buf, 0, buf.length);
                    return;
                } else {
                    for (int i = 0; i < structureArray.length; ++i) {
                        if (structureArray[i] == null) {
                            structureArray[i] = Structure.newInstance(cls);
                        }
                        structureArray[i].useMemory(this.memory, offset2 + i * structureArray[i].size());
                        structureArray[i].write();
                    }
                }
            }
            return;
        } else if (Structure.class.isAssignableFrom(nativeType)) {
            Structure s = (Structure)value2;
            if (ByReference.class.isAssignableFrom(nativeType)) {
                this.memory.setPointer(offset2, s == null ? null : s.getPointer());
                return;
            } else {
                s.useMemory(this.memory, offset2);
                s.write();
            }
            return;
        } else if (Callback.class.isAssignableFrom(nativeType)) {
            this.memory.setPointer(offset2, CallbackReference.getFunctionPointer((Callback)value2));
            return;
        } else {
            String msg = "Structure field \"" + structField.name + "\" was declared as " + structField.type + (structField.type == nativeType ? "" : " (native type " + nativeType + ")") + ", which is not supported within a Structure";
            throw new IllegalArgumentException(msg);
        }
    }

    int calculateSize(boolean force) {
        int i;
        this.structAlignment = 1;
        int calculatedSize = 0;
        Field[] fields2 = this.getClass().getFields();
        if (REVERSE_FIELDS) {
            for (i = 0; i < fields2.length / 2; ++i) {
                int idx = fields2.length - 1 - i;
                Field tmp = fields2[i];
                fields2[i] = fields2[idx];
                fields2[idx] = tmp;
            }
        }
        for (i = 0; i < fields2.length; ++i) {
            Field field2 = fields2[i];
            int modifiers2 = field2.getModifiers();
            if (Modifier.isStatic(modifiers2) || !Modifier.isPublic(modifiers2)) continue;
            Class type2 = field2.getType();
            StructField structField = new StructField();
            structField.isVolatile = Modifier.isVolatile(modifiers2);
            structField.field = field2;
            structField.name = field2.getName();
            structField.type = type2;
            if ((class$com$sun$jna$Callback == null ? Structure.class$("com.sun.jna.Callback") : class$com$sun$jna$Callback).isAssignableFrom(type2) && !type2.isInterface()) {
                throw new IllegalArgumentException("Structure Callback field '" + field2.getName() + "' must be an interface");
            }
            if (type2.isArray() && (class$com$sun$jna$Structure == null ? Structure.class$("com.sun.jna.Structure") : class$com$sun$jna$Structure).equals(type2.getComponentType())) {
                String msg = "Nested Structure arrays must use a derived Structure type so that the size of the elements can be determined";
                throw new IllegalArgumentException(msg);
            }
            int fieldAlignment = 1;
            if (!Modifier.isPublic(field2.getModifiers())) continue;
            Object value2 = this.getField(structField);
            if (value2 == null) {
                if ((class$com$sun$jna$Structure == null ? Structure.class$("com.sun.jna.Structure") : class$com$sun$jna$Structure).isAssignableFrom(type2) && !(class$com$sun$jna$Structure$ByReference == null ? Structure.class$("com.sun.jna.Structure$ByReference") : class$com$sun$jna$Structure$ByReference).isAssignableFrom(type2)) {
                    try {
                        value2 = Structure.newInstance(type2);
                        this.setField(structField, value2);
                    }
                    catch (IllegalArgumentException e) {
                        String msg = "Can't determine size of nested structure: " + e.getMessage();
                        throw new IllegalArgumentException(msg);
                    }
                } else if (type2.isArray()) {
                    if (force) {
                        throw new IllegalStateException("Array fields must be initialized");
                    }
                    return -1;
                }
            }
            Class nativeType = type2;
            if ((class$com$sun$jna$NativeMapped == null ? Structure.class$("com.sun.jna.NativeMapped") : class$com$sun$jna$NativeMapped).isAssignableFrom(type2)) {
                NativeMappedConverter tc = NativeMappedConverter.getInstance(type2);
                value2 = tc.defaultValue();
                nativeType = tc.nativeType();
                structField.writeConverter = tc;
                structField.readConverter = tc;
                structField.context = new StructureReadContext(this, field2);
                this.setField(structField, value2);
            } else if (this.typeMapper != null) {
                ToNativeConverter writeConverter = this.typeMapper.getToNativeConverter(type2);
                FromNativeConverter readConverter = this.typeMapper.getFromNativeConverter(type2);
                if (writeConverter != null && readConverter != null) {
                    nativeType = (value2 = writeConverter.toNative(value2, new StructureWriteContext(this, structField.field))) != null ? value2.getClass() : (class$com$sun$jna$Pointer == null ? Structure.class$("com.sun.jna.Pointer") : class$com$sun$jna$Pointer);
                    structField.writeConverter = writeConverter;
                    structField.readConverter = readConverter;
                    structField.context = new StructureReadContext(this, field2);
                } else if (writeConverter != null || readConverter != null) {
                    String msg = "Structures require bidirectional type conversion for " + type2;
                    throw new IllegalArgumentException(msg);
                }
            }
            structField.size = Structure.getNativeSize(nativeType, value2);
            fieldAlignment = this.getNativeAlignment(nativeType, value2, i == 0);
            this.structAlignment = Math.max(this.structAlignment, fieldAlignment);
            if (calculatedSize % fieldAlignment != 0) {
                calculatedSize += fieldAlignment - calculatedSize % fieldAlignment;
            }
            structField.offset = calculatedSize;
            calculatedSize += structField.size;
            this.structFields.put(structField.name, structField);
        }
        if (calculatedSize > 0) {
            return this.calculateAlignedSize(calculatedSize);
        }
        throw new IllegalArgumentException("Structure " + this.getClass() + " has unknown size (ensure " + "all fields are public)");
    }

    int calculateAlignedSize(int calculatedSize) {
        if (this.alignType != 1 && calculatedSize % this.structAlignment != 0) {
            calculatedSize += this.structAlignment - calculatedSize % this.structAlignment;
        }
        return calculatedSize;
    }

    protected int getStructAlignment() {
        if (this.size == -1) {
            this.calculateSize(true);
        }
        return this.structAlignment;
    }

    protected int getNativeAlignment(Class type2, Object value2, boolean isFirstElement) {
        int alignment = 1;
        int size2 = Structure.getNativeSize(type2, value2);
        if (type2.isPrimitive() || Long.class == type2 || Integer.class == type2 || Short.class == type2 || Character.class == type2 || Byte.class == type2 || Float.class == type2 || Double.class == type2) {
            alignment = size2;
        } else if (Pointer.class == type2 || Buffer.class.isAssignableFrom(type2) || Callback.class.isAssignableFrom(type2) || WString.class == type2 || String.class == type2) {
            alignment = Pointer.SIZE;
        } else if (Structure.class.isAssignableFrom(type2)) {
            if (ByReference.class.isAssignableFrom(type2)) {
                alignment = Pointer.SIZE;
            } else {
                if (value2 == null) {
                    value2 = Structure.newInstance(type2);
                }
                alignment = ((Structure)value2).getStructAlignment();
            }
        } else if (type2.isArray()) {
            alignment = this.getNativeAlignment(type2.getComponentType(), null, isFirstElement);
        } else {
            throw new IllegalArgumentException("Type " + type2 + " has unknown " + "native alignment");
        }
        if (this.alignType == 1) {
            return 1;
        }
        if (this.alignType == 3) {
            return Math.min(8, alignment);
        }
        if (!(this.alignType != 2 || isFirstElement && isPPC)) {
            return Math.min(MAX_GNUC_ALIGNMENT, alignment);
        }
        return alignment;
    }

    private static int getNativeSize(Class type2, Object value2) {
        if (type2.isArray()) {
            int len = Array.getLength(value2);
            if (len > 0) {
                Object o = Array.get(value2, 0);
                return len * Structure.getNativeSize(type2.getComponentType(), o);
            }
            throw new IllegalArgumentException("Arrays of length zero not allowed in structure: " + type2);
        }
        if (Buffer.class.isAssignableFrom(type2)) {
            throw new IllegalArgumentException("the type \"" + type2.getName() + "\" is not supported as a structure field");
        }
        if (Structure.class.isAssignableFrom(type2) && !ByReference.class.isAssignableFrom(type2)) {
            if (value2 == null) {
                value2 = Structure.newInstance(type2);
            }
            return ((Structure)value2).size();
        }
        try {
            return Native.getNativeSize(type2);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("The type \"" + type2.getName() + "\" is not supported as a structure field");
        }
    }

    public String toString() {
        return this.toString(0);
    }

    private String format(Class type2) {
        String s = type2.getName();
        int dot = s.lastIndexOf(".");
        return s.substring(dot + 1);
    }

    private String toString(int indent) {
        String LS = System.getProperty("line.separator");
        String name2 = this.format(this.getClass()) + "(" + this.getPointer() + ")";
        if (!(this.getPointer() instanceof Memory)) {
            name2 = name2 + " (" + this.size() + " bytes)";
        }
        String prefix = "";
        for (int idx = 0; idx < indent; ++idx) {
            prefix = prefix + "  ";
        }
        String contents = "";
        Iterator i = this.structFields.values().iterator();
        while (i.hasNext()) {
            StructField sf = (StructField)i.next();
            Object value2 = this.getField(sf);
            String type2 = this.format(sf.type);
            String index2 = "";
            contents = contents + prefix;
            if (sf.type.isArray() && value2 != null) {
                type2 = this.format(sf.type.getComponentType());
                index2 = "[" + Array.getLength(value2) + "]";
            }
            contents = contents + "  " + type2 + " " + sf.name + index2 + "@" + Integer.toHexString(sf.offset);
            if (value2 instanceof Structure) {
                if (value2 instanceof ByReference) {
                    String v = value2.toString();
                    if (v.indexOf(LS) != -1) {
                        v = v.substring(0, v.indexOf(LS));
                    }
                    value2 = v + "...}";
                } else {
                    value2 = ((Structure)value2).toString(indent + 1);
                }
            }
            contents = contents + "=" + String.valueOf(value2).trim();
            contents = contents + LS;
            if (i.hasNext()) continue;
            contents = contents + prefix + "}";
        }
        if (indent == 0 && Boolean.getBoolean("jna.dump_memory")) {
            byte[] buf = this.getPointer().getByteArray(0L, this.size());
            int BYTES_PER_ROW = 4;
            contents = contents + LS + "memory dump" + LS;
            for (int i2 = 0; i2 < buf.length; ++i2) {
                if (i2 % 4 == 0) {
                    contents = contents + "[";
                }
                if (buf[i2] >= 0 && buf[i2] < 16) {
                    contents = contents + "0";
                }
                contents = contents + Integer.toHexString(buf[i2] & 0xFF);
                if (i2 % 4 != 3 || i2 >= buf.length - 1) continue;
                contents = contents + "]" + LS;
            }
            contents = contents + "]";
        }
        return name2 + " {" + LS + contents;
    }

    public Structure[] toArray(Structure[] array) {
        if (this.size == -1) {
            this.allocateMemory();
        }
        if (Memory.class.equals(this.memory.getClass())) {
            Memory m = (Memory)this.memory;
            int requiredSize = array.length * this.size();
            if (m.getSize() < (long)requiredSize) {
                m = new Memory(requiredSize);
                m.clear();
                this.useMemory(m);
            }
        }
        array[0] = this;
        int size2 = this.size();
        for (int i = 1; i < array.length; ++i) {
            array[i] = Structure.newInstance(this.getClass());
            array[i].useMemory(this.memory.share(i * size2, size2));
            array[i].read();
        }
        return array;
    }

    public Structure[] toArray(int size2) {
        return this.toArray((Structure[])Array.newInstance(this.getClass(), size2));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Structure && ((Structure)o).size() == this.size() && (o.getClass().isAssignableFrom(this.getClass()) || this.getClass().isAssignableFrom(o.getClass()))) {
            Structure s = (Structure)o;
            Pointer p1 = this.getPointer();
            Pointer p2 = s.getPointer();
            for (int i = 0; i < this.size(); ++i) {
                if (p1.getByte(i) == p2.getByte(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.getPointer().hashCode();
    }

    Pointer getTypeInfo() {
        Pointer p2 = Structure.getTypeInfo(this);
        this.typeInfo = p2.peer;
        return p2;
    }

    static Pointer getTypeInfo(Object obj) {
        return FFIType.get(obj);
    }

    public static Structure newInstance(Class type2) throws IllegalArgumentException {
        try {
            Structure s = (Structure)type2.newInstance();
            if (s instanceof ByValue) {
                s.allocateMemory();
            }
            return s;
        }
        catch (InstantiationException e) {
            String msg = "Can't instantiate " + type2 + " (" + e + ")";
            throw new IllegalArgumentException(msg);
        }
        catch (IllegalAccessException e) {
            String msg = "Instantiation of " + type2 + " not allowed, is it public? (" + e + ")";
            throw new IllegalArgumentException(msg);
        }
    }

    static {
        Field[] fields2 = MemberOrder.class.getFields();
        REVERSE_FIELDS = "last".equals(fields2[0].getName());
        if (!"middle".equals(fields2[1].getName())) {
            throw new Error("This VM does not store fields in a predictable order");
        }
        String arch = System.getProperty("os.arch").toLowerCase();
        isPPC = "ppc".equals(arch) || "powerpc".equals(arch);
        isSPARC = "sparc".equals(arch);
        MAX_GNUC_ALIGNMENT = isSPARC ? 8 : NativeLong.SIZE;
        reading = new HashSet();
    }

    private static class FFIType
    extends Structure {
        private static Map typeInfoMap = new WeakHashMap();
        private static final int FFI_TYPE_STRUCT = 13;
        public size_t size;
        public short alignment;
        public short type = (short)13;
        public Pointer elements;

        private FFIType(Structure ref) {
            Pointer[] els = new Pointer[ref.fields().size() + 1];
            int idx = 0;
            Iterator i = ref.fields().values().iterator();
            while (i.hasNext()) {
                StructField sf = (StructField)i.next();
                els[idx++] = FFIType.get(ref.getField(sf), sf.type);
            }
            this.init(els);
        }

        private FFIType(Object array, Class type2) {
            int length2 = Array.getLength(array);
            Pointer[] els = new Pointer[length2 + 1];
            Pointer p2 = FFIType.get(null, type2.getComponentType());
            for (int i = 0; i < length2; ++i) {
                els[i] = p2;
            }
            this.init(els);
        }

        private void init(Pointer[] els) {
            this.elements = new Memory(Pointer.SIZE * els.length);
            this.elements.write(0L, els, 0, els.length);
            this.write();
        }

        static Pointer get(Object obj) {
            if (obj == null) {
                return FFITypes.ffi_type_pointer;
            }
            return FFIType.get(obj, obj.getClass());
        }

        private static Pointer get(Object obj, Class cls) {
            Map map = typeInfoMap;
            synchronized (map) {
                Object o = typeInfoMap.get(cls);
                if (o instanceof Pointer) {
                    return (Pointer)o;
                }
                if (o instanceof FFIType) {
                    return ((FFIType)o).getPointer();
                }
                if ((class$java$nio$Buffer == null ? (class$java$nio$Buffer = Structure.class$("java.nio.Buffer")) : class$java$nio$Buffer).isAssignableFrom(cls) || (class$com$sun$jna$Callback == null ? (class$com$sun$jna$Callback = Structure.class$("com.sun.jna.Callback")) : class$com$sun$jna$Callback).isAssignableFrom(cls)) {
                    typeInfoMap.put(cls, FFITypes.ffi_type_pointer);
                    return FFITypes.ffi_type_pointer;
                }
                if ((class$com$sun$jna$Structure == null ? (class$com$sun$jna$Structure = Structure.class$("com.sun.jna.Structure")) : class$com$sun$jna$Structure).isAssignableFrom(cls)) {
                    if (obj == null) {
                        obj = FFIType.newInstance(cls);
                    }
                    if ((class$com$sun$jna$Structure$ByReference == null ? (class$com$sun$jna$Structure$ByReference = Structure.class$("com.sun.jna.Structure$ByReference")) : class$com$sun$jna$Structure$ByReference).isAssignableFrom(cls)) {
                        typeInfoMap.put(cls, FFITypes.ffi_type_pointer);
                        return FFITypes.ffi_type_pointer;
                    }
                    if ((class$com$sun$jna$Union == null ? (class$com$sun$jna$Union = Structure.class$("com.sun.jna.Union")) : class$com$sun$jna$Union).isAssignableFrom(cls)) {
                        return ((Union)obj).getTypeInfo();
                    }
                    FFIType type2 = new FFIType((Structure)obj);
                    typeInfoMap.put(cls, type2);
                    return type2.getPointer();
                }
                if (cls.isArray()) {
                    FFIType type3 = new FFIType(obj, cls);
                    typeInfoMap.put(obj, type3);
                    return type3.getPointer();
                }
                throw new IllegalArgumentException("Unsupported structure field type " + cls);
            }
        }

        static {
            if (Native.POINTER_SIZE == 0) {
                throw new Error("Native library not initialized");
            }
            if (FFITypes.ffi_type_void == null) {
                throw new Error("FFI types not initialized");
            }
            typeInfoMap.put(Void.TYPE, FFITypes.ffi_type_void);
            typeInfoMap.put(class$java$lang$Void == null ? (class$java$lang$Void = Structure.class$("java.lang.Void")) : class$java$lang$Void, FFITypes.ffi_type_void);
            typeInfoMap.put(Float.TYPE, FFITypes.ffi_type_float);
            typeInfoMap.put(class$java$lang$Float == null ? (class$java$lang$Float = Structure.class$("java.lang.Float")) : class$java$lang$Float, FFITypes.ffi_type_float);
            typeInfoMap.put(Double.TYPE, FFITypes.ffi_type_double);
            typeInfoMap.put(class$java$lang$Double == null ? (class$java$lang$Double = Structure.class$("java.lang.Double")) : class$java$lang$Double, FFITypes.ffi_type_double);
            typeInfoMap.put(Long.TYPE, FFITypes.ffi_type_sint64);
            typeInfoMap.put(class$java$lang$Long == null ? (class$java$lang$Long = Structure.class$("java.lang.Long")) : class$java$lang$Long, FFITypes.ffi_type_sint64);
            typeInfoMap.put(Integer.TYPE, FFITypes.ffi_type_sint32);
            typeInfoMap.put(class$java$lang$Integer == null ? (class$java$lang$Integer = Structure.class$("java.lang.Integer")) : class$java$lang$Integer, FFITypes.ffi_type_sint32);
            typeInfoMap.put(Short.TYPE, FFITypes.ffi_type_sint16);
            typeInfoMap.put(class$java$lang$Short == null ? (class$java$lang$Short = Structure.class$("java.lang.Short")) : class$java$lang$Short, FFITypes.ffi_type_sint16);
            Pointer ctype = Native.WCHAR_SIZE == 2 ? FFITypes.ffi_type_uint16 : FFITypes.ffi_type_uint32;
            typeInfoMap.put(Character.TYPE, ctype);
            typeInfoMap.put(class$java$lang$Character == null ? (class$java$lang$Character = Structure.class$("java.lang.Character")) : class$java$lang$Character, ctype);
            typeInfoMap.put(Byte.TYPE, FFITypes.ffi_type_sint8);
            typeInfoMap.put(class$java$lang$Byte == null ? (class$java$lang$Byte = Structure.class$("java.lang.Byte")) : class$java$lang$Byte, FFITypes.ffi_type_sint8);
            typeInfoMap.put(class$com$sun$jna$Pointer == null ? (class$com$sun$jna$Pointer = Structure.class$("com.sun.jna.Pointer")) : class$com$sun$jna$Pointer, FFITypes.ffi_type_pointer);
            typeInfoMap.put(class$java$lang$String == null ? (class$java$lang$String = Structure.class$("java.lang.String")) : class$java$lang$String, FFITypes.ffi_type_pointer);
            typeInfoMap.put(class$com$sun$jna$WString == null ? (class$com$sun$jna$WString = Structure.class$("com.sun.jna.WString")) : class$com$sun$jna$WString, FFITypes.ffi_type_pointer);
        }

        private static class FFITypes {
            private static Pointer ffi_type_void;
            private static Pointer ffi_type_float;
            private static Pointer ffi_type_double;
            private static Pointer ffi_type_longdouble;
            private static Pointer ffi_type_uint8;
            private static Pointer ffi_type_sint8;
            private static Pointer ffi_type_uint16;
            private static Pointer ffi_type_sint16;
            private static Pointer ffi_type_uint32;
            private static Pointer ffi_type_sint32;
            private static Pointer ffi_type_uint64;
            private static Pointer ffi_type_sint64;
            private static Pointer ffi_type_pointer;

            private FFITypes() {
            }
        }

        public static class size_t
        extends IntegerType {
            public size_t() {
                this(0L);
            }

            public size_t(long value2) {
                super(Native.POINTER_SIZE, value2);
            }
        }
    }

    class StructField {
        public String name;
        public Class type;
        public Field field;
        public int size = -1;
        public int offset = -1;
        public boolean isVolatile;
        public FromNativeConverter readConverter;
        public ToNativeConverter writeConverter;
        public FromNativeContext context;

        StructField() {
        }
    }

    private static class MemberOrder {
        public int first;
        public int middle;
        public int last;

        private MemberOrder() {
        }
    }

    public static interface ByReference {
    }

    public static interface ByValue {
    }
}

