/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.AltCallingConvention;
import com.sun.jna.Callback;
import com.sun.jna.CallbackParameterContext;
import com.sun.jna.CallbackProxy;
import com.sun.jna.CallbackResultContext;
import com.sun.jna.FromNativeConverter;
import com.sun.jna.Function;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeMapped;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.NativeString;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ToNativeConverter;
import com.sun.jna.TypeMapper;
import com.sun.jna.WString;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

class CallbackReference
extends WeakReference {
    static final Map callbackMap = new WeakHashMap();
    static final Map altCallbackMap = new WeakHashMap();
    private static final Map nativeStrings = new WeakHashMap();
    Pointer cbstruct;
    CallbackProxy proxy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Callback getCallback(Class type2, Pointer p2) {
        if (p2 != null) {
            Map map;
            if (!type2.isInterface()) {
                throw new IllegalArgumentException("Callback type must be an interface");
            }
            Map map2 = map = AltCallingConvention.class.isAssignableFrom(type2) ? altCallbackMap : callbackMap;
            synchronized (map2) {
                Iterator i = map.keySet().iterator();
                while (i.hasNext()) {
                    CallbackReference cbref;
                    Pointer cbp;
                    Callback cb = (Callback)i.next();
                    if (!type2.isAssignableFrom(cb.getClass()) || !p2.equals(cbp = (cbref = (CallbackReference)map.get(cb)) != null ? cbref.getTrampoline() : CallbackReference.getNativeFunctionPointer(cb))) continue;
                    return cb;
                }
                int ctype = AltCallingConvention.class.isAssignableFrom(type2) ? 1 : 0;
                Map options2 = Native.getLibraryOptions(type2);
                NativeFunctionHandler h = new NativeFunctionHandler(p2, ctype, options2);
                Callback cb = (Callback)Proxy.newProxyInstance(type2.getClassLoader(), new Class[]{type2, NativeFunctionProxy.class}, (InvocationHandler)h);
                h.options.put("invoking-method", CallbackReference.getCallbackMethod(cb));
                map.put(cb, null);
                return cb;
            }
        }
        return null;
    }

    private static Class getCallbackClass(Class type2) {
        Class<?>[] ifaces = type2.getInterfaces();
        for (int i = 0; i < ifaces.length; ++i) {
            if (!(class$com$sun$jna$Callback == null ? CallbackReference.class$("com.sun.jna.Callback") : class$com$sun$jna$Callback).isAssignableFrom(ifaces[i])) continue;
            type2 = ifaces[i];
            break;
        }
        return type2;
    }

    private CallbackReference(Callback callback, int callingConvention) {
        super(callback);
        Class type2 = CallbackReference.getCallbackClass(callback.getClass());
        TypeMapper mapper = Native.getTypeMapper(type2);
        Method m = CallbackReference.getCallbackMethod(callback);
        this.proxy = callback instanceof CallbackProxy ? (CallbackProxy)callback : new DefaultCallbackProxy(m, mapper);
        Class[] nativeParamTypes = this.proxy.getParameterTypes();
        Class returnType = this.proxy.getReturnType();
        if (mapper != null) {
            for (int i = 0; i < nativeParamTypes.length; ++i) {
                FromNativeConverter rc = mapper.getFromNativeConverter(nativeParamTypes[i]);
                if (rc == null) continue;
                nativeParamTypes[i] = rc.nativeType();
            }
            ToNativeConverter tn = mapper.getToNativeConverter(returnType);
            if (tn != null) {
                returnType = tn.nativeType();
            }
        }
        for (int i = 0; i < nativeParamTypes.length; ++i) {
            nativeParamTypes[i] = this.getNativeType(nativeParamTypes[i]);
            if (CallbackReference.isAllowableNativeType(nativeParamTypes[i])) continue;
            String msg = "Callback argument " + nativeParamTypes[i] + " requires custom type conversion";
            throw new IllegalArgumentException(msg);
        }
        if (!CallbackReference.isAllowableNativeType(returnType = this.getNativeType(returnType))) {
            String msg = "Callback return type " + returnType + " requires custom type conversion";
            throw new IllegalArgumentException(msg);
        }
        Method proxyMethod = CallbackReference.getCallbackMethod(this.proxy);
        this.cbstruct = CallbackReference.createNativeCallback(this.proxy, proxyMethod, nativeParamTypes, returnType, callingConvention);
    }

    private Class getNativeType(Class cls) {
        if (Structure.class.isAssignableFrom(cls)) {
            Structure.newInstance(cls);
            if (!Structure.ByValue.class.isAssignableFrom(cls)) {
                return Pointer.class;
            }
        } else {
            if (NativeMapped.class.isAssignableFrom(cls)) {
                return NativeMappedConverter.getInstance(cls).nativeType();
            }
            if (cls == String.class || cls == WString.class || Callback.class.isAssignableFrom(cls)) {
                return Pointer.class;
            }
        }
        return cls;
    }

    private static Method getCallbackMethod(Callback callback) {
        Method[] mlist = callback.getClass().getMethods();
        for (int mi = 0; mi < mlist.length; ++mi) {
            Method m = mlist[mi];
            if (!"callback".equals(m.getName())) continue;
            if (m.getParameterTypes().length > 256) {
                String msg = "Method signature exceeds the maximum parameter count: " + m;
                throw new IllegalArgumentException(msg);
            }
            return m;
        }
        String msg = "Callback must implement method named 'callback'";
        throw new IllegalArgumentException(msg);
    }

    public Pointer getTrampoline() {
        return this.cbstruct.getPointer(0L);
    }

    protected void finalize() {
        CallbackReference.freeNativeCallback(this.cbstruct.peer);
        this.cbstruct.peer = 0L;
    }

    private Callback getCallback() {
        return (Callback)this.get();
    }

    private static Pointer getNativeFunctionPointer(Callback cb) {
        if (cb instanceof NativeFunctionProxy) {
            NativeFunctionHandler handler = (NativeFunctionHandler)Proxy.getInvocationHandler(cb);
            return handler.getPointer();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pointer getFunctionPointer(Callback cb) {
        Map map;
        Pointer fp = null;
        if (cb == null) {
            return null;
        }
        fp = CallbackReference.getNativeFunctionPointer(cb);
        if (fp != null) {
            return fp;
        }
        int callingConvention = cb instanceof AltCallingConvention ? 1 : 0;
        Map map2 = map = callingConvention == 1 ? altCallbackMap : callbackMap;
        synchronized (map2) {
            CallbackReference cbref = (CallbackReference)map.get(cb);
            if (cbref == null) {
                cbref = new CallbackReference(cb, callingConvention);
                map.put(cb, cbref);
            }
            return cbref.getTrampoline();
        }
    }

    private static boolean isAllowableNativeType(Class cls) {
        return cls == Void.TYPE || cls == Void.class || cls == Boolean.TYPE || cls == Boolean.class || cls == Byte.TYPE || cls == Byte.class || cls == Short.TYPE || cls == Short.class || cls == Character.TYPE || cls == Character.class || cls == Integer.TYPE || cls == Integer.class || cls == Long.TYPE || cls == Long.class || cls == Float.TYPE || cls == Float.class || cls == Double.TYPE || cls == Double.class || Structure.ByValue.class.isAssignableFrom(cls) && Structure.class.isAssignableFrom(cls) || Pointer.class.isAssignableFrom(cls);
    }

    private static synchronized native Pointer createNativeCallback(CallbackProxy var0, Method var1, Class[] var2, Class var3, int var4);

    private static synchronized native void freeNativeCallback(long var0);

    private static class NativeFunctionHandler
    implements InvocationHandler {
        private Function function;
        private Map options;

        public NativeFunctionHandler(Pointer address2, int callingConvention, Map libOptions) {
            this.function = new Function(address2, callingConvention){

                public String getName() {
                    String str = super.getName();
                    if (NativeFunctionHandler.this.options.containsKey("invoking-method")) {
                        Method m = (Method)NativeFunctionHandler.this.options.get("invoking-method");
                        Class cls = CallbackReference.getCallbackClass(m.getDeclaringClass());
                        str = str + " (" + cls.getName() + ")";
                    }
                    return str;
                }
            };
            this.options = new HashMap();
            if (libOptions != null) {
                this.options.putAll(libOptions);
            }
        }

        public Object invoke(Object proxy2, Method method2, Object[] args2) throws Throwable {
            if (Library.Handler.OBJECT_TOSTRING.equals(method2)) {
                return "Proxy interface to " + this.function;
            }
            if (Library.Handler.OBJECT_HASHCODE.equals(method2)) {
                return new Integer(this.hashCode());
            }
            if (Library.Handler.OBJECT_EQUALS.equals(method2)) {
                Object o = args2[0];
                if (o != null && Proxy.isProxyClass(o.getClass())) {
                    return Function.valueOf(Proxy.getInvocationHandler(o) == this);
                }
                return Boolean.FALSE;
            }
            if (Function.isVarArgs(method2)) {
                args2 = Function.concatenateVarArgs(args2);
            }
            return this.function.invoke(method2.getReturnType(), args2, this.options);
        }

        public Pointer getPointer() {
            return this.function;
        }
    }

    private class DefaultCallbackProxy
    implements CallbackProxy {
        private Method callbackMethod;
        private ToNativeConverter toNative;
        private FromNativeConverter[] fromNative;

        public DefaultCallbackProxy(Method callbackMethod, TypeMapper mapper) {
            this.callbackMethod = callbackMethod;
            Class<?>[] argTypes = callbackMethod.getParameterTypes();
            Class<?> returnType = callbackMethod.getReturnType();
            this.fromNative = new FromNativeConverter[argTypes.length];
            if ((class$com$sun$jna$NativeMapped == null ? (class$com$sun$jna$NativeMapped = CallbackReference.class$("com.sun.jna.NativeMapped")) : class$com$sun$jna$NativeMapped).isAssignableFrom(returnType)) {
                this.toNative = NativeMappedConverter.getInstance(returnType);
            } else if (mapper != null) {
                this.toNative = mapper.getToNativeConverter(returnType);
            }
            for (int i = 0; i < this.fromNative.length; ++i) {
                if ((class$com$sun$jna$NativeMapped == null ? CallbackReference.class$("com.sun.jna.NativeMapped") : class$com$sun$jna$NativeMapped).isAssignableFrom(argTypes[i])) {
                    this.fromNative[i] = new NativeMappedConverter(argTypes[i]);
                    continue;
                }
                if (mapper == null) continue;
                this.fromNative[i] = mapper.getFromNativeConverter(argTypes[i]);
            }
            if (!callbackMethod.isAccessible()) {
                try {
                    callbackMethod.setAccessible(true);
                }
                catch (SecurityException e) {
                    throw new IllegalArgumentException("Callback method is inaccessible, make sure the interface is public: " + callbackMethod);
                }
            }
        }

        private Object callback_inner(Object[] args2) {
            Class<?>[] paramTypes = this.callbackMethod.getParameterTypes();
            Object[] callbackArgs = new Object[args2.length];
            for (int i = 0; i < args2.length; ++i) {
                Class<?> type2 = paramTypes[i];
                Object arg2 = args2[i];
                if (this.fromNative[i] != null) {
                    CallbackParameterContext context = new CallbackParameterContext(type2, this.callbackMethod, args2, i);
                    arg2 = this.fromNative[i].fromNative(arg2, context);
                }
                callbackArgs[i] = this.convertArgument(arg2, type2);
            }
            Object result = null;
            Callback cb = CallbackReference.this.getCallback();
            if (cb != null) {
                try {
                    result = this.convertResult(this.callbackMethod.invoke((Object)cb, callbackArgs));
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            return result;
        }

        public Object callback(Object[] args2) {
            try {
                return this.callback_inner(args2);
            }
            catch (Throwable t) {
                t.printStackTrace();
                return null;
            }
        }

        private Object convertArgument(Object value2, Class dstType) {
            if (value2 instanceof Pointer) {
                if (dstType == (class$java$lang$String == null ? (class$java$lang$String = CallbackReference.class$("java.lang.String")) : class$java$lang$String)) {
                    value2 = ((Pointer)value2).getString(0L);
                } else if (dstType == (class$com$sun$jna$WString == null ? (class$com$sun$jna$WString = CallbackReference.class$("com.sun.jna.WString")) : class$com$sun$jna$WString)) {
                    value2 = new WString(((Pointer)value2).getString(0L, true));
                } else if ((class$com$sun$jna$Callback == null ? (class$com$sun$jna$Callback = CallbackReference.class$("com.sun.jna.Callback")) : class$com$sun$jna$Callback).isAssignableFrom(dstType)) {
                    value2 = CallbackReference.getCallback(dstType, (Pointer)value2);
                } else if ((class$com$sun$jna$Structure == null ? (class$com$sun$jna$Structure = CallbackReference.class$("com.sun.jna.Structure")) : class$com$sun$jna$Structure).isAssignableFrom(dstType)) {
                    Structure s = Structure.newInstance(dstType);
                    Pointer old = s.getPointer();
                    s.useMemory((Pointer)value2);
                    s.read();
                    if ((class$com$sun$jna$Structure$ByValue == null ? (class$com$sun$jna$Structure$ByValue = CallbackReference.class$("com.sun.jna.Structure$ByValue")) : class$com$sun$jna$Structure$ByValue).isAssignableFrom(dstType)) {
                        s.useMemory(old);
                        s.write();
                    }
                    value2 = s;
                }
            } else if ((Boolean.TYPE == dstType || (class$java$lang$Boolean == null ? (class$java$lang$Boolean = CallbackReference.class$("java.lang.Boolean")) : class$java$lang$Boolean) == dstType) && value2 instanceof Number) {
                value2 = Function.valueOf(((Number)value2).intValue() != 0);
            }
            return value2;
        }

        private Object convertResult(Object value2) {
            Class<?> cls;
            if (this.toNative != null) {
                value2 = this.toNative.toNative(value2, new CallbackResultContext(this.callbackMethod));
            }
            if (value2 == null) {
                return null;
            }
            if ((class$com$sun$jna$Structure == null ? (class$com$sun$jna$Structure = CallbackReference.class$("com.sun.jna.Structure")) : class$com$sun$jna$Structure).isAssignableFrom(cls = value2.getClass())) {
                if ((class$com$sun$jna$Structure$ByValue == null ? (class$com$sun$jna$Structure$ByValue = CallbackReference.class$("com.sun.jna.Structure$ByValue")) : class$com$sun$jna$Structure$ByValue).isAssignableFrom(cls)) {
                    return value2;
                }
                return ((Structure)value2).getPointer();
            }
            if (cls == Boolean.TYPE || cls == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = CallbackReference.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                return new Integer(Boolean.TRUE.equals(value2) ? -1 : 0);
            }
            if (cls == (class$java$lang$String == null ? (class$java$lang$String = CallbackReference.class$("java.lang.String")) : class$java$lang$String) || cls == (class$com$sun$jna$WString == null ? (class$com$sun$jna$WString = CallbackReference.class$("com.sun.jna.WString")) : class$com$sun$jna$WString)) {
                NativeString ns = new NativeString(value2.toString(), cls == (class$com$sun$jna$WString == null ? (class$com$sun$jna$WString = CallbackReference.class$("com.sun.jna.WString")) : class$com$sun$jna$WString));
                nativeStrings.put(value2, ns);
                return ns.getPointer();
            }
            if ((class$com$sun$jna$Callback == null ? (class$com$sun$jna$Callback = CallbackReference.class$("com.sun.jna.Callback")) : class$com$sun$jna$Callback).isAssignableFrom(cls)) {
                return CallbackReference.getFunctionPointer((Callback)value2);
            }
            return value2;
        }

        public Class[] getParameterTypes() {
            return this.callbackMethod.getParameterTypes();
        }

        public Class getReturnType() {
            return this.callbackMethod.getReturnType();
        }
    }

    private static interface NativeFunctionProxy {
    }
}

