/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jruby.objectweb.asm.ClassWriter;
import jruby.objectweb.asm.Label;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.compiler.util.HandleFactory;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.jruby.util.CodegenUtils;
import org.jruby.util.IdUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MiniJava
implements Library {
    private static final boolean DEBUG = false;
    static Map<Class, RubyModule> classMap = new HashMap<Class, RubyModule>();
    static final Map<Class, JavaMethodFactory> methodFactories = new HashMap<Class, JavaMethodFactory>();
    static final JavaMethodFactory JAVA_OBJECT_METHOD_FACTORY = new JavaMethodFactory(){

        public DynamicMethod createMethod(RubyClass klazz, Method method) {
            return new JavaObjectWrapperMethod((RubyModule)klazz, method);
        }
    };

    @Override
    public void load(Ruby runtime, boolean wrap) {
        runtime.getErr().print("Warning: minijava is experimental and subject to change\n");
        runtime.getKernel().defineAnnotatedMethods(MiniJava.class);
        RubyModule javaObject = MiniJava.getMirrorForClass(runtime, Object.class);
        javaObject.addMethod("to_s", new JavaMethod.JavaMethodZero(javaObject, Visibility.PUBLIC){

            public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name) {
                return context.getRuntime().newString(((JavaObjectWrapper)self).object.toString());
            }
        });
        javaObject.addMethod("hash", new JavaMethod.JavaMethodZero(javaObject, Visibility.PUBLIC){

            public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name) {
                return self.getRuntime().newFixnum(((JavaObjectWrapper)self).object.hashCode());
            }
        });
        javaObject.addMethod("==", new JavaMethod.JavaMethodOne(javaObject, Visibility.PUBLIC){

            public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg) {
                if (arg instanceof JavaObjectWrapper) {
                    return context.getRuntime().newBoolean(((JavaObjectWrapper)self).object.equals(((JavaObjectWrapper)arg).object));
                }
                return context.getRuntime().getFalse();
            }
        });
        RubyModule rubyKernel = runtime.getKernel();
        rubyKernel.addModuleFunction("to_java", new JavaMethod.JavaMethodZeroOrOne(rubyKernel, Visibility.PUBLIC){

            public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name) {
                return ((RubyObject)self).to_java();
            }

            public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg) {
                return ((RubyObject)self).as(MiniJava.getJavaClassFromObject(arg));
            }
        });
    }

    @JRubyMethod(name={"new_class"}, rest=true, module=true)
    public static IRubyObject new_class(ThreadContext context, IRubyObject self, IRubyObject[] interfaces) {
        Class[] javaInterfaces = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            javaInterfaces[i] = MiniJava.getJavaClassFromObject(interfaces[i]);
        }
        return MiniJava.createImplClass(javaInterfaces, context.getRuntime(), "I" + System.currentTimeMillis());
    }

    @JRubyMethod(name={"import"}, module=true)
    public static IRubyObject rb_import(ThreadContext context, IRubyObject self, IRubyObject name) {
        String className = name.toString();
        try {
            Class cls = MiniJava.findClass(context.getRuntime().getJRubyClassLoader(), className);
            RubyModule namespace = self instanceof RubyModule ? (RubyModule)self : self.getMetaClass().getRealClass();
            namespace.defineConstant(cls.getSimpleName(), MiniJava.getMirrorForClass(context.getRuntime(), cls));
            return context.getRuntime().getNil();
        }
        catch (Exception e) {
            if (context.getRuntime().getDebug().isTrue()) {
                e.printStackTrace();
            }
            throw context.getRuntime().newTypeError("Could not find class " + className + ", exception: " + e);
        }
    }

    @JRubyMethod(name={"import"}, module=true)
    public static IRubyObject rb_import(ThreadContext context, IRubyObject self, IRubyObject name, IRubyObject as) {
        String className = name.toString();
        try {
            Class cls = MiniJava.findClass(context.getRuntime().getJRubyClassLoader(), className);
            RubyModule namespace = self instanceof RubyModule ? (RubyModule)self : self.getMetaClass().getRealClass();
            namespace.defineConstant(as.toString(), MiniJava.getMirrorForClass(context.getRuntime(), cls));
            return context.getRuntime().getNil();
        }
        catch (Exception e) {
            if (context.getRuntime().getDebug().isTrue()) {
                e.printStackTrace();
            }
            throw context.getRuntime().newTypeError("Could not find class " + className + ", exception: " + e);
        }
    }

    public static RubyClass createImplClass(Class[] superTypes, Ruby ruby, String name) {
        String[] superTypeNames = new String[superTypes.length];
        HashMap<String, List<Method>> simpleToAll = new HashMap<String, List<Method>>();
        for (int i = 0; i < superTypes.length; ++i) {
            superTypeNames[i] = CodegenUtils.p(superTypes[i]);
            for (Method method : superTypes[i].getDeclaredMethods()) {
                ArrayList<Method> methods = (ArrayList<Method>)simpleToAll.get(method.getName());
                if (methods == null) {
                    methods = new ArrayList<Method>();
                    simpleToAll.put(method.getName(), methods);
                }
                methods.add(method);
            }
        }
        Class newClass = MiniJava.defineImplClass(ruby, name, superTypeNames, simpleToAll);
        RubyClass rubyCls = MiniJava.populateImplClass(ruby, newClass, simpleToAll);
        return rubyCls;
    }

    public static Class defineImplClass(Ruby ruby, String name, String[] superTypeNames, Map<String, List<Method>> simpleToAll) {
        ClassWriter cw = new ClassWriter(1);
        cw.visit(49, 33, name, null, CodegenUtils.p(Object.class), superTypeNames);
        cw.visitField(10, "ruby", CodegenUtils.ci(Ruby.class), null, null).visitEnd();
        cw.visitField(10, "rubyClass", CodegenUtils.ci(RubyClass.class), null, null).visitEnd();
        cw.visitField(18, "self", CodegenUtils.ci(IRubyObject.class), null, null).visitEnd();
        SkinnyMethodAdapter initMethod = new SkinnyMethodAdapter(cw.visitMethod(1, "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]), null, null));
        initMethod.aload(0);
        initMethod.invokespecial(CodegenUtils.p(Object.class), "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]));
        initMethod.aload(0);
        initMethod.getstatic(name, "ruby", CodegenUtils.ci(Ruby.class));
        initMethod.aload(0);
        initMethod.invokestatic(CodegenUtils.p(MiniJava.class), "javaToRuby", CodegenUtils.sig(IRubyObject.class, Ruby.class, Object.class));
        initMethod.putfield(name, "self", CodegenUtils.ci(IRubyObject.class));
        initMethod.voidreturn();
        initMethod.end();
        SkinnyMethodAdapter setupMethod = new SkinnyMethodAdapter(cw.visitMethod(4105, "__setup__", CodegenUtils.sig(Void.TYPE, RubyClass.class), null, null));
        setupMethod.start();
        setupMethod.aload(0);
        setupMethod.dup();
        setupMethod.putstatic(name, "rubyClass", CodegenUtils.ci(RubyClass.class));
        setupMethod.invokevirtual(CodegenUtils.p(RubyClass.class), "getClassRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
        setupMethod.putstatic(name, "ruby", CodegenUtils.ci(Ruby.class));
        for (Map.Entry<String, List<Method>> entry : simpleToAll.entrySet()) {
            String simpleName = entry.getKey();
            cw.visitField(73, simpleName, CodegenUtils.ci(DynamicMethod.class), null, null).visitEnd();
            for (Method method : entry.getValue()) {
                Class[] paramTypes = method.getParameterTypes();
                Class<?> returnType = method.getReturnType();
                SkinnyMethodAdapter mv = new SkinnyMethodAdapter(cw.visitMethod(1, simpleName, CodegenUtils.sig(returnType, paramTypes), null, null));
                mv.start();
                String fieldName = MiniJava.mangleMethodFieldName(simpleName, paramTypes);
                Label dispatch = new Label();
                cw.visitField(73, fieldName, CodegenUtils.ci(DynamicMethod.class), null, null).visitEnd();
                mv.getstatic(name, fieldName, CodegenUtils.ci(DynamicMethod.class));
                mv.dup();
                mv.ifnonnull(dispatch);
                mv.pop();
                mv.getstatic(name, simpleName, CodegenUtils.ci(DynamicMethod.class));
                mv.dup();
                mv.ifnonnull(dispatch);
                mv.pop();
                mv.getstatic(name, "rubyClass", CodegenUtils.ci(RubyClass.class));
                mv.ldc("method_missing");
                mv.invokevirtual(CodegenUtils.p(RubyClass.class), "searchMethod", CodegenUtils.sig(DynamicMethod.class, String.class));
                mv.label(dispatch);
                mv.getstatic(name, "ruby", CodegenUtils.ci(Ruby.class));
                mv.invokevirtual(CodegenUtils.p(Ruby.class), "getCurrentContext", CodegenUtils.sig(ThreadContext.class, new Class[0]));
                mv.aload(0);
                mv.getfield(name, "self", CodegenUtils.ci(IRubyObject.class));
                mv.getstatic(name, "rubyClass", CodegenUtils.ci(RubyClass.class));
                mv.ldc(simpleName);
                if (method.getParameterTypes().length != 0) {
                    mv.pushInt(method.getParameterTypes().length);
                    mv.anewarray(CodegenUtils.p(IRubyObject.class));
                    for (int i = 0; i < paramTypes.length; ++i) {
                        mv.dup();
                        mv.pushInt(i);
                        mv.getstatic(name, "ruby", CodegenUtils.ci(Ruby.class));
                        mv.aload(i + 1);
                        mv.invokestatic(CodegenUtils.p(MiniJava.class), "javaToRuby", CodegenUtils.sig(IRubyObject.class, Ruby.class, Object.class));
                        mv.aastore();
                    }
                } else {
                    mv.getstatic(CodegenUtils.p(IRubyObject.class), "NULL_ARRAY", CodegenUtils.ci(IRubyObject[].class));
                }
                mv.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
                mv.invokevirtual(CodegenUtils.p(DynamicMethod.class), "call", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject[].class, Block.class));
                if (method.getReturnType() != Void.TYPE) {
                    mv.invokestatic(CodegenUtils.p(MiniJava.class), "rubyToJava", CodegenUtils.sig(Object.class, IRubyObject.class));
                    mv.checkcast(CodegenUtils.p(returnType));
                    mv.areturn();
                } else {
                    mv.voidreturn();
                }
                mv.end();
            }
        }
        setupMethod.voidreturn();
        setupMethod.end();
        cw.visitEnd();
        byte[] bytes = cw.toByteArray();
        Class<?> newClass = ruby.getJRubyClassLoader().defineClass(name, cw.toByteArray());
        return newClass;
    }

    public static RubyClass populateImplClass(Ruby ruby, Class newClass, Map<String, List<Method>> simpleToAll) {
        RubyClass rubyCls = (RubyClass)MiniJava.getMirrorForClass(ruby, newClass);
        try {
            newClass.getMethod("__setup__", RubyClass.class).invoke(null, rubyCls);
        }
        catch (IllegalAccessException ex) {
            throw MiniJava.error(ruby, ex, "Could not setup class: " + newClass);
        }
        catch (IllegalArgumentException ex) {
            throw MiniJava.error(ruby, ex, "Could not setup class: " + newClass);
        }
        catch (InvocationTargetException ex) {
            throw MiniJava.error(ruby, ex, "Could not setup class: " + newClass);
        }
        catch (NoSuchMethodException ex) {
            throw MiniJava.error(ruby, ex, "Could not setup class: " + newClass);
        }
        final HashMap<String, Field> allFields = new HashMap<String, Field>();
        try {
            for (Map.Entry<String, List<Method>> entry : simpleToAll.entrySet()) {
                String simpleName = entry.getKey();
                Field simpleField = newClass.getField(simpleName);
                allFields.put(simpleName, simpleField);
                for (Method method : entry.getValue()) {
                    String complexName = simpleName + CodegenUtils.prettyParams(method.getParameterTypes());
                    String fieldName = MiniJava.mangleMethodFieldName(simpleName, method.getParameterTypes());
                    allFields.put(complexName, newClass.getField(fieldName));
                }
            }
        }
        catch (IllegalArgumentException ex) {
            throw MiniJava.error(ruby, ex, "Could not prepare method fields: " + newClass);
        }
        catch (NoSuchFieldException ex) {
            throw MiniJava.error(ruby, ex, "Could not prepare method fields: " + newClass);
        }
        JavaMethod method_added = new JavaMethod((RubyModule)rubyCls.getSingletonClass(), Visibility.PUBLIC){

            public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
                RubyClass selfClass = (RubyClass)self;
                Ruby ruby = selfClass.getClassRuntime();
                String methodName = args[0].asJavaString();
                Field field = (Field)allFields.get(methodName);
                if (field != null) {
                    try {
                        field.set(null, selfClass.searchMethod(methodName));
                    }
                    catch (IllegalAccessException iae) {
                        throw MiniJava.error(ruby, iae, "Could not set new method into field: " + selfClass + "." + methodName);
                    }
                    catch (IllegalArgumentException iae) {
                        throw MiniJava.error(ruby, iae, "Could not set new method into field: " + selfClass + "." + methodName);
                    }
                }
                return context.getRuntime().getNil();
            }
        };
        rubyCls.getSingletonClass().addMethod("method_added", method_added);
        return rubyCls;
    }

    protected static String mangleMethodFieldName(String baseName, Class[] paramTypes) {
        String fieldName = baseName + CodegenUtils.prettyParams(paramTypes);
        fieldName = fieldName.replace('.', '\\');
        return fieldName;
    }

    protected static Class findClass(ClassLoader classLoader, String className) throws ClassNotFoundException {
        if (className.indexOf(46) == -1 && Character.isLowerCase(className.charAt(0))) {
            switch (className.charAt(0)) {
                case 'b': {
                    return Byte.TYPE;
                }
                case 's': {
                    return Short.TYPE;
                }
                case 'c': {
                    return Character.TYPE;
                }
                case 'i': {
                    return Integer.TYPE;
                }
                case 'l': {
                    return Long.TYPE;
                }
                case 'f': {
                    return Float.TYPE;
                }
                case 'd': {
                    return Double.TYPE;
                }
            }
            return classLoader.loadClass(className);
        }
        return classLoader.loadClass(className);
    }

    public static RubyModule getMirrorForClass(Ruby ruby, Class cls) {
        if (cls == null) {
            return ruby.getObject();
        }
        RubyModule rubyCls = classMap.get(cls);
        if (rubyCls == null) {
            rubyCls = MiniJava.createMirrorForClass(ruby, cls);
            classMap.put(cls, rubyCls);
            MiniJava.populateMirrorForClass(rubyCls, cls);
            rubyCls = classMap.get(cls);
        }
        return rubyCls;
    }

    protected static RubyModule createMirrorForClass(Ruby ruby, Class cls) {
        if (cls.isInterface()) {
            RubyModule rubyMod = RubyModule.newModule(ruby);
            return rubyMod;
        }
        RubyClass rubyCls = RubyClass.newClass(ruby, (RubyClass)MiniJava.getMirrorForClass(ruby, cls.getSuperclass()));
        return rubyCls;
    }

    protected static void populateMirrorForClass(RubyModule rubyMod, Class cls) {
        Class<?>[] interfaces;
        Ruby ruby = rubyMod.getRuntime();
        rubyMod.setBaseName(cls.getCanonicalName());
        for (Class<?> ifc : interfaces = cls.getInterfaces()) {
            rubyMod.includeModule(MiniJava.getMirrorForClass(ruby, ifc));
        }
        if (cls.getEnclosingClass() != null && !Modifier.isPublic(cls.getModifiers())) {
            return;
        }
        RubyClass rubySing = rubyMod.getSingletonClass();
        if (cls.isArray()) {
            MiniJava.populateMirrorForArrayClass(rubyMod, cls);
        } else {
            MiniJava.populateDeclaredMethods(rubyMod, cls, true);
            MiniJava.populateConstructors(rubySing, cls);
            MiniJava.populateArrayConstructors(rubySing);
            MiniJava.populateFields(rubyMod, cls);
        }
        MiniJava.populateSpecialMethods(rubyMod, rubySing, cls);
    }

    private static void populateArrayConstructors(RubyModule rubySing) {
        rubySing.addMethod("[]", new JavaMethod.JavaMethodOneOrTwoOrThree(rubySing, Visibility.PUBLIC){

            public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg) {
                Class javaClass = MiniJava.getJavaClassFromObject(self);
                int size = RubyFixnum.fix2int(arg.convertToInteger());
                return MiniJava.javaToRuby(context.getRuntime(), Array.newInstance(javaClass, size));
            }

            public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, IRubyObject arg1) {
                Class javaClass = MiniJava.getJavaClassFromObject(self);
                int x = RubyFixnum.fix2int(arg0.convertToInteger());
                int y = RubyFixnum.fix2int(arg1.convertToInteger());
                return MiniJava.javaToRuby(context.getRuntime(), Array.newInstance(javaClass, x, y));
            }

            public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
                Class javaClass = MiniJava.getJavaClassFromObject(self);
                int x = RubyFixnum.fix2int(arg0.convertToInteger());
                int y = RubyFixnum.fix2int(arg1.convertToInteger());
                int z = RubyFixnum.fix2int(arg2.convertToInteger());
                return MiniJava.javaToRuby(context.getRuntime(), Array.newInstance(javaClass, x, y, z));
            }
        });
    }

    private static void populateConstructors(RubyModule rubySing, final Class cls) {
        Constructor<?>[] constructors;
        final Ruby ruby = rubySing.getRuntime();
        for (final Constructor<?> constructor : constructors = cls.getConstructors()) {
            JavaMethod dynMethod = constructor.getParameterTypes().length == 0 ? new JavaMethod.JavaMethodZero(rubySing, Visibility.PUBLIC){

                public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name) {
                    try {
                        return MiniJava.javaToRuby(context.getRuntime(), constructor.newInstance(new Object[0]));
                    }
                    catch (InstantiationException ex) {
                        if (ruby.getDebug().isTrue()) {
                            ex.printStackTrace();
                        }
                        throw ruby.newTypeError("Could not instantiate " + cls.getCanonicalName() + " using " + CodegenUtils.prettyParams(constructor.getParameterTypes()));
                    }
                    catch (IllegalAccessException ex) {
                        if (ruby.getDebug().isTrue()) {
                            ex.printStackTrace();
                        }
                        throw ruby.newTypeError("Could not instantiate " + cls.getCanonicalName() + " using " + CodegenUtils.prettyParams(constructor.getParameterTypes()));
                    }
                    catch (IllegalArgumentException ex) {
                        if (ruby.getDebug().isTrue()) {
                            ex.printStackTrace();
                        }
                        throw ruby.newTypeError("Could not instantiate " + cls.getCanonicalName() + " using " + CodegenUtils.prettyParams(constructor.getParameterTypes()));
                    }
                    catch (InvocationTargetException ex) {
                        if (ruby.getDebug().isTrue()) {
                            ex.printStackTrace();
                        }
                        throw ruby.newTypeError("Could not instantiate " + cls.getCanonicalName() + " using " + CodegenUtils.prettyParams(constructor.getParameterTypes()));
                    }
                }
            } : new JavaMethod.JavaMethodNoBlock(rubySing, Visibility.PUBLIC){

                public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] rubyArgs) {
                    Object[] args = new Object[rubyArgs.length];
                    for (int i = 0; i < args.length; ++i) {
                        args[i] = MiniJava.rubyToJava(rubyArgs[i]);
                    }
                    try {
                        return MiniJava.javaToRuby(ruby, constructor.newInstance(args));
                    }
                    catch (InstantiationException ex) {
                        if (ruby.getDebug().isTrue()) {
                            ex.printStackTrace();
                        }
                        throw ruby.newTypeError("Could not instantiate " + cls.getCanonicalName() + " using " + CodegenUtils.prettyParams(constructor.getParameterTypes()));
                    }
                    catch (IllegalAccessException ex) {
                        if (ruby.getDebug().isTrue()) {
                            ex.printStackTrace();
                        }
                        throw ruby.newTypeError("Could not instantiate " + cls.getCanonicalName() + " using " + CodegenUtils.prettyParams(constructor.getParameterTypes()));
                    }
                    catch (IllegalArgumentException ex) {
                        if (ruby.getDebug().isTrue()) {
                            ex.printStackTrace();
                        }
                        throw ruby.newTypeError("Could not instantiate " + cls.getCanonicalName() + " using " + CodegenUtils.prettyParams(constructor.getParameterTypes()));
                    }
                    catch (InvocationTargetException ex) {
                        if (ruby.getDebug().isTrue()) {
                            ex.printStackTrace();
                        }
                        throw ruby.newTypeError("Could not instantiate " + cls.getCanonicalName() + " using " + CodegenUtils.prettyParams(constructor.getParameterTypes()));
                    }
                }
            };
            if (rubySing.getMethods().get("new") == null) {
                rubySing.addMethod("new", dynMethod);
            }
            rubySing.addMethod("new" + CodegenUtils.prettyParams(constructor.getParameterTypes()), dynMethod);
        }
    }

    private static void populateDeclaredMethods(RubyModule rubyMod, Class cls, boolean includeStatic) throws SecurityException {
        Method[] methods;
        for (Method method : methods = cls.getDeclaredMethods()) {
            RubyModule target;
            String name = method.getName();
            if (!Modifier.isPublic(method.getModifiers())) continue;
            if (Modifier.isStatic(method.getModifiers())) {
                if (!includeStatic) continue;
                target = rubyMod.getSingletonClass();
            } else {
                target = rubyMod;
            }
            JavaMethodFactory factory = MiniJava.getMethodFactory(method.getReturnType());
            DynamicMethod dynMethod = factory.createMethod(target, method);
            if (target.getMethods().get(name) == null) {
                target.addMethod(name, dynMethod);
            }
            name = name + CodegenUtils.prettyParams(method.getParameterTypes());
            target.addMethod(name, dynMethod);
        }
    }

    private static void populateSpecialMethods(RubyModule rubyMod, RubyModule rubySing, final Class cls) {
        final Ruby ruby = rubyMod.getRuntime();
        rubySing.addMethod("java_class", new JavaMethod.JavaMethodZero(rubySing, Visibility.PUBLIC){

            public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name) {
                return MiniJava.javaToRuby(ruby, cls);
            }
        });
    }

    private static void populateFields(RubyModule rubyMod, Class cls) throws RaiseException, SecurityException {
        Field[] fields;
        Ruby ruby = rubyMod.getRuntime();
        for (Field field : fields = cls.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers()) || !IdUtil.isConstant(field.getName())) continue;
            Object value = null;
            try {
                value = field.get(null);
            }
            catch (Exception e) {
                throw ruby.newTypeError("Could not access field " + cls.getCanonicalName() + "::" + field.getName() + " using " + CodegenUtils.ci(field.getType()));
            }
            rubyMod.defineConstant(field.getName(), new JavaObjectWrapper((RubyClass)MiniJava.getMirrorForClass(ruby, value.getClass()), value));
        }
    }

    protected static void populateMirrorForArrayClass(RubyModule rubyMod, Class cls) {
        final Ruby ruby = rubyMod.getRuntime();
        rubyMod.addMethod("[]", new JavaMethod.JavaMethodOneOrTwo(rubyMod, Visibility.PUBLIC){

            public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg) {
                Object array = MiniJava.rubyToJava(self);
                int x = RubyFixnum.fix2int(arg.convertToInteger());
                return MiniJava.javaToRuby(ruby, Array.get(array, x));
            }

            public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, IRubyObject arg1) {
                Object array = MiniJava.rubyToJava(self);
                int x = RubyFixnum.fix2int(arg0.convertToInteger());
                int y = RubyFixnum.fix2int(arg1.convertToInteger());
                return MiniJava.javaToRuby(ruby, Array.get(Array.get(array, x), y));
            }
        });
        rubyMod.addMethod("[]=", new JavaMethod.JavaMethodTwoOrThree(rubyMod, Visibility.PUBLIC){

            public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, IRubyObject arg1) {
                Object array = MiniJava.rubyToJava(self);
                int x = RubyFixnum.fix2int(arg0.convertToInteger());
                Object obj = MiniJava.rubyToJava(arg1);
                Array.set(array, x, obj);
                return arg1;
            }

            public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
                Object array = MiniJava.rubyToJava(self);
                int x = RubyFixnum.fix2int(arg0.convertToInteger());
                int y = RubyFixnum.fix2int(arg1.convertToInteger());
                Object obj = MiniJava.rubyToJava(arg2);
                Array.set(Array.get(array, x), y, obj);
                return arg2;
            }
        });
        rubyMod.addMethod("length", new JavaMethod.JavaMethodZero(rubyMod, Visibility.PUBLIC){

            public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name) {
                Object array = MiniJava.rubyToJava(self);
                return MiniJava.javaToRuby(ruby, Array.getLength(array));
            }
        });
    }

    protected static JavaMethodFactory getMethodFactory(Class returnType) {
        JavaMethodFactory factory = methodFactories.get(returnType);
        if (factory == null) {
            return JAVA_OBJECT_METHOD_FACTORY;
        }
        return factory;
    }

    protected static RaiseException error(Ruby ruby, Exception e, String message) throws RaiseException {
        if (ruby.getDebug().isTrue()) {
            e.printStackTrace();
        }
        throw ruby.newTypeError(message);
    }

    public static Object rubyToJava(IRubyObject object) {
        if (object.isNil()) {
            return null;
        }
        if (object instanceof JavaObjectWrapper) {
            return ((JavaObjectWrapper)object).object;
        }
        return object;
    }

    public static IRubyObject javaToRuby(Ruby ruby, Object object) {
        if (object == null) {
            return ruby.getNil();
        }
        if (object instanceof IRubyObject) {
            return (IRubyObject)object;
        }
        return new JavaObjectWrapper((RubyClass)MiniJava.getMirrorForClass(ruby, object.getClass()), object);
    }

    public static Class getJavaClassFromObject(IRubyObject obj) {
        if (!obj.respondsTo("java_class")) {
            throw obj.getRuntime().newTypeError(obj.getMetaClass().getBaseName() + " is not a Java type");
        }
        return (Class)MiniJava.rubyToJava(obj.callMethod(obj.getRuntime().getCurrentContext(), "java_class"));
    }

    static {
        methodFactories.put(Void.TYPE, new JavaMethodFactory(){

            public DynamicMethod createMethod(RubyModule klazz, Method method) {
                Class<?>[] parameters = method.getParameterTypes();
                if (parameters.length > 0) {
                    return new JavaVoidWrapperMethod(klazz, method);
                }
                return new JavaVoidWrapperMethodZero(klazz, method);
            }
        });
    }

    public static class JavaObjectWrapper
    extends RubyObject {
        Object object;

        public JavaObjectWrapper(RubyClass klazz, Object object) {
            super(klazz.getRuntime(), klazz);
            this.object = object;
        }
    }

    protected static class JavaVoidWrapperMethodZero
    extends AbstractJavaWrapperMethodZero {
        public JavaVoidWrapperMethodZero(RubyModule klazz, Method method) {
            super(klazz, method);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name) {
            this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)self).object);
            return self;
        }
    }

    protected static class JavaVoidWrapperMethod
    extends AbstractJavaWrapperMethod {
        public JavaVoidWrapperMethod(RubyModule klazz, Method method) {
            super(klazz, method);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
            Object[] newArgs = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                IRubyObject arg = args[i];
                newArgs[i] = MiniJava.rubyToJava(arg);
            }
            this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)self).object, newArgs);
            return self;
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, Block block) {
            this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)self).object);
            return self;
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, Block block) {
            this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)self).object, MiniJava.rubyToJava(arg0));
            return self;
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, IRubyObject arg1, Block block) {
            this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)self).object, MiniJava.rubyToJava(arg0), MiniJava.rubyToJava(arg1));
            return self;
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
            this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)self).object, MiniJava.rubyToJava(arg0), MiniJava.rubyToJava(arg1), MiniJava.rubyToJava(arg2));
            return self;
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args) {
            Object[] newArgs = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                IRubyObject arg = args[i];
                newArgs[i] = MiniJava.rubyToJava(arg);
            }
            this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)self).object, newArgs);
            return self;
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name) {
            this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)self).object);
            return self;
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0) {
            this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)self).object, MiniJava.rubyToJava(arg0));
            return self;
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, IRubyObject arg1) {
            this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)self).object, MiniJava.rubyToJava(arg0), MiniJava.rubyToJava(arg1));
            return self;
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
            this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)self).object, MiniJava.rubyToJava(arg0), MiniJava.rubyToJava(arg1), MiniJava.rubyToJava(arg2));
            return self;
        }
    }

    protected static class JavaObjectWrapperMethod
    extends AbstractJavaWrapperMethod {
        public JavaObjectWrapperMethod(RubyModule klazz, Method method) {
            super(klazz, method);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
            Object[] newArgs = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                IRubyObject arg = args[i];
                newArgs[i] = MiniJava.rubyToJava(arg);
            }
            Object result = this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)self).object, newArgs);
            return MiniJava.javaToRuby(this.ruby, result);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, Block block) {
            Object result = this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)self).object);
            return MiniJava.javaToRuby(this.ruby, result);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, Block block) {
            Object result = this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)self).object, MiniJava.rubyToJava(arg0));
            return MiniJava.javaToRuby(this.ruby, result);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, IRubyObject arg1, Block block) {
            Object result = this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)self).object, MiniJava.rubyToJava(arg0), MiniJava.rubyToJava(arg1));
            return MiniJava.javaToRuby(this.ruby, result);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
            Object result = this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)self).object, MiniJava.rubyToJava(arg0), MiniJava.rubyToJava(arg1), MiniJava.rubyToJava(arg2));
            return MiniJava.javaToRuby(this.ruby, result);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args) {
            Object[] newArgs = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                IRubyObject arg = args[i];
                newArgs[i] = MiniJava.rubyToJava(arg);
            }
            Object result = this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)self).object, newArgs);
            return MiniJava.javaToRuby(this.ruby, result);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name) {
            Object result = this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)self).object);
            return MiniJava.javaToRuby(this.ruby, result);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0) {
            Object result = this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)self).object, MiniJava.rubyToJava(arg0));
            return MiniJava.javaToRuby(this.ruby, result);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, IRubyObject arg1) {
            Object result = this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)self).object, MiniJava.rubyToJava(arg0), MiniJava.rubyToJava(arg1));
            return MiniJava.javaToRuby(this.ruby, result);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
            Object result = this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)self).object, MiniJava.rubyToJava(arg0), MiniJava.rubyToJava(arg1), MiniJava.rubyToJava(arg2));
            return MiniJava.javaToRuby(this.ruby, result);
        }
    }

    protected static class JavaObjectWrapperMethodZero
    extends AbstractJavaWrapperMethodZero {
        public JavaObjectWrapperMethodZero(RubyModule klazz, Method method) {
            super(klazz, method);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name) {
            Object result = this.handle.invoke(this.isStatic ? null : ((JavaObjectWrapper)self).object);
            return MiniJava.javaToRuby(this.ruby, result);
        }
    }

    public static abstract class AbstractJavaWrapperMethod
    extends JavaMethod {
        protected final HandleFactory.Handle handle;
        protected final boolean isStatic;
        protected final String className;
        protected final String methodName;
        protected final String prettySig;
        protected final Ruby ruby;

        public AbstractJavaWrapperMethod(RubyModule klazz, Method method) {
            super(klazz, Visibility.PUBLIC);
            this.handle = HandleFactory.createHandle(klazz.getRuntime().getJRubyClassLoader(), method);
            this.isStatic = Modifier.isStatic(method.getModifiers());
            this.className = method.getDeclaringClass().getCanonicalName();
            this.methodName = method.getName();
            this.prettySig = CodegenUtils.prettyParams(method.getParameterTypes());
            this.ruby = klazz.getRuntime();
        }

        protected RaiseException error(Exception e) throws RaiseException {
            return MiniJava.error(this.ruby, e, "Could not dispatch to " + this.className + "#" + this.methodName + " using " + this.prettySig);
        }
    }

    public static abstract class AbstractJavaWrapperMethodZero
    extends JavaMethod.JavaMethodZero {
        protected final HandleFactory.Handle handle;
        protected final boolean isStatic;
        protected final String className;
        protected final String methodName;
        protected final String prettySig;
        protected final Ruby ruby;

        public AbstractJavaWrapperMethodZero(RubyModule klazz, Method method) {
            super(klazz, Visibility.PUBLIC);
            this.handle = HandleFactory.createHandle(klazz.getRuntime().getJRubyClassLoader(), method);
            this.isStatic = Modifier.isStatic(method.getModifiers());
            this.className = method.getDeclaringClass().getCanonicalName();
            this.methodName = method.getName();
            this.prettySig = CodegenUtils.prettyParams(method.getParameterTypes());
            this.ruby = klazz.getRuntime();
        }

        protected RaiseException error(ThreadContext context, Exception e) throws RaiseException {
            if (this.ruby.getDebug().isTrue()) {
                e.printStackTrace();
            }
            throw this.ruby.newTypeError("Could not dispatch to " + this.className + "#" + this.methodName + " using " + this.prettySig);
        }
    }

    public static class JavaMethodFactory {
        public DynamicMethod createMethod(RubyModule klazz, Method method) {
            Class<?>[] params = method.getParameterTypes();
            if (params.length > 0) {
                return new JavaObjectWrapperMethod(klazz, method);
            }
            return new JavaObjectWrapperMethodZero(klazz, method);
        }
    }
}

