/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.Iterator;
import org.joni.NameEntry;
import org.joni.Regex;
import org.joni.Region;
import org.joni.exception.JOniException;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyClass(name={"MatchData"})
public class RubyMatchData
extends RubyObject {
    Region regs;
    int begin;
    int end;
    RubyString str;
    Regex pattern;
    public static final int MATCH_BUSY = 64;

    public static RubyClass createMatchDataClass(Ruby runtime) {
        RubyClass matchDataClass = runtime.defineClass("MatchData", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime.setMatchData(matchDataClass);
        runtime.defineGlobalConstant("MatchingData", matchDataClass);
        matchDataClass.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject obj, RubyModule type) {
                return obj instanceof RubyMatchData;
            }
        };
        matchDataClass.getMetaClass().undefineMethod("new");
        matchDataClass.defineAnnotatedMethods(RubyMatchData.class);
        return matchDataClass;
    }

    public RubyMatchData(Ruby runtime) {
        super(runtime, runtime.getMatchData());
    }

    public final void use() {
        this.flags |= 0x40;
    }

    public final boolean used() {
        return (this.flags & 0x40) != 0;
    }

    private RubyArray match_array(int start) {
        if (this.regs == null) {
            if (start != 0) {
                return this.getRuntime().newEmptyArray();
            }
            if (this.begin == -1) {
                return this.getRuntime().newArray(this.getRuntime().getNil());
            }
            RubyString ss = this.str.makeShared(this.begin, this.end - this.begin);
            if (this.isTaint()) {
                ss.setTaint(true);
            }
            return this.getRuntime().newArray(ss);
        }
        RubyArray arr = this.getRuntime().newArray(this.regs.numRegs - start);
        for (int i = start; i < this.regs.numRegs; ++i) {
            if (this.regs.beg[i] == -1) {
                arr.append(this.getRuntime().getNil());
                continue;
            }
            RubyString ss = this.str.makeShared(this.regs.beg[i], this.regs.end[i] - this.regs.beg[i]);
            if (this.isTaint()) {
                ss.setTaint(true);
            }
            arr.append(ss);
        }
        return arr;
    }

    public IRubyObject group(long n) {
        return RubyRegexp.nth_match((int)n, this);
    }

    public IRubyObject group(int n) {
        return RubyRegexp.nth_match(n, this);
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        NameEntry e;
        if (this.pattern == null) {
            return this.anyToString();
        }
        RubyString result = this.getRuntime().newString();
        result.cat((byte)35).cat((byte)60);
        result.append(this.getMetaClass().getRealClass().to_s());
        NameEntry[] names = new NameEntry[this.regs == null ? 1 : this.regs.numRegs];
        if (this.pattern.numberOfNames() > 0) {
            Iterator<NameEntry> i = this.pattern.namedBackrefIterator();
            while (i.hasNext()) {
                e = i.next();
                for (int num : e.getBackRefs()) {
                    names[num] = e;
                }
            }
        }
        for (int i = 0; i < names.length; ++i) {
            IRubyObject v;
            result.cat((byte)32);
            if (i > 0) {
                e = names[i];
                if (e != null) {
                    result.cat(e.name, e.nameP, e.nameEnd - e.nameP);
                } else {
                    result.cat((byte)(48 + i));
                }
                result.cat((byte)58);
            }
            if ((v = RubyRegexp.nth_match(i, this)).isNil()) {
                result.cat("nil".getBytes());
                continue;
            }
            result.append(v.inspect());
        }
        return result.cat((byte)62);
    }

    @JRubyMethod(name={"to_a"})
    public RubyArray to_a() {
        return this.match_array(0);
    }

    @JRubyMethod(name={"values_at"}, required=1, rest=true)
    public IRubyObject values_at(IRubyObject[] args) {
        return this.to_a().values_at(args);
    }

    @JRubyMethod(name={"select"}, frame=true)
    public IRubyObject select(ThreadContext context, Block block) {
        return block.yield(context, this.to_a());
    }

    @JRubyMethod(name={"captures"})
    public IRubyObject captures() {
        return this.match_array(1);
    }

    private int nameToBackrefNumber(RubyString str) {
        ByteList value = str.getByteList();
        try {
            return this.pattern.nameToBackrefNumber(value.bytes, value.begin, value.begin + value.realSize, this.regs);
        }
        catch (JOniException je) {
            throw this.getRuntime().newIndexError(je.getMessage());
        }
    }

    final int backrefNumber(IRubyObject obj) {
        if (obj instanceof RubySymbol) {
            return this.nameToBackrefNumber((RubyString)((RubySymbol)obj).id2name());
        }
        if (obj instanceof RubyString) {
            return this.nameToBackrefNumber((RubyString)obj);
        }
        return RubyNumeric.num2int(obj);
    }

    public IRubyObject op_aref(IRubyObject[] args) {
        switch (args.length) {
            case 1: {
                return this.op_aref(args[0]);
            }
            case 2: {
                return this.op_aref(args[0], args[1]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), args.length, 1, 2);
        return null;
    }

    @JRubyMethod(name={"[]"})
    public IRubyObject op_aref(IRubyObject idx) {
        IRubyObject result = this.op_arefCommon(idx);
        return result == null ? this.to_a().aref(idx) : result;
    }

    /*
     * WARNING - void declaration
     */
    @JRubyMethod(name={"[]"})
    public IRubyObject op_aref(IRubyObject idx, IRubyObject rest) {
        void var3_3;
        IRubyObject result;
        return !rest.isNil() || (result = this.op_arefCommon(idx)) == null ? this.to_a().aref(idx, rest) : var3_3;
    }

    private IRubyObject op_arefCommon(IRubyObject idx) {
        if (idx instanceof RubyFixnum) {
            int num = RubyNumeric.fix2int(idx);
            if (num >= 0) {
                return RubyRegexp.nth_match(num, this);
            }
        } else {
            if (idx instanceof RubySymbol) {
                return RubyRegexp.nth_match(this.nameToBackrefNumber((RubyString)((RubySymbol)idx).id2name()), this);
            }
            if (idx instanceof RubyString) {
                return RubyRegexp.nth_match(this.nameToBackrefNumber((RubyString)idx), this);
            }
        }
        return null;
    }

    @JRubyMethod(name={"size", "length"})
    public IRubyObject size() {
        return this.regs == null ? RubyFixnum.one(this.getRuntime()) : RubyFixnum.newFixnum(this.getRuntime(), this.regs.numRegs);
    }

    @JRubyMethod(name={"begin"}, required=1)
    public IRubyObject begin(IRubyObject index) {
        int i = this.backrefNumber(index);
        if (this.regs == null) {
            if (i != 0) {
                throw this.getRuntime().newIndexError("index " + i + " out of matches");
            }
            if (this.begin < 0) {
                return this.getRuntime().getNil();
            }
            return RubyFixnum.newFixnum(this.getRuntime(), this.begin);
        }
        if (i < 0 || this.regs.numRegs <= i) {
            throw this.getRuntime().newIndexError("index " + i + " out of matches");
        }
        if (this.regs.beg[i] < 0) {
            return this.getRuntime().getNil();
        }
        return RubyFixnum.newFixnum(this.getRuntime(), this.regs.beg[i]);
    }

    @JRubyMethod(name={"end"}, required=1)
    public IRubyObject end(IRubyObject index) {
        int i = this.backrefNumber(index);
        if (this.regs == null) {
            if (i != 0) {
                throw this.getRuntime().newIndexError("index " + i + " out of matches");
            }
            if (this.end < 0) {
                return this.getRuntime().getNil();
            }
            return RubyFixnum.newFixnum(this.getRuntime(), this.end);
        }
        if (i < 0 || this.regs.numRegs <= i) {
            throw this.getRuntime().newIndexError("index " + i + " out of matches");
        }
        if (this.regs.end[i] < 0) {
            return this.getRuntime().getNil();
        }
        return RubyFixnum.newFixnum(this.getRuntime(), this.regs.end[i]);
    }

    @JRubyMethod(name={"offset"}, required=1)
    public IRubyObject offset(IRubyObject index) {
        int i = this.backrefNumber(index);
        Ruby runtime = this.getRuntime();
        if (this.regs == null) {
            if (i != 0) {
                throw this.getRuntime().newIndexError("index " + i + " out of matches");
            }
            if (this.begin < 0) {
                return runtime.newArray(runtime.getNil(), runtime.getNil());
            }
            return runtime.newArray(RubyFixnum.newFixnum(runtime, this.begin), RubyFixnum.newFixnum(runtime, this.end));
        }
        if (i < 0 || this.regs.numRegs <= i) {
            throw runtime.newIndexError("index " + i + " out of matches");
        }
        if (this.regs.beg[i] < 0) {
            return runtime.newArray(runtime.getNil(), runtime.getNil());
        }
        return runtime.newArray(RubyFixnum.newFixnum(runtime, this.regs.beg[i]), RubyFixnum.newFixnum(runtime, this.regs.end[i]));
    }

    @JRubyMethod(name={"pre_match"})
    public IRubyObject pre_match() {
        RubyString ss;
        if (this.regs == null) {
            if (this.begin == -1) {
                return this.getRuntime().getNil();
            }
            ss = this.str.makeShared(0, this.begin);
        } else {
            if (this.regs.beg[0] == -1) {
                return this.getRuntime().getNil();
            }
            ss = this.str.makeShared(0, this.regs.beg[0]);
        }
        if (this.isTaint()) {
            ss.setTaint(true);
        }
        return ss;
    }

    @JRubyMethod(name={"post_match"})
    public IRubyObject post_match() {
        RubyString ss;
        if (this.regs == null) {
            if (this.begin == -1) {
                return this.getRuntime().getNil();
            }
            ss = this.str.makeShared(this.end, this.str.getByteList().length() - this.end);
        } else {
            if (this.regs.beg[0] == -1) {
                return this.getRuntime().getNil();
            }
            ss = this.str.makeShared(this.regs.end[0], this.str.getByteList().length() - this.regs.end[0]);
        }
        if (this.isTaint()) {
            ss.setTaint(true);
        }
        return ss;
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        IRubyObject ss = RubyRegexp.last_match(this);
        if (ss.isNil()) {
            ss = RubyString.newEmptyString(this.getRuntime());
        }
        if (this.isTaint()) {
            ss.setTaint(true);
        }
        return ss;
    }

    @JRubyMethod(name={"string"})
    public IRubyObject string() {
        return this.str;
    }

    @JRubyMethod(name={"initialize_copy"}, required=1)
    public IRubyObject initialize_copy(IRubyObject original) {
        if (this == original) {
            return this;
        }
        if (this.getMetaClass() != original.getMetaClass()) {
            throw this.getRuntime().newTypeError("wrong argument class");
        }
        RubyMatchData origMatchData = (RubyMatchData)original;
        this.str = origMatchData.str;
        this.regs = origMatchData.regs;
        return this;
    }
}

