/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.nio.charset.UnsupportedCharsetException;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyClass(name={"Iconv"})
public class RubyIconv
extends RubyObject {
    private static final String IGNORE = "//ignore";
    private CharsetDecoder fromEncoding;
    private CharsetEncoder toEncoding;
    private static final ObjectAllocator ICONV_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyIconv(runtime, klass);
        }
    };

    public RubyIconv(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    public static void createIconv(Ruby runtime) {
        RubyClass iconvClass = runtime.defineClass("Iconv", runtime.getObject(), ICONV_ALLOCATOR);
        iconvClass.defineAnnotatedMethods(RubyIconv.class);
        RubyModule failure = iconvClass.defineModuleUnder("Failure");
        RubyClass argumentError = runtime.fastGetClass("ArgumentError");
        String[] iconvErrors = new String[]{"IllegalSequence", "InvalidCharacter", "InvalidEncoding", "OutOfRange", "BrokenLibrary"};
        for (int i = 0; i < iconvErrors.length; ++i) {
            RubyClass subClass = iconvClass.defineClassUnder(iconvErrors[i], argumentError, RubyFailure.ICONV_FAILURE_ALLOCATOR);
            subClass.defineAnnotatedMethods(RubyFailure.class);
            subClass.includeModule(failure);
        }
    }

    private static String getCharset(String encoding) {
        int index = encoding.indexOf("//");
        if (index == -1) {
            return encoding;
        }
        return encoding.substring(0, index);
    }

    private static boolean isIgnore(String encoding) {
        return encoding.toLowerCase().indexOf(IGNORE) != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"open"}, required=2, frame=true, meta=true)
    public static IRubyObject open(ThreadContext context, IRubyObject recv, IRubyObject to, IRubyObject from, Block block) {
        Ruby runtime = recv.getRuntime();
        RubyIconv iconv = (RubyIconv)runtime.fastGetClass("Iconv").newInstance(context, new IRubyObject[]{to, from}, Block.NULL_BLOCK);
        if (!block.isGiven()) {
            return iconv;
        }
        IRubyObject result = runtime.getNil();
        try {
            result = block.yield(context, iconv);
        }
        finally {
            iconv.close();
        }
        return result;
    }

    @JRubyMethod(name={"initialize"}, required=2, frame=true)
    public IRubyObject initialize(IRubyObject arg1, IRubyObject arg2, Block unusedBlock) {
        Ruby runtime = this.getRuntime();
        if (!arg1.respondsTo("to_str")) {
            throw runtime.newTypeError("can't convert " + arg1.getMetaClass() + " into String");
        }
        if (!arg2.respondsTo("to_str")) {
            throw runtime.newTypeError("can't convert " + arg2.getMetaClass() + " into String");
        }
        String to = arg1.convertToString().toString();
        String from = arg2.convertToString().toString();
        try {
            this.fromEncoding = Charset.forName(RubyIconv.getCharset(from)).newDecoder();
            this.toEncoding = Charset.forName(RubyIconv.getCharset(to)).newEncoder();
            if (!RubyIconv.isIgnore(from)) {
                this.fromEncoding.onUnmappableCharacter(CodingErrorAction.REPORT);
            }
            if (!RubyIconv.isIgnore(to)) {
                this.toEncoding.onUnmappableCharacter(CodingErrorAction.REPORT);
            }
        }
        catch (IllegalCharsetNameException e) {
            throw runtime.newArgumentError("invalid encoding");
        }
        catch (UnsupportedCharsetException e) {
            throw runtime.newArgumentError("invalid encoding");
        }
        catch (Exception e) {
            throw runtime.newSystemCallError(e.toString());
        }
        return this;
    }

    @JRubyMethod(name={"close"})
    public IRubyObject close() {
        this.toEncoding = null;
        this.fromEncoding = null;
        return this.getRuntime().newString("");
    }

    @JRubyMethod(name={"iconv"}, required=1, optional=2)
    public IRubyObject iconv(IRubyObject[] args) {
        Ruby runtime = this.getRuntime();
        args = Arity.scanArgs(runtime, args, 1, 2);
        int start = 0;
        int end = -1;
        if (args[0].isNil()) {
            this.fromEncoding.reset();
            this.toEncoding.reset();
            return runtime.newString("");
        }
        if (!args[0].respondsTo("to_str")) {
            throw runtime.newTypeError("can't convert " + args[0].getMetaClass() + " into String");
        }
        if (!args[1].isNil()) {
            start = RubyNumeric.fix2int(args[1]);
        }
        if (!args[2].isNil()) {
            end = RubyNumeric.fix2int(args[2]);
        }
        IRubyObject result = this._iconv(args[0].convertToString(), start, end);
        return result;
    }

    private IRubyObject _iconv(RubyString str, int start, int end) {
        ByteList bytes = str.getByteList();
        if (start < 0) {
            start += bytes.length();
        }
        if (end < 0) {
            end += 1 + bytes.length();
        } else if (end > bytes.length()) {
            end = bytes.length();
        }
        if (start < 0 || end < start) {
            return this.getRuntime().newString();
        }
        ByteBuffer buf = ByteBuffer.wrap(bytes.unsafeBytes(), bytes.begin() + start, end - start);
        try {
            CharBuffer cbuf = this.fromEncoding.decode(buf);
            buf = this.toEncoding.encode(cbuf);
        }
        catch (MalformedInputException e) {
        }
        catch (UnmappableCharacterException e) {
        }
        catch (CharacterCodingException e) {
            throw this.getRuntime().newInvalidEncoding("invalid sequence");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        byte[] arr = buf.array();
        return this.getRuntime().newString(new ByteList(arr, 0, buf.limit()));
    }

    @JRubyMethod(name={"iconv"}, required=2, optional=1, meta=true)
    public static IRubyObject iconv(IRubyObject recv, IRubyObject[] args, Block unusedBlock) {
        return RubyIconv.convertWithArgs(recv, args, "iconv");
    }

    @JRubyMethod(name={"conv"}, required=3, rest=true, meta=true)
    public static IRubyObject conv(ThreadContext context, IRubyObject recv, IRubyObject[] args, Block unusedBlock) {
        return RubyIconv.convertWithArgs(recv, args, "conv").join(context, recv.getRuntime().newString(""));
    }

    public static RubyArray convertWithArgs(IRubyObject recv, IRubyObject[] args, String function) {
        String fromEncoding = args[1].convertToString().toString();
        String toEncoding = args[0].convertToString().toString();
        RubyArray array = recv.getRuntime().newArray();
        for (int i = 2; i < args.length; ++i) {
            array.append(RubyIconv.convert2(fromEncoding, toEncoding, args[i].convertToString()));
        }
        return array;
    }

    private static IRubyObject convert2(String fromEncoding, String toEncoding, RubyString original) {
        if (fromEncoding.equals(toEncoding)) {
            return original;
        }
        try {
            ByteList bytes = original.getByteList();
            ByteBuffer buf = ByteBuffer.wrap(bytes.unsafeBytes(), bytes.begin(), bytes.length());
            CharsetDecoder decoder = Charset.forName(RubyIconv.getCharset(fromEncoding)).newDecoder();
            if (!RubyIconv.isIgnore(fromEncoding)) {
                decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
            }
            CharBuffer cbuf = decoder.decode(buf);
            CharsetEncoder encoder = Charset.forName(RubyIconv.getCharset(toEncoding)).newEncoder();
            if (!RubyIconv.isIgnore(toEncoding)) {
                encoder.onUnmappableCharacter(CodingErrorAction.REPORT);
            }
            buf = encoder.encode(cbuf);
            byte[] arr = buf.array();
            return RubyString.newString(original.getRuntime(), new ByteList(arr, 0, buf.limit()));
        }
        catch (UnsupportedCharsetException e) {
            throw original.getRuntime().newInvalidEncoding("invalid encoding");
        }
        catch (UnmappableCharacterException e) {
        }
        catch (CharacterCodingException characterCodingException) {
            // empty catch block
        }
        return original.getRuntime().getNil();
    }

    public static class RubyFailure
    extends RubyException {
        private IRubyObject success;
        private IRubyObject failed;
        protected static final ObjectAllocator ICONV_FAILURE_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                return new RubyFailure(runtime, klass);
            }
        };

        public static RubyFailure newInstance(Ruby runtime, RubyClass excptnClass, String msg) {
            return new RubyFailure(runtime, excptnClass, msg);
        }

        protected RubyFailure(Ruby runtime, RubyClass rubyClass) {
            this(runtime, rubyClass, null);
        }

        public RubyFailure(Ruby runtime, RubyClass rubyClass, String message) {
            super(runtime, rubyClass, message);
        }

        @JRubyMethod(name={"initialize"}, required=1, optional=2, frame=true)
        public IRubyObject initialize(IRubyObject[] args, Block block) {
            super.initialize(args, block);
            this.success = args.length >= 2 ? args[1] : this.getRuntime().getNil();
            this.failed = args.length == 3 ? args[2] : this.getRuntime().getNil();
            return this;
        }

        @JRubyMethod(name={"success"})
        public IRubyObject success() {
            return this.success;
        }

        @JRubyMethod(name={"failed"})
        public IRubyObject failed() {
            return this.failed;
        }

        @JRubyMethod(name={"inspect"})
        public IRubyObject inspect() {
            RubyClass rubyClass = this.getMetaClass();
            StringBuffer buffer = new StringBuffer("#<");
            buffer.append(rubyClass.getName()).append(": ").append(this.success.inspect().toString());
            buffer.append(", ").append(this.failed.inspect().toString()).append(">");
            return this.getRuntime().newString(buffer.toString());
        }
    }

    @JRubyClass(name={"Iconv::BrokenLibrary"}, parent="ArgumentError", include={"Iconv::Failure"})
    public static class BrokenLibrary {
    }

    @JRubyClass(name={"Iconv::OutOfRange"}, parent="ArgumentError", include={"Iconv::Failure"})
    public static class OutOfRange {
    }

    @JRubyClass(name={"Iconv::InvalidEncoding"}, parent="ArgumentError", include={"Iconv::Failure"})
    public static class InvalidEncoding {
    }

    @JRubyClass(name={"Iconv::InvalidCharacter"}, parent="ArgumentError", include={"Iconv::Failure"})
    public static class InvalidCharacter {
    }

    @JRubyClass(name={"Iconv::IllegalSequence"}, parent="ArgumentError", include={"Iconv::Failure"})
    public static class IllegalSequence {
    }

    @JRubyModule(name={"Iconv::Failure"})
    public static class Failure {
    }
}

