/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyModule(name={"Comparable"})
public class RubyComparable {
    public static RubyModule createComparable(Ruby runtime) {
        RubyModule comparableModule = runtime.defineModule("Comparable");
        runtime.setComparable(comparableModule);
        comparableModule.defineAnnotatedMethods(RubyComparable.class);
        return comparableModule;
    }

    public static int cmpint(ThreadContext context, IRubyObject val, IRubyObject a, IRubyObject b) {
        if (val.isNil()) {
            RubyComparable.cmperr(a, b);
        }
        if (val instanceof RubyFixnum) {
            return RubyNumeric.fix2int((RubyFixnum)val);
        }
        if (val instanceof RubyBignum) {
            if (((RubyBignum)val).getValue().signum() == -1) {
                return 1;
            }
            return -1;
        }
        Ruby runtime = val.getRuntime();
        RubyFixnum zero = RubyFixnum.zero(runtime);
        if (val.callMethod(context, MethodIndex.OP_GT, ">", zero).isTrue()) {
            return 1;
        }
        if (val.callMethod(context, MethodIndex.OP_LT, "<", zero).isTrue()) {
            return -1;
        }
        return 0;
    }

    public static void cmperr(IRubyObject recv, IRubyObject other) {
        IRubyObject target = other.isImmediate() || !other.isNil() && !other.isTrue() && other != recv.getRuntime().getFalse() ? other.inspect() : other.getType();
        throw recv.getRuntime().newArgumentError("comparison of " + recv.getType() + " with " + target + " failed");
    }

    @JRubyMethod(name={"=="}, required=1)
    public static IRubyObject op_equal(ThreadContext context, IRubyObject recv, IRubyObject other) {
        if (recv == other) {
            return recv.getRuntime().getTrue();
        }
        Ruby runtime = recv.getRuntime();
        IRubyObject result = null;
        try {
            result = recv.callMethod(context, MethodIndex.OP_SPACESHIP, "<=>", other);
        }
        catch (RaiseException e) {
            if (e.getException().kind_of_p(recv.getRuntime().getStandardError()).isTrue()) {
                return recv.getRuntime().getNil();
            }
            throw e;
        }
        if (!(result instanceof RubyInteger)) {
            return runtime.getNil();
        }
        return RubyBoolean.newBoolean(runtime, RubyComparable.cmpint(context, result, recv, other) == 0);
    }

    @JRubyMethod(name={">"}, required=1)
    public static RubyBoolean op_gt(ThreadContext context, IRubyObject recv, IRubyObject other) {
        Ruby runtime = recv.getRuntime();
        IRubyObject result = recv.callMethod(context, MethodIndex.OP_SPACESHIP, "<=>", other);
        if (result.isNil()) {
            RubyComparable.cmperr(recv, other);
        }
        return RubyBoolean.newBoolean(runtime, RubyComparable.cmpint(context, result, recv, other) > 0);
    }

    @JRubyMethod(name={">="}, required=1)
    public static RubyBoolean op_ge(ThreadContext context, IRubyObject recv, IRubyObject other) {
        Ruby runtime = recv.getRuntime();
        IRubyObject result = recv.callMethod(context, MethodIndex.OP_SPACESHIP, "<=>", other);
        if (result.isNil()) {
            RubyComparable.cmperr(recv, other);
        }
        return RubyBoolean.newBoolean(runtime, RubyComparable.cmpint(context, result, recv, other) >= 0);
    }

    @JRubyMethod(name={"<"}, required=1)
    public static RubyBoolean op_lt(ThreadContext context, IRubyObject recv, IRubyObject other) {
        Ruby runtime = recv.getRuntime();
        IRubyObject result = recv.callMethod(context, MethodIndex.OP_SPACESHIP, "<=>", other);
        if (result.isNil()) {
            RubyComparable.cmperr(recv, other);
        }
        return RubyBoolean.newBoolean(runtime, RubyComparable.cmpint(context, result, recv, other) < 0);
    }

    @JRubyMethod(name={"<="}, required=1)
    public static RubyBoolean op_le(ThreadContext context, IRubyObject recv, IRubyObject other) {
        Ruby runtime = recv.getRuntime();
        IRubyObject result = recv.callMethod(context, MethodIndex.OP_SPACESHIP, "<=>", other);
        if (result.isNil()) {
            RubyComparable.cmperr(recv, other);
        }
        return RubyBoolean.newBoolean(runtime, RubyComparable.cmpint(context, result, recv, other) <= 0);
    }

    @JRubyMethod(name={"between?"}, required=2)
    public static RubyBoolean between_p(ThreadContext context, IRubyObject recv, IRubyObject first, IRubyObject second) {
        return recv.getRuntime().newBoolean(RubyComparable.op_lt(context, recv, first).isFalse() && RubyComparable.op_gt(context, recv, second).isFalse());
    }
}

