/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.evaluator;

import jregex.PatternSyntaxException;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBinding;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyRange;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.ast.AliasNode;
import org.jruby.ast.ArgsCatNode;
import org.jruby.ast.ArgsPushNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.AttrAssignNode;
import org.jruby.ast.BackRefNode;
import org.jruby.ast.BeginNode;
import org.jruby.ast.BignumNode;
import org.jruby.ast.BinaryOperatorNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.BlockPassNode;
import org.jruby.ast.BreakNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.CaseNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarDeclNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.Colon3Node;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DRegexpNode;
import org.jruby.ast.DStrNode;
import org.jruby.ast.DSymbolNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.DXStrNode;
import org.jruby.ast.DefinedNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.DotNode;
import org.jruby.ast.EnsureNode;
import org.jruby.ast.EvStrNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.FixnumNode;
import org.jruby.ast.FlipNode;
import org.jruby.ast.FloatNode;
import org.jruby.ast.ForNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.HashNode;
import org.jruby.ast.IfNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.Match2Node;
import org.jruby.ast.Match3Node;
import org.jruby.ast.MatchNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.NextNode;
import org.jruby.ast.Node;
import org.jruby.ast.NotNode;
import org.jruby.ast.NthRefNode;
import org.jruby.ast.OpAsgnNode;
import org.jruby.ast.OpAsgnOrNode;
import org.jruby.ast.OpElementAsgnNode;
import org.jruby.ast.OptNNode;
import org.jruby.ast.OrNode;
import org.jruby.ast.PostExeNode;
import org.jruby.ast.RegexpNode;
import org.jruby.ast.RescueBodyNode;
import org.jruby.ast.ReturnNode;
import org.jruby.ast.RootNode;
import org.jruby.ast.SClassNode;
import org.jruby.ast.SValueNode;
import org.jruby.ast.SplatNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.SuperNode;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.ToAryNode;
import org.jruby.ast.UndefNode;
import org.jruby.ast.UntilNode;
import org.jruby.ast.VAliasNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.WhenNode;
import org.jruby.ast.WhileNode;
import org.jruby.ast.XStrNode;
import org.jruby.ast.YieldNode;
import org.jruby.ast.ZSuperNode;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.evaluator.AssignmentVisitor;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.methods.DefaultMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.WrapperMethod;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.SharedScopeBlock;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.KCode;
import org.jruby.util.collections.SinglyLinkedList;

public class EvaluationState {
    public static IRubyObject eval(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block block) {
        try {
            return EvaluationState.evalInternal(runtime, context, node, self, block);
        }
        catch (StackOverflowError sfe) {
            throw runtime.newSystemStackError("stack level too deep");
        }
    }

    private static IRubyObject evalInternal(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        block94: while (true) {
            if (node == null) {
                return EvaluationState.nilNode(runtime, context);
            }
            switch (node.nodeId) {
                case 0: {
                    return EvaluationState.aliasNode(runtime, context, node);
                }
                case 1: {
                    Object iVisited = (BinaryOperatorNode)((Object)node);
                    IRubyObject result = EvaluationState.evalInternal(runtime, context, iVisited.getFirstNode(), self, aBlock);
                    if (!result.isTrue()) {
                        return result;
                    }
                    node = iVisited.getSecondNode();
                    continue block94;
                }
                case 2: {
                    return EvaluationState.argsCatNode(runtime, context, node, self, aBlock);
                }
                case 103: {
                    return EvaluationState.argsPushNode(runtime, context, node, self, aBlock);
                }
                case 5: {
                    return EvaluationState.arrayNode(runtime, context, node, self, aBlock);
                }
                case 102: {
                    return EvaluationState.attrAssignNode(runtime, context, node, self, aBlock);
                }
                case 7: {
                    return EvaluationState.backRefNode(context, node);
                }
                case 8: {
                    node = ((BeginNode)node).getBodyNode();
                    continue block94;
                }
                case 9: {
                    return EvaluationState.bignumNode(runtime, node);
                }
                case 12: {
                    return EvaluationState.blockNode(runtime, context, node, self, aBlock);
                }
                case 13: {
                    assert (false) : "Call nodes and friends deal with this";
                }
                case 14: {
                    return EvaluationState.breakNode(runtime, context, node, self, aBlock);
                }
                case 15: {
                    return EvaluationState.callNode(runtime, context, node, self, aBlock);
                }
                case 16: {
                    return EvaluationState.caseNode(runtime, context, node, self, aBlock);
                }
                case 17: {
                    return EvaluationState.classNode(runtime, context, node, self, aBlock);
                }
                case 18: {
                    return EvaluationState.classVarAsgnNode(runtime, context, node, self, aBlock);
                }
                case 19: {
                    return EvaluationState.classVarDeclNode(runtime, context, node, self, aBlock);
                }
                case 20: {
                    return EvaluationState.classVarNode(runtime, context, node, self);
                }
                case 21: {
                    return EvaluationState.colon2Node(runtime, context, node, self, aBlock);
                }
                case 22: {
                    return EvaluationState.colon3Node(runtime, node);
                }
                case 23: {
                    return EvaluationState.constDeclNode(runtime, context, node, self, aBlock);
                }
                case 24: {
                    return EvaluationState.constNode(context, node);
                }
                case 25: {
                    return EvaluationState.dAsgnNode(runtime, context, node, self, aBlock);
                }
                case 26: {
                    return EvaluationState.definedNode(runtime, context, node, self, aBlock);
                }
                case 27: {
                    return EvaluationState.defnNode(runtime, context, node);
                }
                case 28: {
                    return EvaluationState.defsNode(runtime, context, node, self, aBlock);
                }
                case 29: {
                    return EvaluationState.dotNode(runtime, context, node, self, aBlock);
                }
                case 30: {
                    return EvaluationState.dregexpNode(runtime, context, node, self, aBlock);
                }
                case 31: {
                    return EvaluationState.dStrNode(runtime, context, node, self, aBlock);
                }
                case 32: {
                    return EvaluationState.dSymbolNode(runtime, context, node, self, aBlock);
                }
                case 33: {
                    return EvaluationState.dVarNode(runtime, context, node);
                }
                case 34: {
                    return EvaluationState.dXStrNode(runtime, context, node, self, aBlock);
                }
                case 35: {
                    return EvaluationState.ensureNode(runtime, context, node, self, aBlock);
                }
                case 36: {
                    return EvaluationState.evStrNode(runtime, context, node, self, aBlock);
                }
                case 37: {
                    return EvaluationState.falseNode(runtime, context);
                }
                case 38: {
                    return EvaluationState.fCallNode(runtime, context, node, self, aBlock);
                }
                case 39: {
                    return EvaluationState.fixnumNode(runtime, node);
                }
                case 40: {
                    return EvaluationState.flipNode(runtime, context, node, self, aBlock);
                }
                case 41: {
                    return EvaluationState.floatNode(runtime, node);
                }
                case 42: {
                    return EvaluationState.forNode(runtime, context, node, self, aBlock);
                }
                case 43: {
                    return EvaluationState.globalAsgnNode(runtime, context, node, self, aBlock);
                }
                case 44: {
                    return EvaluationState.globalVarNode(runtime, context, node);
                }
                case 45: {
                    return EvaluationState.hashNode(runtime, context, node, self, aBlock);
                }
                case 46: {
                    Object iVisited = (IfNode)node;
                    IRubyObject result = EvaluationState.evalInternal(runtime, context, ((IfNode)iVisited).getCondition(), self, aBlock);
                    if (result.isTrue()) {
                        node = ((IfNode)iVisited).getThenBody();
                        continue block94;
                    }
                    node = ((IfNode)iVisited).getElseBody();
                    continue block94;
                }
                case 47: {
                    return EvaluationState.instAsgnNode(runtime, context, node, self, aBlock);
                }
                case 48: {
                    return EvaluationState.instVarNode(runtime, node, self);
                }
                case 50: {
                    assert (false) : "Call nodes deal with these directly";
                }
                case 52: {
                    return EvaluationState.localAsgnNode(runtime, context, node, self, aBlock);
                }
                case 53: {
                    return EvaluationState.localVarNode(runtime, context, node);
                }
                case 54: {
                    return EvaluationState.match2Node(runtime, context, node, self, aBlock);
                }
                case 55: {
                    return EvaluationState.match3Node(runtime, context, node, self, aBlock);
                }
                case 56: {
                    return EvaluationState.matchNode(runtime, context, node, self, aBlock);
                }
                case 57: {
                    return EvaluationState.moduleNode(runtime, context, node, self, aBlock);
                }
                case 58: {
                    return EvaluationState.multipleAsgnNode(runtime, context, node, self, aBlock);
                }
                case 59: {
                    Object iVisited = (NewlineNode)node;
                    context.setPosition(((Node)iVisited).getPosition());
                    if (EvaluationState.isTrace(runtime)) {
                        EvaluationState.callTraceFunction(runtime, context, "line", self);
                    }
                    node = ((NewlineNode)iVisited).getNextNode();
                    continue block94;
                }
                case 60: {
                    return EvaluationState.nextNode(runtime, context, node, self, aBlock);
                }
                case 61: {
                    return EvaluationState.nilNode(runtime, context);
                }
                case 63: {
                    return EvaluationState.notNode(runtime, context, node, self, aBlock);
                }
                case 64: {
                    return EvaluationState.nthRefNode(context, node);
                }
                case 65: {
                    Object iVisited = (BinaryOperatorNode)((Object)node);
                    IRubyObject result = EvaluationState.evalInternal(runtime, context, iVisited.getFirstNode(), self, aBlock);
                    if (!result.isTrue()) {
                        return EvaluationState.pollAndReturn(context, result);
                    }
                    node = iVisited.getSecondNode();
                    continue block94;
                }
                case 66: {
                    return EvaluationState.opAsgnNode(runtime, context, node, self, aBlock);
                }
                case 67: {
                    return EvaluationState.opAsgnOrNode(runtime, context, node, self, aBlock);
                }
                case 68: {
                    return EvaluationState.opElementAsgnNode(runtime, context, node, self, aBlock);
                }
                case 69: {
                    return EvaluationState.optNNode(runtime, context, node, self, aBlock);
                }
                case 70: {
                    return EvaluationState.orNode(runtime, context, node, self, aBlock);
                }
                case 71: {
                    return EvaluationState.postExeNode(runtime, context, node, self, aBlock);
                }
                case 72: {
                    return EvaluationState.redoNode(context, node);
                }
                case 73: {
                    return EvaluationState.regexpNode(runtime, node);
                }
                case 74: {
                    node = ((RescueBodyNode)node).getBodyNode();
                    continue block94;
                }
                case 75: {
                    return EvaluationState.rescueNode(runtime, context, node, self, aBlock);
                }
                case 76: {
                    return EvaluationState.retryNode(context);
                }
                case 77: {
                    return EvaluationState.returnNode(runtime, context, node, self, aBlock);
                }
                case 101: {
                    return EvaluationState.rootNode(runtime, context, node, self, aBlock);
                }
                case 78: {
                    return EvaluationState.sClassNode(runtime, context, node, self, aBlock);
                }
                case 80: {
                    return EvaluationState.pollAndReturn(context, self);
                }
                case 81: {
                    return EvaluationState.splatNode(runtime, context, node, self, aBlock);
                }
                case 83: {
                    return EvaluationState.strNode(runtime, node);
                }
                case 84: {
                    return EvaluationState.superNode(runtime, context, node, self, aBlock);
                }
                case 85: {
                    return EvaluationState.sValueNode(runtime, context, node, self, aBlock);
                }
                case 86: {
                    return EvaluationState.symbolNode(runtime, node);
                }
                case 87: {
                    return EvaluationState.toAryNode(runtime, context, node, self, aBlock);
                }
                case 88: {
                    return EvaluationState.trueNode(runtime, context);
                }
                case 89: {
                    return EvaluationState.undefNode(runtime, context, node);
                }
                case 90: {
                    return EvaluationState.untilNode(runtime, context, node, self, aBlock);
                }
                case 91: {
                    return EvaluationState.valiasNode(runtime, node);
                }
                case 92: {
                    return EvaluationState.vcallNode(runtime, context, node, self);
                }
                case 93: {
                    assert (false);
                    return null;
                }
                case 94: {
                    return EvaluationState.whileNode(runtime, context, node, self, aBlock);
                }
                case 95: {
                    return EvaluationState.xStrNode(runtime, context, node, self);
                }
                case 96: {
                    return EvaluationState.yieldNode(runtime, context, node, self, aBlock);
                }
                case 97: {
                    return EvaluationState.zArrayNode(runtime);
                }
                case 99: {
                    return EvaluationState.zsuperNode(runtime, context, node, self, aBlock);
                }
            }
            break;
        }
        throw new RuntimeException("Invalid node encountered in interpreter: \"" + node.getClass().getName() + "\", please report this at www.jruby.org");
    }

    private static IRubyObject aliasNode(Ruby runtime, ThreadContext context, Node node) {
        AliasNode iVisited = (AliasNode)node;
        if (context.getRubyClass() == null) {
            throw runtime.newTypeError("no class to make alias");
        }
        context.getRubyClass().defineAlias(iVisited.getNewName(), iVisited.getOldName());
        context.getRubyClass().callMethod(context, "method_added", runtime.newSymbol(iVisited.getNewName()));
        return runtime.getNil();
    }

    private static IRubyObject argsCatNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        ArgsCatNode iVisited = (ArgsCatNode)node;
        IRubyObject args = EvaluationState.evalInternal(runtime, context, iVisited.getFirstNode(), self, aBlock);
        RubyArray secondArgs = EvaluationState.splatValue(runtime, EvaluationState.evalInternal(runtime, context, iVisited.getSecondNode(), self, aBlock));
        RubyArray list = args instanceof RubyArray ? (RubyArray)args : runtime.newArray(args);
        return list.concat(secondArgs);
    }

    private static IRubyObject argsPushNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        ArgsPushNode iVisited = (ArgsPushNode)node;
        RubyArray args = (RubyArray)EvaluationState.evalInternal(runtime, context, iVisited.getFirstNode(), self, aBlock).dup();
        return args.append(EvaluationState.evalInternal(runtime, context, iVisited.getSecondNode(), self, aBlock));
    }

    private static IRubyObject arrayNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        ArrayNode iVisited = (ArrayNode)node;
        IRubyObject[] array = new IRubyObject[iVisited.size()];
        for (int i = 0; i < iVisited.size(); ++i) {
            Node next = iVisited.get(i);
            array[i] = EvaluationState.evalInternal(runtime, context, next, self, aBlock);
        }
        if (iVisited.isLightweight()) {
            return runtime.newArrayNoCopyLight(array);
        }
        return runtime.newArrayNoCopy(array);
    }

    public static RubyArray arrayValue(Ruby runtime, IRubyObject value) {
        IRubyObject newValue = value.convertToType(runtime.getArray(), 18, "to_ary", false);
        if (newValue.isNil()) {
            if (value.getMetaClass().searchMethod("to_a").getImplementationClass() != runtime.getKernel()) {
                newValue = value.convertToType(runtime.getArray(), 22, "to_a", false);
                if (newValue.getType() != runtime.getClass("Array")) {
                    throw runtime.newTypeError("`to_a' did not return Array");
                }
            } else {
                newValue = runtime.newArray(value);
            }
        }
        return (RubyArray)newValue;
    }

    private static IRubyObject aryToAry(Ruby runtime, IRubyObject value) {
        if (value instanceof RubyArray) {
            return value;
        }
        if (value.respondsTo("to_ary")) {
            return value.convertToType(runtime.getArray(), 22, "to_ary", false);
        }
        return runtime.newArray(value);
    }

    private static IRubyObject attrAssignNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        AttrAssignNode iVisited = (AttrAssignNode)node;
        IRubyObject receiver = EvaluationState.evalInternal(runtime, context, iVisited.getReceiverNode(), self, aBlock);
        IRubyObject[] args = EvaluationState.setupArgs(runtime, context, iVisited.getArgsNode(), self);
        assert (receiver.getMetaClass() != null) : receiver.getClass().getName();
        CallType callType = receiver == self ? CallType.VARIABLE : CallType.NORMAL;
        receiver.callMethod(context, iVisited.getName(), args, callType);
        return args[args.length - 1];
    }

    private static IRubyObject backRefNode(ThreadContext context, Node node) {
        BackRefNode iVisited = (BackRefNode)node;
        IRubyObject backref = context.getBackref();
        switch (iVisited.getType()) {
            case '~': {
                return backref;
            }
            case '&': {
                return RubyRegexp.last_match(backref);
            }
            case '`': {
                return RubyRegexp.match_pre(backref);
            }
            case '\'': {
                return RubyRegexp.match_post(backref);
            }
            case '+': {
                return RubyRegexp.match_last(backref);
            }
        }
        assert (false) : "backref with invalid type";
        return null;
    }

    private static IRubyObject bignumNode(Ruby runtime, Node node) {
        return RubyBignum.newBignum(runtime, ((BignumNode)node).getValue());
    }

    private static IRubyObject blockNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        BlockNode iVisited = (BlockNode)node;
        IRubyObject result = runtime.getNil();
        for (int i = 0; i < iVisited.size(); ++i) {
            result = EvaluationState.evalInternal(runtime, context, iVisited.get(i), self, aBlock);
        }
        return result;
    }

    private static IRubyObject breakNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        BreakNode iVisited = (BreakNode)node;
        IRubyObject result = EvaluationState.evalInternal(runtime, context, iVisited.getValueNode(), self, aBlock);
        JumpException je = context.controlException;
        je.setJumpType(JumpException.JumpType.BreakJump);
        je.setValue(result);
        throw je;
    }

    private static IRubyObject callNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        CallNode iVisited = (CallNode)node;
        IRubyObject receiver = EvaluationState.evalInternal(runtime, context, iVisited.getReceiverNode(), self, aBlock);
        IRubyObject[] args = EvaluationState.setupArgs(runtime, context, iVisited.getArgsNode(), self);
        assert (receiver.getMetaClass() != null) : receiver.getClass().getName();
        Block block = EvaluationState.getBlock(runtime, context, self, aBlock, iVisited.getIterNode());
        RubyClass module = receiver.getMetaClass();
        if (!block.isGiven()) {
            if (iVisited.index != 0) {
                return receiver.callMethod(context, module, iVisited.index, iVisited.getName(), args, CallType.NORMAL, Block.NULL_BLOCK);
            }
            DynamicMethod method = module.searchMethod(iVisited.getName());
            IRubyObject mmResult = RubyObject.callMethodMissingIfNecessary(context, receiver, method, iVisited.getName(), args, self, CallType.NORMAL, Block.NULL_BLOCK);
            if (mmResult != null) {
                return mmResult;
            }
            return method.call(context, receiver, module, iVisited.getName(), args, false, Block.NULL_BLOCK);
        }
        try {
            DynamicMethod method = module.searchMethod(iVisited.getName());
            IRubyObject mmResult = RubyObject.callMethodMissingIfNecessary(context, receiver, method, iVisited.getName(), args, self, CallType.NORMAL, block);
            if (mmResult != null) {
                return mmResult;
            }
            return method.call(context, receiver, module, iVisited.getName(), args, false, block);
        }
        catch (JumpException je) {
            switch (je.getJumpType().getTypeId()) {
                case 0: 
                case 3: {
                    return (IRubyObject)je.getValue();
                }
            }
            throw je;
        }
    }

    private static IRubyObject caseNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        CaseNode iVisited = (CaseNode)node;
        IRubyObject expression = null;
        if (iVisited.getCaseNode() != null) {
            expression = EvaluationState.evalInternal(runtime, context, iVisited.getCaseNode(), self, aBlock);
        }
        context.pollThreadEvents();
        IRubyObject result = runtime.getNil();
        Node firstWhenNode = iVisited.getFirstWhenNode();
        while (firstWhenNode != null) {
            if (!(firstWhenNode instanceof WhenNode)) {
                node = firstWhenNode;
                return EvaluationState.evalInternal(runtime, context, node, self, aBlock);
            }
            WhenNode whenNode = (WhenNode)firstWhenNode;
            if (whenNode.getExpressionNodes() instanceof ArrayNode) {
                ArrayNode arrayNode = (ArrayNode)whenNode.getExpressionNodes();
                for (int i = 0; i < arrayNode.size(); ++i) {
                    Node tag = arrayNode.get(i);
                    context.setPosition(tag.getPosition());
                    if (EvaluationState.isTrace(runtime)) {
                        EvaluationState.callTraceFunction(runtime, context, "line", self);
                    }
                    if (tag instanceof WhenNode) {
                        RubyArray expressions = (RubyArray)EvaluationState.evalInternal(runtime, context, ((WhenNode)tag).getExpressionNodes(), self, aBlock);
                        int k = expressions.getLength();
                        for (int j = 0; j < k; ++j) {
                            IRubyObject condition = expressions.eltInternal(j);
                            if ((expression == null || !condition.callMethod(context, 30, "===", expression).isTrue()) && (expression != null || !condition.isTrue())) continue;
                            node = ((WhenNode)firstWhenNode).getBodyNode();
                            return EvaluationState.evalInternal(runtime, context, node, self, aBlock);
                        }
                        continue;
                    }
                    result = EvaluationState.evalInternal(runtime, context, tag, self, aBlock);
                    if ((expression == null || !result.callMethod(context, 30, "===", expression).isTrue()) && (expression != null || !result.isTrue())) continue;
                    node = whenNode.getBodyNode();
                    return EvaluationState.evalInternal(runtime, context, node, self, aBlock);
                }
            } else {
                result = EvaluationState.evalInternal(runtime, context, whenNode.getExpressionNodes(), self, aBlock);
                if (expression != null && result.callMethod(context, 30, "===", expression).isTrue() || expression == null && result.isTrue()) {
                    node = ((WhenNode)firstWhenNode).getBodyNode();
                    return EvaluationState.evalInternal(runtime, context, node, self, aBlock);
                }
            }
            context.pollThreadEvents();
            firstWhenNode = whenNode.getNextCase();
        }
        return runtime.getNil();
    }

    private static IRubyObject classNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        ClassNode iVisited = (ClassNode)node;
        Node superNode = iVisited.getSuperNode();
        RubyClass superClass = null;
        if (superNode != null) {
            IRubyObject _super = EvaluationState.evalInternal(runtime, context, superNode, self, aBlock);
            if (!(_super instanceof RubyClass)) {
                throw runtime.newTypeError("superclass must be a Class (" + RubyObject.trueFalseNil(_super) + ") given");
            }
            superClass = superNode == null ? null : (RubyClass)_super;
        }
        Colon3Node classNameNode = iVisited.getCPath();
        String name = ((INameNode)classNameNode).getName();
        RubyModule enclosingClass = EvaluationState.getEnclosingModule(runtime, context, classNameNode, self, aBlock);
        RubyClass rubyClass = enclosingClass.defineOrGetClassUnder(name, superClass);
        return EvaluationState.evalClassDefinitionBody(runtime, context, iVisited.getScope(), iVisited.getBodyNode(), rubyClass, self, aBlock);
    }

    private static IRubyObject classVarAsgnNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        ClassVarAsgnNode iVisited = (ClassVarAsgnNode)node;
        IRubyObject result = EvaluationState.evalInternal(runtime, context, iVisited.getValueNode(), self, aBlock);
        RubyModule rubyClass = EvaluationState.getClassVariableBase(context, runtime);
        if (rubyClass == null) {
            rubyClass = self.getMetaClass();
        }
        rubyClass.setClassVar(iVisited.getName(), result);
        return result;
    }

    private static IRubyObject classVarDeclNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        ClassVarDeclNode iVisited = (ClassVarDeclNode)node;
        RubyModule rubyClass = EvaluationState.getClassVariableBase(context, runtime);
        if (rubyClass == null) {
            throw runtime.newTypeError("no class/module to define class variable");
        }
        IRubyObject result = EvaluationState.evalInternal(runtime, context, iVisited.getValueNode(), self, aBlock);
        rubyClass.setClassVar(iVisited.getName(), result);
        return result;
    }

    private static IRubyObject classVarNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self) {
        ClassVarNode iVisited = (ClassVarNode)node;
        RubyModule rubyClass = EvaluationState.getClassVariableBase(context, runtime);
        if (rubyClass == null) {
            rubyClass = self.getMetaClass();
        }
        return rubyClass.getClassVar(iVisited.getName());
    }

    private static IRubyObject colon2Node(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        Colon2Node iVisited = (Colon2Node)node;
        Node leftNode = iVisited.getLeftNode();
        if (leftNode == null) {
            return runtime.getObject().getConstantFrom(iVisited.getName());
        }
        IRubyObject result = EvaluationState.evalInternal(runtime, context, iVisited.getLeftNode(), self, aBlock);
        if (result instanceof RubyModule) {
            return ((RubyModule)result).getConstantFrom(iVisited.getName());
        }
        return result.callMethod(context, iVisited.getName(), aBlock);
    }

    private static IRubyObject colon3Node(Ruby runtime, Node node) {
        return runtime.getObject().getConstantFrom(((Colon3Node)node).getName());
    }

    private static IRubyObject constDeclNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        ConstDeclNode iVisited = (ConstDeclNode)node;
        Node constNode = iVisited.getConstNode();
        IRubyObject result = EvaluationState.evalInternal(runtime, context, iVisited.getValueNode(), self, aBlock);
        if (constNode == null) {
            return context.setConstantInCurrent(iVisited.getName(), result);
        }
        if (constNode.nodeId == 21) {
            RubyModule module = (RubyModule)EvaluationState.evalInternal(runtime, context, ((Colon2Node)iVisited.getConstNode()).getLeftNode(), self, aBlock);
            return context.setConstantInModule(iVisited.getName(), module, result);
        }
        return context.setConstantInObject(iVisited.getName(), result);
    }

    private static IRubyObject constNode(ThreadContext context, Node node) {
        return context.getConstant(((ConstNode)node).getName());
    }

    private static IRubyObject dAsgnNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        DAsgnNode iVisited = (DAsgnNode)node;
        IRubyObject result = EvaluationState.evalInternal(runtime, context, iVisited.getValueNode(), self, aBlock);
        context.getCurrentScope().setValue(iVisited.getIndex(), result, iVisited.getDepth());
        return result;
    }

    private static IRubyObject definedNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        DefinedNode iVisited = (DefinedNode)node;
        String definition = EvaluationState.getDefinition(runtime, context, iVisited.getExpressionNode(), self, aBlock);
        if (definition != null) {
            return runtime.newString(definition);
        }
        return runtime.getNil();
    }

    private static IRubyObject defnNode(Ruby runtime, ThreadContext context, Node node) {
        DefnNode iVisited = (DefnNode)node;
        RubyModule containingClass = context.getRubyClass();
        if (containingClass == null) {
            throw runtime.newTypeError("No class to add method.");
        }
        String name = iVisited.getName();
        if (containingClass == runtime.getObject() && name == "initialize") {
            runtime.getWarnings().warn("redefining Object#initialize may cause infinite loop");
        }
        Visibility visibility = context.getCurrentVisibility();
        if (name == "initialize" || visibility.isModuleFunction() || context.isTopLevel()) {
            visibility = Visibility.PRIVATE;
        }
        DefaultMethod newMethod = new DefaultMethod(containingClass, iVisited.getScope(), iVisited.getBodyNode(), iVisited.getArgsNode(), visibility, context.peekCRef());
        containingClass.addMethod(name, newMethod);
        if (context.getCurrentVisibility().isModuleFunction()) {
            containingClass.getSingletonClass().addMethod(name, new WrapperMethod(containingClass.getSingletonClass(), newMethod, Visibility.PUBLIC));
            containingClass.callMethod(context, "singleton_method_added", runtime.newSymbol(name));
        }
        if (containingClass.isSingleton()) {
            ((MetaClass)containingClass).getAttachedObject().callMethod(context, "singleton_method_added", runtime.newSymbol(iVisited.getName()));
        } else {
            containingClass.callMethod(context, "method_added", runtime.newSymbol(name));
        }
        return runtime.getNil();
    }

    private static IRubyObject defsNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        Object method;
        RubyClass rubyClass;
        DefsNode iVisited = (DefsNode)node;
        IRubyObject receiver = EvaluationState.evalInternal(runtime, context, iVisited.getReceiverNode(), self, aBlock);
        if (receiver.isNil()) {
            rubyClass = runtime.getNilClass();
        } else if (receiver == runtime.getTrue()) {
            rubyClass = runtime.getClass("TrueClass");
        } else if (receiver == runtime.getFalse()) {
            rubyClass = runtime.getClass("FalseClass");
        } else {
            if (runtime.getSafeLevel() >= 4 && !receiver.isTaint()) {
                throw runtime.newSecurityError("Insecure; can't define singleton method.");
            }
            if (receiver.isFrozen()) {
                throw runtime.newFrozenError("object");
            }
            if (receiver.getMetaClass() == runtime.getFixnum() || receiver.getMetaClass() == runtime.getClass("Symbol")) {
                throw runtime.newTypeError("can't define singleton method \"" + iVisited.getName() + "\" for " + receiver.getType());
            }
            rubyClass = receiver.getSingletonClass();
        }
        if (runtime.getSafeLevel() >= 4 && (method = rubyClass.getMethods().get(iVisited.getName())) != null) {
            throw runtime.newSecurityError("Redefining method prohibited.");
        }
        DefaultMethod newMethod = new DefaultMethod(rubyClass, iVisited.getScope(), iVisited.getBodyNode(), iVisited.getArgsNode(), Visibility.PUBLIC, context.peekCRef());
        rubyClass.addMethod(iVisited.getName(), newMethod);
        receiver.callMethod(context, "singleton_method_added", runtime.newSymbol(iVisited.getName()));
        return runtime.getNil();
    }

    private static IRubyObject dotNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        DotNode iVisited = (DotNode)node;
        return RubyRange.newRange(runtime, EvaluationState.evalInternal(runtime, context, iVisited.getBeginNode(), self, aBlock), EvaluationState.evalInternal(runtime, context, iVisited.getEndNode(), self, aBlock), iVisited.isExclusive());
    }

    private static IRubyObject dregexpNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        DRegexpNode iVisited = (DRegexpNode)node;
        RubyString string = runtime.newString(new ByteList());
        for (int i = 0; i < iVisited.size(); ++i) {
            Node iterNode = iVisited.get(i);
            if (iterNode instanceof StrNode) {
                string.getByteList().append(((StrNode)iterNode).getValue());
                continue;
            }
            string.append(EvaluationState.evalInternal(runtime, context, iterNode, self, aBlock));
        }
        String lang = null;
        int opts = iVisited.getOptions();
        if ((opts & 0x10) != 0) {
            lang = "n";
        } else if ((opts & 0x30) != 0) {
            lang = "s";
        } else if ((opts & 0x40) != 0) {
            lang = "u";
        }
        try {
            return RubyRegexp.newRegexp(runtime, string.toString(), iVisited.getOptions(), lang);
        }
        catch (PatternSyntaxException e) {
            throw runtime.newRegexpError(e.getMessage());
        }
    }

    private static IRubyObject dStrNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        DStrNode iVisited = (DStrNode)node;
        RubyString string = runtime.newString(new ByteList());
        for (int i = 0; i < iVisited.size(); ++i) {
            Node iterNode = iVisited.get(i);
            if (iterNode instanceof StrNode) {
                string.getByteList().append(((StrNode)iterNode).getValue());
                continue;
            }
            string.append(EvaluationState.evalInternal(runtime, context, iterNode, self, aBlock));
        }
        return string;
    }

    private static IRubyObject dSymbolNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        DSymbolNode iVisited = (DSymbolNode)node;
        RubyString string = runtime.newString(new ByteList());
        for (int i = 0; i < iVisited.size(); ++i) {
            Node iterNode = iVisited.get(i);
            if (iterNode instanceof StrNode) {
                string.getByteList().append(((StrNode)iterNode).getValue());
                continue;
            }
            string.append(EvaluationState.evalInternal(runtime, context, iterNode, self, aBlock));
        }
        return runtime.newSymbol(string.toString());
    }

    private static IRubyObject dVarNode(Ruby runtime, ThreadContext context, Node node) {
        DVarNode iVisited = (DVarNode)node;
        IRubyObject obj = context.getCurrentScope().getValue(iVisited.getIndex(), iVisited.getDepth());
        return obj == null ? runtime.getNil() : obj;
    }

    private static IRubyObject dXStrNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        DXStrNode iVisited = (DXStrNode)node;
        RubyString string = runtime.newString(new ByteList());
        for (int i = 0; i < iVisited.size(); ++i) {
            Node iterNode = iVisited.get(i);
            if (iterNode instanceof StrNode) {
                string.getByteList().append(((StrNode)iterNode).getValue());
                continue;
            }
            string.append(EvaluationState.evalInternal(runtime, context, iterNode, self, aBlock));
        }
        return self.callMethod(context, "`", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject ensureNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        EnsureNode iVisited = (EnsureNode)node;
        if (iVisited.getEnsureNode() != null) {
            IRubyObject result = runtime.getNil();
            try {
                result = EvaluationState.evalInternal(runtime, context, iVisited.getBodyNode(), self, aBlock);
            }
            finally {
                EvaluationState.evalInternal(runtime, context, iVisited.getEnsureNode(), self, aBlock);
            }
            return result;
        }
        node = iVisited.getBodyNode();
        return EvaluationState.evalInternal(runtime, context, node, self, aBlock);
    }

    private static IRubyObject evStrNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        return EvaluationState.evalInternal(runtime, context, ((EvStrNode)node).getBody(), self, aBlock).asString();
    }

    private static IRubyObject falseNode(Ruby runtime, ThreadContext context) {
        return EvaluationState.pollAndReturn(context, runtime.getFalse());
    }

    private static IRubyObject fCallNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        FCallNode iVisited = (FCallNode)node;
        IRubyObject[] args = EvaluationState.setupArgs(runtime, context, iVisited.getArgsNode(), self);
        Block block = EvaluationState.getBlock(runtime, context, self, aBlock, iVisited.getIterNode());
        if (!block.isGiven()) {
            RubyClass module = self.getMetaClass();
            if (module.index != 0 && iVisited.index != 0) {
                return self.callMethod(context, module, iVisited.index, iVisited.getName(), args, CallType.FUNCTIONAL, Block.NULL_BLOCK);
            }
            DynamicMethod method = module.searchMethod(iVisited.getName());
            IRubyObject mmResult = RubyObject.callMethodMissingIfNecessary(context, self, method, iVisited.getName(), args, self, CallType.FUNCTIONAL, Block.NULL_BLOCK);
            if (mmResult != null) {
                return mmResult;
            }
            return method.call(context, self, module, iVisited.getName(), args, false, Block.NULL_BLOCK);
        }
        block6: while (true) {
            try {
                RubyClass module = self.getMetaClass();
                IRubyObject result = self.callMethod(context, module, iVisited.getName(), args, CallType.FUNCTIONAL, block);
                if (result == null) {
                    result = runtime.getNil();
                }
                return result;
            }
            catch (JumpException je) {
                switch (je.getJumpType().getTypeId()) {
                    case 3: {
                        continue block6;
                    }
                    case 0: {
                        if (je.isBreakInKernelLoop()) {
                            if (block == je.getTarget()) {
                                je.setBreakInKernelLoop(false);
                            }
                            throw je;
                        }
                        return (IRubyObject)je.getValue();
                    }
                }
                throw je;
            }
            break;
        }
    }

    private static IRubyObject fixnumNode(Ruby runtime, Node node) {
        return ((FixnumNode)node).getFixnum(runtime);
    }

    private static IRubyObject flipNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        FlipNode iVisited = (FlipNode)node;
        IRubyObject result = runtime.getNil();
        if (iVisited.isExclusive()) {
            if (!context.getCurrentScope().getValue(iVisited.getIndex(), iVisited.getDepth()).isTrue()) {
                result = EvaluationState.evalInternal(runtime, context, iVisited.getBeginNode(), self, aBlock).isTrue() ? runtime.getFalse() : runtime.getTrue();
                context.getCurrentScope().setValue(iVisited.getIndex(), result, iVisited.getDepth());
                return result;
            }
            if (EvaluationState.evalInternal(runtime, context, iVisited.getEndNode(), self, aBlock).isTrue()) {
                context.getCurrentScope().setValue(iVisited.getIndex(), runtime.getFalse(), iVisited.getDepth());
            }
            return runtime.getTrue();
        }
        if (!context.getCurrentScope().getValue(iVisited.getIndex(), iVisited.getDepth()).isTrue()) {
            if (EvaluationState.evalInternal(runtime, context, iVisited.getBeginNode(), self, aBlock).isTrue()) {
                context.getCurrentScope().setValue(iVisited.getIndex(), EvaluationState.evalInternal(runtime, context, iVisited.getEndNode(), self, aBlock).isTrue() ? runtime.getFalse() : runtime.getTrue(), iVisited.getDepth());
                return runtime.getTrue();
            }
            return runtime.getFalse();
        }
        if (EvaluationState.evalInternal(runtime, context, iVisited.getEndNode(), self, aBlock).isTrue()) {
            context.getCurrentScope().setValue(iVisited.getIndex(), runtime.getFalse(), iVisited.getDepth());
        }
        return runtime.getTrue();
    }

    private static IRubyObject floatNode(Ruby runtime, Node node) {
        return RubyFloat.newFloat(runtime, ((FloatNode)node).getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject forNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        ForNode iVisited = (ForNode)node;
        Block block = SharedScopeBlock.createSharedScopeBlock(context, iVisited, context.getCurrentScope(), self);
        block13: while (true) {
            try {
                ISourcePosition position = context.getPosition();
                IRubyObject recv = null;
                try {
                    recv = EvaluationState.evalInternal(runtime, context, iVisited.getIterNode(), self, aBlock);
                }
                finally {
                    context.setPosition(position);
                }
                return recv.callMethod(context, "each", IRubyObject.NULL_ARRAY, CallType.NORMAL, block);
            }
            catch (JumpException je) {
                try {
                    switch (je.getJumpType().getTypeId()) {
                        case 3: {
                            continue block13;
                        }
                    }
                    throw je;
                }
                catch (JumpException je2) {
                    switch (je2.getJumpType().getTypeId()) {
                        case 0: {
                            return (IRubyObject)je2.getValue();
                        }
                    }
                    throw je2;
                }
            }
            break;
        }
    }

    private static IRubyObject globalAsgnNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        GlobalAsgnNode iVisited = (GlobalAsgnNode)node;
        IRubyObject result = EvaluationState.evalInternal(runtime, context, iVisited.getValueNode(), self, aBlock);
        if (iVisited.getName().length() == 2) {
            switch (iVisited.getName().charAt(1)) {
                case '_': {
                    context.getCurrentScope().setLastLine(result);
                    return result;
                }
                case '~': {
                    context.setBackref(result);
                    return result;
                }
            }
        }
        runtime.getGlobalVariables().set(iVisited.getName(), result);
        if (iVisited.getName() == "$KCODE") {
            runtime.setKCode(KCode.create(runtime, result.toString()));
        }
        return result;
    }

    private static IRubyObject globalVarNode(Ruby runtime, ThreadContext context, Node node) {
        GlobalVarNode iVisited = (GlobalVarNode)node;
        if (iVisited.getName().length() == 2) {
            IRubyObject value = null;
            switch (iVisited.getName().charAt(1)) {
                case '_': {
                    value = context.getCurrentScope().getLastLine();
                    if (value == null) {
                        return runtime.getNil();
                    }
                    return value;
                }
                case '~': {
                    value = context.getCurrentScope().getBackRef();
                    if (value == null) {
                        return runtime.getNil();
                    }
                    return value;
                }
            }
        }
        return runtime.getGlobalVariables().get(iVisited.getName());
    }

    private static IRubyObject hashNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        HashNode iVisited = (HashNode)node;
        RubyHash hash = null;
        if (iVisited.getListNode() != null) {
            hash = RubyHash.newHash(runtime);
            int i = 0;
            while (i < iVisited.getListNode().size()) {
                IRubyObject key = EvaluationState.evalInternal(runtime, context, iVisited.getListNode().get(i++), self, aBlock);
                IRubyObject value = EvaluationState.evalInternal(runtime, context, iVisited.getListNode().get(i++), self, aBlock);
                hash.fastASet(key, value);
            }
        }
        if (hash == null) {
            return RubyHash.newHash(runtime);
        }
        return hash;
    }

    private static IRubyObject instAsgnNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        InstAsgnNode iVisited = (InstAsgnNode)node;
        IRubyObject result = EvaluationState.evalInternal(runtime, context, iVisited.getValueNode(), self, aBlock);
        self.setInstanceVariable(iVisited.getName(), result);
        return result;
    }

    private static IRubyObject instVarNode(Ruby runtime, Node node, IRubyObject self) {
        InstVarNode iVisited = (InstVarNode)node;
        IRubyObject variable = self.getInstanceVariable(iVisited.getName());
        return variable == null ? runtime.getNil() : variable;
    }

    private static IRubyObject localAsgnNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        LocalAsgnNode iVisited = (LocalAsgnNode)node;
        IRubyObject result = EvaluationState.evalInternal(runtime, context, iVisited.getValueNode(), self, aBlock);
        context.getCurrentScope().setValue(iVisited.getIndex(), result, iVisited.getDepth());
        return result;
    }

    private static IRubyObject localVarNode(Ruby runtime, ThreadContext context, Node node) {
        LocalVarNode iVisited = (LocalVarNode)node;
        IRubyObject result = context.getCurrentScope().getValue(iVisited.getIndex(), iVisited.getDepth());
        return result == null ? runtime.getNil() : result;
    }

    private static IRubyObject match2Node(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        Match2Node iVisited = (Match2Node)node;
        IRubyObject recv = EvaluationState.evalInternal(runtime, context, iVisited.getReceiverNode(), self, aBlock);
        IRubyObject value = EvaluationState.evalInternal(runtime, context, iVisited.getValueNode(), self, aBlock);
        return ((RubyRegexp)recv).match(value);
    }

    private static IRubyObject match3Node(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        Match3Node iVisited = (Match3Node)node;
        IRubyObject recv = EvaluationState.evalInternal(runtime, context, iVisited.getReceiverNode(), self, aBlock);
        IRubyObject value = EvaluationState.evalInternal(runtime, context, iVisited.getValueNode(), self, aBlock);
        if (value instanceof RubyString) {
            return ((RubyRegexp)recv).match(value);
        }
        return value.callMethod(context, "=~", recv);
    }

    private static IRubyObject matchNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        return ((RubyRegexp)EvaluationState.evalInternal(runtime, context, ((MatchNode)node).getRegexpNode(), self, aBlock)).match2();
    }

    private static IRubyObject moduleNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        ModuleNode iVisited = (ModuleNode)node;
        Colon3Node classNameNode = iVisited.getCPath();
        String name = ((INameNode)classNameNode).getName();
        RubyModule enclosingModule = EvaluationState.getEnclosingModule(runtime, context, classNameNode, self, aBlock);
        if (enclosingModule == null) {
            throw runtime.newTypeError("no outer class/module");
        }
        RubyModule module = enclosingModule == runtime.getObject() ? runtime.getOrCreateModule(name) : enclosingModule.defineModuleUnder(name);
        return EvaluationState.evalClassDefinitionBody(runtime, context, iVisited.getScope(), iVisited.getBodyNode(), module, self, aBlock);
    }

    private static IRubyObject multipleAsgnNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        MultipleAsgnNode iVisited = (MultipleAsgnNode)node;
        switch (iVisited.getValueNode().nodeId) {
            case 5: {
                ArrayNode iVisited2 = (ArrayNode)iVisited.getValueNode();
                IRubyObject[] array = new IRubyObject[iVisited2.size()];
                for (int i = 0; i < iVisited2.size(); ++i) {
                    Node next = iVisited2.get(i);
                    array[i] = EvaluationState.evalInternal(runtime, context, next, self, aBlock);
                }
                return AssignmentVisitor.multiAssign(runtime, context, self, iVisited, RubyArray.newArrayNoCopyLight(runtime, array), false);
            }
            case 81: {
                SplatNode splatNode = (SplatNode)iVisited.getValueNode();
                RubyArray rubyArray = EvaluationState.splatValue(runtime, EvaluationState.evalInternal(runtime, context, splatNode.getValue(), self, aBlock));
                return AssignmentVisitor.multiAssign(runtime, context, self, iVisited, rubyArray, false);
            }
        }
        IRubyObject value = EvaluationState.evalInternal(runtime, context, iVisited.getValueNode(), self, aBlock);
        if (!(value instanceof RubyArray)) {
            value = RubyArray.newArray(runtime, value);
        }
        return AssignmentVisitor.multiAssign(runtime, context, self, iVisited, (RubyArray)value, false);
    }

    private static IRubyObject nextNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        NextNode iVisited = (NextNode)node;
        context.pollThreadEvents();
        IRubyObject result = EvaluationState.evalInternal(runtime, context, iVisited.getValueNode(), self, aBlock);
        JumpException je = context.controlException;
        je.setJumpType(JumpException.JumpType.NextJump);
        je.setTarget(iVisited);
        je.setValue(result);
        throw je;
    }

    private static IRubyObject nilNode(Ruby runtime, ThreadContext context) {
        return EvaluationState.pollAndReturn(context, runtime.getNil());
    }

    private static IRubyObject notNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        NotNode iVisited = (NotNode)node;
        IRubyObject result = EvaluationState.evalInternal(runtime, context, iVisited.getConditionNode(), self, aBlock);
        return result.isTrue() ? runtime.getFalse() : runtime.getTrue();
    }

    private static IRubyObject nthRefNode(ThreadContext context, Node node) {
        return RubyRegexp.nth_match(((NthRefNode)node).getMatchNumber(), context.getBackref());
    }

    private static IRubyObject pollAndReturn(ThreadContext context, IRubyObject result) {
        context.pollThreadEvents();
        return result;
    }

    private static IRubyObject opAsgnNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        OpAsgnNode iVisited = (OpAsgnNode)node;
        IRubyObject receiver = EvaluationState.evalInternal(runtime, context, iVisited.getReceiverNode(), self, aBlock);
        IRubyObject value = receiver.callMethod(context, iVisited.getVariableName());
        if (iVisited.getOperatorName() == "||") {
            if (value.isTrue()) {
                return EvaluationState.pollAndReturn(context, value);
            }
            value = EvaluationState.evalInternal(runtime, context, iVisited.getValueNode(), self, aBlock);
        } else if (iVisited.getOperatorName() == "&&") {
            if (!value.isTrue()) {
                return EvaluationState.pollAndReturn(context, value);
            }
            value = EvaluationState.evalInternal(runtime, context, iVisited.getValueNode(), self, aBlock);
        } else {
            value = value.callMethod(context, iVisited.index, iVisited.getOperatorName(), EvaluationState.evalInternal(runtime, context, iVisited.getValueNode(), self, aBlock));
        }
        receiver.callMethod(context, iVisited.getVariableNameAsgn(), value);
        return EvaluationState.pollAndReturn(context, value);
    }

    private static IRubyObject opAsgnOrNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        OpAsgnOrNode iVisited = (OpAsgnOrNode)node;
        String def = EvaluationState.getDefinition(runtime, context, iVisited.getFirstNode(), self, aBlock);
        IRubyObject result = runtime.getNil();
        if (def != null) {
            result = EvaluationState.evalInternal(runtime, context, iVisited.getFirstNode(), self, aBlock);
        }
        if (!result.isTrue()) {
            result = EvaluationState.evalInternal(runtime, context, iVisited.getSecondNode(), self, aBlock);
        }
        return EvaluationState.pollAndReturn(context, result);
    }

    private static IRubyObject opElementAsgnNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        OpElementAsgnNode iVisited = (OpElementAsgnNode)node;
        IRubyObject receiver = EvaluationState.evalInternal(runtime, context, iVisited.getReceiverNode(), self, aBlock);
        IRubyObject[] args = EvaluationState.setupArgs(runtime, context, iVisited.getArgsNode(), self);
        IRubyObject firstValue = receiver.callMethod(context, 4, "[]", args);
        if (iVisited.getOperatorName() == "||") {
            if (firstValue.isTrue()) {
                return firstValue;
            }
            firstValue = EvaluationState.evalInternal(runtime, context, iVisited.getValueNode(), self, aBlock);
        } else if (iVisited.getOperatorName() == "&&") {
            if (!firstValue.isTrue()) {
                return firstValue;
            }
            firstValue = EvaluationState.evalInternal(runtime, context, iVisited.getValueNode(), self, aBlock);
        } else {
            firstValue = firstValue.callMethod(context, iVisited.index, iVisited.getOperatorName(), EvaluationState.evalInternal(runtime, context, iVisited.getValueNode(), self, aBlock));
        }
        IRubyObject[] expandedArgs = new IRubyObject[args.length + 1];
        System.arraycopy(args, 0, expandedArgs, 0, args.length);
        expandedArgs[expandedArgs.length - 1] = firstValue;
        return receiver.callMethod(context, 5, "[]=", expandedArgs);
    }

    private static IRubyObject optNNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        OptNNode iVisited = (OptNNode)node;
        IRubyObject result = runtime.getNil();
        block7: while (RubyKernel.gets(runtime.getTopSelf(), IRubyObject.NULL_ARRAY).isTrue()) {
            while (true) {
                try {
                    result = EvaluationState.evalInternal(runtime, context, iVisited.getBodyNode(), self, aBlock);
                    continue block7;
                }
                catch (JumpException je) {
                    switch (je.getJumpType().getTypeId()) {
                        case 2: {
                            break;
                        }
                        case 1: {
                            continue block7;
                        }
                        case 0: {
                            result = (IRubyObject)je.getValue();
                            break block7;
                        }
                        default: {
                            throw je;
                        }
                    }
                    continue;
                }
                break;
            }
        }
        return EvaluationState.pollAndReturn(context, result);
    }

    private static IRubyObject orNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        OrNode iVisited = (OrNode)node;
        IRubyObject result = EvaluationState.evalInternal(runtime, context, iVisited.getFirstNode(), self, aBlock);
        if (!result.isTrue()) {
            result = EvaluationState.evalInternal(runtime, context, iVisited.getSecondNode(), self, aBlock);
        }
        return result;
    }

    private static IRubyObject postExeNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        PostExeNode iVisited = (PostExeNode)node;
        Block block = SharedScopeBlock.createSharedScopeBlock(context, iVisited, context.getCurrentScope(), self);
        runtime.pushExitBlock(runtime.newProc(true, block));
        return runtime.getNil();
    }

    private static IRubyObject redoNode(ThreadContext context, Node node) {
        context.pollThreadEvents();
        JumpException je = context.controlException;
        je.setJumpType(JumpException.JumpType.RedoJump);
        je.setValue(node);
        throw je;
    }

    private static IRubyObject regexpNode(Ruby runtime, Node node) {
        RegexpNode iVisited = (RegexpNode)node;
        String lang = null;
        int opts = iVisited.getOptions();
        if ((opts & 0x10) != 0) {
            lang = "n";
        } else if ((opts & 0x30) != 0) {
            lang = "s";
        } else if ((opts & 0x40) != 0) {
            lang = "u";
        }
        try {
            return RubyRegexp.newRegexp(runtime, iVisited.getValue().toString(), iVisited.getPattern(), iVisited.getFlags(), lang);
        }
        catch (PatternSyntaxException e) {
            throw runtime.newRegexpError(e.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    private static IRubyObject rescueNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 9[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static IRubyObject retryNode(ThreadContext context) {
        context.pollThreadEvents();
        JumpException je = context.controlException;
        je.setJumpType(JumpException.JumpType.RetryJump);
        throw je;
    }

    private static IRubyObject returnNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        ReturnNode iVisited = (ReturnNode)node;
        IRubyObject result = EvaluationState.evalInternal(runtime, context, iVisited.getValueNode(), self, aBlock);
        JumpException je = context.controlException;
        je.setJumpType(JumpException.JumpType.ReturnJump);
        je.setTarget(context.getFrameJumpTarget());
        je.setValue(result);
        throw je;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject rootNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        RootNode iVisited = (RootNode)node;
        DynamicScope scope = iVisited.getScope();
        if (scope == null) {
            scope = new DynamicScope(iVisited.getStaticScope(), null);
        }
        context.preRootNode(scope);
        try {
            IRubyObject iRubyObject = EvaluationState.evalInternal(runtime, context, iVisited.getBodyNode(), self, aBlock);
            return iRubyObject;
        }
        finally {
            context.postRootNode();
        }
    }

    private static IRubyObject sClassNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        RubyClass singletonClass;
        SClassNode iVisited = (SClassNode)node;
        IRubyObject receiver = EvaluationState.evalInternal(runtime, context, iVisited.getReceiverNode(), self, aBlock);
        if (receiver.isNil()) {
            singletonClass = runtime.getNilClass();
        } else if (receiver == runtime.getTrue()) {
            singletonClass = runtime.getClass("TrueClass");
        } else if (receiver == runtime.getFalse()) {
            singletonClass = runtime.getClass("FalseClass");
        } else {
            if (receiver.getMetaClass() == runtime.getFixnum() || receiver.getMetaClass() == runtime.getClass("Symbol")) {
                throw runtime.newTypeError("no virtual class for " + receiver.getMetaClass().getBaseName());
            }
            if (runtime.getSafeLevel() >= 4 && !receiver.isTaint()) {
                throw runtime.newSecurityError("Insecure: can't extend object.");
            }
            singletonClass = receiver.getSingletonClass();
        }
        return EvaluationState.evalClassDefinitionBody(runtime, context, iVisited.getScope(), iVisited.getBodyNode(), singletonClass, self, aBlock);
    }

    private static IRubyObject splatNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        return EvaluationState.splatValue(runtime, EvaluationState.evalInternal(runtime, context, ((SplatNode)node).getValue(), self, aBlock));
    }

    private static IRubyObject strNode(Ruby runtime, Node node) {
        return runtime.newStringShared(((StrNode)node).getValue());
    }

    private static IRubyObject superNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        SuperNode iVisited = (SuperNode)node;
        RubyModule klazz = context.getFrameKlazz();
        if (klazz == null) {
            String name = context.getFrameName();
            throw runtime.newNameError("Superclass method '" + name + "' disabled.", name);
        }
        IRubyObject[] args = EvaluationState.setupArgs(runtime, context, iVisited.getArgsNode(), self);
        Block block = EvaluationState.getBlock(runtime, context, self, aBlock, iVisited.getIterNode());
        if (!block.isGiven()) {
            block = aBlock;
        }
        return self.callSuper(context, args, block);
    }

    private static IRubyObject sValueNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        return EvaluationState.aValueSplat(runtime, EvaluationState.evalInternal(runtime, context, ((SValueNode)node).getValue(), self, aBlock));
    }

    private static IRubyObject symbolNode(Ruby runtime, Node node) {
        return runtime.newSymbol(((SymbolNode)node).getName());
    }

    private static IRubyObject toAryNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        return EvaluationState.aryToAry(runtime, EvaluationState.evalInternal(runtime, context, ((ToAryNode)node).getValue(), self, aBlock));
    }

    private static IRubyObject trueNode(Ruby runtime, ThreadContext context) {
        return EvaluationState.pollAndReturn(context, runtime.getTrue());
    }

    private static IRubyObject undefNode(Ruby runtime, ThreadContext context, Node node) {
        UndefNode iVisited = (UndefNode)node;
        if (context.getRubyClass() == null) {
            throw runtime.newTypeError("No class to undef method '" + iVisited.getName() + "'.");
        }
        context.getRubyClass().undef(iVisited.getName());
        return runtime.getNil();
    }

    private static IRubyObject untilNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        UntilNode iVisited = (UntilNode)node;
        IRubyObject result = runtime.getNil();
        block7: while (!(result = EvaluationState.evalInternal(runtime, context, iVisited.getConditionNode(), self, aBlock)).isTrue()) {
            block8: while (true) {
                try {
                    result = EvaluationState.evalInternal(runtime, context, iVisited.getBodyNode(), self, aBlock);
                    continue block7;
                }
                catch (JumpException je) {
                    switch (je.getJumpType().getTypeId()) {
                        case 2: {
                            continue block8;
                        }
                        case 1: {
                            continue block7;
                        }
                        case 0: {
                            if (je.getTarget() == aBlock) {
                                je.setTarget(null);
                                throw je;
                            }
                            result = (IRubyObject)je.getValue();
                            break block7;
                        }
                        default: {
                            throw je;
                        }
                    }
                }
                break;
            }
        }
        return EvaluationState.pollAndReturn(context, result);
    }

    private static IRubyObject valiasNode(Ruby runtime, Node node) {
        VAliasNode iVisited = (VAliasNode)node;
        runtime.getGlobalVariables().alias(iVisited.getNewName(), iVisited.getOldName());
        return runtime.getNil();
    }

    private static IRubyObject vcallNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self) {
        VCallNode iVisited = (VCallNode)node;
        RubyClass module = self.getMetaClass();
        if (module.index != 0 && iVisited.index != 0) {
            return self.callMethod(context, module, iVisited.index, iVisited.getName(), IRubyObject.NULL_ARRAY, CallType.VARIABLE, Block.NULL_BLOCK);
        }
        DynamicMethod method = module.searchMethod(iVisited.getName());
        IRubyObject mmResult = RubyObject.callMethodMissingIfNecessary(context, self, method, iVisited.getName(), IRubyObject.NULL_ARRAY, self, CallType.VARIABLE, Block.NULL_BLOCK);
        if (mmResult != null) {
            return mmResult;
        }
        return method.call(context, self, module, iVisited.getName(), IRubyObject.NULL_ARRAY, false, Block.NULL_BLOCK);
    }

    private static IRubyObject whileNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        WhileNode iVisited = (WhileNode)node;
        IRubyObject result = runtime.getNil();
        boolean firstTest = iVisited.evaluateAtStart();
        block7: while (!firstTest || (result = EvaluationState.evalInternal(runtime, context, iVisited.getConditionNode(), self, aBlock)).isTrue()) {
            firstTest = true;
            block8: while (true) {
                try {
                    EvaluationState.evalInternal(runtime, context, iVisited.getBodyNode(), self, aBlock);
                    continue block7;
                }
                catch (JumpException je) {
                    switch (je.getJumpType().getTypeId()) {
                        case 2: {
                            continue block8;
                        }
                        case 1: {
                            continue block7;
                        }
                        case 0: {
                            if (je.getTarget() != aBlock) break block7;
                            je.setTarget(null);
                            throw je;
                        }
                        default: {
                            throw je;
                        }
                    }
                }
                break;
            }
        }
        return EvaluationState.pollAndReturn(context, result);
    }

    private static IRubyObject xStrNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self) {
        return self.callMethod(context, "`", runtime.newStringShared(((XStrNode)node).getValue()));
    }

    private static IRubyObject yieldNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        YieldNode iVisited = (YieldNode)node;
        IRubyObject result = null;
        if (iVisited.getArgsNode() != null) {
            result = EvaluationState.evalInternal(runtime, context, iVisited.getArgsNode(), self, aBlock);
        }
        Block block = context.getCurrentFrame().getBlock();
        return block.yield(context, result, null, null, iVisited.getCheckState());
    }

    private static IRubyObject zArrayNode(Ruby runtime) {
        return runtime.newArray();
    }

    private static IRubyObject zsuperNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        if (context.getFrameKlazz() == null) {
            String name = context.getFrameName();
            throw runtime.newNameError("superclass method '" + name + "' disabled", name);
        }
        Block block = EvaluationState.getBlock(runtime, context, self, aBlock, ((ZSuperNode)node).getIterNode());
        if (!block.isGiven()) {
            block = context.getCurrentFrame().getBlock();
        }
        context.getCurrentScope().getArgValues(context.getFrameArgs(), context.getCurrentFrame().getRequiredArgCount());
        return self.callSuper(context, context.getFrameArgs(), block);
    }

    public static IRubyObject aValueSplat(Ruby runtime, IRubyObject value) {
        if (!(value instanceof RubyArray) || ((RubyArray)value).length().getLongValue() == 0L) {
            return runtime.getNil();
        }
        RubyArray array = (RubyArray)value;
        return array.getLength() == 1 ? array.first(IRubyObject.NULL_ARRAY) : array;
    }

    private static void callTraceFunction(Ruby runtime, ThreadContext context, String event, IRubyObject zelf) {
        String name = context.getFrameName();
        RubyModule type = context.getFrameKlazz();
        runtime.callTraceFunction(context, event, context.getPosition(), RubyBinding.newBinding(runtime), name, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject evalClassDefinitionBody(Ruby runtime, ThreadContext context, StaticScope scope, Node bodyNode, RubyModule type, IRubyObject self, Block block) {
        context.preClassEval(scope, type);
        try {
            if (EvaluationState.isTrace(runtime)) {
                EvaluationState.callTraceFunction(runtime, context, "class", type);
            }
            IRubyObject iRubyObject = EvaluationState.evalInternal(runtime, context, bodyNode, type, block);
            return iRubyObject;
        }
        finally {
            if (EvaluationState.isTrace(runtime)) {
                EvaluationState.callTraceFunction(runtime, context, "end", null);
            }
            context.postClassEval();
        }
    }

    private static String getArgumentDefinition(Ruby runtime, ThreadContext context, Node node, String type, IRubyObject self, Block block) {
        if (node == null) {
            return type;
        }
        if (node instanceof ArrayNode) {
            for (int i = 0; i < ((ArrayNode)node).size(); ++i) {
                Node iterNode = ((ArrayNode)node).get(i);
                if (EvaluationState.getDefinitionInner(runtime, context, iterNode, self, block) != null) continue;
                return null;
            }
        } else if (EvaluationState.getDefinitionInner(runtime, context, node, self, block) == null) {
            return null;
        }
        return type;
    }

    public static Block getBlock(Ruby runtime, ThreadContext context, IRubyObject self, Block currentBlock, Node blockNode) {
        if (blockNode == null) {
            return Block.NULL_BLOCK;
        }
        if (blockNode instanceof IterNode) {
            IterNode iterNode = (IterNode)blockNode;
            return Block.createBlock(context, iterNode, new DynamicScope(iterNode.getScope(), context.getCurrentScope()), self);
        }
        if (blockNode instanceof BlockPassNode) {
            RubyProc procObject;
            BlockPassNode blockPassNode = (BlockPassNode)blockNode;
            IRubyObject proc = EvaluationState.evalInternal(runtime, context, blockPassNode.getBodyNode(), self, currentBlock);
            if (proc.isNil()) {
                return Block.NULL_BLOCK;
            }
            if (!(proc instanceof RubyProc) && !((proc = proc.convertToType(runtime.getClass("Proc"), 0, "to_proc", false)) instanceof RubyProc)) {
                throw runtime.newTypeError("wrong argument type " + proc.getMetaClass().getName() + " (expected Proc)");
            }
            if (currentBlock.isGiven() && (procObject = currentBlock.getProcObject()) != null && procObject == proc) {
                return currentBlock;
            }
            return ((RubyProc)proc).getBlock();
        }
        assert (false) : "Trying to get block from something which cannot deliver";
        return null;
    }

    public static RubyModule getClassVariableBase(ThreadContext context, Ruby runtime) {
        SinglyLinkedList cref = context.peekCRef();
        RubyModule rubyClass = (RubyModule)cref.getValue();
        if (rubyClass.isSingleton()) {
            cref = cref.getNext();
            rubyClass = (RubyModule)cref.getValue();
            if (cref.getNext() == null) {
                runtime.getWarnings().warn("class variable access from toplevel singleton method");
            }
        }
        return rubyClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDefinition(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        try {
            context.setWithinDefined(true);
            String string = EvaluationState.getDefinitionInner(runtime, context, node, self, aBlock);
            return string;
        }
        finally {
            context.setWithinDefined(false);
        }
    }

    private static String getDefinitionInner(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        if (node == null) {
            return "expression";
        }
        switch (node.nodeId) {
            case 102: {
                AttrAssignNode iVisited = (AttrAssignNode)node;
                if (EvaluationState.getDefinitionInner(runtime, context, iVisited.getReceiverNode(), self, aBlock) != null) {
                    try {
                        IRubyObject receiver = EvaluationState.eval(runtime, context, iVisited.getReceiverNode(), self, aBlock);
                        RubyClass metaClass = receiver.getMetaClass();
                        DynamicMethod method = metaClass.searchMethod(iVisited.getName());
                        Visibility visibility = method.getVisibility();
                        if (!visibility.isPrivate() && (!visibility.isProtected() || self.isKindOf(metaClass.getRealClass())) && metaClass.isMethodBound(iVisited.getName(), false)) {
                            return EvaluationState.getArgumentDefinition(runtime, context, iVisited.getArgsNode(), "assignment", self, aBlock);
                        }
                    }
                    catch (JumpException excptn) {
                        // empty catch block
                    }
                }
                return null;
            }
            case 7: {
                return "$" + ((BackRefNode)node).getType();
            }
            case 15: {
                CallNode iVisited = (CallNode)node;
                if (EvaluationState.getDefinitionInner(runtime, context, iVisited.getReceiverNode(), self, aBlock) != null) {
                    try {
                        IRubyObject receiver = EvaluationState.eval(runtime, context, iVisited.getReceiverNode(), self, aBlock);
                        RubyClass metaClass = receiver.getMetaClass();
                        DynamicMethod method = metaClass.searchMethod(iVisited.getName());
                        Visibility visibility = method.getVisibility();
                        if (!visibility.isPrivate() && (!visibility.isProtected() || self.isKindOf(metaClass.getRealClass())) && metaClass.isMethodBound(iVisited.getName(), false)) {
                            return EvaluationState.getArgumentDefinition(runtime, context, iVisited.getArgsNode(), "method", self, aBlock);
                        }
                    }
                    catch (JumpException excptn) {
                        // empty catch block
                    }
                }
                return null;
            }
            case 18: 
            case 19: 
            case 23: 
            case 25: 
            case 43: 
            case 52: 
            case 58: 
            case 66: 
            case 68: {
                return "assignment";
            }
            case 20: {
                ClassVarNode iVisited = (ClassVarNode)node;
                if (context.getRubyClass() == null && self.getMetaClass().isClassVarDefined(iVisited.getName())) {
                    return "class_variable";
                }
                if (!context.getRubyClass().isSingleton() && context.getRubyClass().isClassVarDefined(iVisited.getName())) {
                    return "class_variable";
                }
                RubyModule module = (RubyModule)context.getRubyClass().getInstanceVariable("__attached__");
                if (module != null && module.isClassVarDefined(iVisited.getName())) {
                    return "class_variable";
                }
                return null;
            }
            case 21: {
                Colon2Node iVisited = (Colon2Node)node;
                try {
                    IRubyObject left = EvaluationState.eval(runtime, context, iVisited.getLeftNode(), self, aBlock);
                    if (left instanceof RubyModule && ((RubyModule)left).getConstantAt(iVisited.getName()) != null) {
                        return "constant";
                    }
                    if (left.getMetaClass().isMethodBound(iVisited.getName(), true)) {
                        return "method";
                    }
                }
                catch (JumpException excptn) {
                    // empty catch block
                }
                return null;
            }
            case 24: {
                if (context.getConstantDefined(((ConstNode)node).getName())) {
                    return "constant";
                }
                return null;
            }
            case 33: {
                return "local-variable(in-block)";
            }
            case 37: {
                return "false";
            }
            case 38: {
                FCallNode iVisited = (FCallNode)node;
                if (self.getMetaClass().isMethodBound(iVisited.getName(), false)) {
                    return EvaluationState.getArgumentDefinition(runtime, context, iVisited.getArgsNode(), "method", self, aBlock);
                }
                return null;
            }
            case 44: {
                if (runtime.getGlobalVariables().isDefined(((GlobalVarNode)node).getName())) {
                    return "global-variable";
                }
                return null;
            }
            case 48: {
                if (self.getInstanceVariable(((InstVarNode)node).getName()) != null) {
                    return "instance-variable";
                }
                return null;
            }
            case 53: {
                return "local-variable";
            }
            case 54: 
            case 55: {
                return "method";
            }
            case 61: {
                return "nil";
            }
            case 64: {
                return "$" + ((NthRefNode)node).getMatchNumber();
            }
            case 80: {
                return "state.getSelf()";
            }
            case 84: {
                SuperNode iVisited = (SuperNode)node;
                String name = context.getFrameName();
                RubyModule klazz = context.getFrameKlazz();
                if (name != null && klazz != null && klazz.getSuperClass().isMethodBound(name, false)) {
                    return EvaluationState.getArgumentDefinition(runtime, context, iVisited.getArgsNode(), "super", self, aBlock);
                }
                return null;
            }
            case 88: {
                return "true";
            }
            case 92: {
                VCallNode iVisited = (VCallNode)node;
                if (self.getMetaClass().isMethodBound(iVisited.getName(), false)) {
                    return "method";
                }
                return null;
            }
            case 96: {
                return aBlock.isGiven() ? "yield" : null;
            }
            case 99: {
                String name = context.getFrameName();
                RubyModule klazz = context.getFrameKlazz();
                if (name != null && klazz != null && klazz.getSuperClass().isMethodBound(name, false)) {
                    return "super";
                }
                return null;
            }
        }
        try {
            EvaluationState.eval(runtime, context, node, self, aBlock);
            return "expression";
        }
        catch (JumpException jumpExcptn) {
            return null;
        }
    }

    private static RubyModule getEnclosingModule(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block block) {
        RubyModule enclosingModule = null;
        if (node instanceof Colon2Node) {
            IRubyObject result = EvaluationState.evalInternal(runtime, context, ((Colon2Node)node).getLeftNode(), self, block);
            if (result != null && !result.isNil()) {
                enclosingModule = (RubyModule)result;
            }
        } else if (node instanceof Colon3Node) {
            enclosingModule = runtime.getObject();
        }
        if (enclosingModule == null) {
            enclosingModule = (RubyModule)context.peekCRef().getValue();
        }
        return enclosingModule;
    }

    private static boolean isRescueHandled(Ruby runtime, ThreadContext context, RubyException currentException, ListNode exceptionNodes, IRubyObject self) {
        if (exceptionNodes == null) {
            return currentException.isKindOf(runtime.getClass("StandardError"));
        }
        IRubyObject[] args = EvaluationState.setupArgs(runtime, context, exceptionNodes, self);
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].isKindOf(runtime.getClass("Module"))) {
                throw runtime.newTypeError("class or module required for rescue clause");
            }
            if (!args[i].callMethod(context, "===", currentException).isTrue()) continue;
            return true;
        }
        return false;
    }

    private static boolean isTrace(Ruby runtime) {
        return runtime.getTraceFunction() != null;
    }

    private static IRubyObject[] setupArgs(Ruby runtime, ThreadContext context, Node node, IRubyObject self) {
        if (node == null) {
            return IRubyObject.NULL_ARRAY;
        }
        if (node instanceof ArrayNode) {
            ArrayNode argsArrayNode = (ArrayNode)node;
            ISourcePosition position = context.getPosition();
            int size = argsArrayNode.size();
            IRubyObject[] argsArray = new IRubyObject[size];
            for (int i = 0; i < size; ++i) {
                argsArray[i] = EvaluationState.evalInternal(runtime, context, argsArrayNode.get(i), self, Block.NULL_BLOCK);
            }
            context.setPosition(position);
            return argsArray;
        }
        return ArgsUtil.convertToJavaArray(EvaluationState.evalInternal(runtime, context, node, self, Block.NULL_BLOCK));
    }

    public static RubyArray splatValue(Ruby runtime, IRubyObject value) {
        if (value.isNil()) {
            return runtime.newArray(value);
        }
        return EvaluationState.arrayValue(runtime, value);
    }
}

