/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.WritableByteChannel;
import org.jruby.Ruby;
import org.jruby.RubyIO;
import org.jruby.RubyString;
import org.jruby.util.ByteList;
import org.jruby.util.IOHandler;
import org.jruby.util.IOModes;

public class IOHandlerNio
extends IOHandler {
    private Channel channel;
    private static final int BLOCK_SIZE = 16384;
    private ByteBuffer outBuffer;
    private ByteBuffer inBuffer;
    private boolean blocking = true;
    private boolean bufferedIO = false;
    int ungotc = -1;

    public IOHandlerNio(Ruby runtime, Channel channel) throws IOException {
        super(runtime);
        String mode = "";
        this.channel = channel;
        if (channel instanceof ReadableByteChannel) {
            mode = mode + "r";
            this.isOpen = true;
        }
        if (channel instanceof WritableByteChannel) {
            mode = mode + "w";
            this.isOpen = true;
        }
        if ("rw".equals(mode)) {
            this.modes = new IOModes(runtime, 2L);
            this.isOpen = true;
        } else {
            if (!this.isOpen) {
                mode = "r";
                this.isOpen = true;
            }
            this.modes = new IOModes(runtime, mode);
        }
        this.fileno = RubyIO.getNewFileno();
        this.outBuffer = ByteBuffer.allocate(16384);
    }

    public Channel getChannel() {
        return this.channel;
    }

    public IOHandler cloneIOHandler() throws IOException {
        return new IOHandlerNio(this.getRuntime(), this.channel);
    }

    private void checkBuffered() throws IOException {
        if (this.bufferedIO) {
            throw new IOException("Can't mix buffered and unbuffered IO.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlocking(boolean block) throws IOException {
        if (!(this.channel instanceof SelectableChannel)) {
            return;
        }
        Object object = ((SelectableChannel)this.channel).blockingLock();
        synchronized (object) {
            this.blocking = block;
            try {
                ((SelectableChannel)this.channel).configureBlocking(block);
            }
            catch (IllegalBlockingModeException illegalBlockingModeException) {
                // empty catch block
            }
        }
    }

    public boolean getBlocking() {
        return this.blocking;
    }

    public ByteList sysread(int length) throws EOFException, IOHandler.BadDescriptorException, IOException {
        byte[] ret;
        this.checkReadable();
        this.checkBuffered();
        ByteBuffer buffer = ByteBuffer.allocate(length);
        int bytes_read = 0;
        bytes_read = ((ReadableByteChannel)this.channel).read(buffer);
        if (bytes_read < 0) {
            throw new EOFException();
        }
        if (buffer.hasRemaining()) {
            buffer.flip();
            ret = new byte[buffer.remaining()];
            buffer.get(ret);
        } else {
            ret = buffer.array();
        }
        return new ByteList(ret, false);
    }

    public int syswrite(ByteList string) throws IOHandler.BadDescriptorException, IOException {
        this.checkWritable();
        this.outBuffer.flip();
        this.flushOutBuffer();
        ByteBuffer buffer = ByteBuffer.wrap(string.bytes, string.begin, string.realSize);
        while (buffer.hasRemaining()) {
            if (((WritableByteChannel)this.channel).write(buffer) >= 0) continue;
            throw new IOException("write returned less than zero");
        }
        return buffer.capacity();
    }

    public int syswrite(int c) throws IOHandler.BadDescriptorException, IOException {
        ByteBuffer buffer = ByteBuffer.allocate(1);
        buffer.put((byte)c);
        return this.syswrite(new ByteList(buffer.array(), false));
    }

    public ByteList recv(int length) throws EOFException, IOHandler.BadDescriptorException, IOException {
        return this.sysread(length);
    }

    private void setupBufferedIO() {
        if (this.bufferedIO) {
            return;
        }
        this.inBuffer = ByteBuffer.allocate(16384);
        this.flushInBuffer();
        this.bufferedIO = true;
    }

    private ByteList consumeInBuffer(int length) {
        int offset = 0;
        if (this.ungotc > 0) {
            --length;
            offset = 1;
        }
        length = this.inBuffer.remaining() < length ? this.inBuffer.remaining() : length;
        byte[] ret = new byte[length + offset];
        this.inBuffer.get(ret, offset, length);
        if (this.ungotc > 0) {
            ret[0] = (byte)(this.ungotc & 0xFF);
            this.ungotc = -1;
        }
        return new ByteList(ret, false);
    }

    private int fillInBuffer() throws IOException {
        this.inBuffer.clear();
        int i = ((ReadableByteChannel)this.channel).read(this.inBuffer);
        this.inBuffer.flip();
        return i;
    }

    private void flushInBuffer() {
        this.inBuffer.position(0);
        this.inBuffer.limit(0);
        this.ungotc = -1;
    }

    private void flushOutBuffer() throws IOException {
        while (this.outBuffer.hasRemaining()) {
            if (((WritableByteChannel)this.channel).write(this.outBuffer) >= 0) continue;
            throw new IOException("write returned less than zero");
        }
        this.outBuffer.clear();
    }

    private int buffer_index(ByteBuffer haystack, ByteList needle) {
        int i = haystack.position();
        while (i + (needle.realSize - 1) < haystack.limit()) {
            block3: {
                for (int j = 0; j < needle.realSize; ++j) {
                    if (haystack.get(i + j) == needle.bytes[needle.begin + j]) {
                        continue;
                    }
                    break block3;
                }
                return i;
            }
            ++i;
        }
        return -1;
    }

    public ByteList readpartial(int length) throws IOException, IOHandler.BadDescriptorException, EOFException {
        this.checkReadable();
        this.setupBufferedIO();
        if (!this.inBuffer.hasRemaining() && length > 0 && this.fillInBuffer() < 0) {
            throw new EOFException();
        }
        return this.consumeInBuffer(length);
    }

    public ByteList read(int length) throws IOException, IOHandler.BadDescriptorException, EOFException {
        this.setupBufferedIO();
        this.checkReadable();
        boolean eof = false;
        int remaining = length;
        ByteList ret = new ByteList(length);
        ret.append(this.consumeInBuffer(remaining));
        remaining -= ret.length();
        while (remaining > 0) {
            int i = this.fillInBuffer();
            if (i < 0) {
                eof = true;
                break;
            }
            ret.append(this.consumeInBuffer(remaining));
            remaining -= i;
        }
        if (eof && ret.length() == 0) {
            throw new EOFException();
        }
        return ret;
    }

    public int write(ByteList string) throws IOException, IOHandler.BadDescriptorException {
        this.checkWritable();
        ByteBuffer buffer = ByteBuffer.wrap(string.bytes, string.begin, string.realSize);
        while (true) {
            if (buffer.hasRemaining() && this.outBuffer.hasRemaining()) {
                this.outBuffer.put(buffer.get());
                continue;
            }
            this.outBuffer.flip();
            if (buffer.hasRemaining() && !this.outBuffer.hasRemaining() || this.isSync()) {
                this.flushOutBuffer();
            }
            if (!buffer.hasRemaining()) break;
        }
        if (!this.isSync()) {
            this.flushOutBuffer();
        }
        return buffer.capacity();
    }

    public ByteList gets(ByteList separator) throws IOException, IOHandler.BadDescriptorException, EOFException {
        int idx;
        this.setupBufferedIO();
        this.checkReadable();
        ByteList ret = new ByteList();
        boolean eof = false;
        ByteList trigger = separator != null ? separator : ((RubyString)this.getRuntime().getGlobalVariables().get("$/")).getByteList();
        while ((idx = this.buffer_index(this.inBuffer, trigger)) < 0 && !eof) {
            ret.append(this.consumeInBuffer(16384));
            if (this.fillInBuffer() >= 0) continue;
            eof = true;
        }
        if (eof && !this.inBuffer.hasRemaining() && ret.length() == 0) {
            throw new EOFException();
        }
        if (idx >= 0) {
            ret.append(this.consumeInBuffer(idx + trigger.realSize - this.inBuffer.position()));
        } else if (eof) {
            ret.append(this.consumeInBuffer(16384));
        }
        return ret;
    }

    public ByteList getsEntireStream() throws IOException, IOHandler.BadDescriptorException, EOFException {
        this.checkReadable();
        this.setupBufferedIO();
        ByteList ret = new ByteList();
        do {
            ret.append(this.consumeInBuffer(16384));
        } while (this.fillInBuffer() >= 0);
        boolean eof = true;
        if (eof && ret.length() == 0) {
            throw new EOFException();
        }
        return ret;
    }

    public int getc() throws IOException, IOHandler.BadDescriptorException, EOFException {
        this.checkReadable();
        this.setupBufferedIO();
        if (this.ungotc > 0) {
            int i = this.ungotc;
            this.ungotc = -1;
            return i;
        }
        if (!this.inBuffer.hasRemaining() && this.fillInBuffer() < 0) {
            throw new EOFException();
        }
        return this.inBuffer.get() & 0xFF;
    }

    public void ungetc(int c) {
        this.setupBufferedIO();
        this.ungotc = c;
    }

    public void putc(int c) throws IOException, IOHandler.BadDescriptorException {
        this.checkWritable();
        if (!this.outBuffer.hasRemaining()) {
            this.outBuffer.flip();
            this.flushOutBuffer();
        }
        this.outBuffer.put((byte)(c & 0xFF));
    }

    public void flush() throws IOException, IOHandler.BadDescriptorException {
        this.checkWritable();
        this.outBuffer.flip();
        this.flushOutBuffer();
    }

    public void sync() throws IOException, IOHandler.BadDescriptorException {
        this.flush();
    }

    public boolean isEOF() throws IOException, IOHandler.BadDescriptorException {
        this.setupBufferedIO();
        this.checkReadable();
        if (this.ungotc > 0) {
            return false;
        }
        if (this.inBuffer.hasRemaining()) {
            return false;
        }
        return this.fillInBuffer() < 0;
    }

    public void close() throws IOException {
        if (this.outBuffer.position() > 0) {
            this.outBuffer.flip();
            this.flushOutBuffer();
        }
        this.channel.close();
    }

    public long pos() throws IOHandler.PipeException, IOException {
        if (this.channel instanceof FileChannel) {
            if (this.bufferedIO) {
                return ((FileChannel)this.channel).position() - (long)(this.inBuffer.remaining() + (this.ungotc > 0 ? 1 : 0));
            }
            return ((FileChannel)this.channel).position();
        }
        throw new IOHandler.PipeException();
    }

    public void seek(long offset, int type) throws IOException, IOHandler.InvalidValueException, IOHandler.PipeException {
        this.checkOpen();
        if (this.channel instanceof FileChannel) {
            if (this.bufferedIO) {
                this.flushInBuffer();
            }
            try {
                switch (type) {
                    case 0: {
                        ((FileChannel)this.channel).position(offset);
                        break;
                    }
                    case 1: {
                        ((FileChannel)this.channel).position(((FileChannel)this.channel).position() + offset);
                        break;
                    }
                    case 2: {
                        ((FileChannel)this.channel).position(((FileChannel)this.channel).size() + offset);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                throw new IOHandler.InvalidValueException();
            }
        } else {
            throw new IOHandler.PipeException();
        }
    }

    public void resetByModes(IOModes newModes) throws IOException, IOHandler.InvalidValueException {
        if (this.channel instanceof FileChannel) {
            if (newModes.isAppendable()) {
                try {
                    this.seek(0L, 2);
                }
                catch (IOHandler.PipeException e) {
                }
                catch (IOHandler.InvalidValueException e) {}
            } else if (newModes.isWritable()) {
                try {
                    this.rewind();
                }
                catch (IOHandler.PipeException pipeException) {
                    // empty catch block
                }
            }
        }
    }

    public void rewind() throws IOException, IOHandler.PipeException {
        this.checkOpen();
        this.checkBuffered();
        if (this.channel instanceof FileChannel) {
            try {
                this.seek(0L, 0);
            }
            catch (IOHandler.InvalidValueException invalidValueException) {}
        } else {
            throw new IOHandler.PipeException();
        }
    }

    public void truncate(long length) throws IOException, IOHandler.PipeException {
        if (!(this.channel instanceof FileChannel)) {
            throw new IOHandler.PipeException();
        }
        ((FileChannel)this.channel).truncate(length);
    }

    public int pid() {
        return -1;
    }

    public FileChannel getFileChannel() {
        return null;
    }

    public boolean hasPendingBuffered() {
        return this.ungotc >= 0 || this.bufferedIO && this.inBuffer.remaining() > 0;
    }

    public int ready() throws IOException {
        if (this.bufferedIO) {
            return this.inBuffer.remaining();
        }
        return this.ungotc;
    }
}

