/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.RubyDateFormat;

public class RubyTime
extends RubyObject {
    public static final String UTC = "UTC";
    private Calendar cal;
    private long usec;
    private static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("-", Locale.US);
    private static ObjectAllocator TIME_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            RubyTime instance = new RubyTime(runtime, klass);
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(new Date());
            instance.setJavaCalendar(cal);
            return instance;
        }
    };
    private static final String[] months = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};
    private static final long[] time_min = new long[]{1L, 0L, 0L, 0L, 0L};
    private static final long[] time_max = new long[]{31L, 23L, 59L, 60L, Long.MAX_VALUE};
    private static final int ARG_SIZE = 7;

    public static TimeZone getLocalTimeZone(Ruby runtime) {
        RubyString tzVar = runtime.newString("TZ");
        RubyHash h = (RubyHash)runtime.getObject().getConstant("ENV");
        IRubyObject tz = h.aref(tzVar);
        if (tz == null || !(tz instanceof RubyString)) {
            return TimeZone.getDefault();
        }
        return TimeZone.getTimeZone(tz.toString());
    }

    public RubyTime(Ruby runtime, RubyClass rubyClass) {
        super(runtime, rubyClass);
    }

    public RubyTime(Ruby runtime, RubyClass rubyClass, Calendar cal) {
        super(runtime, rubyClass);
        this.cal = cal;
    }

    public static RubyClass createTimeClass(Ruby runtime) {
        RubyClass timeClass = runtime.defineClass("Time", runtime.getObject(), TIME_ALLOCATOR);
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyTime.class);
        RubyClass timeMetaClass = timeClass.getMetaClass();
        timeClass.includeModule(runtime.getModule("Comparable"));
        timeMetaClass.defineAlias("now", "new");
        timeMetaClass.defineFastMethod("at", callbackFactory.getFastOptSingletonMethod("new_at"));
        timeMetaClass.defineFastMethod("local", callbackFactory.getFastOptSingletonMethod("new_local"));
        timeMetaClass.defineFastMethod("mktime", callbackFactory.getFastOptSingletonMethod("new_local"));
        timeMetaClass.defineFastMethod("utc", callbackFactory.getFastOptSingletonMethod("new_utc"));
        timeMetaClass.defineFastMethod("gm", callbackFactory.getFastOptSingletonMethod("new_utc"));
        timeMetaClass.defineMethod("_load", callbackFactory.getSingletonMethod("s_load", RubyKernel.IRUBY_OBJECT));
        timeClass.defineFastMethod(">=", callbackFactory.getFastMethod("op_ge", RubyKernel.IRUBY_OBJECT));
        timeClass.defineFastMethod(">", callbackFactory.getFastMethod("op_gt", RubyKernel.IRUBY_OBJECT));
        timeClass.defineFastMethod("<=", callbackFactory.getFastMethod("op_le", RubyKernel.IRUBY_OBJECT));
        timeClass.defineFastMethod("<", callbackFactory.getFastMethod("op_lt", RubyKernel.IRUBY_OBJECT));
        timeClass.defineFastMethod("===", callbackFactory.getFastMethod("same2", RubyKernel.IRUBY_OBJECT));
        timeClass.defineFastMethod("+", callbackFactory.getFastMethod("op_plus", RubyKernel.IRUBY_OBJECT));
        timeClass.defineFastMethod("-", callbackFactory.getFastMethod("op_minus", RubyKernel.IRUBY_OBJECT));
        timeClass.defineFastMethod("<=>", callbackFactory.getFastMethod("op_cmp", RubyKernel.IRUBY_OBJECT));
        timeClass.defineFastMethod("eql?", callbackFactory.getFastMethod("eql_p", RubyKernel.IRUBY_OBJECT));
        timeClass.defineFastMethod("asctime", callbackFactory.getFastMethod("asctime"));
        timeClass.defineFastMethod("mday", callbackFactory.getFastMethod("mday"));
        timeClass.defineAlias("day", "mday");
        timeClass.defineAlias("ctime", "asctime");
        timeClass.defineFastMethod("sec", callbackFactory.getFastMethod("sec"));
        timeClass.defineFastMethod("min", callbackFactory.getFastMethod("min"));
        timeClass.defineFastMethod("hour", callbackFactory.getFastMethod("hour"));
        timeClass.defineFastMethod("month", callbackFactory.getFastMethod("month"));
        timeClass.defineAlias("mon", "month");
        timeClass.defineFastMethod("year", callbackFactory.getFastMethod("year"));
        timeClass.defineFastMethod("wday", callbackFactory.getFastMethod("wday"));
        timeClass.defineFastMethod("yday", callbackFactory.getFastMethod("yday"));
        timeClass.defineFastMethod("isdst", callbackFactory.getFastMethod("isdst"));
        timeClass.defineAlias("dst?", "isdst");
        timeClass.defineFastMethod("zone", callbackFactory.getFastMethod("zone"));
        timeClass.defineFastMethod("to_a", callbackFactory.getFastMethod("to_a"));
        timeClass.defineFastMethod("to_f", callbackFactory.getFastMethod("to_f"));
        timeClass.defineFastMethod("succ", callbackFactory.getFastMethod("succ"));
        timeClass.defineFastMethod("to_i", callbackFactory.getFastMethod("to_i"));
        timeClass.defineFastMethod("to_s", callbackFactory.getFastMethod("to_s"));
        timeClass.defineFastMethod("inspect", callbackFactory.getFastMethod("inspect"));
        timeClass.defineFastMethod("strftime", callbackFactory.getFastMethod("strftime", IRubyObject.class));
        timeClass.defineFastMethod("usec", callbackFactory.getFastMethod("usec"));
        timeClass.defineAlias("tv_usec", "usec");
        timeClass.defineAlias("tv_sec", "to_i");
        timeClass.defineFastMethod("gmtime", callbackFactory.getFastMethod("gmtime"));
        timeClass.defineAlias("utc", "gmtime");
        timeClass.defineFastMethod("gmt?", callbackFactory.getFastMethod("gmt"));
        timeClass.defineAlias("utc?", "gmt?");
        timeClass.defineAlias("gmtime?", "gmt?");
        timeClass.defineFastMethod("localtime", callbackFactory.getFastMethod("localtime"));
        timeClass.defineFastMethod("hash", callbackFactory.getFastMethod("hash"));
        timeClass.defineMethod("initialize", callbackFactory.getOptMethod("initialize"));
        timeClass.defineFastMethod("initialize_copy", callbackFactory.getFastMethod("initialize_copy", IRubyObject.class));
        timeClass.defineMethod("_dump", callbackFactory.getOptMethod("dump"));
        timeClass.defineFastMethod("gmt_offset", callbackFactory.getFastMethod("gmt_offset"));
        timeClass.defineAlias("gmtoff", "gmt_offset");
        timeClass.defineAlias("utc_offset", "gmt_offset");
        timeClass.defineFastMethod("getgm", callbackFactory.getFastMethod("getgm"));
        timeClass.defineFastMethod("getlocal", callbackFactory.getFastMethod("getlocal"));
        timeClass.defineAlias("getutc", "getgm");
        return timeClass;
    }

    public void setUSec(long usec) {
        this.usec = usec;
    }

    public long getUSec() {
        return this.usec;
    }

    public void updateCal(Calendar calendar) {
        calendar.setTimeZone(this.cal.getTimeZone());
        calendar.setTimeInMillis(this.getTimeInMillis());
    }

    protected long getTimeInMillis() {
        return this.cal.getTimeInMillis();
    }

    public static RubyTime newTime(Ruby runtime, long milliseconds) {
        Calendar cal = Calendar.getInstance();
        RubyTime time = new RubyTime(runtime, runtime.getClass("Time"), cal);
        cal.setTimeInMillis(milliseconds);
        return time;
    }

    public static RubyTime newTime(Ruby runtime, Calendar cal) {
        RubyTime time = new RubyTime(runtime, runtime.getClass("Time"), cal);
        return time;
    }

    public IRubyObject initialize_copy(IRubyObject original) {
        if (!(original instanceof RubyTime)) {
            throw this.getRuntime().newTypeError("Expecting an instance of class Time");
        }
        RubyTime originalTime = (RubyTime)original;
        this.cal = (Calendar)originalTime.cal.clone();
        this.usec = originalTime.usec;
        return this;
    }

    public RubyTime succ() {
        Calendar newCal = (Calendar)this.cal.clone();
        newCal.add(13, 1);
        return RubyTime.newTime(this.getRuntime(), newCal);
    }

    public RubyTime gmtime() {
        this.cal.setTimeZone(TimeZone.getTimeZone(UTC));
        return this;
    }

    public RubyTime localtime() {
        long dump = this.cal.getTimeInMillis();
        this.cal = Calendar.getInstance(RubyTime.getLocalTimeZone(this.getRuntime()));
        this.cal.setTimeInMillis(dump);
        return this;
    }

    public RubyBoolean gmt() {
        return this.getRuntime().newBoolean(this.cal.getTimeZone().getID().equals(UTC));
    }

    public RubyTime getgm() {
        Calendar newCal = (Calendar)this.cal.clone();
        newCal.setTimeZone(TimeZone.getTimeZone(UTC));
        return RubyTime.newTime(this.getRuntime(), newCal);
    }

    public RubyTime getlocal() {
        Calendar newCal = (Calendar)this.cal.clone();
        newCal.setTimeZone(RubyTime.getLocalTimeZone(this.getRuntime()));
        return RubyTime.newTime(this.getRuntime(), newCal);
    }

    public RubyString strftime(IRubyObject format) {
        RubyDateFormat rubyDateFormat = new RubyDateFormat("-", Locale.US);
        rubyDateFormat.setCalendar(this.cal);
        rubyDateFormat.applyPattern(format.toString());
        String result = rubyDateFormat.format(this.cal.getTime());
        return this.getRuntime().newString(result);
    }

    public IRubyObject op_ge(IRubyObject other) {
        if (other instanceof RubyTime) {
            return this.getRuntime().newBoolean(this.cmp((RubyTime)other) >= 0);
        }
        return RubyComparable.op_ge(this, other);
    }

    public IRubyObject op_gt(IRubyObject other) {
        if (other instanceof RubyTime) {
            return this.getRuntime().newBoolean(this.cmp((RubyTime)other) > 0);
        }
        return RubyComparable.op_gt(this, other);
    }

    public IRubyObject op_le(IRubyObject other) {
        if (other instanceof RubyTime) {
            return this.getRuntime().newBoolean(this.cmp((RubyTime)other) <= 0);
        }
        return RubyComparable.op_le(this, other);
    }

    public IRubyObject op_lt(IRubyObject other) {
        if (other instanceof RubyTime) {
            return this.getRuntime().newBoolean(this.cmp((RubyTime)other) < 0);
        }
        return RubyComparable.op_lt(this, other);
    }

    private int cmp(RubyTime other) {
        long millis = this.getTimeInMillis();
        long millis_other = other.getTimeInMillis();
        long usec_other = other.usec;
        if (millis > millis_other || millis == millis_other && this.usec > usec_other) {
            return 1;
        }
        if (millis < millis_other || millis == millis_other && this.usec < usec_other) {
            return -1;
        }
        return 0;
    }

    public IRubyObject op_plus(IRubyObject other) {
        long time = this.getTimeInMillis();
        if (other instanceof RubyTime) {
            throw this.getRuntime().newTypeError("time + time ?");
        }
        long adjustment = (long)(RubyNumeric.num2dbl(other) * 1000000.0);
        int micro = (int)(adjustment % 1000L);
        RubyTime newTime = new RubyTime(this.getRuntime(), this.getMetaClass());
        newTime.cal = Calendar.getInstance();
        newTime.cal.setTimeZone(this.cal.getTimeZone());
        newTime.cal.setTime(new Date(time += (adjustment /= 1000L)));
        newTime.setUSec(micro);
        return newTime;
    }

    public IRubyObject op_minus(IRubyObject other) {
        long time = this.getTimeInMillis();
        if (other instanceof RubyTime) {
            return RubyFloat.newFloat(this.getRuntime(), (double)(time -= ((RubyTime)other).getTimeInMillis()) * 0.001);
        }
        long adjustment = (long)(((RubyNumeric)other).getDoubleValue() * 1000000.0);
        int micro = (int)(adjustment % 1000L);
        RubyTime newTime = new RubyTime(this.getRuntime(), this.getMetaClass());
        newTime.cal = Calendar.getInstance();
        newTime.cal.setTimeZone(this.cal.getTimeZone());
        newTime.cal.setTime(new Date(time -= (adjustment /= 1000L)));
        newTime.setUSec(micro);
        return newTime;
    }

    public IRubyObject same2(IRubyObject other) {
        return RubyNumeric.fix2int(this.callMethod(this.getRuntime().getCurrentContext(), 27, "<=>", other)) == 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public IRubyObject op_cmp(IRubyObject other) {
        if (other.isNil()) {
            return other;
        }
        if (other instanceof RubyTime) {
            return this.getRuntime().newFixnum(this.cmp((RubyTime)other));
        }
        long millis = this.getTimeInMillis();
        if (other instanceof RubyNumeric) {
            if (other instanceof RubyFloat || other instanceof RubyBignum) {
                double time = (double)millis / 1000.0;
                double time_other = ((RubyNumeric)other).getDoubleValue();
                if (time > time_other) {
                    return RubyFixnum.one(this.getRuntime());
                }
                if (time < time_other) {
                    return RubyFixnum.minus_one(this.getRuntime());
                }
                return RubyFixnum.zero(this.getRuntime());
            }
            long millis_other = RubyNumeric.num2long(other) * 1000L;
            if (millis > millis_other || millis == millis_other && this.usec > 0L) {
                return RubyFixnum.one(this.getRuntime());
            }
            if (millis < millis_other || millis == millis_other && this.usec < 0L) {
                return RubyFixnum.minus_one(this.getRuntime());
            }
            return RubyFixnum.zero(this.getRuntime());
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject eql_p(IRubyObject other) {
        if (other instanceof RubyTime) {
            RubyTime otherTime = (RubyTime)other;
            return this.usec == otherTime.usec && this.getTimeInMillis() == otherTime.getTimeInMillis() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }
        return this.getRuntime().getFalse();
    }

    public RubyString asctime() {
        simpleDateFormat.setCalendar(this.cal);
        if (this.cal.get(5) < 10) {
            simpleDateFormat.applyPattern("EEE MMM  d HH:mm:ss yyyy");
        } else {
            simpleDateFormat.applyPattern("EEE MMM dd HH:mm:ss yyyy");
        }
        String result = simpleDateFormat.format(this.cal.getTime());
        return this.getRuntime().newString(result);
    }

    public IRubyObject to_s() {
        simpleDateFormat.setCalendar(this.cal);
        simpleDateFormat.applyPattern("EEE MMM dd HH:mm:ss z yyyy");
        String result = simpleDateFormat.format(this.cal.getTime());
        return this.getRuntime().newString(result);
    }

    public RubyArray to_a() {
        return this.getRuntime().newArrayNoCopy(new IRubyObject[]{this.sec(), this.min(), this.hour(), this.mday(), this.month(), this.year(), this.wday(), this.yday(), this.isdst(), this.zone()});
    }

    public RubyFloat to_f() {
        long time = this.getTimeInMillis();
        time = time * 1000L + this.usec;
        return RubyFloat.newFloat(this.getRuntime(), (double)time / 1000000.0);
    }

    public RubyInteger to_i() {
        return this.getRuntime().newFixnum(this.getTimeInMillis() / 1000L);
    }

    public RubyInteger usec() {
        return this.getRuntime().newFixnum(this.microseconds());
    }

    public void setMicroseconds(long mic) {
        long millis = this.getTimeInMillis() % 1000L;
        long withoutMillis = this.getTimeInMillis() - millis;
        this.cal.setTimeInMillis(withoutMillis += mic / 1000L);
        this.usec = mic % 1000L;
    }

    public long microseconds() {
        return this.getTimeInMillis() % 1000L * 1000L + this.usec;
    }

    public RubyInteger sec() {
        return this.getRuntime().newFixnum(this.cal.get(13));
    }

    public RubyInteger min() {
        return this.getRuntime().newFixnum(this.cal.get(12));
    }

    public RubyInteger hour() {
        return this.getRuntime().newFixnum(this.cal.get(11));
    }

    public RubyInteger mday() {
        return this.getRuntime().newFixnum(this.cal.get(5));
    }

    public RubyInteger month() {
        return this.getRuntime().newFixnum(this.cal.get(2) + 1);
    }

    public RubyInteger year() {
        return this.getRuntime().newFixnum(this.cal.get(1));
    }

    public RubyInteger wday() {
        return this.getRuntime().newFixnum(this.cal.get(7) - 1);
    }

    public RubyInteger yday() {
        return this.getRuntime().newFixnum(this.cal.get(6));
    }

    public RubyInteger gmt_offset() {
        return this.getRuntime().newFixnum(this.cal.get(15) / 1000);
    }

    public RubyBoolean isdst() {
        return this.getRuntime().newBoolean(this.cal.getTimeZone().inDaylightTime(this.cal.getTime()));
    }

    public RubyString zone() {
        return this.getRuntime().newString(this.cal.getTimeZone().getDisplayName(this.cal.get(16) != 0, 0));
    }

    public void setJavaCalendar(Calendar cal) {
        this.cal = cal;
    }

    public Calendar getJavaCalendar() {
        return this.cal;
    }

    public Date getJavaDate() {
        return this.cal.getTime();
    }

    public RubyFixnum hash() {
        return this.getRuntime().newFixnum((int)((this.cal.getTimeInMillis() / 1000L ^ this.microseconds()) << 1) >> 1);
    }

    public RubyString dump(IRubyObject[] args, Block unusedBlock) {
        if (args.length > 1) {
            throw this.getRuntime().newArgumentError(0, 1);
        }
        RubyString str = (RubyString)this.mdump(new IRubyObject[]{this});
        str.setInstanceVariables(this.getInstanceVariables());
        return str;
    }

    public RubyObject mdump(IRubyObject[] args) {
        int i;
        RubyTime obj = (RubyTime)args[0];
        Calendar calendar = obj.gmtime().cal;
        byte[] dumpValue = new byte[8];
        int pe = Integer.MIN_VALUE | calendar.get(1) - 1900 << 14 | calendar.get(2) << 10 | calendar.get(5) << 5 | calendar.get(11);
        int se = calendar.get(12) << 26 | calendar.get(13) << 20 | calendar.get(14);
        for (i = 0; i < 4; ++i) {
            dumpValue[i] = (byte)(pe & 0xFF);
            pe >>>= 8;
        }
        for (i = 4; i < 8; ++i) {
            dumpValue[i] = (byte)(se & 0xFF);
            se >>>= 8;
        }
        return RubyString.newString(obj.getRuntime(), new ByteList(dumpValue, false));
    }

    public IRubyObject initialize(IRubyObject[] args, Block block) {
        return this;
    }

    public static IRubyObject s_new(IRubyObject recv, IRubyObject[] args, Block block) {
        Ruby runtime = recv.getRuntime();
        RubyTime time = new RubyTime(runtime, (RubyClass)recv);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date());
        time.setJavaCalendar(cal);
        time.callInit(args, block);
        return time;
    }

    public static IRubyObject new_at(IRubyObject recv, IRubyObject[] args) {
        Ruby runtime = recv.getRuntime();
        int len = Arity.checkArgumentCount(runtime, args, 1, 2);
        Calendar cal = Calendar.getInstance();
        RubyTime time = new RubyTime(runtime, (RubyClass)recv, cal);
        if (args[0] instanceof RubyTime) {
            RubyTime other = (RubyTime)args[0];
            other.updateCal(cal);
            time.setUSec(other.getUSec());
        } else {
            long seconds = RubyNumeric.num2long(args[0]);
            long millisecs = 0L;
            long microsecs = 0L;
            if (len > 1) {
                long tmp = RubyNumeric.num2long(args[1]);
                millisecs = tmp / 1000L;
                microsecs = tmp % 1000L;
            } else if (args[0] instanceof RubyFloat) {
                double dbl = ((RubyFloat)args[0]).getDoubleValue();
                long micro = (long)((dbl - (double)seconds) * 1000000.0);
                millisecs = micro / 1000L;
                microsecs = micro % 1000L;
            }
            time.setUSec(microsecs);
            cal.setTimeInMillis(seconds * 1000L + millisecs);
        }
        time.callInit(IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
        return time;
    }

    public static RubyTime new_local(IRubyObject recv, IRubyObject[] args) {
        return RubyTime.createTime(recv, args, false);
    }

    public static RubyTime new_utc(IRubyObject recv, IRubyObject[] args) {
        return RubyTime.createTime(recv, args, true);
    }

    public static RubyTime s_load(IRubyObject recv, IRubyObject from, Block block) {
        return RubyTime.s_mload(recv, (RubyTime)((RubyClass)recv).allocate(), from);
    }

    protected static RubyTime s_mload(IRubyObject recv, RubyTime time, IRubyObject from) {
        int i;
        Ruby runtime = recv.getRuntime();
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTimeZone(TimeZone.getTimeZone(UTC));
        byte[] fromAsBytes = null;
        fromAsBytes = from.convertToString().getBytes();
        if (fromAsBytes.length != 8) {
            throw runtime.newTypeError("marshaled time format differ");
        }
        int p = 0;
        int s = 0;
        for (i = 0; i < 4; ++i) {
            p |= (fromAsBytes[i] & 0xFF) << 8 * i;
        }
        for (i = 4; i < 8; ++i) {
            s |= (fromAsBytes[i] & 0xFF) << 8 * (i - 4);
        }
        if ((p & Integer.MIN_VALUE) == 0) {
            calendar.setTimeInMillis((long)p * 1000L + (long)s);
        } else {
            calendar.set(1, ((p &= Integer.MAX_VALUE) >>> 14 & 0xFFFF) + 1900);
            calendar.set(2, p >>> 10 & 0xF);
            calendar.set(5, p >>> 5 & 0x1F);
            calendar.set(11, p & 0x1F);
            calendar.set(12, s >>> 26 & 0x3F);
            calendar.set(13, s >>> 20 & 0x3F);
            calendar.set(14, s & 0xFFFFF);
        }
        time.setJavaCalendar(calendar);
        return time;
    }

    private static RubyTime createTime(IRubyObject recv, IRubyObject[] args, boolean gmt) {
        Ruby runtime = recv.getRuntime();
        int len = 7;
        if (args.length == 10) {
            args = new IRubyObject[]{args[5], args[4], args[3], args[2], args[1], args[0], runtime.getNil()};
        } else {
            len = Arity.checkArgumentCount(runtime, args, 1, 8);
            if (len < 7) {
                IRubyObject[] newArgs = new IRubyObject[7];
                System.arraycopy(args, 0, newArgs, 0, args.length);
                for (int i = len; i < 7; ++i) {
                    newArgs[i] = runtime.getNil();
                }
                args = newArgs;
                len = 7;
            }
        }
        ThreadContext tc = runtime.getCurrentContext();
        if (args[0] instanceof RubyString) {
            args[0] = RubyNumeric.str2inum(runtime, (RubyString)args[0], 10, false);
        }
        int year = (int)RubyNumeric.num2long(args[0]);
        int month = 0;
        if (len > 1) {
            if (!args[1].isNil()) {
                if (args[1] instanceof RubyString) {
                    month = -1;
                    for (int i = 0; i < 12; ++i) {
                        if (!months[i].equalsIgnoreCase(args[1].toString())) continue;
                        month = i;
                    }
                    if (month == -1) {
                        try {
                            month = Integer.parseInt(args[1].toString()) - 1;
                        }
                        catch (NumberFormatException nfExcptn) {
                            throw runtime.newArgumentError("Argument out of range.");
                        }
                    }
                } else {
                    month = (int)RubyNumeric.num2long(args[1]) - 1;
                }
            }
            if (0 > month || month > 11) {
                throw runtime.newArgumentError("Argument out of range.");
            }
        }
        int[] int_args = new int[]{1, 0, 0, 0, 0, 0};
        int i = 0;
        while (int_args.length >= i + 2) {
            if (!args[i + 2].isNil()) {
                if (!(args[i + 2] instanceof RubyNumeric)) {
                    args[i + 2] = args[i + 2].callMethod(tc, "to_i");
                }
                int_args[i] = (int)RubyNumeric.num2long(args[i + 2]);
                if (time_min[i] > (long)int_args[i] || (long)int_args[i] > time_max[i]) {
                    throw runtime.newArgumentError("Argument out of range.");
                }
            }
            ++i;
        }
        if (year < 100) {
            year += 2000;
        }
        Calendar cal = gmt ? Calendar.getInstance(TimeZone.getTimeZone(UTC)) : Calendar.getInstance(RubyTime.getLocalTimeZone(runtime));
        cal.set(year, month, int_args[0], int_args[1], int_args[2], int_args[3]);
        cal.set(14, int_args[4] / 1000);
        if (cal.getTimeInMillis() / 1000L < Integer.MIN_VALUE) {
            throw runtime.newArgumentError("time out of range");
        }
        RubyTime time = new RubyTime(runtime, (RubyClass)recv, cal);
        time.setUSec(int_args[4] % 1000);
        time.callInit(IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
        return time;
    }
}

