/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.Iterator;
import org.jruby.Ruby;
import org.jruby.RubyFixnum;
import org.jruby.RubyGC;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyProc;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyObjectSpace {
    public static RubyModule createObjectSpaceModule(Ruby runtime) {
        RubyModule objectSpaceModule = runtime.defineModule("ObjectSpace");
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyObjectSpace.class);
        objectSpaceModule.defineModuleFunction("each_object", callbackFactory.getOptSingletonMethod("each_object"));
        objectSpaceModule.defineFastModuleFunction("garbage_collect", callbackFactory.getFastSingletonMethod("garbage_collect"));
        objectSpaceModule.defineFastModuleFunction("_id2ref", callbackFactory.getFastSingletonMethod("id2ref", RubyFixnum.class));
        objectSpaceModule.defineModuleFunction("define_finalizer", callbackFactory.getOptSingletonMethod("define_finalizer"));
        objectSpaceModule.defineModuleFunction("undefine_finalizer", callbackFactory.getOptSingletonMethod("undefine_finalizer"));
        return objectSpaceModule;
    }

    public static IRubyObject define_finalizer(IRubyObject recv, IRubyObject[] args, Block block) {
        Ruby runtime = recv.getRuntime();
        RubyProc proc = null;
        proc = Arity.checkArgumentCount(runtime, args, 1, 2) == 2 ? (args[1] instanceof RubyProc ? (RubyProc)args[1] : (RubyProc)args[1].convertToType(runtime.getClass("Proc"), 0, "to_proc", true)) : runtime.newProc(Block.Type.PROC, block);
        IRubyObject obj = args[0];
        runtime.getObjectSpace().addFinalizer(obj, proc);
        return recv;
    }

    public static IRubyObject undefine_finalizer(IRubyObject recv, IRubyObject[] args, Block block) {
        Arity.checkArgumentCount(recv.getRuntime(), args, 1, 1);
        recv.getRuntime().getObjectSpace().removeFinalizers(RubyNumeric.fix2long(args[0].id()));
        return recv;
    }

    public static IRubyObject id2ref(IRubyObject recv, RubyFixnum id) {
        Ruby runtime = id.getRuntime();
        long longId = id.getLongValue();
        if (longId == 0L) {
            return runtime.getFalse();
        }
        if (longId == 2L) {
            return runtime.getTrue();
        }
        if (longId == 4L) {
            return runtime.getNil();
        }
        if (longId % 2L != 0L) {
            return runtime.newFixnum((longId - 1L) / 2L);
        }
        IRubyObject object = runtime.getObjectSpace().id2ref(longId);
        if (object == null) {
            return runtime.getNil();
        }
        return object;
    }

    public static IRubyObject each_object(IRubyObject recv, IRubyObject[] args, Block block) {
        RubyModule rubyClass = args.length == 0 ? recv.getRuntime().getObject() : (RubyModule)args[0];
        int count = 0;
        Iterator iter = recv.getRuntime().getObjectSpace().iterator(rubyClass);
        IRubyObject obj = null;
        ThreadContext context = recv.getRuntime().getCurrentContext();
        while ((obj = (IRubyObject)iter.next()) != null) {
            ++count;
            block.yield(context, obj);
        }
        return recv.getRuntime().newFixnum(count);
    }

    public static IRubyObject garbage_collect(IRubyObject recv) {
        return RubyGC.start(recv);
    }
}

