/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyKernel;
import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyUnboundMethod
extends RubyMethod {
    protected RubyUnboundMethod(Ruby runtime) {
        super(runtime, runtime.getClass("UnboundMethod"));
    }

    public static RubyUnboundMethod newUnboundMethod(RubyModule implementationModule, String methodName, RubyModule originModule, String originName, DynamicMethod method) {
        RubyUnboundMethod newMethod = new RubyUnboundMethod(implementationModule.getRuntime());
        newMethod.implementationModule = implementationModule;
        newMethod.methodName = methodName;
        newMethod.originModule = originModule;
        newMethod.originName = originName;
        newMethod.method = method;
        return newMethod;
    }

    public static RubyClass defineUnboundMethodClass(Ruby runtime) {
        RubyClass newClass = runtime.defineClass("UnboundMethod", runtime.getClass("Method"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyUnboundMethod.class);
        newClass.defineMethod("[]", callbackFactory.getOptMethod("call"));
        newClass.defineMethod("bind", callbackFactory.getMethod("bind", RubyKernel.IRUBY_OBJECT));
        newClass.defineMethod("call", callbackFactory.getOptMethod("call"));
        newClass.defineMethod("to_proc", callbackFactory.getMethod("to_proc"));
        newClass.defineMethod("unbind", callbackFactory.getMethod("unbind"));
        return newClass;
    }

    public IRubyObject call(IRubyObject[] args, Block block) {
        throw this.getRuntime().newTypeError("you cannot call unbound method; bind first");
    }

    public RubyUnboundMethod unbind(Block block) {
        return this;
    }

    public RubyMethod bind(IRubyObject aReceiver, Block block) {
        RubyClass receiverClass = aReceiver.getMetaClass();
        if (!aReceiver.isKindOf(this.originModule)) {
            if (this.originModule instanceof MetaClass) {
                throw this.getRuntime().newTypeError("singleton method called for a different object");
            }
            if (receiverClass instanceof MetaClass && receiverClass.getMethods().containsKey(this.originName)) {
                throw this.getRuntime().newTypeError("method `" + this.originName + "' overridden");
            }
            if (!(!this.originModule.isModule() ? aReceiver.getType() == this.originModule : aReceiver.isKindOf(this.originModule))) {
                throw this.getRuntime().newTypeError("bind argument must be an instance of " + this.originModule.getName());
            }
        }
        return RubyMethod.newMethod(this.implementationModule, this.methodName, receiverClass, this.originName, this.method, aReceiver);
    }
}

