/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import org.jruby.Ruby;
import org.jruby.RubyArgsFile;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBinding;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFile;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyIO;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyProcess;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubyThread;
import org.jruby.RubyTime;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.IAutoloadMethod;
import org.jruby.runtime.load.LoadService;
import org.jruby.util.ShellLauncher;
import org.jruby.util.Sprintf;

public class RubyKernel {
    public static final Class IRUBY_OBJECT = IRubyObject.class;

    public static RubyModule createKernelModule(Ruby runtime) {
        RubyModule module = runtime.defineModule("Kernel");
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyKernel.class);
        CallbackFactory objectCallbackFactory = runtime.callbackFactory(RubyObject.class);
        module.defineFastModuleFunction("Array", callbackFactory.getFastSingletonMethod("new_array", IRUBY_OBJECT));
        module.defineFastModuleFunction("Float", callbackFactory.getFastSingletonMethod("new_float", IRUBY_OBJECT));
        module.defineFastModuleFunction("Integer", callbackFactory.getFastSingletonMethod("new_integer", IRUBY_OBJECT));
        module.defineFastModuleFunction("String", callbackFactory.getFastSingletonMethod("new_string", IRUBY_OBJECT));
        module.defineFastModuleFunction("`", callbackFactory.getFastSingletonMethod("backquote", IRUBY_OBJECT));
        module.defineFastModuleFunction("abort", callbackFactory.getFastOptSingletonMethod("abort"));
        module.defineModuleFunction("at_exit", callbackFactory.getSingletonMethod("at_exit"));
        module.defineFastModuleFunction("autoload", callbackFactory.getFastSingletonMethod("autoload", IRUBY_OBJECT, IRUBY_OBJECT));
        module.defineFastModuleFunction("autoload?", callbackFactory.getFastSingletonMethod("autoload_p", IRUBY_OBJECT));
        module.defineModuleFunction("binding", callbackFactory.getSingletonMethod("binding"));
        module.defineModuleFunction("block_given?", callbackFactory.getSingletonMethod("block_given"));
        module.defineModuleFunction("callcc", callbackFactory.getOptSingletonMethod("callcc"));
        module.defineModuleFunction("caller", callbackFactory.getOptSingletonMethod("caller"));
        module.defineModuleFunction("catch", callbackFactory.getSingletonMethod("rbCatch", IRUBY_OBJECT));
        module.defineFastModuleFunction("chomp", callbackFactory.getFastOptSingletonMethod("chomp"));
        module.defineFastModuleFunction("chomp!", callbackFactory.getFastOptSingletonMethod("chomp_bang"));
        module.defineFastModuleFunction("chop", callbackFactory.getFastSingletonMethod("chop"));
        module.defineFastModuleFunction("chop!", callbackFactory.getFastSingletonMethod("chop_bang"));
        module.defineModuleFunction("eval", callbackFactory.getOptSingletonMethod("eval"));
        module.defineFastModuleFunction("exit", callbackFactory.getFastOptSingletonMethod("exit"));
        module.defineFastModuleFunction("exit!", callbackFactory.getFastOptSingletonMethod("exit_bang"));
        module.defineModuleFunction("fail", callbackFactory.getOptSingletonMethod("raise"));
        module.defineFastModuleFunction("format", callbackFactory.getFastOptSingletonMethod("sprintf"));
        module.defineFastModuleFunction("gets", callbackFactory.getFastOptSingletonMethod("gets"));
        module.defineFastModuleFunction("global_variables", callbackFactory.getFastSingletonMethod("global_variables"));
        module.defineModuleFunction("gsub", callbackFactory.getOptSingletonMethod("gsub"));
        module.defineModuleFunction("gsub!", callbackFactory.getOptSingletonMethod("gsub_bang"));
        module.defineModuleFunction("iterator?", callbackFactory.getSingletonMethod("block_given"));
        module.defineModuleFunction("lambda", callbackFactory.getSingletonMethod("proc"));
        module.defineModuleFunction("load", callbackFactory.getOptSingletonMethod("load"));
        module.defineFastModuleFunction("local_variables", callbackFactory.getFastSingletonMethod("local_variables"));
        module.defineModuleFunction("loop", callbackFactory.getSingletonMethod("loop"));
        module.defineModuleFunction("method_missing", callbackFactory.getOptSingletonMethod("method_missing"));
        module.defineModuleFunction("open", callbackFactory.getOptSingletonMethod("open"));
        module.defineFastModuleFunction("p", callbackFactory.getFastOptSingletonMethod("p"));
        module.defineFastModuleFunction("print", callbackFactory.getFastOptSingletonMethod("print"));
        module.defineFastModuleFunction("printf", callbackFactory.getFastOptSingletonMethod("printf"));
        module.defineModuleFunction("proc", callbackFactory.getSingletonMethod("proc"));
        module.defineFastModuleFunction("putc", callbackFactory.getFastSingletonMethod("putc", IRubyObject.class));
        module.defineFastModuleFunction("puts", callbackFactory.getFastOptSingletonMethod("puts"));
        module.defineModuleFunction("raise", callbackFactory.getOptSingletonMethod("raise"));
        module.defineFastModuleFunction("rand", callbackFactory.getFastOptSingletonMethod("rand"));
        module.defineFastModuleFunction("readline", callbackFactory.getFastOptSingletonMethod("readline"));
        module.defineFastModuleFunction("readlines", callbackFactory.getFastOptSingletonMethod("readlines"));
        module.defineModuleFunction("require", callbackFactory.getSingletonMethod("require", IRUBY_OBJECT));
        module.defineModuleFunction("scan", callbackFactory.getSingletonMethod("scan", IRUBY_OBJECT));
        module.defineFastModuleFunction("select", callbackFactory.getFastOptSingletonMethod("select"));
        module.defineModuleFunction("set_trace_func", callbackFactory.getSingletonMethod("set_trace_func", IRUBY_OBJECT));
        module.defineModuleFunction("trace_var", callbackFactory.getOptSingletonMethod("trace_var"));
        module.defineModuleFunction("untrace_var", callbackFactory.getOptSingletonMethod("untrace_var"));
        module.defineFastModuleFunction("sleep", callbackFactory.getFastOptSingletonMethod("sleep"));
        module.defineFastModuleFunction("split", callbackFactory.getFastOptSingletonMethod("split"));
        module.defineFastModuleFunction("sprintf", callbackFactory.getFastOptSingletonMethod("sprintf"));
        module.defineFastModuleFunction("srand", callbackFactory.getFastOptSingletonMethod("srand"));
        module.defineModuleFunction("sub", callbackFactory.getOptSingletonMethod("sub"));
        module.defineModuleFunction("sub!", callbackFactory.getOptSingletonMethod("sub_bang"));
        module.defineFastModuleFunction("system", callbackFactory.getFastOptSingletonMethod("system"));
        module.defineFastModuleFunction("exec", callbackFactory.getFastOptSingletonMethod("system"));
        module.defineFastModuleFunction("test", callbackFactory.getFastOptSingletonMethod("test"));
        module.defineModuleFunction("throw", callbackFactory.getOptSingletonMethod("rbThrow"));
        module.definePublicModuleFunction("trap", callbackFactory.getOptSingletonMethod("trap"));
        module.defineFastModuleFunction("warn", callbackFactory.getFastSingletonMethod("warn", IRUBY_OBJECT));
        module.defineModuleFunction("singleton_method_added", callbackFactory.getSingletonMethod("singleton_method_added", IRUBY_OBJECT));
        module.defineModuleFunction("singleton_method_removed", callbackFactory.getSingletonMethod("singleton_method_removed", IRUBY_OBJECT));
        module.defineModuleFunction("singleton_method_undefined", callbackFactory.getSingletonMethod("singleton_method_undefined", IRUBY_OBJECT));
        module.defineFastPublicModuleFunction("==", objectCallbackFactory.getFastMethod("obj_equal", IRUBY_OBJECT));
        module.defineFastPublicModuleFunction("eql?", objectCallbackFactory.getFastMethod("obj_equal", IRUBY_OBJECT));
        module.defineFastPublicModuleFunction("equal?", objectCallbackFactory.getFastMethod("obj_equal", IRUBY_OBJECT));
        module.defineFastPublicModuleFunction("===", objectCallbackFactory.getFastMethod("equal", IRUBY_OBJECT));
        module.defineFastPublicModuleFunction("to_s", objectCallbackFactory.getFastMethod("to_s"));
        module.defineFastPublicModuleFunction("nil?", objectCallbackFactory.getFastMethod("nil_p"));
        module.defineFastPublicModuleFunction("to_a", callbackFactory.getFastSingletonMethod("to_a"));
        module.defineFastPublicModuleFunction("hash", objectCallbackFactory.getFastMethod("hash"));
        module.defineFastPublicModuleFunction("id", objectCallbackFactory.getFastMethod("id_deprecated"));
        module.defineFastPublicModuleFunction("object_id", objectCallbackFactory.getFastMethod("id"));
        module.defineAlias("__id__", "object_id");
        module.defineFastPublicModuleFunction("is_a?", objectCallbackFactory.getFastMethod("kind_of", IRUBY_OBJECT));
        module.defineAlias("kind_of?", "is_a?");
        module.defineFastPublicModuleFunction("dup", objectCallbackFactory.getFastMethod("dup"));
        module.defineFastPublicModuleFunction("type", objectCallbackFactory.getFastMethod("type_deprecated"));
        module.defineFastPublicModuleFunction("class", objectCallbackFactory.getFastMethod("type"));
        module.defineFastPublicModuleFunction("inspect", objectCallbackFactory.getFastMethod("inspect"));
        module.defineFastPublicModuleFunction("=~", objectCallbackFactory.getFastMethod("match", IRUBY_OBJECT));
        module.definePublicModuleFunction("clone", objectCallbackFactory.getMethod("rbClone"));
        module.defineFastPublicModuleFunction("display", objectCallbackFactory.getFastOptMethod("display"));
        module.defineFastPublicModuleFunction("extend", objectCallbackFactory.getFastOptMethod("extend"));
        module.defineFastPublicModuleFunction("freeze", objectCallbackFactory.getFastMethod("freeze"));
        module.defineFastPublicModuleFunction("frozen?", objectCallbackFactory.getFastMethod("frozen"));
        module.defineFastModuleFunction("initialize_copy", objectCallbackFactory.getFastMethod("initialize_copy", IRUBY_OBJECT));
        module.definePublicModuleFunction("instance_eval", objectCallbackFactory.getOptMethod("instance_eval"));
        module.definePublicModuleFunction("instance_exec", objectCallbackFactory.getOptMethod("instance_exec"));
        module.defineFastPublicModuleFunction("instance_of?", objectCallbackFactory.getFastMethod("instance_of", IRUBY_OBJECT));
        module.defineFastPublicModuleFunction("instance_variables", objectCallbackFactory.getFastMethod("instance_variables"));
        module.defineFastPublicModuleFunction("instance_variable_get", objectCallbackFactory.getFastMethod("instance_variable_get", IRUBY_OBJECT));
        module.defineFastPublicModuleFunction("instance_variable_set", objectCallbackFactory.getFastMethod("instance_variable_set", IRUBY_OBJECT, IRUBY_OBJECT));
        module.defineFastPublicModuleFunction("method", objectCallbackFactory.getFastMethod("method", IRUBY_OBJECT));
        module.defineFastPublicModuleFunction("methods", objectCallbackFactory.getFastOptMethod("methods"));
        module.defineFastPublicModuleFunction("private_methods", objectCallbackFactory.getFastOptMethod("private_methods"));
        module.defineFastPublicModuleFunction("protected_methods", objectCallbackFactory.getFastOptMethod("protected_methods"));
        module.defineFastPublicModuleFunction("public_methods", objectCallbackFactory.getFastOptMethod("public_methods"));
        module.defineFastModuleFunction("remove_instance_variable", objectCallbackFactory.getMethod("remove_instance_variable", IRUBY_OBJECT));
        module.defineFastPublicModuleFunction("respond_to?", objectCallbackFactory.getFastOptMethod("respond_to"));
        module.definePublicModuleFunction("send", objectCallbackFactory.getOptMethod("send"));
        module.defineAlias("__send__", "send");
        module.defineFastPublicModuleFunction("singleton_methods", objectCallbackFactory.getFastOptMethod("singleton_methods"));
        module.defineFastPublicModuleFunction("taint", objectCallbackFactory.getFastMethod("taint"));
        module.defineFastPublicModuleFunction("tainted?", objectCallbackFactory.getFastMethod("tainted"));
        module.defineFastPublicModuleFunction("untaint", objectCallbackFactory.getFastMethod("untaint"));
        runtime.setRespondToMethod(module.searchMethod("respond_to?"));
        return module;
    }

    public static IRubyObject at_exit(IRubyObject recv, Block block) {
        return recv.getRuntime().pushExitBlock(recv.getRuntime().newProc(false, block));
    }

    public static IRubyObject autoload_p(IRubyObject recv, IRubyObject symbol) {
        RubyModule module = recv instanceof RubyModule ? (RubyModule)recv : recv.getRuntime().getObject();
        String name = module.getName() + "::" + symbol.asSymbol();
        IAutoloadMethod autoloadMethod = recv.getRuntime().getLoadService().autoloadFor(name);
        if (autoloadMethod == null) {
            return recv.getRuntime().getNil();
        }
        return recv.getRuntime().newString(autoloadMethod.file());
    }

    public static IRubyObject autoload(IRubyObject recv, IRubyObject symbol, final IRubyObject file) {
        Ruby runtime = recv.getRuntime();
        final LoadService loadService = runtime.getLoadService();
        final String baseName = symbol.asSymbol();
        final RubyModule module = recv instanceof RubyModule ? (RubyModule)recv : runtime.getObject();
        String nm = module.getName() + "::" + baseName;
        IRubyObject undef = runtime.getUndef();
        IRubyObject existingValue = module.getInstanceVariable(baseName);
        if (existingValue != null && existingValue != undef) {
            return runtime.getNil();
        }
        module.setInstanceVariable(baseName, undef);
        loadService.addAutoload(nm, new IAutoloadMethod(){

            public String file() {
                return file.toString();
            }

            public IRubyObject load(Ruby runtime, String name) {
                boolean required = loadService.require(file.toString());
                if (!required) {
                    return null;
                }
                return module.getConstant(baseName);
            }
        });
        return runtime.getNil();
    }

    public static IRubyObject method_missing(IRubyObject recv, IRubyObject[] args, Block block) {
        RubyClass exc;
        Ruby runtime = recv.getRuntime();
        if (args.length == 0 || !(args[0] instanceof RubySymbol)) {
            throw runtime.newArgumentError("no id given");
        }
        String name = args[0].asSymbol();
        ThreadContext context = runtime.getCurrentContext();
        Visibility lastVis = context.getLastVisibility();
        CallType lastCallType = context.getLastCallType();
        String format = null;
        boolean noMethod = true;
        if (lastVis == Visibility.PRIVATE) {
            format = "private method `%s' called for %s";
        } else if (lastVis == Visibility.PROTECTED) {
            format = "protected method `%s' called for %s";
        } else if (lastCallType == CallType.VARIABLE) {
            format = "undefined local variable or method `%s' for %s";
            noMethod = false;
        } else if (lastCallType == CallType.SUPER) {
            format = "super: no superclass method `%s'";
        }
        if (format == null) {
            format = "undefined method `%s' for %s";
        }
        String description = null;
        if (recv.isNil()) {
            description = "nil";
        } else if (recv instanceof RubyBoolean && recv.isTrue()) {
            description = "true";
        } else if (recv instanceof RubyBoolean && !recv.isTrue()) {
            description = "false";
        } else if (name.equals("inspect") || name.equals("to_s")) {
            description = recv.anyToString().toString();
        } else {
            IRubyObject d;
            try {
                d = recv.callMethod(context, "inspect");
                if (d.getMetaClass() == recv.getMetaClass() || d instanceof RubyString && ((RubyString)d).length().getLongValue() > 65L) {
                    d = recv.anyToString();
                }
            }
            catch (JumpException je) {
                d = recv.anyToString();
            }
            description = d.toString();
        }
        if (description.length() == 0 || description.length() > 0 && description.charAt(0) != '#') {
            description = description + ":" + recv.getMetaClass().getRealClass().getName();
        }
        IRubyObject[] exArgs = new IRubyObject[noMethod ? 3 : 2];
        RubyArray arr = runtime.newArray(args[0], runtime.newString(description));
        RubyString msg = runtime.newString(((Object)Sprintf.sprintf(runtime.newString(format), (IRubyObject)arr)).toString());
        if (recv.isTaint()) {
            msg.setTaint(true);
        }
        exArgs[0] = msg;
        exArgs[1] = args[0];
        if (noMethod) {
            IRubyObject[] NMEArgs = new IRubyObject[args.length - 1];
            System.arraycopy(args, 1, NMEArgs, 0, NMEArgs.length);
            exArgs[2] = runtime.newArrayNoCopy(NMEArgs);
            exc = runtime.getClass("NoMethodError");
        } else {
            exc = runtime.getClass("NameError");
        }
        throw new RaiseException((RubyException)exc.newInstance(exArgs, Block.NULL_BLOCK));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IRubyObject open(IRubyObject recv, IRubyObject[] args, Block block) {
        IRubyObject iRubyObject;
        Arity.checkArgumentCount(recv.getRuntime(), args, 1, 3);
        String arg = args[0].convertToString().toString();
        Ruby runtime = recv.getRuntime();
        if (!arg.startsWith("|")) return RubyFile.open(runtime.getClass("File"), args, block);
        String command = arg.substring(1);
        Process p = new ShellLauncher(runtime).run(RubyString.newString(runtime, command));
        RubyIO io = new RubyIO(runtime, p);
        if (!block.isGiven()) return io;
        try {
            block.yield(recv.getRuntime().getCurrentContext(), io);
            iRubyObject = runtime.getNil();
            io.close();
        }
        catch (Throwable throwable) {
            try {
                io.close();
                throw throwable;
            }
            catch (IOException ioe) {
                throw runtime.newIOErrorFromException(ioe);
            }
        }
        return iRubyObject;
    }

    public static IRubyObject gets(IRubyObject recv, IRubyObject[] args) {
        return ((RubyArgsFile)recv.getRuntime().getGlobalVariables().get("$<")).gets(args);
    }

    public static IRubyObject abort(IRubyObject recv, IRubyObject[] args) {
        if (Arity.checkArgumentCount(recv.getRuntime(), args, 0, 1) == 1) {
            recv.getRuntime().getGlobalVariables().get("$stderr").callMethod(recv.getRuntime().getCurrentContext(), "puts", args[0]);
        }
        throw new MainExitException(1, true);
    }

    public static IRubyObject new_array(IRubyObject recv, IRubyObject object) {
        IRubyObject value = object.convertToType(recv.getRuntime().getArray(), 18, "to_ary", false, true, true);
        if (value.isNil()) {
            DynamicMethod method = object.getMetaClass().searchMethod("to_a");
            if (method.getImplementationClass() == recv.getRuntime().getKernel()) {
                return recv.getRuntime().newArray(object);
            }
            value = object.callMethod(recv.getRuntime().getCurrentContext(), 22, "to_a");
            if (value.getMetaClass() != recv.getRuntime().getClass("Array")) {
                throw recv.getRuntime().newTypeError("`to_a' did not return Array");
            }
        }
        return value;
    }

    public static IRubyObject new_float(IRubyObject recv, IRubyObject object) {
        if (object instanceof RubyFixnum) {
            return RubyFloat.newFloat(object.getRuntime(), ((RubyFixnum)object).getDoubleValue());
        }
        if (object instanceof RubyFloat) {
            return object;
        }
        if (object instanceof RubyBignum) {
            return RubyFloat.newFloat(object.getRuntime(), RubyBignum.big2dbl((RubyBignum)object));
        }
        if (object instanceof RubyString) {
            if (((RubyString)object).getValue().length() == 0) {
                throw recv.getRuntime().newArgumentError("invalid value for Float(): " + object.inspect());
            }
            return RubyNumeric.str2fnum(recv.getRuntime(), (RubyString)object, true);
        }
        if (object.isNil()) {
            throw recv.getRuntime().newTypeError("can't convert nil into Float");
        }
        RubyFloat rFloat = object.convertToFloat();
        if (Double.isNaN(rFloat.getDoubleValue())) {
            recv.getRuntime().newArgumentError("invalid value for Float()");
        }
        return rFloat;
    }

    public static IRubyObject new_integer(IRubyObject recv, IRubyObject object) {
        if (object instanceof RubyFloat) {
            double val = ((RubyFloat)object).getDoubleValue();
            if (val <= 9.223372036854776E18 && val >= -9.223372036854776E18) {
                IRubyObject tmp = ((RubyObject)object).convertToType(recv.getRuntime().getClass("Integer"), 19, "to_int", false);
                if (tmp.isNil()) {
                    return ((RubyObject)object).convertToType(recv.getRuntime().getClass("Integer"), 15, "to_i", true);
                }
                return tmp;
            }
            return RubyNumeric.dbl2num(recv.getRuntime(), ((RubyFloat)object).getDoubleValue());
        }
        if (object instanceof RubyFixnum || object instanceof RubyBignum) {
            return object;
        }
        if (object instanceof RubyString) {
            return RubyNumeric.str2inum(recv.getRuntime(), (RubyString)object, 0, true);
        }
        IRubyObject tmp = ((RubyObject)object).convertToType(recv.getRuntime().getClass("Integer"), 19, "to_int", false);
        if (tmp.isNil()) {
            return ((RubyObject)object).convertToType(recv.getRuntime().getClass("Integer"), 15, "to_i", true);
        }
        return tmp;
    }

    public static IRubyObject new_string(IRubyObject recv, IRubyObject object) {
        return object.callMethod(recv.getRuntime().getCurrentContext(), 14, "to_s");
    }

    public static IRubyObject p(IRubyObject recv, IRubyObject[] args) {
        IRubyObject defout = recv.getRuntime().getGlobalVariables().get("$>");
        ThreadContext context = recv.getRuntime().getCurrentContext();
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            defout.callMethod(context, "write", args[i].callMethod(context, "inspect"));
            defout.callMethod(context, "write", recv.getRuntime().newString("\n"));
        }
        return recv.getRuntime().getNil();
    }

    public static IRubyObject putc(IRubyObject recv, IRubyObject ch) {
        IRubyObject defout = recv.getRuntime().getGlobalVariables().get("$>");
        return defout.callMethod(recv.getRuntime().getCurrentContext(), "putc", ch);
    }

    public static IRubyObject puts(IRubyObject recv, IRubyObject[] args) {
        IRubyObject defout = recv.getRuntime().getGlobalVariables().get("$>");
        ThreadContext context = recv.getRuntime().getCurrentContext();
        defout.callMethod(context, "puts", args);
        return recv.getRuntime().getNil();
    }

    public static IRubyObject print(IRubyObject recv, IRubyObject[] args) {
        IRubyObject defout = recv.getRuntime().getGlobalVariables().get("$>");
        ThreadContext context = recv.getRuntime().getCurrentContext();
        defout.callMethod(context, "print", args);
        return recv.getRuntime().getNil();
    }

    public static IRubyObject printf(IRubyObject recv, IRubyObject[] args) {
        if (args.length != 0) {
            IRubyObject defout = recv.getRuntime().getGlobalVariables().get("$>");
            if (!(args[0] instanceof RubyString)) {
                defout = args[0];
                args = ArgsUtil.popArray(args);
            }
            ThreadContext context = recv.getRuntime().getCurrentContext();
            defout.callMethod(context, "write", RubyKernel.sprintf(recv, args));
        }
        return recv.getRuntime().getNil();
    }

    public static IRubyObject readline(IRubyObject recv, IRubyObject[] args) {
        IRubyObject line = RubyKernel.gets(recv, args);
        if (line.isNil()) {
            throw recv.getRuntime().newEOFError();
        }
        return line;
    }

    public static RubyArray readlines(IRubyObject recv, IRubyObject[] args) {
        return ((RubyArgsFile)recv.getRuntime().getGlobalVariables().get("$<")).readlines(args);
    }

    private static RubyString getLastlineString(Ruby runtime) {
        IRubyObject line = runtime.getCurrentContext().getLastline();
        if (line.isNil()) {
            throw runtime.newTypeError("$_ value need to be String (nil given).");
        }
        if (!(line instanceof RubyString)) {
            throw runtime.newTypeError("$_ value need to be String (" + line.getMetaClass().getName() + " given).");
        }
        return (RubyString)line;
    }

    public static IRubyObject sub_bang(IRubyObject recv, IRubyObject[] args, Block block) {
        return RubyKernel.getLastlineString(recv.getRuntime()).sub_bang(args, block);
    }

    public static IRubyObject sub(IRubyObject recv, IRubyObject[] args, Block block) {
        RubyString str = (RubyString)RubyKernel.getLastlineString(recv.getRuntime()).dup();
        if (!str.sub_bang(args, block).isNil()) {
            recv.getRuntime().getCurrentContext().setLastline(str);
        }
        return str;
    }

    public static IRubyObject gsub_bang(IRubyObject recv, IRubyObject[] args, Block block) {
        return RubyKernel.getLastlineString(recv.getRuntime()).gsub_bang(args, block);
    }

    public static IRubyObject gsub(IRubyObject recv, IRubyObject[] args, Block block) {
        RubyString str = (RubyString)RubyKernel.getLastlineString(recv.getRuntime()).dup();
        if (!str.gsub_bang(args, block).isNil()) {
            recv.getRuntime().getCurrentContext().setLastline(str);
        }
        return str;
    }

    public static IRubyObject chop_bang(IRubyObject recv) {
        return RubyKernel.getLastlineString(recv.getRuntime()).chop_bang();
    }

    public static IRubyObject chop(IRubyObject recv) {
        RubyString str = RubyKernel.getLastlineString(recv.getRuntime());
        if (str.getValue().length() > 0) {
            str = (RubyString)str.dup();
            str.chop_bang();
            recv.getRuntime().getCurrentContext().setLastline(str);
        }
        return str;
    }

    public static IRubyObject chomp_bang(IRubyObject recv, IRubyObject[] args) {
        return RubyKernel.getLastlineString(recv.getRuntime()).chomp_bang(args);
    }

    public static IRubyObject chomp(IRubyObject recv, IRubyObject[] args) {
        RubyString str = RubyKernel.getLastlineString(recv.getRuntime());
        RubyString dup = (RubyString)str.dup();
        if (dup.chomp_bang(args).isNil()) {
            return str;
        }
        recv.getRuntime().getCurrentContext().setLastline(dup);
        return dup;
    }

    public static IRubyObject split(IRubyObject recv, IRubyObject[] args) {
        return RubyKernel.getLastlineString(recv.getRuntime()).split(args);
    }

    public static IRubyObject scan(IRubyObject recv, IRubyObject pattern, Block block) {
        return RubyKernel.getLastlineString(recv.getRuntime()).scan(pattern, block);
    }

    public static IRubyObject select(IRubyObject recv, IRubyObject[] args) {
        return RubyIO.select_static(recv.getRuntime(), args);
    }

    public static IRubyObject sleep(IRubyObject recv, IRubyObject[] args) {
        long milliseconds;
        if (args.length == 0) {
            milliseconds = 0L;
        } else {
            milliseconds = (long)(args[0].convertToFloat().getDoubleValue() * 1000.0);
            if (milliseconds < 0L) {
                throw recv.getRuntime().newArgumentError("time interval must be positive");
            }
            if (milliseconds == 0L) {
                return recv.getRuntime().newFixnum(0L);
            }
        }
        long startTime = System.currentTimeMillis();
        RubyThread rubyThread = recv.getRuntime().getThreadService().getCurrentContext().getThread();
        while (milliseconds > 0L) {
            long loopStartTime = System.currentTimeMillis();
            try {
                rubyThread.sleep(milliseconds);
            }
            catch (InterruptedException iExcptn) {
                // empty catch block
            }
            milliseconds -= System.currentTimeMillis() - loopStartTime;
        }
        return recv.getRuntime().newFixnum(Math.round((double)(System.currentTimeMillis() - startTime) / 1000.0));
    }

    public static IRubyObject exit(IRubyObject recv, IRubyObject[] args) {
        recv.getRuntime().secure(4);
        int status = 1;
        if (args.length > 0) {
            RubyObject argument = (RubyObject)args[0];
            status = argument instanceof RubyFixnum ? RubyNumeric.fix2int(argument) : (argument.isFalse() ? 1 : 0);
        }
        throw recv.getRuntime().newSystemExit(status);
    }

    public static IRubyObject exit_bang(IRubyObject recv, IRubyObject[] args) {
        return RubyKernel.exit(recv, args);
    }

    public static RubyArray global_variables(IRubyObject recv) {
        RubyArray globalVariables = recv.getRuntime().newArray();
        Iterator iter = recv.getRuntime().getGlobalVariables().getNames();
        while (iter.hasNext()) {
            String globalVariableName = (String)iter.next();
            globalVariables.append(recv.getRuntime().newString(globalVariableName));
        }
        return globalVariables;
    }

    public static RubyArray local_variables(IRubyObject recv) {
        Ruby runtime = recv.getRuntime();
        RubyArray localVariables = runtime.newArray();
        String[] names = runtime.getCurrentContext().getCurrentScope().getAllNamesInScope();
        for (int i = 0; i < names.length; ++i) {
            localVariables.append(runtime.newString(names[i]));
        }
        return localVariables;
    }

    public static RubyBinding binding(IRubyObject recv, Block block) {
        return recv.getRuntime().newBinding();
    }

    public static RubyBoolean block_given(IRubyObject recv, Block block) {
        return recv.getRuntime().newBoolean(recv.getRuntime().getCurrentContext().getPreviousFrame().getBlock().isGiven());
    }

    public static IRubyObject sprintf(IRubyObject recv, IRubyObject[] args) {
        if (args.length == 0) {
            throw recv.getRuntime().newArgumentError("sprintf must have at least one argument");
        }
        RubyString str = RubyString.stringValue(args[0]);
        RubyArray newArgs = recv.getRuntime().newArrayNoCopy(args);
        newArgs.shift();
        return str.format(newArgs);
    }

    public static IRubyObject raise(IRubyObject recv, IRubyObject[] args, Block block) {
        IRubyObject exception;
        Arity.checkArgumentCount(recv.getRuntime(), args, 0, 3);
        Ruby runtime = recv.getRuntime();
        if (args.length == 0) {
            IRubyObject lastException = runtime.getGlobalVariables().get("$!");
            if (lastException.isNil()) {
                throw new RaiseException(runtime, runtime.getClass("RuntimeError"), "", false);
            }
            throw new RaiseException((RubyException)lastException);
        }
        ThreadContext context = recv.getRuntime().getCurrentContext();
        if (args.length == 1) {
            if (args[0] instanceof RubyString) {
                throw new RaiseException((RubyException)runtime.getClass("RuntimeError").newInstance(args, block));
            }
            if (!args[0].respondsTo("exception")) {
                throw runtime.newTypeError("exception class/object expected");
            }
            exception = args[0].callMethod(context, "exception");
        } else {
            if (!args[0].respondsTo("exception")) {
                throw runtime.newTypeError("exception class/object expected");
            }
            exception = args[0].callMethod(context, "exception", args[1]);
        }
        if (!exception.isKindOf(runtime.getClass("Exception"))) {
            throw runtime.newTypeError("exception object expected");
        }
        if (args.length == 3) {
            ((RubyException)exception).set_backtrace(args[2]);
        }
        throw new RaiseException((RubyException)exception);
    }

    public static IRubyObject require(IRubyObject recv, IRubyObject name, Block block) {
        if (recv.getRuntime().getLoadService().require(name.toString())) {
            return recv.getRuntime().getTrue();
        }
        return recv.getRuntime().getFalse();
    }

    public static IRubyObject load(IRubyObject recv, IRubyObject[] args, Block block) {
        RubyString file = args[0].convertToString();
        recv.getRuntime().getLoadService().load(file.toString());
        return recv.getRuntime().getTrue();
    }

    public static IRubyObject eval(IRubyObject recv, IRubyObject[] args, Block block) {
        if (args == null || args.length == 0) {
            throw recv.getRuntime().newArgumentError(args.length, 1);
        }
        RubyString src = args[0].convertToString();
        IRubyObject scope = null;
        String file = "(eval)";
        if (args.length > 1) {
            if (!args[1].isNil()) {
                scope = args[1];
            }
            if (args.length > 2) {
                file = args[2].toString();
            }
        }
        int line = args.length > 3 ? RubyNumeric.fix2int(args[3]) - 1 : 1;
        recv.getRuntime().checkSafeString(src);
        ThreadContext context = recv.getRuntime().getCurrentContext();
        if (scope == null) {
            scope = RubyBinding.newBindingForEval(recv.getRuntime());
        }
        return recv.evalWithBinding(context, src, scope, file, line);
    }

    public static IRubyObject callcc(IRubyObject recv, IRubyObject[] args, Block block) {
        Ruby runtime = recv.getRuntime();
        runtime.getWarnings().warn("Kernel#callcc: Continuations are not implemented in JRuby and will not work");
        IRubyObject cc = runtime.getClass("Continuation").callMethod(runtime.getCurrentContext(), "new");
        cc.dataWrapStruct(block);
        return block.yield(runtime.getCurrentContext(), cc);
    }

    public static IRubyObject caller(IRubyObject recv, IRubyObject[] args, Block block) {
        int level;
        int n = level = args.length > 0 ? RubyNumeric.fix2int(args[0]) : 1;
        if (level < 0) {
            throw recv.getRuntime().newArgumentError("negative level(" + level + ')');
        }
        return ThreadContext.createBacktraceFromFrames(recv.getRuntime(), recv.getRuntime().getCurrentContext().createBacktrace(level, false));
    }

    public static IRubyObject rbCatch(IRubyObject recv, IRubyObject tag, Block block) {
        ThreadContext context = recv.getRuntime().getCurrentContext();
        try {
            context.pushCatch(tag.asSymbol());
            IRubyObject iRubyObject = block.yield(context, tag);
            return iRubyObject;
        }
        catch (JumpException je) {
            if (je.getJumpType() == JumpException.JumpType.ThrowJump && je.getTarget().equals(tag.asSymbol())) {
                IRubyObject iRubyObject = (IRubyObject)je.getValue();
                return iRubyObject;
            }
            throw je;
        }
        finally {
            context.popCatch();
        }
    }

    public static IRubyObject rbThrow(IRubyObject recv, IRubyObject[] args, Block block) {
        Ruby runtime = recv.getRuntime();
        String tag = args[0].asSymbol();
        ThreadContext context = runtime.getCurrentContext();
        String[] catches = context.getActiveCatches();
        String message = "uncaught throw `" + tag + "'";
        for (int i = catches.length - 1; i >= 0; --i) {
            if (!tag.equals(catches[i])) continue;
            throw context.prepareJumpException(JumpException.JumpType.ThrowJump, tag, args.length > 1 ? args[1] : runtime.getNil());
        }
        throw runtime.newNameError(message, tag);
    }

    public static IRubyObject trap(IRubyObject recv, IRubyObject[] args, Block block) {
        recv.getRuntime().getLoadService().require("jsignal");
        return recv.callMethod(recv.getRuntime().getCurrentContext(), "trap", args, CallType.FUNCTIONAL, block);
    }

    public static IRubyObject warn(IRubyObject recv, IRubyObject message) {
        Ruby runtime = recv.getRuntime();
        IRubyObject out = runtime.getObject().getConstant("STDERR");
        RubyIO io = (RubyIO)out.convertToType(runtime.getClass("IO"), 0, "to_io", true);
        io.puts(new IRubyObject[]{message});
        return recv.getRuntime().getNil();
    }

    public static IRubyObject set_trace_func(IRubyObject recv, IRubyObject trace_func, Block block) {
        if (trace_func.isNil()) {
            recv.getRuntime().setTraceFunction(null);
        } else {
            if (!(trace_func instanceof RubyProc)) {
                throw recv.getRuntime().newTypeError("trace_func needs to be Proc.");
            }
            recv.getRuntime().setTraceFunction((RubyProc)trace_func);
        }
        return trace_func;
    }

    public static IRubyObject trace_var(IRubyObject recv, IRubyObject[] args, Block block) {
        if (args.length == 0) {
            throw recv.getRuntime().newArgumentError(0, 1);
        }
        RubyProc proc = null;
        String var = null;
        if (args.length > 1) {
            var = args[0].toString();
        }
        if (var.charAt(0) != '$') {
            return recv.getRuntime().getNil();
        }
        if (args.length == 1) {
            proc = RubyProc.newProc(recv.getRuntime(), block, false);
        }
        if (args.length == 2) {
            proc = (RubyProc)args[1].convertToType(recv.getRuntime().getClass("Proc"), 0, "to_proc", true);
        }
        recv.getRuntime().getGlobalVariables().setTraceVar(var, proc);
        return recv.getRuntime().getNil();
    }

    public static IRubyObject untrace_var(IRubyObject recv, IRubyObject[] args, Block block) {
        if (args.length == 0) {
            throw recv.getRuntime().newArgumentError(0, 1);
        }
        String var = null;
        if (args.length >= 1) {
            var = args[0].toString();
        }
        if (var.charAt(0) != '$') {
            return recv.getRuntime().getNil();
        }
        if (args.length > 1) {
            ArrayList<IRubyObject> success = new ArrayList<IRubyObject>();
            for (int i = 1; i < args.length; ++i) {
                if (!recv.getRuntime().getGlobalVariables().untraceVar(var, args[i])) continue;
                success.add(args[i]);
            }
            return RubyArray.newArray(recv.getRuntime(), success);
        }
        recv.getRuntime().getGlobalVariables().untraceVar(var);
        return recv.getRuntime().getNil();
    }

    public static IRubyObject singleton_method_added(IRubyObject recv, IRubyObject symbolId, Block block) {
        return recv.getRuntime().getNil();
    }

    public static IRubyObject singleton_method_removed(IRubyObject recv, IRubyObject symbolId, Block block) {
        return recv.getRuntime().getNil();
    }

    public static IRubyObject singleton_method_undefined(IRubyObject recv, IRubyObject symbolId, Block block) {
        return recv.getRuntime().getNil();
    }

    public static RubyProc proc(IRubyObject recv, Block block) {
        return recv.getRuntime().newProc(true, block);
    }

    public static IRubyObject loop(IRubyObject recv, Block block) {
        ThreadContext context = recv.getRuntime().getCurrentContext();
        try {
            while (true) {
                block.yield(context, recv.getRuntime().getNil());
                context.pollThreadEvents();
            }
        }
        catch (JumpException je) {
            if (je.getJumpType() == JumpException.JumpType.BreakJump && je.getTarget() != null && je.getTarget() != block) {
                je.setBreakInKernelLoop(true);
            }
            throw je;
        }
    }

    public static IRubyObject test(IRubyObject recv, IRubyObject[] args) {
        Ruby runtime = recv.getRuntime();
        if (args.length == 0) {
            throw runtime.newArgumentError("wrong number of arguments");
        }
        IRubyObject cmdArg = args[0];
        int cmd = cmdArg instanceof RubyFixnum ? (int)((RubyFixnum)cmdArg).getLongValue() : (cmdArg instanceof RubyString && ((RubyString)cmdArg).getByteList().length() > 0 ? (int)((RubyString)cmdArg).getByteList().charAt(0) : (int)cmdArg.convertToInteger().getLongValue());
        switch (cmd) {
            case 45: 
            case 60: 
            case 61: 
            case 62: 
            case 67: 
            case 77: 
            case 100: 
            case 101: 
            case 102: 
            case 115: 
            case 122: {
                break;
            }
            case 65: 
            case 71: 
            case 79: 
            case 82: 
            case 83: 
            case 87: 
            case 88: 
            case 98: 
            case 99: 
            case 103: 
            case 107: 
            case 108: 
            case 111: 
            case 112: 
            case 114: 
            case 117: 
            case 119: 
            case 120: {
                throw runtime.newArgumentError("unimplemented command ?" + (char)cmd);
            }
            default: {
                throw runtime.newArgumentError("unknown command ?" + (char)cmd);
            }
        }
        switch (cmd) {
            case 45: 
            case 60: 
            case 61: 
            case 62: {
                if (args.length == 3) break;
                throw runtime.newArgumentError(args.length, 3);
            }
            default: {
                if (args.length == 2) break;
                throw runtime.newArgumentError(args.length, 2);
            }
        }
        File pwd = new File(runtime.getCurrentDirectory());
        File file1 = new File(pwd, args[1].convertToString().toString());
        File file2 = null;
        Calendar calendar = null;
        switch (cmd) {
            case 67: {
                return runtime.newFixnum(file1.lastModified());
            }
            case 100: {
                return runtime.newBoolean(file1.isDirectory());
            }
            case 101: {
                return runtime.newBoolean(file1.exists());
            }
            case 102: {
                return runtime.newBoolean(file1.isFile());
            }
            case 77: {
                calendar = Calendar.getInstance();
                calendar.setTimeInMillis(file1.lastModified());
                return RubyTime.newTime(runtime, calendar);
            }
            case 115: {
                long length = file1.length();
                return length == 0L ? runtime.getNil() : runtime.newFixnum(length);
            }
            case 122: {
                return runtime.newBoolean(file1.exists() && file1.length() == 0L);
            }
            case 61: {
                file2 = new File(pwd, args[2].convertToString().toString());
                return runtime.newBoolean(file1.lastModified() == file2.lastModified());
            }
            case 60: {
                file2 = new File(pwd, args[2].convertToString().toString());
                return runtime.newBoolean(file1.lastModified() < file2.lastModified());
            }
            case 62: {
                file2 = new File(pwd, args[2].convertToString().toString());
                return runtime.newBoolean(file1.lastModified() > file2.lastModified());
            }
            case 45: {
                file2 = new File(pwd, args[2].convertToString().toString());
                return runtime.newBoolean(file1.equals(file2));
            }
        }
        throw new InternalError("unreachable code reached!");
    }

    public static IRubyObject backquote(IRubyObject recv, IRubyObject aString) {
        Ruby runtime = recv.getRuntime();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        int resultCode = new ShellLauncher(runtime).runAndWait(new IRubyObject[]{aString}, output);
        recv.getRuntime().getGlobalVariables().set("$?", RubyProcess.RubyStatus.newProcessStatus(runtime, resultCode));
        return RubyString.newString(recv.getRuntime(), output.toByteArray());
    }

    public static RubyInteger srand(IRubyObject recv, IRubyObject[] args) {
        Ruby runtime = recv.getRuntime();
        long oldRandomSeed = runtime.getRandomSeed();
        if (args.length > 0) {
            RubyInteger integerSeed = (RubyInteger)args[0].convertToType(runtime.getClass("Integer"), 15, "to_i", true);
            runtime.setRandomSeed(integerSeed.getLongValue());
        } else {
            runtime.setRandomSeed(System.currentTimeMillis() ^ (long)recv.hashCode() ^ runtime.incrementRandomSeedSequence() ^ (long)runtime.getRandom().nextInt(Math.max(1, Math.abs((int)runtime.getRandomSeed()))));
        }
        runtime.getRandom().setSeed(runtime.getRandomSeed());
        return runtime.newFixnum(oldRandomSeed);
    }

    /*
     * WARNING - void declaration
     */
    public static RubyNumeric rand(IRubyObject recv, IRubyObject[] args) {
        void var3_3;
        long ceil;
        Ruby runtime = recv.getRuntime();
        if (args.length == 0) {
            ceil = 0L;
        } else if (args.length == 1) {
            if (args[0] instanceof RubyBignum) {
                byte[] bytes = new byte[((RubyBignum)args[0]).getValue().toByteArray().length - 1];
                runtime.getRandom().nextBytes(bytes);
                return new RubyBignum(runtime, new BigInteger(bytes).abs());
            }
            RubyInteger integerCeil = (RubyInteger)args[0].convertToType(runtime.getClass("Integer"), 15, "to_i", true);
            ceil = Math.abs(integerCeil.getLongValue());
        } else {
            throw runtime.newArgumentError("wrong # of arguments(" + args.length + " for 1)");
        }
        if (var3_3 == 0L) {
            return RubyFloat.newFloat(runtime, runtime.getRandom().nextDouble());
        }
        if (var3_3 > Integer.MAX_VALUE) {
            return runtime.newFixnum(runtime.getRandom().nextLong() % var3_3);
        }
        return runtime.newFixnum(runtime.getRandom().nextInt((int)var3_3));
    }

    public static RubyBoolean system(IRubyObject recv, IRubyObject[] args) {
        int resultCode;
        Ruby runtime = recv.getRuntime();
        try {
            resultCode = new ShellLauncher(runtime).runAndWait(args);
        }
        catch (Exception e) {
            resultCode = 127;
        }
        recv.getRuntime().getGlobalVariables().set("$?", RubyProcess.RubyStatus.newProcessStatus(runtime, resultCode));
        return runtime.newBoolean(resultCode == 0);
    }

    public static RubyArray to_a(IRubyObject recv) {
        recv.getRuntime().getWarnings().warn("default 'to_a' will be obsolete");
        return recv.getRuntime().newArray(recv);
    }
}

