/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.parser;

import java.io.Reader;
import java.io.StringReader;
import org.jruby.Ruby;
import org.jruby.RubyFile;
import org.jruby.ast.Node;
import org.jruby.lexer.yacc.LexerSource;
import org.jruby.lexer.yacc.SyntaxException;
import org.jruby.parser.DefaultRubyParser;
import org.jruby.parser.RubyParserConfiguration;
import org.jruby.parser.RubyParserPool;
import org.jruby.parser.RubyParserResult;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.collections.SinglyLinkedList;

public class Parser {
    private final Ruby runtime;

    public Parser(Ruby runtime) {
        this.runtime = runtime;
    }

    public Node parse(String file, String content, DynamicScope blockScope) {
        return this.parse(file, new StringReader(content), blockScope);
    }

    public Node parse(String file, Reader content, DynamicScope blockScope) {
        RubyParserConfiguration configuration = new RubyParserConfiguration();
        SinglyLinkedList cref = this.runtime.getObject().getCRef();
        ThreadContext tc = this.runtime.getCurrentContext();
        if (blockScope != null) {
            configuration.parseAsBlock(blockScope);
        }
        DefaultRubyParser parser = null;
        RubyParserResult result = null;
        try {
            parser = RubyParserPool.getInstance().borrowParser();
            parser.setWarnings(this.runtime.getWarnings());
            tc.setCRef(cref);
            LexerSource lexerSource = LexerSource.getSource(file, content);
            result = parser.parse(configuration, lexerSource);
            if (result.isEndSeen()) {
                IRubyObject verbose = this.runtime.getVerbose();
                this.runtime.setVerbose(this.runtime.getNil());
                this.runtime.defineGlobalConstant("DATA", new RubyFile(this.runtime, file, content));
                this.runtime.setVerbose(verbose);
                result.setEndSeen(false);
            }
        }
        catch (SyntaxException e) {
            StringBuffer buffer = new StringBuffer(100);
            buffer.append(e.getPosition().getFile()).append(':');
            buffer.append(e.getPosition().getEndLine()).append(": ");
            buffer.append(e.getMessage());
            throw this.runtime.newSyntaxError(buffer.toString());
        }
        finally {
            RubyParserPool.getInstance().returnParser(parser);
            tc.unsetCRef();
        }
        if (result.getScope() != null) {
            result.getScope().growIfNeeded();
        }
        result.addAppendBeginNodes();
        return result.getAST();
    }
}

