/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.Map;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ObjectMarshal;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.collections.SinglyLinkedList;

public class RubyClass
extends RubyModule {
    private final Ruby runtime;
    private final ObjectAllocator allocator;
    private ObjectMarshal marshal;
    private static final ObjectMarshal DEFAULT_OBJECT_MARSHAL = new ObjectMarshal(){

        public void marshalTo(Ruby runtime, Object obj, RubyClass type, MarshalStream marshalStream) throws IOException {
            IRubyObject object = (IRubyObject)obj;
            Map iVars = object.getInstanceVariablesSnapshot();
            marshalStream.dumpInstanceVars(iVars);
        }

        public Object unmarshalFrom(Ruby runtime, RubyClass type, UnmarshalStream unmarshalStream) throws IOException {
            IRubyObject result = type.allocate();
            unmarshalStream.registerLinkTarget(result);
            unmarshalStream.defaultInstanceVarsUnmarshal(result);
            return result;
        }
    };
    public static final byte EQQ_SWITCHVALUE = 1;

    protected RubyClass(RubyClass superClass, ObjectAllocator allocator) {
        this(superClass.getRuntime(), superClass.getRuntime().getClass("Class"), superClass, allocator, null, null);
        this.infectBy(superClass);
    }

    protected RubyClass(Ruby runtime, RubyClass superClass, ObjectAllocator allocator) {
        this(runtime, null, superClass, allocator, null, null);
    }

    protected RubyClass(Ruby runtime, RubyClass metaClass, RubyClass superClass, ObjectAllocator allocator) {
        this(runtime, metaClass, superClass, allocator, null, null);
    }

    protected RubyClass(Ruby runtime, RubyClass metaClass, RubyClass superClass, ObjectAllocator allocator, SinglyLinkedList parentCRef, String name) {
        super(runtime, metaClass, superClass, parentCRef, name);
        this.allocator = allocator;
        this.runtime = runtime;
        this.marshal = superClass != null ? superClass.getMarshal() : DEFAULT_OBJECT_MARSHAL;
    }

    public static RubyClass createBootstrapMetaClass(Ruby runtime, String className, RubyClass superClass, ObjectAllocator allocator, SinglyLinkedList cref) {
        RubyClass objectClass = new RubyClass(runtime, null, superClass, allocator, cref, className);
        return objectClass;
    }

    public int getNativeTypeIndex() {
        return 13;
    }

    public IRubyObject callMethod(ThreadContext context, RubyModule rubyclass, int methodIndex, String name, IRubyObject[] args, CallType callType, Block block) {
        if (context.getRuntime().getTraceFunction() != null) {
            return super.callMethod(context, rubyclass, name, args, callType, block);
        }
        switch (this.getRuntime().getSelectorTable().table[rubyclass.index][methodIndex]) {
            case 1: {
                if (args.length != 1) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 1 + ")");
                }
                return this.op_eqq(args[0]);
            }
        }
        return super.callMethod(context, rubyclass, name, args, callType, block);
    }

    public final IRubyObject allocate() {
        return this.getAllocator().allocate(this.getRuntime(), this);
    }

    public final ObjectMarshal getMarshal() {
        return this.marshal;
    }

    public final void setMarshal(ObjectMarshal marshal) {
        this.marshal = marshal;
    }

    public final void marshal(Object obj, MarshalStream marshalStream) throws IOException {
        this.getMarshal().marshalTo(this.getRuntime(), obj, this, marshalStream);
    }

    public final Object unmarshal(UnmarshalStream unmarshalStream) throws IOException {
        return this.getMarshal().unmarshalFrom(this.getRuntime(), this, unmarshalStream);
    }

    public static RubyClass newClassClass(Ruby runtime, RubyClass moduleClass) {
        ObjectAllocator defaultAllocator = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                RubyObject instance = new RubyObject(runtime, klass);
                instance.setMetaClass(klass);
                return instance;
            }
        };
        RubyClass classClass = new RubyClass(runtime, null, moduleClass, defaultAllocator, null, "Class");
        classClass.index = 13;
        return classClass;
    }

    public Ruby getRuntime() {
        return this.runtime;
    }

    public boolean isModule() {
        return false;
    }

    public boolean isClass() {
        return true;
    }

    public static void createClassClass(RubyClass classClass) {
        CallbackFactory callbackFactory = classClass.getRuntime().callbackFactory(RubyClass.class);
        classClass.getMetaClass().defineMethod("new", callbackFactory.getOptSingletonMethod("newClass"));
        classClass.defineFastMethod("allocate", callbackFactory.getFastMethod("allocate"));
        classClass.defineMethod("new", callbackFactory.getOptMethod("newInstance"));
        classClass.defineMethod("superclass", callbackFactory.getMethod("superclass"));
        classClass.defineFastMethod("initialize_copy", callbackFactory.getFastMethod("initialize_copy", RubyKernel.IRUBY_OBJECT));
        classClass.defineMethod("inherited", callbackFactory.getSingletonMethod("inherited", RubyKernel.IRUBY_OBJECT));
        classClass.undefineMethod("module_function");
    }

    public static IRubyObject inherited(IRubyObject recv, IRubyObject arg, Block block) {
        return recv.getRuntime().getNil();
    }

    public void inheritedBy(RubyClass superType) {
        if (superType == null) {
            superType = this.getRuntime().getObject();
        }
        superType.callMethod(this.getRuntime().getCurrentContext(), "inherited", this);
    }

    public boolean isSingleton() {
        return false;
    }

    public RubyClass getRealClass() {
        return this;
    }

    public static RubyClass newClass(Ruby runtime, RubyClass superClass, SinglyLinkedList parentCRef, String name) {
        return new RubyClass(runtime, runtime.getClass("Class"), superClass, superClass.getAllocator(), parentCRef, name);
    }

    public static RubyClass cloneClass(Ruby runtime, RubyClass metaClass, RubyClass superClass, ObjectAllocator allocator, SinglyLinkedList parentCRef, String name) {
        return new RubyClass(runtime, metaClass, superClass, allocator, parentCRef, name);
    }

    protected RubyClass subclass() {
        if (this == this.getRuntime().getClass("Class")) {
            throw this.getRuntime().newTypeError("can't make subclass of Class");
        }
        return new RubyClass(this, this.getAllocator());
    }

    public IRubyObject newInstance(IRubyObject[] args, Block block) {
        IRubyObject obj = this.allocate();
        obj.callMethod(this.getRuntime().getCurrentContext(), "initialize", args, block);
        return obj;
    }

    public ObjectAllocator getAllocator() {
        return this.allocator;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RubyClass newClass(IRubyObject recv, IRubyObject[] args, Block block, boolean invokeInherited) {
        RubyClass superClass;
        Ruby runtime = recv.getRuntime();
        if (args.length > 0) {
            if (!(args[0] instanceof RubyClass)) throw runtime.newTypeError("wrong argument type " + args[0].getType().getName() + " (expected Class)");
            superClass = (RubyClass)args[0];
        } else {
            superClass = runtime.getObject();
        }
        ThreadContext tc = runtime.getCurrentContext();
        RubyClass newClass = superClass.newSubClass(null, superClass.getAllocator(), tc.peekCRef(), invokeInherited);
        newClass.callInit(args, block);
        if (!block.isGiven()) return newClass;
        block.yield(tc, null, newClass, newClass, false);
        return newClass;
    }

    public static RubyClass newClass(IRubyObject recv, IRubyObject[] args, Block block) {
        return RubyClass.newClass(recv, args, block, true);
    }

    public IRubyObject superclass(Block block) {
        RubyClass superClass;
        for (superClass = this.getSuperClass(); superClass != null && superClass.isIncluded(); superClass = superClass.getSuperClass()) {
        }
        return superClass != null ? superClass : this.getRuntime().getNil();
    }

    public static IRubyObject inherited(RubyClass recv) {
        throw recv.getRuntime().newTypeError("can't make subclass of Class");
    }

    public static void marshalTo(RubyClass clazz, MarshalStream output) throws IOException {
        String name = clazz.getName();
        if (name.length() > 0 && name.charAt(0) == '#') {
            throw clazz.getRuntime().newTypeError("can't dump anonymous " + (clazz instanceof RubyClass ? "class" : "module") + " " + name);
        }
        output.writeString(name);
    }

    public static RubyModule unmarshalFrom(UnmarshalStream output) throws IOException {
        return (RubyClass)RubyModule.unmarshalFrom(output);
    }

    public RubyClass newSubClass(String name, ObjectAllocator allocator, SinglyLinkedList parentCRef, boolean invokeInherited) {
        RubyClass classClass = this.runtime.getClass("Class");
        if (this == classClass) {
            throw this.runtime.newTypeError("can't make subclass of Class");
        }
        if (this instanceof MetaClass) {
            throw this.runtime.newTypeError("can't make subclass of virtual class");
        }
        RubyClass newClass = new RubyClass(this.runtime, classClass, this, allocator, parentCRef, name);
        newClass.makeMetaClass(this.getMetaClass(), newClass.getCRef());
        if (invokeInherited) {
            newClass.inheritedBy(this);
        }
        if (null != name) {
            ((RubyModule)parentCRef.getValue()).setConstant(name, newClass);
        }
        return newClass;
    }

    public RubyClass newSubClass(String name, ObjectAllocator allocator, SinglyLinkedList parentCRef) {
        return this.newSubClass(name, allocator, parentCRef, true);
    }

    protected IRubyObject doClone() {
        return RubyClass.cloneClass(this.getRuntime(), this.getMetaClass(), this.getSuperClass(), this.getAllocator(), null, null);
    }

    public IRubyObject initialize_copy(IRubyObject original) {
        if (((RubyClass)original).isSingleton()) {
            throw this.getRuntime().newTypeError("can't copy singleton class");
        }
        super.initialize_copy(original);
        return this;
    }
}

