/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringScanner {
    private CharSequence string;
    private Matcher matcher;
    private int pos = 0;
    private int lastPos = -1;
    private int matchStart = -1;
    private int matchEnd = -1;

    public StringScanner() {
        this("");
    }

    public StringScanner(CharSequence string) {
        this.string = string;
    }

    public boolean isEndOfString() {
        return this.pos == this.string.length();
    }

    public boolean isBeginningOfLine() {
        return this.pos == 0 || this.string.charAt(this.pos - 1) == '\n';
    }

    public CharSequence getString() {
        return this.string;
    }

    private void resetMatchData() {
        this.matcher = null;
        this.matchStart = -1;
        this.matchEnd = -1;
    }

    public void terminate() {
        this.pos = this.string.length();
        this.lastPos = -1;
        this.resetMatchData();
    }

    public void reset() {
        this.pos = 0;
        this.lastPos = -1;
        this.resetMatchData();
    }

    public void setString(CharSequence string) {
        this.string = string;
        this.reset();
    }

    public void append(CharSequence string) {
        StringBuffer buf = new StringBuffer();
        buf.append((Object)this.string);
        buf.append((Object)string);
        this.string = buf.toString();
    }

    public CharSequence rest() {
        return this.string.subSequence(this.pos, this.string.length());
    }

    public int getPos() {
        return this.pos;
    }

    public void setPos(int pos) {
        if (pos > this.string.length()) {
            throw new IllegalArgumentException("index out of range.");
        }
        this.pos = pos;
    }

    public char getChar() {
        if (this.isEndOfString()) {
            return '\u0000';
        }
        this.matcher = null;
        this.matchStart = this.pos;
        this.matchEnd = this.pos + 1;
        this.lastPos = this.pos;
        return this.string.charAt(this.pos++);
    }

    public boolean matched() {
        return this.matchStart > -1;
    }

    public CharSequence group(int n) {
        if (!this.matched()) {
            return null;
        }
        if (this.matcher == null && this.matchEnd - this.matchStart == 1) {
            return this.string.subSequence(this.matchStart, this.matchEnd);
        }
        if (n > this.matcher.groupCount()) {
            return null;
        }
        return this.matcher.group(n);
    }

    public CharSequence preMatch() {
        if (this.matched()) {
            return this.string.subSequence(0, this.matchStart);
        }
        return null;
    }

    public CharSequence postMatch() {
        if (this.matched()) {
            return this.string.subSequence(this.matchEnd, this.string.length());
        }
        return null;
    }

    public CharSequence matchedValue() {
        if (this.matched()) {
            return this.string.subSequence(this.matchStart, this.matchEnd);
        }
        return null;
    }

    public int matchedSize() {
        if (this.matcher == null) {
            return -1;
        }
        return this.matchEnd - this.matchStart;
    }

    public void unscan() {
        if (this.lastPos == -1) {
            throw new IllegalStateException("unscan() cannot be called after an unmached scan.");
        }
        this.pos = this.lastPos;
        this.resetMatchData();
    }

    public int matches(Pattern pattern) {
        if (!this.isEndOfString()) {
            this.matcher = pattern.matcher(this.string.subSequence(this.pos, this.string.length()));
            if (this.matcher.lookingAt()) {
                this.matchStart = this.pos;
                this.matchEnd = this.matcher.end();
                return this.matchEnd;
            }
            this.resetMatchData();
        }
        return -1;
    }

    public CharSequence scanUntil(Pattern pattern) {
        if (!this.isEndOfString()) {
            this.matcher = pattern.matcher(this.string);
            if (this.matcher.find(this.pos)) {
                this.lastPos = this.pos;
                this.matchStart = this.matcher.start();
                this.pos = this.matchEnd = this.matcher.end();
                return this.string.subSequence(this.lastPos, this.pos);
            }
            this.lastPos = -1;
            this.resetMatchData();
        }
        return null;
    }

    public CharSequence scan(Pattern pattern) {
        if (!this.isEndOfString()) {
            this.matcher = pattern.matcher(this.string.subSequence(this.pos, this.string.length()));
            if (this.matcher.lookingAt()) {
                this.lastPos = this.pos;
                this.matchStart = this.pos;
                this.pos += this.matcher.end();
                this.matchEnd = this.pos;
                return this.matcher.group();
            }
            this.lastPos = -1;
            this.resetMatchData();
        }
        return null;
    }

    public CharSequence check(Pattern pattern) {
        if (!this.isEndOfString()) {
            this.matcher = pattern.matcher(this.string.subSequence(this.pos, this.string.length()));
            if (this.matcher.lookingAt()) {
                this.matchStart = this.pos;
                this.matchEnd = this.matchStart + this.matcher.end();
                return this.matcher.group();
            }
            this.resetMatchData();
        }
        return null;
    }

    public CharSequence checkUntil(Pattern pattern) {
        if (!this.isEndOfString()) {
            this.matcher = pattern.matcher(this.string);
            if (this.matcher.find(this.pos)) {
                this.matchStart = this.matcher.start();
                this.matchEnd = this.matcher.end();
                return this.string.subSequence(this.pos, this.matcher.end());
            }
            this.resetMatchData();
        }
        return null;
    }

    public int skip(Pattern pattern) {
        if (!this.isEndOfString()) {
            this.matcher = pattern.matcher(this.string.subSequence(this.pos, this.string.length()));
            if (this.matcher.lookingAt()) {
                this.lastPos = this.pos;
                this.matchStart = this.pos;
                int end = this.matcher.end();
                this.pos += end;
                this.matchEnd = this.pos;
                return end;
            }
            this.resetMatchData();
        }
        return -1;
    }

    public int skipUntil(Pattern pattern) {
        if (!this.isEndOfString()) {
            this.matcher = pattern.matcher(this.string);
            if (this.matcher.find(this.pos)) {
                this.lastPos = this.pos;
                this.pos = this.matcher.end();
                this.matchStart = this.matcher.start();
                this.matchEnd = this.pos;
                return this.pos - this.lastPos;
            }
            this.resetMatchData();
        }
        return -1;
    }

    public int exists(Pattern pattern) {
        if (!this.isEndOfString()) {
            this.matcher = pattern.matcher(this.string);
            if (this.matcher.find(this.pos)) {
                this.matchStart = this.matcher.start();
                this.matchEnd = this.matcher.end();
                return this.matchEnd - this.pos;
            }
            this.resetMatchData();
        }
        return -1;
    }

    public CharSequence peek(int length) {
        int end = this.pos + length;
        if (end > this.string.length()) {
            end = this.string.length();
        }
        return this.string.subSequence(this.pos, end);
    }
}

