/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets;

import com.headius.invokebinder.Signature;
import java.util.ArrayDeque;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.ir.IRScope;
import org.jruby.ir.targets.ClassData;
import org.jruby.ir.targets.IRBytecodeAdapter;
import org.jruby.ir.targets.JVMVisitor;
import org.jruby.ir.targets.MethodData;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JavaNameMangler;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;

public class JVM {
    final ArrayDeque<ClassData> classStack = new ArrayDeque();
    private ClassWriter writer;
    public static final Class OBJECT = IRubyObject.class;
    public static final Class OBJECT_ARRAY = IRubyObject[].class;
    public static final Class BLOCK = Block.class;
    public static final Class THREADCONTEXT = ThreadContext.class;
    public static final Class STATICSCOPE = StaticScope.class;
    public static final Class RUBY_MODULE = RubyModule.class;
    public static final Type OBJECT_TYPE = Type.getType((Class)OBJECT);
    public static final Type OBJECT_ARRAY_TYPE = Type.getType((Class)OBJECT_ARRAY);
    public static final Type BOOLEAN_TYPE = Type.BOOLEAN_TYPE;
    public static final Type DOUBLE_TYPE = Type.DOUBLE_TYPE;
    public static final Type LONG_TYPE = Type.LONG_TYPE;
    public static final Type INT_TYPE = Type.INT_TYPE;
    public static final Type BLOCK_TYPE = Type.getType((Class)BLOCK);
    public static final Type THREADCONTEXT_TYPE = Type.getType((Class)THREADCONTEXT);
    public static final Type STATICSCOPE_TYPE = Type.getType((Class)STATICSCOPE);
    public static final Type RUBY_MODULE_TYPE = Type.getType((Class)RUBY_MODULE);

    public byte[] toByteCode() {
        return this.writer.toByteArray();
    }

    public ClassVisitor cls() {
        return this.classData().cls;
    }

    public ClassData classData() {
        return this.classStack.getFirst();
    }

    public MethodData methodData() {
        return this.classData().methodData();
    }

    public void pushscript(JVMVisitor visitor, String clsName, String filename2) {
        this.writer = new ClassWriter(3);
        this.classStack.push(new ClassData(clsName, (ClassVisitor)this.writer, visitor));
        this.cls().visit(RubyInstanceConfig.JAVA_VERSION, 33, clsName, null, CodegenUtils.p(Object.class), null);
        this.cls().visitSource(filename2, null);
        SkinnyMethodAdapter adapter = new SkinnyMethodAdapter(this.cls(), 9, "<clinit>", CodegenUtils.sig(Void.TYPE, new Class[0]), null, null);
        adapter.start();
        adapter.ldc(Type.getObjectType((String)CodegenUtils.p(String.class)));
        adapter.ldc(Type.getObjectType((String)CodegenUtils.p(RubyModule.class)));
        adapter.pop2();
        adapter.ldc(Type.getObjectType((String)CodegenUtils.p(Block.class)));
        adapter.ldc(Type.getObjectType((String)CodegenUtils.p(IRubyObject.class)));
        adapter.pop2();
        adapter.ldc(Type.getObjectType((String)CodegenUtils.p(StaticScope.class)));
        adapter.ldc(Type.getObjectType((String)CodegenUtils.p(ThreadContext.class)));
        adapter.pop2();
        adapter.ldc(Type.getObjectType((String)CodegenUtils.p(IRubyObject[].class)));
        adapter.ldc(Type.getObjectType((String)CodegenUtils.p(DynamicScope.class)));
        adapter.pop2();
        adapter.voidreturn();
        adapter.end();
    }

    public void popclass() {
        this.classStack.pop();
    }

    public IRBytecodeAdapter method() {
        return this.classData().method();
    }

    public void pushmethod(String name2, IRScope scope, String scopeField, Signature signature, boolean specificArity) {
        this.classData().pushmethod(name2, scope, scopeField, signature, specificArity);
        this.method().startMethod();
        this.method().updateLineNumber(scope.getLine());
    }

    public void popmethod() {
        this.classData().popmethod();
    }

    public static String scriptToClass(String name2) {
        if (name2 == null || name2.length() == 0) {
            return "NullFilename";
        }
        if (name2.equals("-e")) {
            return "DashE";
        }
        return JavaNameMangler.mangledFilenameForStartupClasspath(name2);
    }
}

