/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import org.jruby.Ruby;
import org.jruby.ast.executable.AbstractScript;
import org.jruby.ast.executable.Script;
import org.jruby.ast.executable.ScriptAndCode;
import org.jruby.compiler.NotCompilableException;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.IRTranslator;
import org.jruby.ir.operands.IRException;
import org.jruby.ir.persistence.util.IRFileExpert;
import org.jruby.ir.runtime.IRBreakJump;
import org.jruby.ir.targets.JVM;
import org.jruby.ir.targets.JVMVisitor;
import org.jruby.ir.targets.JVMVisitorMethodContext;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ClassDefiningClassLoader;
import org.jruby.util.cli.Options;

public class Compiler
extends IRTranslator<ScriptAndCode, ClassDefiningClassLoader> {
    private Compiler() {
    }

    public static Compiler getInstance() {
        return CompilerHolder.instance;
    }

    @Override
    protected ScriptAndCode execute(Ruby runtime2, IRScriptBody scope, ClassDefiningClassLoader classLoader) {
        if (scope.anyUsesEval() || scope.hasFlipFlops()) {
            throw new NotCompilableException("AOT not supported for scripts containing eval or flip-flops.");
        }
        boolean cacheClasses = (Boolean)Options.COMPILE_CACHE_CLASSES.load();
        JVMVisitor visitor = cacheClasses ? JVMVisitor.newForAOT(runtime2) : JVMVisitor.newForJIT(runtime2);
        JVMVisitorMethodContext context = new JVMVisitorMethodContext();
        byte[] bytecode = visitor.compileToBytecode(scope, context);
        Class compiled = visitor.defineScriptFromBytecode(scope, bytecode, classLoader);
        Script script = Compiler.getScriptFromClass(compiled);
        if (cacheClasses) {
            File path2 = IRFileExpert.getIRClassFile(JVM.scriptToClass(scope.getFile()));
            try (FileOutputStream fos = new FileOutputStream(path2);){
                fos.write(bytecode);
                if (((Boolean)Options.COMPILE_CACHE_CLASSES_LOGGING.load()).booleanValue()) {
                    System.err.println("saved compiled script as " + path2);
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        return new ScriptAndCode(bytecode, script);
    }

    public static Script getScriptFromClass(Class compiled) {
        MethodHandle scriptHandle;
        try {
            Method scriptMethod = compiled.getMethod("run", ThreadContext.class, IRubyObject.class, String.class, Boolean.TYPE);
            scriptHandle = MethodHandles.publicLookup().unreflect(scriptMethod);
        }
        catch (Throwable t) {
            throw new NotCompilableException("failed to load script from class" + compiled.getName(), t);
        }
        return new AbstractScript(){

            @Override
            public IRubyObject __file__(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
                try {
                    return (IRubyObject)scriptHandle.invokeWithArguments(context, self2, this.filename, false);
                }
                catch (Throwable t) {
                    Helpers.throwException(t);
                    return null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public IRubyObject load(ThreadContext context, IRubyObject self2, boolean wrap2) {
                try {
                    return (IRubyObject)scriptHandle.invokeWithArguments(context, self2, this.filename, wrap2);
                }
                catch (IRBreakJump bj) {
                    throw IRException.BREAK_LocalJumpError.getException(context.runtime);
                }
                catch (Throwable t) {
                    Helpers.throwException(t);
                    return null;
                }
            }
        };
    }

    private static class CompilerHolder {
        public static final Compiler instance = new Compiler();

        private CompilerHolder() {
        }
    }
}

