/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jnr.constants.platform.AddressFamily;
import jnr.constants.platform.IPProto;
import jnr.constants.platform.NameInfo;
import jnr.constants.platform.ProtocolFamily;
import jnr.constants.platform.Sock;
import jnr.constants.platform.SocketLevel;
import jnr.constants.platform.SocketOption;
import jnr.netdb.Protocol;
import jnr.netdb.Service;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Error;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.socket.Addrinfo;
import org.jruby.ext.socket.RubyIPSocket;
import org.jruby.ext.socket.RubySocket;
import org.jruby.ext.socket.SocketType;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.Sockaddr;

public class SocketUtils {
    public static final String IP_V4_MAPPED_ADDRESS_PREFIX = "::ffff:";
    private static final String ipv6LocalHost = "::1";
    private static final Pattern STRING_IPV4_ADDRESS_PATTERN = Pattern.compile("((.*)\\/)?([\\.0-9]+)(:([0-9]+))?");
    private static final int IPV4_HOST_GROUP = 3;
    private static final int IPV4_PORT_GROUP = 5;
    private static final String BROADCAST = "<broadcast>";
    private static final byte[] INADDR_BROADCAST = new byte[]{-1, -1, -1, -1};
    private static final String ANY = "<any>";
    private static final byte[] INADDR_ANY = new byte[]{0, 0, 0, 0};

    public static IRubyObject gethostname(ThreadContext context) {
        try {
            return Create.newString(context, InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            try {
                return Create.newString(context, InetAddress.getByAddress(new byte[]{0, 0, 0, 0}).getHostName());
            }
            catch (UnknownHostException e2) {
                throw SocketUtils.sockerr(context.runtime, "gethostname: name or service not known");
            }
        }
    }

    public static IRubyObject gethostbyaddr(ThreadContext context, IRubyObject[] args2) {
        RubyString ret0 = Create.newString(context, Sockaddr.addressFromString(context.runtime, args2[0].convertToString().toString()).getCanonicalHostName());
        RubyArray<?> ret1 = Create.newEmptyArray(context);
        RubyFixnum ret2 = Convert.asFixnum(context, 2);
        IRubyObject ret3 = args2[0];
        return RubyArray.newArray(context.runtime, ret0, ret1, ret2, ret3);
    }

    public static IRubyObject getservbyname(ThreadContext context, IRubyObject[] args2) {
        int port;
        String proto;
        String name2 = args2[0].convertToString().toString();
        Service service = Service.getServiceByName((String)name2, (String)(proto = args2.length == 1 ? "tcp" : args2[1].convertToString().toString()));
        if (service != null) {
            port = service.getPort();
        } else {
            try {
                port = Integer.parseInt(name2.trim());
            }
            catch (NumberFormatException nfe) {
                throw SocketUtils.sockerr(context.runtime, "no such service " + name2 + "/" + proto);
            }
        }
        return Convert.asFixnum(context, port);
    }

    @Deprecated
    public static IRubyObject pack_sockaddr_in(ThreadContext context, IRubyObject port, IRubyObject host) {
        return Sockaddr.pack_sockaddr_in(context, port, host);
    }

    @Deprecated
    public static RubyArray unpack_sockaddr_in(ThreadContext context, IRubyObject addr2) {
        return Sockaddr.unpack_sockaddr_in(context, addr2);
    }

    @Deprecated
    public static IRubyObject pack_sockaddr_un(ThreadContext context, IRubyObject filename2) {
        String path2 = filename2.convertToString().asJavaString();
        return Sockaddr.pack_sockaddr_un(context, path2);
    }

    public static IRubyObject gethostbyname(ThreadContext context, IRubyObject hostname) {
        try {
            InetAddress addr2 = SocketUtils.getRubyInetAddress(hostname.convertToString().toString());
            return RubyArray.newArray(context.runtime, Create.newString(context, addr2.getCanonicalHostName()), Create.newEmptyArray(context), Convert.asFixnum(context, AddressFamily.AF_INET.longValue()), Create.newString(context, new ByteList(addr2.getAddress())));
        }
        catch (UnknownHostException e) {
            throw SocketUtils.sockerr(context.runtime, "gethostbyname: name or service not known");
        }
    }

    public static IRubyObject getaddrinfo(ThreadContext context, IRubyObject[] args2) {
        ArrayList<IRubyObject> list2 = new ArrayList<IRubyObject>();
        SocketUtils.buildAddrinfoList(context, args2, true, (address2, port, sock, reverse2, usesCanonical) -> {
            boolean is_ipv6 = address2 instanceof Inet6Address;
            boolean sock_stream = true;
            boolean sock_dgram = true;
            if (sock != null) {
                if (sock == Sock.SOCK_STREAM) {
                    sock_dgram = false;
                } else if (sock == Sock.SOCK_DGRAM) {
                    sock_stream = false;
                }
            }
            if (sock_dgram) {
                list2.add(RubyArray.newArrayMayCopy(context.runtime, Create.newString(context, is_ipv6 ? "AF_INET6" : "AF_INET"), Convert.asFixnum(context, port), Create.newString(context, SocketUtils.getHostAddress(context, address2, reverse2)), Create.newString(context, address2.getHostAddress()), Convert.asFixnum(context, is_ipv6 ? ProtocolFamily.PF_INET6.longValue() : ProtocolFamily.PF_INET.longValue()), Convert.asFixnum(context, Sock.SOCK_DGRAM.longValue()), Convert.asFixnum(context, IPProto.IPPROTO_UDP.longValue())));
            }
            if (sock_stream) {
                list2.add(RubyArray.newArrayMayCopy(context.runtime, Create.newString(context, is_ipv6 ? "AF_INET6" : "AF_INET"), Convert.asFixnum(context, port), Create.newString(context, SocketUtils.getHostAddress(context, address2, reverse2)), Create.newString(context, address2.getHostAddress()), Convert.asFixnum(context, is_ipv6 ? ProtocolFamily.PF_INET6.longValue() : ProtocolFamily.PF_INET.longValue()), Convert.asFixnum(context, Sock.SOCK_STREAM.longValue()), Convert.asFixnum(context, IPProto.IPPROTO_TCP.longValue())));
            }
        });
        return Create.newArray(context, list2);
    }

    public static List<Addrinfo> getaddrinfoList(ThreadContext context, IRubyObject[] args2) {
        ArrayList<Addrinfo> l = new ArrayList<Addrinfo>();
        SocketUtils.buildAddrinfoList(context, args2, false, (address2, port, sock, reverse2, usesCanonical) -> {
            boolean sock_stream = true;
            boolean sock_dgram = true;
            if (sock != null) {
                if (sock == Sock.SOCK_STREAM) {
                    sock_dgram = false;
                } else if (sock == Sock.SOCK_DGRAM) {
                    sock_stream = false;
                }
            }
            if (sock_dgram) {
                l.add(new Addrinfo(context.runtime, Access.getClass(context, "Addrinfo"), new InetSocketAddress(address2, port), Sock.SOCK_DGRAM, SocketType.DATAGRAM, usesCanonical));
            }
            if (sock_stream) {
                l.add(new Addrinfo(context.runtime, Access.getClass(context, "Addrinfo"), new InetSocketAddress(address2, port), Sock.SOCK_STREAM, SocketType.SOCKET, usesCanonical));
            }
        });
        return l;
    }

    public static void buildAddrinfoList(ThreadContext context, IRubyObject[] args2, boolean processLastArgAsReverse, AddrinfoCallback callback) {
        Sock sock;
        Ruby runtime2 = context.runtime;
        IRubyObject host = args2[0];
        IRubyObject port = args2[1];
        boolean emptyHost = host.isNil() || host.convertToString().isEmpty();
        IRubyObject family2 = args2.length > 2 ? args2[2] : context.nil;
        IRubyObject socktype2 = args2.length > 3 ? args2[3] : context.nil;
        IRubyObject protocol2 = args2.length > 4 ? args2[4] : context.nil;
        IRubyObject flags2 = args2.length > 5 ? args2[5] : context.nil;
        IRubyObject reverseArg = args2.length > 6 ? args2[6] : context.nil;
        Boolean reverseLookup = null;
        IRubyObject timeout2 = context.nil;
        if (processLastArgAsReverse) {
            reverseLookup = RubyIPSocket.doReverseLookup(context, reverseArg);
        } else if (reverseArg != context.nil) {
            timeout2 = ArgsUtil.extractKeywordArg(context, "timeout", reverseArg);
        }
        AddressFamily addressFamily = family2.isNil() ? null : SocketUtils.addressFamilyFromArg(context, family2);
        Sock sock2 = sock = socktype2.isNil() ? Sock.SOCK_STREAM : SocketUtils.sockFromArg(context, socktype2);
        if (port instanceof RubyString) {
            port = SocketUtils.getservbyname(context, new IRubyObject[]{port});
        }
        int p2 = port.isNil() ? 0 : Convert.toInt(context, port);
        int flag = flags2.isNil() ? 0 : Convert.toInt(context, flags2);
        boolean displayCanonical = (flag & 2) != 0;
        String hostString = null;
        hostString = flag == 1 && emptyHost ? (addressFamily == AddressFamily.AF_INET6 ? "[::]" : "0.0.0.0") : (emptyHost ? "localhost" : host.convertToString().toString());
        try {
            InetAddress[] addrs = InetAddress.getAllByName(hostString);
            for (int i2 = 0; i2 < addrs.length; ++i2) {
                if (addressFamily == AddressFamily.AF_INET6 && !(addrs[i2] instanceof Inet6Address) || addressFamily == AddressFamily.AF_INET && !(addrs[i2] instanceof Inet4Address)) continue;
                callback.addrinfo(addrs[i2], p2, sock, reverseLookup, displayCanonical);
            }
        }
        catch (UnknownHostException e) {
            throw SocketUtils.sockerr(runtime2, "getaddrinfo: name or service not known");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IRubyObject getnameinfo(ThreadContext context, IRubyObject[] args2) {
        InetAddress addr2;
        String host;
        String port;
        int flags2 = args2.length == 2 ? Convert.toInt(context, args2[1]) : 0;
        IRubyObject arg0 = args2[0];
        if (arg0 instanceof RubyArray) {
            RubyArray ary = (RubyArray)arg0;
            int len = ary.size();
            if (len < 3 || len > 4) {
                throw Error.argumentError(context, "array size should be 3 or 4, " + len + " given");
            }
            port = ary.eltInternal(1).toString();
            host = len == 3 ? ary.eltInternal(2).toString() : ary.eltInternal(3).toString();
        } else {
            if (!(arg0 instanceof RubyString)) throw Error.argumentError(context, "invalid args");
            RubyString argS = (RubyString)arg0;
            String arg2 = argS.toString();
            Matcher m = STRING_IPV4_ADDRESS_PATTERN.matcher(arg2);
            if (!m.matches()) {
                RubyArray portAndHost = Sockaddr.unpack_sockaddr_in(context, arg0);
                if (portAndHost.size() != 2) {
                    throw Error.argumentError(context, "invalid address representation");
                }
                port = portAndHost.eltInternal(0).toString();
                host = portAndHost.eltInternal(1).toString();
            } else {
                host = m.group(3);
                if (host == null || host.length() == 0 || (port = m.group(5)) == null || port.length() == 0) {
                    throw Error.argumentError(context, "invalid address string");
                }
                try {
                    InetAddress ipv6_addr = InetAddress.getByName(host);
                    if (ipv6_addr instanceof Inet6Address) {
                        host = ipv6_addr.getHostAddress();
                    }
                }
                catch (UnknownHostException uhe) {
                    throw Error.argumentError(context, "invalid address string");
                }
            }
        }
        try {
            addr2 = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw SocketUtils.sockerr(context.runtime, "unknown host: " + host);
        }
        host = (flags2 & NameInfo.NI_NUMERICHOST.intValue()) == 0 ? addr2.getCanonicalHostName() : addr2.getHostAddress();
        Service serv = Service.getServiceByPort((int)Integer.parseInt(port), null);
        if (serv == null) return Create.newArray(context, (IRubyObject)Create.newString(context, host), (IRubyObject)Create.newString(context, port));
        port = (flags2 & NameInfo.NI_NUMERICSERV.intValue()) == 0 ? serv.getName() : Integer.toString(serv.getPort());
        return Create.newArray(context, (IRubyObject)Create.newString(context, host), (IRubyObject)Create.newString(context, port));
    }

    public static IRubyObject ip_address_list(ThreadContext context) {
        try {
            RubyArray<?> list2 = Create.newArray(context);
            RubyClass addrInfoCls = Access.getClass(context, "Addrinfo");
            Enumeration<NetworkInterface> networkIfcs = NetworkInterface.getNetworkInterfaces();
            while (networkIfcs.hasMoreElements()) {
                Enumeration<InetAddress> addresses = networkIfcs.nextElement().getInetAddresses();
                while (addresses.hasMoreElements()) {
                    list2.append(context, new Addrinfo(context.runtime, addrInfoCls, addresses.nextElement()));
                }
            }
            return list2;
        }
        catch (SocketException se) {
            throw SocketUtils.sockerr(context.runtime, se.getLocalizedMessage());
        }
    }

    @Deprecated
    public static InetAddress[] getRubyInetAddresses(ByteList address2) throws UnknownHostException {
        String addressString = Helpers.byteListToString(address2);
        return SocketUtils.getRubyInetAddresses(addressString);
    }

    public static InetAddress[] getRubyInetAddresses(String addressString) throws UnknownHostException {
        InetAddress specialAddress = SocketUtils.specialAddress(addressString);
        if (specialAddress != null) {
            return new InetAddress[]{specialAddress};
        }
        return InetAddress.getAllByName(addressString);
    }

    public static InetAddress getRubyInetAddress(String addressString) throws UnknownHostException {
        InetAddress specialAddress = SocketUtils.specialAddress(addressString);
        if (specialAddress != null) {
            return specialAddress;
        }
        return InetAddress.getByName(addressString);
    }

    public static InetAddress getRubyInetAddress(String host, String node) throws UnknownHostException {
        InetAddress specialAddress = SocketUtils.specialAddress(host);
        if (specialAddress != null) {
            return specialAddress;
        }
        return InetAddress.getByAddress(host, InetAddress.getByName(node).getAddress());
    }

    public static InetAddress getRubyInetAddress(byte[] addressBytes) throws UnknownHostException {
        return InetAddress.getByAddress(addressBytes);
    }

    private static InetAddress specialAddress(String addressString) throws UnknownHostException {
        if (addressString.equals(BROADCAST)) {
            return InetAddress.getByAddress(INADDR_BROADCAST);
        }
        if (addressString.equals(ANY)) {
            return InetAddress.getByAddress(INADDR_ANY);
        }
        return null;
    }

    public static boolean isIPV4MappedAddressPrefix(String address2) {
        return address2.startsWith(IP_V4_MAPPED_ADDRESS_PREFIX);
    }

    public static IRubyObject getaddress(ThreadContext context, IRubyObject hostname) {
        try {
            String hostnameString = hostname.convertToString().toString();
            InetAddress address2 = InetAddress.getByName(hostnameString);
            if (SocketUtils.isIPV4MappedAddressPrefix(hostnameString)) {
                return RubyString.newInternalFromJavaExternal(context.runtime, IP_V4_MAPPED_ADDRESS_PREFIX + address2.getHostAddress());
            }
            if (hostnameString.equals(ipv6LocalHost)) {
                return RubyString.newInternalFromJavaExternal(context.runtime, ipv6LocalHost);
            }
            return RubyString.newInternalFromJavaExternal(context.runtime, address2.getHostAddress());
        }
        catch (UnknownHostException e) {
            throw SocketUtils.sockerr(context.runtime, "getaddress: name or service not known");
        }
    }

    public static RuntimeException sockerr(Ruby runtime2, String msg) {
        return RaiseException.from(runtime2, Access.getClass(runtime2.getCurrentContext(), "SocketError"), msg);
    }

    public static RuntimeException sockerr_with_trace(Ruby runtime2, String msg, StackTraceElement[] trace2) {
        String eol = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append(msg);
        int il = trace2.length;
        for (int i2 = 0; i2 < il; ++i2) {
            sb.append(eol).append(trace2[i2].toString());
        }
        return RaiseException.from(runtime2, Access.getClass(runtime2.getCurrentContext(), "SocketError"), sb.toString());
    }

    public static int getPortFrom(ThreadContext context, IRubyObject _port) {
        int port;
        if (_port instanceof RubyInteger) {
            port = Convert.toInt(context, _port);
        } else {
            RubyString portString = _port.convertToString();
            RubyInteger portInteger = portString.convertToInteger("to_i");
            port = Convert.toInt(context, portInteger);
            if (port <= 0) {
                port = Convert.toInt(context, RubySocket.getservbyname(context, Access.objectClass(context), new IRubyObject[]{portString}));
            }
        }
        return port;
    }

    private static String getHostAddress(ThreadContext context, InetAddress addr2, Boolean reverse2) {
        String ret = reverse2 == null ? (context.runtime.isDoNotReverseLookupEnabled() ? addr2.getHostAddress() : addr2.getCanonicalHostName()) : (reverse2 != false ? addr2.getCanonicalHostName() : addr2.getHostAddress());
        return ret;
    }

    static AddressFamily addressFamilyFromArg(ThreadContext context, IRubyObject domain) {
        IRubyObject maybeString = TypeConverter.checkStringType(context.runtime, domain);
        if (!maybeString.isNil()) {
            domain = maybeString;
        }
        try {
            if (domain instanceof RubyString || domain instanceof RubySymbol) {
                String domainString = domain.toString();
                if (domainString.startsWith("AF_")) {
                    return AddressFamily.valueOf((String)domainString);
                }
                if (domainString.startsWith("PF_")) {
                    return AddressFamily.valueOf((long)ProtocolFamily.valueOf((String)domainString).intValue());
                }
                return AddressFamily.valueOf((String)("AF_" + domainString));
            }
            int domainInt = Convert.toInt(context, domain);
            return AddressFamily.valueOf((long)domainInt);
        }
        catch (IllegalArgumentException iae) {
            throw SocketUtils.sockerr(context.runtime, "invalid address family: " + String.valueOf(domain));
        }
    }

    static Sock sockFromArg(ThreadContext context, IRubyObject type2) {
        IRubyObject maybeString = TypeConverter.checkStringType(context.runtime, type2);
        if (!maybeString.isNil()) {
            type2 = maybeString;
        }
        try {
            if (type2 instanceof RubyString || type2 instanceof RubySymbol) {
                String typeString = type2.toString();
                if (typeString.startsWith("SOCK_")) {
                    return Sock.valueOf((String)typeString.toString());
                }
                return Sock.valueOf((String)("SOCK_" + typeString));
            }
            int typeInt = Convert.toInt(context, type2);
            return Sock.valueOf((long)typeInt);
        }
        catch (IllegalArgumentException iae) {
            throw SocketUtils.sockerr(context.runtime, "invalid socket type: " + String.valueOf(type2));
        }
    }

    static ProtocolFamily protocolFamilyFromArg(ThreadContext context, IRubyObject protocol2) {
        IRubyObject maybeString = TypeConverter.checkStringType(context.runtime, protocol2);
        if (!maybeString.isNil()) {
            protocol2 = maybeString;
        }
        try {
            if (protocol2 instanceof RubyString || protocol2 instanceof RubySymbol) {
                String protocolString = protocol2.toString();
                if (protocolString.startsWith("PF_")) {
                    return ProtocolFamily.valueOf((String)protocolString);
                }
                if (protocolString.startsWith("AF_")) {
                    return ProtocolFamily.valueOf((long)AddressFamily.valueOf((String)protocolString).intValue());
                }
                return ProtocolFamily.valueOf((String)("PF_" + protocolString));
            }
            int protocolInt = Convert.toInt(context, protocol2);
            return ProtocolFamily.valueOf((long)protocolInt);
        }
        catch (IllegalArgumentException iae) {
            throw SocketUtils.sockerr(context.runtime, "invalid protocol family: " + String.valueOf(protocol2));
        }
    }

    static Protocol protocolFromArg(ThreadContext context, IRubyObject protocol2) {
        IRubyObject maybeString = TypeConverter.checkStringType(context.runtime, protocol2);
        if (!maybeString.isNil()) {
            protocol2 = maybeString;
        }
        try {
            if (protocol2 instanceof RubyString || protocol2 instanceof RubySymbol) {
                String protocolString = protocol2.toString();
                return Protocol.getProtocolByName((String)protocolString);
            }
            int protocolInt = Convert.toInt(context, protocol2);
            return Protocol.getProtocolByNumber((int)protocolInt);
        }
        catch (IllegalArgumentException iae) {
            throw SocketUtils.sockerr(context.runtime, "invalid protocol: " + String.valueOf(protocol2));
        }
    }

    static SocketLevel levelFromArg(ThreadContext context, IRubyObject level2) {
        IRubyObject maybeString = TypeConverter.checkStringType(context.runtime, level2);
        if (!maybeString.isNil()) {
            level2 = maybeString;
        }
        try {
            if (level2 instanceof RubyString || level2 instanceof RubySymbol) {
                String levelString = level2.toString();
                if (levelString.startsWith("SOL_")) {
                    return SocketLevel.valueOf((String)levelString);
                }
                return SocketLevel.valueOf((String)("SOL_" + levelString));
            }
            return SocketLevel.valueOf((long)Convert.toInt(context, level2));
        }
        catch (IllegalArgumentException iae) {
            throw SocketUtils.sockerr(context.runtime, "invalid socket level: " + String.valueOf(level2));
        }
    }

    static SocketOption optionFromArg(ThreadContext context, IRubyObject opt) {
        IRubyObject maybeString = TypeConverter.checkStringType(context.runtime, opt);
        if (!maybeString.isNil()) {
            opt = maybeString;
        }
        try {
            if (opt instanceof RubyString || opt instanceof RubySymbol) {
                String optString = opt.toString();
                if (optString.startsWith("SO_")) {
                    return SocketOption.valueOf((String)optString);
                }
                return SocketOption.valueOf((String)("SO_" + optString));
            }
            return SocketOption.valueOf((long)Convert.toInt(context, opt));
        }
        catch (IllegalArgumentException iae) {
            throw SocketUtils.sockerr(context.runtime, "invalid socket option: " + String.valueOf(opt));
        }
    }

    @Deprecated(since="10.0")
    public static int portToInt(IRubyObject port) {
        return SocketUtils.portToInt(((RubyBasicObject)port).getCurrentContext(), port);
    }

    public static int portToInt(ThreadContext context, IRubyObject port) {
        if (port.isNil()) {
            return 0;
        }
        IRubyObject maybeStr = TypeConverter.checkStringType(context.runtime, port);
        if (!maybeStr.isNil()) {
            RubyString portStr = maybeStr.convertToString();
            Service serv = Service.getServiceByName((String)portStr.toString(), null);
            if (serv != null) {
                return serv.getPort();
            }
            return ((RubyInteger)portStr.to_i(context)).asInt(context);
        }
        return Convert.toInt(context, port);
    }

    static interface AddrinfoCallback {
        public void addrinfo(InetAddress var1, int var2, Sock var3, Boolean var4, boolean var5);
    }
}

