/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import java.io.File;
import java.nio.channels.Channel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import jnr.constants.platform.Errno;
import jnr.constants.platform.Fcntl;
import jnr.constants.platform.OpenFlags;
import jnr.enxio.channels.NativeDeviceChannel;
import jnr.posix.POSIX;
import jnr.posix.SpawnAttribute;
import jnr.posix.SpawnFileAction;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyFile;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyProcess;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.api.API;
import org.jruby.api.Access;
import org.jruby.api.Check;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Error;
import org.jruby.exceptions.RaiseException;
import org.jruby.platform.Platform;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.ShellLauncher;
import org.jruby.util.TypeConverter;
import org.jruby.util.cli.Options;
import org.jruby.util.io.ChannelFD;
import org.jruby.util.io.EncodingUtils;
import org.jruby.util.io.IOEncodable;
import org.jruby.util.io.OpenFile;
import org.jruby.util.io.POSIXProcess;
import org.jruby.util.io.PosixShim;

public class PopenExecutor {
    public static final int SH_CHDIR_ARG_COUNT = 5;
    private Errno errno = null;
    private static final int ST_CONTINUE = 0;
    private static final int ST_STOP = 1;
    private static final int posix_sh_cmd_length = 8;
    private static final String[] posix_sh_cmds = new String[]{"!", ".", ":", "break", "case", "continue", "do", "done", "elif", "else", "esac", "eval", "exec", "exit", "export", "fi", "for", "if", "in", "readonly", "return", "set", "shift", "then", "times", "trap", "unset", "until", "while"};
    private static final byte[] DUMMY_ARRAY = ByteList.NULL_ARRAY;
    private static final Comparator<run_exec_dup2_fd_pair> intcmp = new Comparator<run_exec_dup2_fd_pair>(){

        @Override
        public int compare(run_exec_dup2_fd_pair o1, run_exec_dup2_fd_pair o2) {
            return Integer.compare(o1.oldfd, o2.oldfd);
        }
    };
    private static final Comparator<run_exec_dup2_fd_pair> intrcmp = new Comparator<run_exec_dup2_fd_pair>(){

        @Override
        public int compare(run_exec_dup2_fd_pair o1, run_exec_dup2_fd_pair o2) {
            return Integer.compare(o2.oldfd, o1.oldfd);
        }
    };

    public static boolean nativePopenAvailable(Ruby runtime2) {
        return (Boolean)Options.NATIVE_POPEN.load() != false && runtime2.getPosix().isNative() && !Platform.IS_WINDOWS;
    }

    public static IRubyObject checkPipeCommand(ThreadContext context, IRubyObject filenameOrCommand) {
        RubyString filenameStr = filenameOrCommand.convertToString();
        ByteList filenameByteList = filenameStr.getByteList();
        int[] chlen = new int[]{0};
        if (EncodingUtils.encAscget(filenameByteList.getUnsafeBytes(), filenameByteList.getBegin(), filenameByteList.getBegin() + filenameByteList.getRealSize(), chlen, filenameByteList.getEncoding()) == 124) {
            return filenameStr.makeShared(context.runtime, chlen[0], filenameByteList.length() - 1);
        }
        return context.nil;
    }

    public static RubyFixnum spawn(ThreadContext context, IRubyObject[] argv2) {
        String[] errmsg = new String[]{null};
        ExecArg eargp = PopenExecutor.execargNew(context, argv2, context.nil, true, false);
        PopenExecutor.execargFixup(context, eargp);
        RubyString fail_str = eargp.use_shell ? eargp.command_name : eargp.command_name;
        PopenExecutor executor = new PopenExecutor();
        long pid2 = executor.spawnProcess(context, eargp, errmsg);
        if (pid2 == -1L) {
            if (errmsg[0] == null) {
                throw context.runtime.newErrnoFromErrno(executor.errno, ((Object)fail_str).toString());
            }
            throw context.runtime.newErrnoFromErrno(executor.errno, errmsg[0]);
        }
        return Convert.asFixnum(context, pid2);
    }

    public IRubyObject systemInternal(ThreadContext context, IRubyObject[] argv2, String[] errmsg) {
        long ret;
        Ruby runtime2 = context.runtime;
        ExecArg eargp = PopenExecutor.execargNew(context, argv2, context.nil, true, true);
        PopenExecutor.execargFixup(context, eargp);
        long pid2 = this.spawnProcess(context, eargp, errmsg);
        if (pid2 > 0L && (ret = RubyProcess.waitpid(context, pid2, 0)) == -1L) {
            throw runtime2.newErrnoFromInt(runtime2.getPosix().errno(), "Another thread waited the process started by system().");
        }
        if (pid2 < 0L) {
            if (eargp.exception) {
                int err = this.errno.intValue();
                RubyString command = eargp.command_name;
                throw runtime2.newErrnoFromInt(err, command.toString());
            }
            return context.nil;
        }
        int status2 = (int)((RubyProcess.RubyStatus)context.getLastExitStatus()).getStatus();
        if (status2 == 0) {
            return context.tru;
        }
        if (eargp.exception) {
            throw Error.runtimeError(context, RubyProcess.RubyStatus.pst_message("Command failed with", pid2, status2));
        }
        return context.fals;
    }

    long spawnProcess(ThreadContext context, ExecArg eargp, String[] errmsg) {
        long pid2;
        RubyString prog = eargp.use_shell ? eargp.command_name : eargp.command_name;
        ExecArg sarg = new ExecArg();
        if (eargp.chdirGiven) {
            String script = "cd '" + eargp.chdir_dir + "'; ";
            if (!PopenExecutor.searchForMetaChars(prog)) {
                script = script + "exec ";
            }
            prog = (RubyString)Create.dupString(context, prog).prepend(context, Create.newString(context, script));
            eargp.chdir_dir = null;
            eargp.chdirGiven = false;
        }
        if (this.execargRunOptions(context, eargp, sarg, errmsg) < 0) {
            return -1L;
        }
        if (prog == null || !eargp.use_shell) {
            // empty if block
        }
        long l = pid2 = eargp.use_shell ? this.procSpawnSh(context, prog.toString(), eargp) : this.procSpawnCmd(context, eargp.argv_str.argv, prog.toString(), eargp);
        if (pid2 == -1L) {
            Ruby runtime2 = context.runtime;
            context.setLastExitStatus(new RubyProcess.RubyStatus(runtime2, runtime2.getProcStatus(), 32512L, 0L));
            if (this.errno == null || this.errno == Errno.__UNKNOWN_CONSTANT__) {
                this.errno = Errno.valueOf((long)runtime2.getPosix().errno());
            }
        }
        this.execargRunOptions(context, sarg, null, errmsg);
        return pid2;
    }

    long procSpawnCmdInternal(ThreadContext context, String[] argv2, String prog, ExecArg eargp) {
        if (prog == null) {
            prog = argv2[0];
        }
        if ((prog = PopenExecutor.dlnFindExeR(context, prog, eargp.path_env)) == null) {
            this.errno = Errno.ENOENT;
            return -1L;
        }
        if (prog.isEmpty()) {
            this.errno = Errno.ENOENT;
            return -1L;
        }
        POSIX posix = context.runtime.getPosix();
        long status2 = posix.posix_spawnp(prog, eargp.fileActions, eargp.attributes, Arrays.asList(argv2), (Collection)(eargp.envp_str == null ? Collections.EMPTY_LIST : Arrays.asList(eargp.envp_str)));
        if (status2 == -1L) {
            if (posix.errno() == Errno.ENOEXEC.intValue()) {
                status2 = posix.posix_spawnp("/bin/sh", eargp.fileActions, eargp.attributes, Arrays.asList(argv2), (Collection)(eargp.envp_str == null ? Collections.EMPTY_LIST : Arrays.asList(eargp.envp_str)));
                if (status2 == -1L) {
                    this.errno = Errno.ENOEXEC;
                }
            } else {
                this.errno = Errno.valueOf((long)posix.errno());
            }
        }
        return status2;
    }

    long procSpawnCmd(ThreadContext context, String[] argv2, String prog, ExecArg eargp) {
        long pid2 = -1L;
        if (argv2.length > 0 && argv2[0] != null) {
            if (Platform.IS_WINDOWS) {
                long flags2 = 0L;
                if (!eargp.newPgroupGiven || eargp.newPgroupFlag) {
                    // empty if block
                }
            }
            pid2 = this.procSpawnCmdInternal(context, argv2, prog, eargp);
        }
        return pid2;
    }

    long procSpawnSh(ThreadContext context, String str, ExecArg eargp) {
        String shell = PopenExecutor.dlnFindExeR(context, "sh", eargp.path_env);
        POSIX posix = context.runtime.getPosix();
        long status2 = posix.posix_spawnp(shell != null ? shell : "/bin/sh", eargp.fileActions, eargp.attributes, Arrays.asList("sh", "-c", str), (Collection)(eargp.envp_str == null ? Collections.EMPTY_LIST : Arrays.asList(eargp.envp_str)));
        if (status2 == -1L) {
            this.errno = Errno.valueOf((long)posix.errno());
        }
        return status2;
    }

    public static IRubyObject pipeOpen(ThreadContext context, IRubyObject prog, String modestr, int fmode, IOEncodable convconfig) {
        IRubyObject[] argv2 = new IRubyObject[]{prog};
        ExecArg execArg = null;
        if (!PopenExecutor.isPopenFork(context, (RubyString)prog)) {
            execArg = PopenExecutor.execargNew(context, argv2, context.nil, true, false);
        }
        return new PopenExecutor().pipeOpen(context, execArg, modestr, fmode, convconfig);
    }

    public static IRubyObject popen(ThreadContext context, IRubyObject[] argv2, RubyClass klass, Block block) {
        ExecArg eargp;
        IRubyObject pname;
        Ruby runtime2 = context.runtime;
        IRubyObject opt = context.nil;
        IRubyObject env = context.nil;
        API.ModeAndPermission pmode = new API.ModeAndPermission(null, null);
        int[] oflags_p = new int[]{0};
        int[] fmode_p = new int[]{0};
        IOEncodable.ConvConfig convconfig = new IOEncodable.ConvConfig();
        int argc = argv2.length;
        if (argc > 1 && !(opt = TypeConverter.checkHashType(runtime2, argv2[argc - 1])).isNil()) {
            --argc;
        }
        if (argc > 1 && !(env = TypeConverter.checkHashType(runtime2, argv2[0])).isNil()) {
            argv2 = Arrays.copyOfRange(argv2, 1, --argc + 1);
        }
        switch (argc) {
            case 2: {
                EncodingUtils.vmode(pmode, argv2[1]);
            }
            case 1: {
                pname = argv2[0];
                break;
            }
            default: {
                int ex = opt.isNil() ? 0 : 1;
                Arity.raiseArgumentError(context, argc + ex, 1 + ex, 2 + ex);
                return null;
            }
        }
        IRubyObject tmp = TypeConverter.checkArrayType(runtime2, pname);
        if (!tmp.isNil()) {
            tmp = ((RubyArray)tmp).aryDup();
            eargp = PopenExecutor.execargNew(context, ((RubyArray)tmp).toJavaArray(context), opt, false, false);
            ((RubyArray)tmp).clear();
        } else {
            pname = pname.convertToString();
            eargp = null;
            if (!PopenExecutor.isPopenFork(context, (RubyString)pname)) {
                IRubyObject[] pname_p = new IRubyObject[]{pname};
                eargp = PopenExecutor.execargNew(context, pname_p, opt, true, false);
                pname = pname_p[0];
            }
        }
        if (eargp != null) {
            if (!opt.isNil()) {
                opt = PopenExecutor.execargExtractOptions(context, eargp, (RubyHash)opt);
            }
            if (!env.isNil()) {
                PopenExecutor.execargSetenv(context, eargp, env);
            }
        }
        EncodingUtils.extractModeEncoding(context, (IOEncodable)convconfig, pmode, opt, oflags_p, fmode_p);
        String modestr = OpenFile.ioOflagsModestr(context, oflags_p[0]);
        RubyIO port = new PopenExecutor().pipeOpen(context, eargp, modestr, fmode_p[0], convconfig);
        ((RubyBasicObject)port).setMetaClass(klass);
        return RubyIO.ensureYieldClose(context, port, block);
    }

    static void execargSetenv(ThreadContext context, ExecArg eargp, IRubyObject env) {
        eargp.env_modification = !env.isNil() ? PopenExecutor.checkExecEnv(context, (RubyHash)env, eargp) : null;
    }

    public static RubyArray checkExecEnv(ThreadContext context, RubyHash hash2, final ExecArg pathArg) {
        RubyArray<?> env = Create.newArray(context);
        hash2.visitAll(context, new RubyHash.VisitorWithState<RubyArray>(){

            @Override
            public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, RubyArray state2) {
                RubyString keyString = Check.checkEmbeddedNulls(context, key2).export(context);
                String k = keyString.toString();
                if (k.indexOf(61) != -1) {
                    throw Error.argumentError(context, "environment name contains a equal : " + k);
                }
                if (!value2.isNil()) {
                    value2 = Check.checkEmbeddedNulls(context, value2);
                }
                if (!value2.isNil()) {
                    value2 = ((RubyString)value2).export(context);
                }
                if (k.equalsIgnoreCase("PATH")) {
                    pathArg.path_env = value2;
                }
                state2.push(context, Create.newArray(context, (IRubyObject)keyString, value2));
            }
        }, env);
        return env;
    }

    static IRubyObject execargExtractOptions(ThreadContext context, ExecArg eargp, RubyHash opthash) {
        return PopenExecutor.handleOptionsCommon(context, eargp, opthash, false);
    }

    static void checkExecOptions(ThreadContext context, RubyHash opthash, ExecArg eargp) {
        PopenExecutor.handleOptionsCommon(context, eargp, opthash, true);
    }

    static IRubyObject handleOptionsCommon(ThreadContext context, ExecArg eargp, RubyHash opthash, boolean raise2) {
        if (opthash.isEmpty()) {
            return null;
        }
        IRubyObject nonopts = null;
        for (Map.Entry entry : opthash.directEntrySet()) {
            IRubyObject val;
            IRubyObject key2 = (IRubyObject)entry.getKey();
            if (PopenExecutor.execargAddopt(context, eargp, key2, val = (IRubyObject)entry.getValue()) == 0) continue;
            if (raise2) {
                if (key2 instanceof RubySymbol) {
                    switch (key2.toString()) {
                        case "gid": {
                            throw context.runtime.newNotImplementedError("popen does not support :gid option in JRuby");
                        }
                        case "uid": {
                            throw context.runtime.newNotImplementedError("popen does not support :uid option in JRuby");
                        }
                    }
                    throw Error.argumentError(context, "wrong exec option symbol: " + String.valueOf(key2));
                }
                throw Error.argumentError(context, "wrong exec option: " + String.valueOf(key2));
            }
            if (nonopts == null) {
                nonopts = Create.newHash(context);
            }
            ((RubyHash)nonopts).op_aset(context, key2, val);
        }
        return nonopts != null ? nonopts : context.nil;
    }

    static boolean isPopenFork(ThreadContext context, RubyString prog) {
        if (prog.size() == 1 && prog.getByteList().get(0) == 45) {
            throw context.runtime.newNotImplementedError("fork() function is unimplemented on JRuby");
        }
        return false;
    }

    private long DO_SPAWN(ThreadContext context, ExecArg eargp, String cmd, String[] args2, String[] envp) {
        if (eargp.use_shell) {
            return this.procSpawnSh(context, eargp, cmd, envp);
        }
        if (cmd == null || cmd.isEmpty()) {
            this.errno = Errno.ENOENT;
            return -1L;
        }
        long ret = context.runtime.getPosix().posix_spawnp(cmd, eargp.fileActions, eargp.attributes, args2 == null ? Collections.EMPTY_LIST : Arrays.asList(args2), envp == null ? Collections.EMPTY_LIST : Arrays.asList(envp));
        if (ret == -1L) {
            this.errno = Errno.valueOf((long)context.runtime.getPosix().errno());
        }
        return ret;
    }

    private long procSpawnSh(ThreadContext context, ExecArg eargp, String str, String[] envp) {
        int s2;
        char[] sChars = str.toCharArray();
        for (s2 = 0; s2 < sChars.length && (sChars[s2] == ' ' || sChars[s2] == '\t' || sChars[s2] == '\n'); ++s2) {
        }
        if (s2 >= sChars.length) {
            this.errno = Errno.ENOENT;
            return -1L;
        }
        if (Platform.IS_WINDOWS) {
            return -1L;
        }
        long ret = context.runtime.getPosix().posix_spawnp("/bin/sh", eargp.fileActions, eargp.attributes, Arrays.asList("sh", "-c", str), envp == null ? Collections.EMPTY_LIST : Arrays.asList(envp));
        if (ret == -1L) {
            this.errno = Errno.valueOf((long)context.runtime.getPosix().errno());
        }
        return ret;
    }

    private static String[] ARGVSTR2ARGV(byte[][] argv_str) {
        String[] argv2 = new String[argv_str.length];
        for (int i2 = 0; i2 < argv_str.length; ++i2) {
            if (argv_str[i2] == null) continue;
            argv2[i2] = new String(argv_str[i2]);
        }
        return argv2;
    }

    private RubyIO pipeOpen(ThreadContext context, ExecArg eargp, String modestr, int fmode, IOEncodable convconfig) {
        int fd;
        long pid2;
        Ruby runtime2 = context.runtime;
        RubyString prog = eargp != null ? (eargp.use_shell ? eargp.command_name : eargp.command_name) : null;
        PosixShim posix = new PosixShim(runtime2);
        Errno e = null;
        String[] args2 = null;
        String[] envp = null;
        ExecArg sargp = new ExecArg();
        int write_fd = -1;
        Object cmd = null;
        if (prog != null) {
            cmd = Check.checkEmbeddedNulls(context, prog).toString();
        }
        if (eargp.chdirGiven) {
            cmd = "cd '" + eargp.chdir_dir + "'; " + (String)cmd;
            eargp.chdir_dir = null;
            eargp.chdirGiven = false;
        }
        if (eargp != null && !eargp.use_shell) {
            args2 = eargp.argv_str.argv;
        }
        int[] pair = new int[]{-1, -1};
        int[] writePair = new int[]{-1, -1};
        switch (fmode & 3) {
            case 3: {
                if (API.newPipe(context, writePair) == -1) {
                    throw runtime2.newErrnoFromErrno(posix.getErrno(), ((Object)prog).toString());
                }
                if (API.newPipe(context, pair) == -1) {
                    e = posix.getErrno();
                    runtime2.getPosix().close(writePair[1]);
                    runtime2.getPosix().close(writePair[0]);
                    posix.setErrno(e);
                    throw runtime2.newErrnoFromErrno(posix.getErrno(), ((Object)prog).toString());
                }
                if (eargp == null) break;
                this.prepareStdioRedirects(context, pair, writePair, eargp);
                break;
            }
            case 1: {
                if (API.newPipe(context, pair) == -1) {
                    throw runtime2.newErrnoFromErrno(posix.getErrno(), ((Object)prog).toString());
                }
                if (eargp == null) break;
                this.prepareStdioRedirects(context, pair, null, eargp);
                break;
            }
            case 2: {
                if (API.newPipe(context, pair) == -1) {
                    throw runtime2.newErrnoFromErrno(posix.getErrno(), ((Object)prog).toString());
                }
                if (eargp == null) break;
                this.prepareStdioRedirects(context, null, pair, eargp);
                break;
            }
            default: {
                throw runtime2.newSystemCallError(((Object)prog).toString());
            }
        }
        if (eargp != null) {
            try {
                PopenExecutor.execargFixup(context, eargp);
            }
            catch (RaiseException re) {
                if (writePair[0] != -1) {
                    runtime2.getPosix().close(writePair[0]);
                }
                if (writePair[1] != -1) {
                    runtime2.getPosix().close(writePair[1]);
                }
                if (pair[0] != -1) {
                    runtime2.getPosix().close(pair[0]);
                }
                if (pair[1] != -1) {
                    runtime2.getPosix().close(pair[1]);
                }
                throw re;
            }
            this.execargRunOptions(context, eargp, sargp, null);
            if (eargp.envp_str != null) {
                envp = eargp.envp_str;
            }
            block12: while ((pid2 = this.DO_SPAWN(context, eargp, (String)cmd, args2, envp)) == -1L) {
                e = this.errno;
                switch (e) {
                    case EAGAIN: 
                    case EWOULDBLOCK: {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException re) {}
                        continue block12;
                    }
                }
            }
            if (eargp != null) {
                this.execargRunOptions(context, sargp, null, null);
            }
        } else {
            throw runtime2.newNotImplementedError("spawn without exec args (probably a bug)");
        }
        if (pid2 == -1L) {
            runtime2.getPosix().close(pair[1]);
            runtime2.getPosix().close(pair[0]);
            if ((fmode & 3) == 3) {
                runtime2.getPosix().close(pair[1]);
                runtime2.getPosix().close(pair[0]);
            }
            this.errno = e;
            throw runtime2.newErrnoFromErrno(this.errno, ((Object)prog).toString());
        }
        if ((fmode & 1) != 0 && (fmode & 2) != 0) {
            runtime2.getPosix().close(pair[1]);
            fd = pair[0];
            runtime2.getPosix().close(writePair[0]);
            write_fd = writePair[1];
        } else if ((fmode & 1) != 0) {
            runtime2.getPosix().close(pair[1]);
            fd = pair[0];
        } else {
            runtime2.getPosix().close(pair[0]);
            fd = pair[1];
        }
        RubyClass IO = Access.ioClass(context);
        RubyIO port = (RubyIO)IO.allocate(context);
        OpenFile fptr = port.MakeOpenFile();
        fptr.setChannel((Channel)new NativeDeviceChannel(fd));
        fptr.setMode(fmode | 0x28);
        if (convconfig != null) {
            fptr.encs.copy(convconfig);
            if (Platform.IS_WINDOWS && (fptr.encs.ecflags & EncodingUtils.ECONV_DEFAULT_NEWLINE_DECORATOR) != 0) {
                fptr.encs.ecflags |= 0x100;
            }
        } else {
            if (fptr.NEED_NEWLINE_DECORATOR_ON_READ()) {
                fptr.encs.ecflags |= 0x100;
            }
            if (EncodingUtils.TEXTMODE_NEWLINE_DECORATOR_ON_WRITE != 0 && fptr.NEED_NEWLINE_DECORATOR_ON_WRITE()) {
                fptr.encs.ecflags |= EncodingUtils.TEXTMODE_NEWLINE_DECORATOR_ON_WRITE;
            }
        }
        long finalPid = pid2;
        fptr.setPid(pid2);
        fptr.setProcess(new POSIXProcess(runtime2, finalPid));
        if (write_fd != -1) {
            IRubyObject write_port = IO.allocate(context);
            OpenFile write_fptr = ((RubyIO)write_port).MakeOpenFile();
            write_fptr.setChannel((Channel)new NativeDeviceChannel(write_fd));
            write_fptr.setMode(fmode & 0xFFFFFFFE | 8 | 0x20);
            fptr.setMode(fptr.getMode() & 0xFFFFFFFD);
            fptr.tiedIOForWriting = (RubyIO)write_port;
            port.setInstanceVariable("@tied_io_for_writing", write_port);
        }
        return port;
    }

    private void prepareStdioRedirects(ThreadContext context, int[] readPipe, int[] writePipe, ExecArg eargp) {
        if (readPipe != null) {
            int readPipeWriteFD = readPipe[1];
            eargp.fd_dup2 = PopenExecutor.checkExecRedirect1(context, eargp.fd_dup2, Convert.asFixnum(context, 1), Convert.asFixnum(context, readPipeWriteFD));
            int readPipeReadFD = readPipe[0];
            eargp.fileActions.add(SpawnFileAction.close((int)readPipeReadFD));
        }
        if (writePipe != null) {
            int writePipeReadFD = writePipe[0];
            eargp.fd_dup2 = PopenExecutor.checkExecRedirect1(context, eargp.fd_dup2, Convert.asFixnum(context, 0), Convert.asFixnum(context, writePipeReadFD));
            int writePipeWriteFD = writePipe[1];
            eargp.fileActions.add(SpawnFileAction.close((int)writePipeWriteFD));
        }
    }

    static int run_exec_pgroup(ThreadContext context, ExecArg eargp, ExecArg sargp, String[] errmsg) {
        int ret = 0;
        long pgroup = eargp.pgroup_pgid;
        if (pgroup == -1L) {
            return ret;
        }
        eargp.attributes.add(SpawnAttribute.pgroup((long)pgroup));
        eargp.attributes.add(SpawnAttribute.flags((short)2));
        return ret;
    }

    static int run_exec_rlimit(Ruby runtime2, RubyArray ary, ExecArg sargp, String[] errmsg) {
        throw runtime2.newNotImplementedError("changing rlimit in child is not supported");
    }

    static void saveEnv(ThreadContext context, Ruby runtime2, ExecArg sargp) {
    }

    static int run_exec_dup2(ThreadContext context, RubyArray ary, ExecArg eargp, ExecArg sargp, String[] errmsg) {
        int i2;
        int extra_fd = -1;
        run_exec_dup2_fd_pair[] pairs = eargp.dup2_tmpbuf;
        int n = ary.size();
        for (i2 = 0; i2 < n; ++i2) {
            Object elt = ary.eltOk(i2);
            pairs[i2].oldfd = Convert.toInt(context, ((RubyArray)elt).eltOk(1L));
            pairs[i2].newfd = Convert.toInt(context, ((RubyArray)elt).eltOk(0L));
            pairs[i2].older_index = -1;
        }
        if (sargp == null) {
            Arrays.sort(pairs, intcmp);
        } else {
            Arrays.sort(pairs, intrcmp);
        }
        for (i2 = 0; i2 < n; ++i2) {
            int found;
            int newfd = pairs[i2].newfd;
            run_exec_dup2_fd_pair key2 = new run_exec_dup2_fd_pair();
            key2.oldfd = newfd;
            pairs[i2].num_newer = 0;
            if (found < 0) continue;
            for (found = Arrays.binarySearch(pairs, key2, intcmp); found > 0 && pairs[found - 1].oldfd == newfd; --found) {
            }
            while (found < n && pairs[found].oldfd == newfd) {
                ++pairs[i2].num_newer;
                pairs[found].older_index = i2;
                ++found;
            }
        }
        for (i2 = 0; i2 < n; ++i2) {
            int j = i2;
            while (j != -1 && pairs[j].oldfd != -1 && pairs[j].num_newer == 0) {
                if (PopenExecutor.saveRedirectFd(context, pairs[j].newfd, sargp, errmsg) < 0) {
                    return -1;
                }
                PopenExecutor.redirectDup2(context, eargp, pairs[j].oldfd, pairs[j].newfd);
                pairs[j].oldfd = -1;
                j = pairs[j].older_index;
                if (j == -1) continue;
                --pairs[j].num_newer;
            }
        }
        POSIX posix = context.runtime.getPosix();
        for (i2 = 0; i2 < n; ++i2) {
            if (pairs[i2].oldfd == -1) continue;
            if (pairs[i2].oldfd == pairs[i2].newfd) {
                int fd = pairs[i2].oldfd;
                int ret = posix.fcntl(fd, Fcntl.F_GETFD);
                if (ret == -1) {
                    if (errmsg != null) {
                        errmsg[0] = "fcntl(F_GETFD)";
                    }
                    return -1;
                }
                if ((ret & 1) != 0) {
                    ret &= 0xFFFFFFFE;
                    if ((ret = posix.fcntlInt(fd, Fcntl.F_SETFD, ret)) == -1) {
                        if (errmsg != null) {
                            errmsg[0] = "fcntl(F_SETFD)";
                        }
                        return -1;
                    }
                }
                pairs[i2].oldfd = -1;
                continue;
            }
            if (extra_fd == -1) {
                extra_fd = PopenExecutor.redirectDup(context, pairs[i2].oldfd);
                if (extra_fd == -1) {
                    if (errmsg != null) {
                        errmsg[0] = "dup";
                    }
                    return -1;
                }
            } else {
                PopenExecutor.redirectDup2(context, eargp, pairs[i2].oldfd, extra_fd);
            }
            pairs[i2].oldfd = extra_fd;
            int j = pairs[i2].older_index;
            pairs[i2].older_index = -1;
            while (j != -1) {
                PopenExecutor.redirectDup2(context, eargp, pairs[j].oldfd, pairs[j].newfd);
                pairs[j].oldfd = -1;
                j = pairs[j].older_index;
            }
        }
        if (extra_fd != -1) {
            PopenExecutor.redirectClose(eargp, extra_fd);
        }
        return 0;
    }

    static int redirectDup(ThreadContext context, int oldfd) {
        POSIX posix = context.runtime.getPosix();
        int ret = posix.dup(oldfd);
        int flags2 = posix.fcntl(ret, Fcntl.F_GETFD);
        posix.fcntlInt(ret, Fcntl.F_SETFD, flags2 | 1);
        return ret;
    }

    static int redirectCloexecDup(ThreadContext context, int oldfd) {
        int ret = PopenExecutor.redirectDup(context, oldfd);
        POSIX posix = context.runtime.getPosix();
        int flags2 = posix.fcntl(ret, Fcntl.F_GETFD);
        posix.fcntlInt(ret, Fcntl.F_SETFD, flags2 | 1);
        return ret;
    }

    static int redirectClearCloexec(ThreadContext context, int oldfd) {
        int flags2 = context.runtime.getPosix().fcntl(oldfd, Fcntl.F_GETFD);
        context.runtime.getPosix().fcntlInt(oldfd, Fcntl.F_SETFD, flags2 & 0xFFFFFFFE);
        return oldfd;
    }

    static void redirectDup2(ThreadContext context, ExecArg eargp, int oldfd, int newfd) {
        if (oldfd == newfd) {
            PopenExecutor.redirectClearCloexec(context, oldfd);
        }
        eargp.fileActions.add(SpawnFileAction.dup((int)oldfd, (int)newfd));
    }

    static void redirectClose(ExecArg eargp, int fd) {
        eargp.fileActions.add(SpawnFileAction.close((int)fd));
    }

    static void redirectOpen(ExecArg eargp, int fd, String pathname2, int flags2, int perm) {
        eargp.fileActions.add(SpawnFileAction.open((String)pathname2, (int)fd, (int)flags2, (int)perm));
    }

    static int saveRedirectFd(ThreadContext context, int fd, ExecArg sargp, String[] errmsg) {
        return 0;
    }

    int execargRunOptions(ThreadContext context, ExecArg eargp, ExecArg sargp, String[] errmsg) {
        RubyArray env;
        if (sargp != null) {
            sargp.redirect_fds = context.nil;
        }
        if (eargp.pgroupGiven && PopenExecutor.run_exec_pgroup(context, eargp, sargp, errmsg) == -1) {
            return -1;
        }
        IRubyObject obj = eargp.rlimit_limits;
        if (obj != null) {
            throw context.runtime.newNotImplementedError("setting rlimit in child is unsupported");
        }
        boolean clearEnv = false;
        if (eargp.unsetenvOthersGiven && eargp.unsetenvOthersDo) {
            clearEnv = true;
        }
        if ((env = eargp.env_modification) != null) {
            eargp.envp_str = ShellLauncher.getModifiedEnv(context, (Collection)env, clearEnv);
        }
        if (eargp.umaskGiven) {
            throw context.runtime.newNotImplementedError("setting umask in child is unsupported");
        }
        obj = eargp.fd_dup2;
        if (obj != null && PopenExecutor.run_exec_dup2(context, (RubyArray)obj, eargp, sargp, errmsg) == -1) {
            return -1;
        }
        obj = eargp.fd_close;
        if (obj != null) {
            PopenExecutor.run_exec_close(context, (RubyArray)obj, eargp);
        }
        if ((obj = eargp.fd_dup2_child) != null) {
            PopenExecutor.run_exec_dup2_child(context, (RubyArray)obj, eargp);
        }
        if (eargp.chdirGiven) {
            throw new RuntimeException("BUG: chdir not supported in posix_spawn; should have been made into chdir");
        }
        if (eargp.gidGiven) {
            throw context.runtime.newNotImplementedError("setgid in the child is not supported");
        }
        if (eargp.uidGiven) {
            throw context.runtime.newNotImplementedError("setuid in the child is not supported");
        }
        return 0;
    }

    static void run_exec_close(ThreadContext context, RubyArray ary, ExecArg eargp) {
        for (int i2 = 0; i2 < ary.size(); ++i2) {
            RubyArray elt = (RubyArray)ary.eltOk(i2);
            int fd = Convert.toInt(context, elt.eltOk(0L));
            PopenExecutor.redirectClose(eargp, fd);
        }
    }

    static void run_exec_open(ThreadContext context, RubyArray<RubyArray> ary, ExecArg eargp) {
        for (int i2 = 0; i2 < ary.size(); ++i2) {
            RubyArray elt = ary.eltOk(i2);
            int fd = Convert.toInt(context, elt.eltOk(0L));
            RubyArray param = (RubyArray)elt.eltOk(1L);
            Object vpath = param.eltOk(0L);
            int flags2 = Convert.toInt(context, param.eltOk(1L));
            int perm = Convert.toInt(context, param.eltOk(2L));
            IRubyObject fd2v = param.entry(3);
            if (fd2v.isNil()) {
                PopenExecutor.redirectOpen(eargp, fd, vpath.toString(), flags2, perm);
                param.store(3L, (IRubyObject)elt.eltOk(0L));
                continue;
            }
            PopenExecutor.redirectDup2(context, eargp, Convert.toInt(context, fd2v), fd);
        }
    }

    static void run_exec_dup2_child(ThreadContext context, RubyArray ary, ExecArg eargp) {
        for (int i2 = 0; i2 < ary.size(); ++i2) {
            RubyArray elt = (RubyArray)ary.eltOk(i2);
            int newfd = Convert.toInt(context, elt.eltOk(0L));
            int oldfd = Convert.toInt(context, elt.eltOk(1L));
            PopenExecutor.redirectDup2(context, eargp, oldfd, newfd);
        }
    }

    static int runExecDup2TmpbufSize(int n) {
        return n;
    }

    static void execargFixup(ThreadContext context, ExecArg eargp) {
        PopenExecutor.execargParentStart(context, eargp);
    }

    static void execargParentStart(ThreadContext context, ExecArg eargp) {
        PopenExecutor.execargParentStart1(context, eargp);
    }

    static void execargParentStart1(ThreadContext context, ExecArg eargp) {
        IRubyObject envtbl;
        eargp.redirect_fds = PopenExecutor.checkExecFds(context, eargp);
        RubyArray ary = eargp.fd_open;
        if (ary != null) {
            PopenExecutor.run_exec_open(context, ary, eargp);
        }
        if ((ary = eargp.fd_dup2) != null) {
            int len = PopenExecutor.runExecDup2TmpbufSize(ary.size());
            run_exec_dup2_fd_pair[] tmpbuf = new run_exec_dup2_fd_pair[len];
            for (int i2 = 0; i2 < tmpbuf.length; ++i2) {
                tmpbuf[i2] = new run_exec_dup2_fd_pair();
            }
            eargp.dup2_tmpbuf = tmpbuf;
        }
        boolean unsetenv_others = eargp.unsetenvOthersGiven && eargp.unsetenvOthersDo;
        RubyArray envopts = eargp.env_modification;
        if (unsetenv_others || envopts != null) {
            if (unsetenv_others) {
                envtbl = Create.newHash(context);
            } else {
                envtbl = Access.objectClass(context).getConstant(context, "ENV");
                envtbl = TypeConverter.convertToType(envtbl, Access.hashClass(context), "to_hash").dup();
            }
            if (envopts != null) {
                IRubyObject stenv = envtbl;
                for (long i3 = 0L; i3 < (long)envopts.size(); ++i3) {
                    Object pair = envopts.eltOk(i3);
                    Object key2 = ((RubyArray)pair).eltOk(0L);
                    Object val = ((RubyArray)pair).eltOk(1L);
                    if (val.isNil()) {
                        Object stkey = key2;
                        ((RubyHash)stenv).fastDelete((IRubyObject)stkey);
                        continue;
                    }
                    ((RubyHash)stenv).op_aset(context, (IRubyObject)key2, (IRubyObject)val);
                }
            }
        } else {
            envtbl = Access.objectClass(context).getConstant(context, "ENV");
            envtbl = TypeConverter.convertToType(envtbl, Access.hashClass(context), "to_hash");
        }
        PopenExecutor.buildEnvp(context, eargp, envtbl);
    }

    static ChannelFD open_func(Ruby runtime2, RubyIO.Sysopen data2) {
        ChannelFD ret = PopenExecutor.parentRedirectOpen(runtime2, data2);
        data2.errno = Errno.valueOf((long)runtime2.getPosix().errno());
        return ret;
    }

    static ChannelFD parentRedirectOpen(Ruby runtime2, RubyIO.Sysopen data2) {
        return RubyIO.cloexecOpen(runtime2, data2);
    }

    static void parentRedirectClose(Ruby runtime2, int fd) {
        if (fd > 2) {
            runtime2.getPosix().close(fd);
        }
    }

    private static void buildEnvp(ThreadContext context, ExecArg eargp, RubyHash envTable) {
        String[] envp_str = new String[envTable.size()];
        ArrayList<String> envp_buf = new ArrayList<String>(envTable.size());
        int i2 = 0;
        for (Map.Entry entry : envTable.directEntrySet()) {
            envp_str[i2] = String.valueOf(Check.checkEmbeddedNulls(context, (IRubyObject)entry.getKey())) + "=" + String.valueOf(Check.checkEmbeddedNulls(context, (IRubyObject)entry.getValue()));
            envp_buf.add(envp_str[i2]);
            ++i2;
        }
        eargp.envp_str = envp_str;
        eargp.envp_buf = envp_buf;
    }

    static int checkExecFds1(ThreadContext context, ExecArg eargp, RubyHash h, int maxhint, IRubyObject ary) {
        if (ary != null) {
            for (long i2 = 0L; i2 < (long)((RubyArray)ary).size(); ++i2) {
                Object elt = ((RubyArray)ary).eltOk(i2);
                int fd = Convert.toInt(context, ((RubyArray)elt).eltOk(0L));
                if (h.fastARef(Convert.asFixnum(context, fd)) != null) {
                    throw Error.argumentError(context, "fd " + fd + " specified twice");
                }
                if (ary == eargp.fd_open || ary == eargp.fd_dup2) {
                    h.op_aset(context, Convert.asFixnum(context, fd), context.tru);
                } else if (ary == eargp.fd_dup2_child) {
                    h.op_aset(context, Convert.asFixnum(context, fd), (IRubyObject)((RubyArray)elt).eltOk(1L));
                } else {
                    h.op_aset(context, Convert.asFixnum(context, fd), Convert.asFixnum(context, -1));
                }
                if (maxhint < fd) {
                    maxhint = fd;
                }
                if (ary != eargp.fd_dup2 && ary != eargp.fd_dup2_child || maxhint >= (fd = Convert.toInt(context, ((RubyArray)elt).eltOk(1L)))) continue;
                maxhint = fd;
            }
        }
        return maxhint;
    }

    static IRubyObject checkExecFds(ThreadContext context, ExecArg eargp) {
        RubyHash h = Create.newHash(context);
        int maxhint = -1;
        maxhint = PopenExecutor.checkExecFds1(context, eargp, h, maxhint, eargp.fd_dup2);
        maxhint = PopenExecutor.checkExecFds1(context, eargp, h, maxhint, eargp.fd_close);
        maxhint = PopenExecutor.checkExecFds1(context, eargp, h, maxhint, eargp.fd_open);
        maxhint = PopenExecutor.checkExecFds1(context, eargp, h, maxhint, eargp.fd_dup2_child);
        if (eargp.fd_dup2_child != null) {
            RubyArray ary = eargp.fd_dup2_child;
            for (int i2 = 0; i2 < ary.size(); ++i2) {
                IRubyObject val2;
                RubyFixnum fixnum;
                int oldfd;
                RubyArray elt = (RubyArray)ary.eltOk(i2);
                int newfd = Convert.toInt(context, elt.eltOk(0L));
                int lastfd = oldfd = Convert.toInt(context, elt.eltOk(1L));
                IRubyObject val = h.fastARef(Convert.asFixnum(context, lastfd));
                long depth = 0L;
                while (val instanceof RubyFixnum && 0 <= (fixnum = (RubyFixnum)val).asInt(context)) {
                    lastfd = fixnum.asInt(context);
                    val = h.fastARef(val);
                    if ((long)ary.size() < depth) {
                        throw Error.argumentError(context, "cyclic child fd redirection from " + oldfd);
                    }
                    ++depth;
                }
                if (val != context.tru) {
                    throw Error.argumentError(context, "child fd " + oldfd + " is not redirected");
                }
                if (oldfd == lastfd) continue;
                elt.store(1L, Convert.asFixnum(context, lastfd));
                h.op_aset(context, Convert.asFixnum(context, newfd), Convert.asFixnum(context, lastfd));
                val = Convert.asFixnum(context, oldfd);
                while ((val2 = h.fastARef(val)) instanceof RubyFixnum) {
                    h.op_aset(context, val, Convert.asFixnum(context, lastfd));
                    val = val2;
                }
            }
        }
        eargp.close_others_maxhint = maxhint;
        return h;
    }

    static int execargAddopt(ThreadContext context, ExecArg eargp, IRubyObject key2, IRubyObject val) {
        boolean rtype = false;
        boolean redirect = false;
        switch (key2.getType().getClassIndex()) {
            case SYMBOL: {
                String id2 = key2.toString();
                if (id2.equals("pgroup")) {
                    long pgroup;
                    if (eargp.pgroupGiven) {
                        throw Error.argumentError(context, "pgroup option specified twice");
                    }
                    if (val == null || !val.isTrue()) {
                        pgroup = -1L;
                    } else if (val == context.tru) {
                        pgroup = 0L;
                    } else {
                        pgroup = Convert.toLong(context, val);
                        if (pgroup < 0L) {
                            throw Error.argumentError(context, "negative process group symbol : " + pgroup);
                        }
                    }
                    eargp.pgroupGiven = true;
                    eargp.pgroup_pgid = pgroup;
                    break;
                }
                if (Platform.IS_WINDOWS && id2.equals("new_pgroup")) {
                    if (eargp.newPgroupGiven) {
                        throw Error.argumentError(context, "new_pgroup option specified twice");
                    }
                    eargp.newPgroupGiven = true;
                    eargp.newPgroupFlag = val.isTrue();
                    break;
                }
                if (id2.equals("unsetenv_others")) {
                    if (eargp.unsetenvOthersGiven) {
                        throw Error.argumentError(context, "unsetenv_others option specified twice");
                    }
                    eargp.unsetenvOthersGiven = true;
                    if (val.isTrue()) {
                        eargp.unsetenvOthersDo = true;
                        break;
                    }
                    eargp.unsetenvOthersDo = false;
                    break;
                }
                if (id2.equals("chdir")) {
                    if (eargp.chdirGiven) {
                        throw Error.argumentError(context, "chdir option specified twice");
                    }
                    RubyString valTmp = RubyFile.get_path(context, val);
                    eargp.chdirGiven = true;
                    eargp.chdir_dir = valTmp.toString();
                    break;
                }
                if (id2.equals("umask")) {
                    int cmask = Convert.toInt(context, val);
                    if (eargp.umaskGiven) {
                        throw Error.argumentError(context, "umask option specified twice");
                    }
                    eargp.umaskGiven = true;
                    eargp.umask_mask = cmask;
                    break;
                }
                if (id2.equals("close_others")) {
                    if (eargp.closeOthersGiven) {
                        throw Error.argumentError(context, "close_others option specified twice");
                    }
                    eargp.closeOthersGiven = true;
                    if (!val.isNil()) {
                        eargp.closeOthersDo = true;
                        break;
                    }
                    eargp.closeOthersDo = false;
                    break;
                }
                if (id2.equals("in")) {
                    key2 = RubyFixnum.zero(context.runtime);
                    PopenExecutor.checkExecRedirect(context, key2, val, eargp);
                    break;
                }
                if (id2.equals("out")) {
                    key2 = RubyFixnum.one(context.runtime);
                    PopenExecutor.checkExecRedirect(context, key2, val, eargp);
                    break;
                }
                if (id2.equals("err")) {
                    key2 = RubyFixnum.two(context.runtime);
                    PopenExecutor.checkExecRedirect(context, key2, val, eargp);
                    break;
                }
                if (id2.equals("uid")) {
                    // empty if block
                }
                if (id2.equals("gid")) {
                    // empty if block
                }
                if (id2.equals("exception")) {
                    if (eargp.exception_given) {
                        throw Error.argumentError(context, "exception option specified twice");
                    }
                    eargp.exception_given = true;
                    eargp.exception = val.isTrue();
                    break;
                }
                return 1;
            }
            case INTEGER: {
                if (!(key2 instanceof RubyFixnum)) {
                    return 1;
                }
            }
            case FILE: 
            case IO: 
            case ARRAY: {
                PopenExecutor.checkExecRedirect(context, key2, val, eargp);
                break;
            }
            default: {
                return 1;
            }
        }
        return 0;
    }

    static void checkExecRedirect(ThreadContext context, IRubyObject key2, IRubyObject val, ExecArg eargp) {
        switch (val.getMetaClass().getRealClass().getClassIndex()) {
            case SYMBOL: {
                String id2 = val.toString();
                if (id2.equals("close")) {
                    IRubyObject param = context.nil;
                    eargp.fd_close = PopenExecutor.checkExecRedirect1(context, eargp.fd_close, key2, param);
                    break;
                }
                if (id2.equals("in")) {
                    RubyFixnum param = Convert.asFixnum(context, 0);
                    eargp.fd_dup2 = PopenExecutor.checkExecRedirect1(context, eargp.fd_dup2, key2, param);
                    break;
                }
                if (id2.equals("out")) {
                    RubyFixnum param = Convert.asFixnum(context, 1);
                    eargp.fd_dup2 = PopenExecutor.checkExecRedirect1(context, eargp.fd_dup2, key2, param);
                    break;
                }
                if (id2.equals("err")) {
                    RubyFixnum param = Convert.asFixnum(context, 2);
                    eargp.fd_dup2 = PopenExecutor.checkExecRedirect1(context, eargp.fd_dup2, key2, param);
                    break;
                }
                throw Error.argumentError(context, "wrong exec redirect symbol: " + id2);
            }
            case FILE: 
            case IO: {
                val = PopenExecutor.checkExecRedirectFd(context, val, false);
            }
            case INTEGER: {
                if (val instanceof RubyFixnum) {
                    IRubyObject param = val;
                    eargp.fd_dup2 = PopenExecutor.checkExecRedirect1(context, eargp.fd_dup2, key2, param);
                    break;
                }
                PopenExecutor.checkExecRedirectDefault(context, key2, val, eargp);
                break;
            }
            case ARRAY: {
                Object path2 = ((RubyArray)val).eltOk(0L);
                if (((RubyArray)val).size() == 2 && path2 instanceof RubySymbol && path2.toString().equals("child")) {
                    IRubyObject param = PopenExecutor.checkExecRedirectFd(context, ((RubyArray)val).eltOk(1L), false);
                    eargp.fd_dup2_child = PopenExecutor.checkExecRedirect1(context, eargp.fd_dup2_child, key2, param);
                    break;
                }
                path2 = RubyFile.get_path(context, path2);
                Object flags2 = ((RubyArray)val).eltOk(1L);
                int intFlags = flags2.isNil() ? OpenFlags.O_RDONLY.intValue() : (flags2 instanceof RubyString ? OpenFile.ioModestrOflags(context, flags2.toString()) : Convert.toInt(context, flags2));
                flags2 = Convert.asFixnum(context, intFlags);
                IRubyObject perm = ((RubyArray)val).entry(2);
                perm = perm.isNil() ? Convert.asFixnum(context, 420) : perm.convertToInteger();
                RubyArray<?> param = Create.newArray(context, (IRubyObject)Create.dupString(context, (RubyString)path2).export(context), flags2, perm);
                eargp.fd_open = PopenExecutor.checkExecRedirect1(context, eargp.fd_open, key2, param);
                break;
            }
            case STRING: {
                RubyFixnum flags3;
                RubyFixnum k;
                RubyString path3 = RubyFile.get_path(context, val);
                if (key2 instanceof RubyIO) {
                    key2 = PopenExecutor.checkExecRedirectFd(context, key2, true);
                }
                if (key2 instanceof RubyFixnum && ((k = (RubyFixnum)key2).asInt(context) == 1 || k.asInt(context) == 2)) {
                    flags3 = Convert.asFixnum(context, OpenFlags.O_WRONLY.intValue() | OpenFlags.O_CREAT.intValue() | OpenFlags.O_TRUNC.intValue());
                } else if (key2 instanceof RubyArray) {
                    RubyArray keyAry = (RubyArray)key2;
                    boolean allOut = true;
                    for (int i2 = 0; i2 < keyAry.size(); ++i2) {
                        Object v = keyAry.eltOk(i2);
                        IRubyObject fd = PopenExecutor.checkExecRedirectFd(context, v, true);
                        if (Convert.toInt(context, fd) == 1 || Convert.toInt(context, fd) == 2) continue;
                        allOut = false;
                        break;
                    }
                    flags3 = allOut ? Convert.asFixnum(context, OpenFlags.O_WRONLY.intValue() | OpenFlags.O_CREAT.intValue() | OpenFlags.O_TRUNC.intValue()) : Convert.asFixnum(context, OpenFlags.O_RDONLY.intValue());
                } else {
                    flags3 = Convert.asFixnum(context, OpenFlags.O_RDONLY.intValue());
                }
                RubyFixnum perm = Convert.asFixnum(context, 420);
                RubyArray<?> param = Create.newArray(context, (IRubyObject)Create.dupString(context, path3).export(context), (IRubyObject)flags3, (IRubyObject)perm);
                eargp.fd_open = PopenExecutor.checkExecRedirect1(context, eargp.fd_open, key2, param);
                break;
            }
            default: {
                PopenExecutor.checkExecRedirectDefault(context, key2, val, eargp);
            }
        }
    }

    private static void checkExecRedirectDefault(ThreadContext context, IRubyObject key2, IRubyObject val, ExecArg eargp) {
        IRubyObject tmp = val;
        if (!(val = TypeConverter.ioCheckIO(context.runtime, tmp)).isNil()) {
            IRubyObject param = val = PopenExecutor.checkExecRedirectFd(context, val, false);
            eargp.fd_dup2 = PopenExecutor.checkExecRedirect1(context, eargp.fd_dup2, key2, param);
            return;
        }
        throw Error.argumentError(context, "wrong exec redirect action");
    }

    static IRubyObject checkExecRedirectFd(ThreadContext context, IRubyObject v, boolean iskey) {
        int fd;
        if (v instanceof RubyFixnum) {
            fd = Convert.toInt(context, v);
        } else if (v instanceof RubySymbol) {
            fd = switch (v.toString()) {
                case "in" -> 0;
                case "out" -> 1;
                case "err" -> 2;
                default -> throw Error.argumentError(context, "wrong exec redirect");
            };
        } else {
            IRubyObject tmp = TypeConverter.convertToTypeWithCheck(v, Access.ioClass(context), "to_io");
            if (!tmp.isNil()) {
                OpenFile fptr = ((RubyIO)tmp).getOpenFileChecked();
                if (fptr.tiedIOForWriting != null) {
                    throw Error.argumentError(context, "duplex IO redirection");
                }
                fd = fptr.fd().bestFileno();
            } else {
                throw Error.argumentError(context, "wrong exec redirect");
            }
        }
        if (fd < 0) {
            throw Error.argumentError(context, "negative file descriptor");
        }
        if (Platform.IS_WINDOWS && fd >= 3 && iskey) {
            throw Error.argumentError(context, "wrong file descriptor (" + fd + ")");
        }
        return Convert.asFixnum(context, fd);
    }

    static RubyArray checkExecRedirect1(ThreadContext context, RubyArray ary, IRubyObject key2, IRubyObject param) {
        if (ary == null) {
            ary = Create.newArray(context);
        }
        if (key2 instanceof RubyArray) {
            RubyArray k = (RubyArray)key2;
            for (int i2 = 0; i2 < k.size(); ++i2) {
                IRubyObject fd = PopenExecutor.checkExecRedirectFd(context, k.eltOk(i2), !param.isNil());
                ary.push(context, Create.newArray(context, fd, param));
            }
        } else {
            IRubyObject fd = PopenExecutor.checkExecRedirectFd(context, key2, !param.isNil());
            ary.push(context, Create.newArray(context, fd, param));
        }
        return ary;
    }

    public static ExecArg execargNew(ThreadContext context, IRubyObject[] argv2, IRubyObject optForChdir, boolean accept_shell, boolean allow_exc_opt) {
        ExecArg eargp = new ExecArg();
        PopenExecutor.execargInit(context, argv2, optForChdir, accept_shell, eargp, allow_exc_opt);
        return eargp;
    }

    private static RubyString execargInit(ThreadContext context, IRubyObject[] argv2, IRubyObject optForChdir, boolean accept_shell, ExecArg eargp, boolean allow_exc_opt) {
        IRubyObject chdir2;
        RubyHash optHash;
        IRubyObject[] env_opt = new IRubyObject[]{context.nil, context.nil};
        IRubyObject[][] argv_p = new IRubyObject[][]{argv2};
        IRubyObject exception2 = context.nil;
        RubyString prog = PopenExecutor.execGetargs(context, argv_p, accept_shell, env_opt);
        IRubyObject opt = env_opt[1];
        RubySymbol exceptionSym = Convert.asSymbol(context, "exception");
        if (allow_exc_opt && !opt.isNil() && (optHash = (RubyHash)opt).has_key_p(context, exceptionSym).isTrue()) {
            optHash = optHash.dupFast(context);
            exception2 = optHash.delete(context, exceptionSym);
        }
        RubySymbol chdirSym = Convert.asSymbol(context, "chdir");
        if (!optForChdir.isNil() && (chdir2 = ((RubyHash)optForChdir).delete(chdirSym)) != null) {
            eargp.chdirGiven = true;
            eargp.chdir_dir = chdir2.convertToString().toString();
        }
        PopenExecutor.execFillarg(context, prog, argv_p[0], env_opt[0], env_opt[1], eargp);
        if (exception2.isTrue()) {
            eargp.exception = true;
        }
        RubyString ret = eargp.use_shell ? eargp.command_name : eargp.command_name;
        return ret;
    }

    private static RubyString execGetargs(ThreadContext context, IRubyObject[][] argv_p, boolean accept_shell, IRubyObject[] env_opt) {
        IRubyObject hash2;
        int beg = 0;
        int end2 = argv_p[0].length;
        if (end2 >= 1 && !(hash2 = TypeConverter.checkHashType(context.runtime, argv_p[0][end2 - 1])).isNil()) {
            env_opt[1] = hash2;
            --end2;
        }
        if (end2 >= 1 && !(hash2 = TypeConverter.checkHashType(context.runtime, argv_p[0][0])).isNil()) {
            env_opt[0] = hash2;
            ++beg;
        }
        argv_p[0] = Arrays.copyOfRange(argv_p[0], beg, end2);
        RubyString prog = PopenExecutor.checkArgv(context, argv_p[0]);
        if (prog == null) {
            prog = (RubyString)argv_p[0][0];
            if (accept_shell && end2 - beg == 1) {
                argv_p[0] = IRubyObject.NULL_ARRAY;
            }
        }
        return prog;
    }

    public static RubyString checkArgv(ThreadContext context, IRubyObject[] argv2) {
        Arity.checkArgumentCount(context, argv2, 1, Integer.MAX_VALUE);
        RubyString prog = null;
        IRubyObject tmp = TypeConverter.checkArrayType(context.runtime, argv2[0]);
        if (!tmp.isNil()) {
            RubyArray arrayArg = (RubyArray)tmp;
            if (arrayArg.size() != 2) {
                throw Error.argumentError(context, "wrong first argument");
            }
            prog = arrayArg.eltOk(0L).convertToString();
            argv2[0] = arrayArg.eltOk(1L);
            Check.checkEmbeddedNulls(context, prog);
            prog = Create.dupString(context, prog);
            prog.setFrozen(true);
        }
        for (int i2 = 0; i2 < argv2.length; ++i2) {
            argv2[i2] = argv2[i2].convertToString().newFrozen();
            Check.checkEmbeddedNulls(context, argv2[i2]);
        }
        return prog;
    }

    private static void execFillarg(ThreadContext context, RubyString prog, IRubyObject[] argv2, IRubyObject env, IRubyObject opthash, ExecArg eargp) {
        String virtualCWD;
        Ruby runtime2 = context.runtime;
        int argc = argv2.length;
        if (!opthash.isNil()) {
            PopenExecutor.checkExecOptions(context, (RubyHash)opthash, eargp);
        }
        if (!(virtualCWD = runtime2.getCurrentDirectory()).equals(runtime2.getPosix().getcwd())) {
            String arg2 = prog.toString();
            if ((arg2 = ShellLauncher.changeDirInsideJar(runtime2, arg2)) != null) {
                prog = Create.newString(context, arg2);
            } else if (!virtualCWD.startsWith("uri:classloader:") && !eargp.chdirGiven) {
                eargp.chdirGiven = true;
                eargp.chdir_dir = virtualCWD;
            }
        }
        if (eargp.chdirGiven && argc > 1) {
            IRubyObject[] newArgv = new IRubyObject[argc += 5];
            newArgv[0] = Create.newString(context, "sh");
            newArgv[1] = Create.newString(context, "-c");
            newArgv[2] = Create.newString(context, "cd -- \"$1\"; shift; exec \"$@\"");
            newArgv[3] = Create.newString(context, "sh");
            newArgv[4] = Create.newString(context, eargp.chdir_dir);
            System.arraycopy(argv2, 0, newArgv, 5, argv2.length);
            argv2 = newArgv;
            prog = Create.newString(context, "/bin/sh");
            eargp.chdirGiven = false;
        }
        if (!env.isNil()) {
            eargp.env_modification = PopenExecutor.checkExecEnv(context, (RubyHash)env, eargp);
        }
        prog = prog.export(context);
        eargp.use_shell = argc == 0 || eargp.chdirGiven;
        eargp.command_name = eargp.use_shell ? prog : prog;
        if (!Platform.IS_WINDOWS && eargp.use_shell) {
            boolean has_meta = PopenExecutor.searchForMetaChars(prog);
            if (!has_meta && !eargp.chdirGiven) {
                eargp.use_shell = false;
            }
            if (!eargp.use_shell) {
                ArrayList<byte[]> argv_buf = new ArrayList<byte[]>();
                byte[] pBytes = prog.getByteList().unsafeBytes();
                int p2 = prog.getByteList().begin();
                int pEnd = prog.getByteList().length() + p2;
                while (p2 < pEnd) {
                    while (p2 < pEnd && (pBytes[p2] == 32 || pBytes[p2] == 9)) {
                        ++p2;
                    }
                    if (p2 >= pEnd) continue;
                    int w = p2;
                    while (p2 < pEnd && pBytes[p2] != 32 && pBytes[p2] != 9) {
                        ++p2;
                    }
                    argv_buf.add(Arrays.copyOfRange(pBytes, w, p2));
                    eargp.argv_buf = argv_buf;
                }
                RubyString rubyString = eargp.command_name = argv_buf.size() > 0 ? RubyString.newStringNoCopy(context.runtime, (byte[])argv_buf.get(0)) : Create.newEmptyString(context);
            }
        }
        if (!eargp.use_shell) {
            String abspath = PopenExecutor.dlnFindExeR(context, eargp.command_name.toString(), eargp.path_env);
            eargp.command_abspath = abspath != null ? Check.checkEmbeddedNulls(context, Create.newString(context, abspath)) : null;
        }
        if (!eargp.use_shell && eargp.argv_buf == null) {
            ArrayList<byte[]> argv_buf = new ArrayList<byte[]>(argc);
            for (int i2 = 0; i2 < argc; ++i2) {
                IRubyObject arg3 = argv2[i2];
                RubyString argStr = Check.checkEmbeddedNulls(context, arg3);
                argStr = argStr.export(context);
                argv_buf.add(argStr.getBytes());
            }
            eargp.argv_buf = argv_buf;
        }
        if (!eargp.use_shell) {
            ArgvStr argv_str = new ArgvStr();
            argv_str.argv = new String[eargp.argv_buf.size()];
            int i3 = 0;
            for (byte[] bytes2 : eargp.argv_buf) {
                argv_str.argv[i3++] = new String(bytes2);
            }
            eargp.argv_str = argv_str;
        }
    }

    private static boolean searchForMetaChars(RubyString prog) {
        int p2;
        boolean has_meta = false;
        ByteList first2 = new ByteList(DUMMY_ARRAY, false);
        ByteList progByteList = prog.getByteList();
        byte[] pBytes = progByteList.unsafeBytes();
        for (p2 = 0; p2 < progByteList.length(); ++p2) {
            if (progByteList.get(p2) == 32 || progByteList.get(p2) == 9) {
                if (first2.unsafeBytes() != DUMMY_ARRAY && first2.length() == 0) {
                    first2.setRealSize(p2 - first2.begin());
                }
            } else if (first2.unsafeBytes() == DUMMY_ARRAY) {
                first2.setUnsafeBytes(pBytes);
                first2.setBegin(p2 + progByteList.begin());
            }
            if (!has_meta && "*?{}[]<>()~&|\\$;'`\"\n#".indexOf(progByteList.get(p2) & 0xFF) != -1) {
                has_meta = true;
            }
            if (first2.length() == 0) {
                if (progByteList.get(p2) == 61) {
                    has_meta = true;
                } else if (progByteList.get(p2) == 47) {
                    first2.setRealSize(256);
                }
            }
            if (has_meta) break;
        }
        if (!has_meta && first2.getUnsafeBytes() != DUMMY_ARRAY) {
            int length2 = first2.length();
            if (length2 == 0) {
                first2.setRealSize(p2 - first2.getBegin());
            }
            if (length2 > 0 && length2 <= 8 && Arrays.binarySearch(posix_sh_cmds, first2.toString(), StringComparator.INSTANCE) >= 0) {
                has_meta = true;
            }
        }
        return has_meta;
    }

    private static String dlnFindExeR(ThreadContext context, String fname, IRubyObject path2) {
        File exePath = ShellLauncher.findPathExecutable(context, fname, path2);
        return exePath != null ? exePath.getAbsolutePath() : null;
    }

    public static class ExecArg {
        boolean use_shell;
        RubyString command_name;
        RubyString command_abspath;
        ArgvStr argv_str;
        List<byte[]> argv_buf;
        IRubyObject redirect_fds;
        String[] envp_str;
        List<String> envp_buf;
        run_exec_dup2_fd_pair[] dup2_tmpbuf;
        long pgroup_pgid = -1L;
        IRubyObject rlimit_limits;
        int umask_mask;
        int uid;
        int gid;
        RubyArray fd_dup2;
        RubyArray fd_close;
        RubyArray<RubyArray> fd_open;
        RubyArray fd_dup2_child;
        int close_others_maxhint;
        RubyArray env_modification;
        String chdir_dir;
        final List<SpawnFileAction> fileActions = new ArrayList<SpawnFileAction>();
        final List<SpawnAttribute> attributes = new ArrayList<SpawnAttribute>();
        IRubyObject path_env;
        boolean exception_given;
        boolean exception;
        boolean pgroupGiven;
        boolean umaskGiven;
        boolean unsetenvOthersGiven;
        boolean unsetenvOthersDo;
        boolean closeOthersGiven;
        boolean closeOthersDo;
        boolean chdirGiven;
        boolean newPgroupGiven;
        boolean newPgroupFlag;
        boolean uidGiven;
        boolean gidGiven;
    }

    private static class ArgvStr {
        String[] argv;

        private ArgvStr() {
        }
    }

    private static class run_exec_dup2_fd_pair {
        int oldfd;
        int newfd;
        int older_index;
        int num_newer;

        private run_exec_dup2_fd_pair() {
        }
    }

    private static final class StringComparator
    implements Comparator<String> {
        static final StringComparator INSTANCE = new StringComparator();

        private StringComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            int ret = o1.compareTo(o2);
            if (ret == 0 && o1.length() > o2.length()) {
                return -1;
            }
            return ret;
        }
    }

    private static class PopenArg {
        ExecArg eargp;
        int modef;

        private PopenArg() {
        }
    }
}

