/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyString;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.StringSupport;

public class ConvertBytes {
    private final Ruby runtime;
    private final ByteList str;
    private int beg;
    private int end;
    private byte[] data;
    private int base;
    private final boolean badcheck;
    private static final byte[] ZERO_BYTES;
    private static final byte[][] MIN_VALUE_BYTES;
    private static final byte[] MIN_VALUE_BYTES_RADIX_10;
    public static final int MIN_VALUE_BYTES_RADIX_10_LENGTH;
    private static final byte[] LOWER_DIGITS;
    private static final byte[] UPPER_DIGITS;
    private static final byte[] conv_digit;
    private static final boolean[] digit;
    private static final boolean[] space;
    private static final boolean[] spaceOrUnderscore;
    private static final ByteList[] BYTE_RANGE_STRINGS;

    public ConvertBytes(Ruby runtime2, ByteList str, int base, boolean badcheck) {
        this.runtime = runtime2;
        this.str = str;
        this.beg = str.getBegin();
        this.data = str.getUnsafeBytes();
        this.end = this.beg + str.getRealSize();
        this.badcheck = badcheck;
        this.base = base;
    }

    ConvertBytes(Ruby runtime2, ByteList str, int off, int end2, int base, boolean badcheck) {
        this.runtime = runtime2;
        this.str = str;
        this.beg = off + str.getBegin();
        this.data = str.getUnsafeBytes();
        this.end = str.getBegin() + end2;
        this.badcheck = badcheck;
        this.base = base;
    }

    @Deprecated
    public ConvertBytes(Ruby runtime2, ByteList str, int base, boolean badcheck, boolean is19) {
        this(runtime2, str, base, badcheck);
    }

    public static final byte[] intToBinaryBytes(int i2) {
        return ConvertBytes.intToUnsignedByteList(i2, 1, LOWER_DIGITS).bytes();
    }

    public static final byte[] intToOctalBytes(int i2) {
        return ConvertBytes.intToUnsignedByteList(i2, 3, LOWER_DIGITS).bytes();
    }

    public static final byte[] intToHexBytes(int i2) {
        return ConvertBytes.intToUnsignedByteList(i2, 4, LOWER_DIGITS).bytes();
    }

    public static final byte[] intToHexBytes(int i2, boolean upper) {
        return ConvertBytes.intToUnsignedByteList(i2, 4, upper ? UPPER_DIGITS : LOWER_DIGITS).bytes();
    }

    public static final ByteList intToBinaryByteList(int i2) {
        return new ByteList(ConvertBytes.intToBinaryBytes(i2));
    }

    public static final ByteList intToOctalByteList(int i2) {
        return new ByteList(ConvertBytes.intToOctalBytes(i2));
    }

    public static final ByteList intToHexByteList(int i2) {
        return new ByteList(ConvertBytes.intToHexBytes(i2));
    }

    public static final ByteList intToHexByteList(int i2, boolean upper) {
        return new ByteList(ConvertBytes.intToHexBytes(i2, upper));
    }

    public static final byte[] intToByteArray(int i2, int radix, boolean upper) {
        return ConvertBytes.longToByteArray(i2, radix, upper);
    }

    public static final byte[] intToCharBytes(int i2) {
        return ConvertBytes.longToByteList(i2, 10, LOWER_DIGITS).bytes();
    }

    public static final byte[] longToBinaryBytes(long i2) {
        return ConvertBytes.longToUnsignedByteList(i2, 1, LOWER_DIGITS).bytes();
    }

    public static final byte[] longToOctalBytes(long i2) {
        return ConvertBytes.longToUnsignedByteList(i2, 3, LOWER_DIGITS).bytes();
    }

    public static final byte[] longToHexBytes(long i2) {
        return ConvertBytes.longToUnsignedByteList(i2, 4, LOWER_DIGITS).bytes();
    }

    public static final byte[] longToHexBytes(long i2, boolean upper) {
        return ConvertBytes.longToUnsignedByteList(i2, 4, upper ? UPPER_DIGITS : LOWER_DIGITS).bytes();
    }

    public static final ByteList longToBinaryByteList(long i2) {
        return ConvertBytes.longToByteList(i2, 2, LOWER_DIGITS);
    }

    public static final ByteList longToOctalByteList(long i2) {
        return ConvertBytes.longToByteList(i2, 8, LOWER_DIGITS);
    }

    public static final ByteList longToHexByteList(long i2) {
        return ConvertBytes.longToByteList(i2, 16, LOWER_DIGITS);
    }

    public static final ByteList longToHexByteList(long i2, boolean upper) {
        return ConvertBytes.longToByteList(i2, 16, upper ? UPPER_DIGITS : LOWER_DIGITS);
    }

    public static final byte[] longToByteArray(long i2, int radix, boolean upper) {
        if (radix == 10) {
            return ConvertBytes.longToCharBytes(i2);
        }
        return ConvertBytes.longToByteList(i2, radix, upper ? UPPER_DIGITS : LOWER_DIGITS).bytes();
    }

    public static final ByteList longToByteList(long i2) {
        return ConvertBytes.longToByteListSimple(i2);
    }

    public static final ByteList longToByteList(long i2, int radix) {
        if (radix == 10) {
            return ConvertBytes.longToByteListSimple(i2);
        }
        return ConvertBytes.longToByteList(i2, radix, LOWER_DIGITS);
    }

    public static final ByteList longToByteListCached(long i2) {
        if (i2 >= -256L && i2 < 256L) {
            return ConvertBytes.byteToSharedByteList((short)i2);
        }
        return ConvertBytes.longToByteListSimple(i2);
    }

    public static final ByteList byteToSharedByteList(short i2) {
        assert (i2 >= -256 && i2 < 256) : "only -256 to 255 bytelists are cached";
        return BYTE_RANGE_STRINGS[i2 + 256];
    }

    public static final void longIntoString(RubyString string2, long i2) {
        ConvertBytes.longIntoStringSimple(string2, i2);
    }

    public static final ByteList longToByteList(long i2, int radix, byte[] digitmap) {
        boolean neg;
        if (i2 == 0L) {
            return new ByteList(ZERO_BYTES);
        }
        if (i2 == Long.MIN_VALUE) {
            return new ByteList(MIN_VALUE_BYTES[radix]);
        }
        boolean bl = neg = i2 < 0L;
        if (neg) {
            i2 = -i2;
        }
        int len = 64;
        byte[] buf = new byte[len];
        int pos2 = len;
        do {
            buf[--pos2] = digitmap[(int)(i2 % (long)radix)];
        } while ((i2 /= (long)radix) > 0L);
        if (neg) {
            buf[--pos2] = 45;
        }
        return new ByteList(buf, pos2, len - pos2);
    }

    public static final ByteList longToByteListSimple(long i2) {
        byte[] bytes2 = ConvertBytes.longToCharBytes(i2);
        return new ByteList(bytes2, false);
    }

    public static final byte[] longToCharBytes(long i2) {
        boolean neg;
        if (i2 == 0L) {
            return ZERO_BYTES;
        }
        if (i2 == Long.MIN_VALUE) {
            return MIN_VALUE_BYTES_RADIX_10;
        }
        boolean bl = neg = i2 < 0L;
        if (neg) {
            i2 = -i2;
        }
        int newSize = ConvertBytes.sizeWithDecimalString(i2, neg, 0);
        byte[] bytes2 = new byte[newSize];
        ConvertBytes.writeDecimalDigitsToArray(bytes2, i2, neg, 0, 0, newSize);
        return bytes2;
    }

    public static final void longIntoStringSimple(RubyString string2, long i2) {
        boolean neg;
        if (i2 == 0L) {
            string2.cat(48);
            return;
        }
        if (i2 == Long.MIN_VALUE) {
            string2.cat(MIN_VALUE_BYTES_RADIX_10, 0, MIN_VALUE_BYTES_RADIX_10.length, (Encoding)USASCIIEncoding.INSTANCE);
            return;
        }
        boolean bl = neg = i2 < 0L;
        if (neg) {
            i2 = -i2;
        }
        int baseSize = string2.size();
        int newSize = ConvertBytes.sizeWithDecimalString(i2, neg, baseSize);
        string2.resize(newSize);
        ByteList byteList = string2.getByteList();
        byte[] bytes2 = byteList.getUnsafeBytes();
        int beg = byteList.begin();
        ConvertBytes.writeDecimalDigitsToArray(bytes2, i2, neg, beg, baseSize, newSize);
    }

    private static int sizeWithDecimalString(long i2, boolean neg, int baseSize) {
        int count2 = 0;
        while (i2 > 9L) {
            i2 /= 10L;
            ++count2;
        }
        int newSize = baseSize + count2 + 1;
        if (neg) {
            ++newSize;
        }
        return newSize;
    }

    private static void writeDecimalDigitsToArray(byte[] bytes2, long i2, boolean negative, int begin2, int originalSize, int newSize) {
        int n = newSize - 1;
        while (i2 > 0L) {
            bytes2[begin2 + n] = ConvertBytes.decimalByteForDigit(i2);
            i2 /= 10L;
            --n;
        }
        if (negative) {
            bytes2[originalSize] = 45;
        }
    }

    private static byte decimalByteForDigit(long i2) {
        return (byte)(i2 % 10L + 48L);
    }

    private static final ByteList intToUnsignedByteList(int i2, int shift2, byte[] digitmap) {
        byte[] buf = new byte[32];
        int charPos = 32;
        int radix = 1 << shift2;
        long mask = radix - 1;
        do {
            buf[--charPos] = digitmap[(int)((long)i2 & mask)];
        } while ((i2 >>>= shift2) != 0);
        return new ByteList(buf, charPos, 32 - charPos, false);
    }

    private static final ByteList longToUnsignedByteList(long i2, int shift2, byte[] digitmap) {
        byte[] buf = new byte[64];
        int charPos = 64;
        int radix = 1 << shift2;
        long mask = radix - 1;
        do {
            buf[--charPos] = digitmap[(int)(i2 & mask)];
        } while ((i2 >>>= shift2) != 0L);
        return new ByteList(buf, charPos, 64 - charPos, false);
    }

    public static final byte[] twosComplementToBinaryBytes(byte[] in) {
        return ConvertBytes.twosComplementToUnsignedBytes(in, 1, false);
    }

    public static final byte[] twosComplementToOctalBytes(byte[] in) {
        return ConvertBytes.twosComplementToUnsignedBytes(in, 3, false);
    }

    public static final byte[] twosComplementToHexBytes(byte[] in, boolean upper) {
        return ConvertBytes.twosComplementToUnsignedBytes(in, 4, upper);
    }

    public static final byte[] twosComplementToUnsignedBytes(byte[] in, int shift2, boolean upper) {
        if (shift2 < 1 || shift2 > 4) {
            throw new IllegalArgumentException("shift value must be 1-4");
        }
        int ilen = in.length;
        int olen = (ilen * 8 + shift2 - 1) / shift2;
        byte[] out = new byte[olen];
        int mask = (1 << shift2) - 1;
        byte[] digits2 = upper ? UPPER_DIGITS : LOWER_DIGITS;
        int bitbuf = 0;
        int bitcnt = 0;
        int i2 = ilen;
        int o = olen;
        while (--o >= 0) {
            if (bitcnt < shift2) {
                bitbuf |= (in[--i2] & 0xFF) << bitcnt;
                bitcnt += 8;
            }
            out[o] = digits2[bitbuf & mask];
            bitbuf >>= shift2;
            bitcnt -= shift2;
        }
        return out;
    }

    public static IRubyObject byteListToInum(Ruby runtime2, ByteList str, int base, boolean badcheck, boolean exception2) {
        return new ConvertBytes(runtime2, str, base, badcheck).byteListToInum(exception2);
    }

    public static RubyInteger byteListToInum(Ruby runtime2, ByteList str, int base, boolean badcheck) {
        return (RubyInteger)ConvertBytes.byteListToInum(runtime2, str, base, badcheck, true);
    }

    public static RubyInteger byteListToInum(Ruby runtime2, ByteList str, int off, int end2, int base, boolean badcheck) {
        return (RubyInteger)new ConvertBytes(runtime2, str, off, end2, base, badcheck).byteListToInum(true);
    }

    public static byte[] bytesToUUIDBytes(byte[] randBytes, boolean upper) {
        ByteBuffer bytes2 = ByteBuffer.wrap(randBytes);
        long N0 = (long)bytes2.getInt() & 0xFFFFFFFFL;
        int n1 = bytes2.getShort() & 0xFFFF;
        int n2 = bytes2.getShort() & 0xFFFF;
        n2 = n2 & 0xFFF | 0x4000;
        int n3 = bytes2.getShort() & 0xFFFF;
        n3 = n3 & 0x3FFF | 0x8000;
        int n4 = bytes2.getShort() & 0xFFFF;
        long N5 = (long)bytes2.getInt() & 0xFFFFFFFFL;
        byte[] convert2 = upper ? UPPER_DIGITS : LOWER_DIGITS;
        return new byte[]{convert2[(int)(N0 >> 28 & 0xFL)], convert2[(int)(N0 >> 24 & 0xFL)], convert2[(int)(N0 >> 20 & 0xFL)], convert2[(int)(N0 >> 16 & 0xFL)], convert2[(int)(N0 >> 12 & 0xFL)], convert2[(int)(N0 >> 8 & 0xFL)], convert2[(int)(N0 >> 4 & 0xFL)], convert2[(int)(N0 & 0xFL)], 45, convert2[n1 >> 12 & 0xF], convert2[n1 >> 8 & 0xF], convert2[n1 >> 4 & 0xF], convert2[n1 & 0xF], 45, convert2[n2 >> 12 & 0xF], convert2[n2 >> 8 & 0xF], convert2[n2 >> 4 & 0xF], convert2[n2 & 0xF], 45, convert2[n3 >> 12 & 0xF], convert2[n3 >> 8 & 0xF], convert2[n3 >> 4 & 0xF], convert2[n3 & 0xF], 45, convert2[n4 >> 12 & 0xF], convert2[n4 >> 8 & 0xF], convert2[n4 >> 4 & 0xF], convert2[n4 & 0xF], convert2[(int)(N5 >> 28 & 0xFL)], convert2[(int)(N5 >> 24 & 0xFL)], convert2[(int)(N5 >> 20 & 0xFL)], convert2[(int)(N5 >> 16 & 0xFL)], convert2[(int)(N5 >> 12 & 0xFL)], convert2[(int)(N5 >> 8 & 0xFL)], convert2[(int)(N5 >> 4 & 0xFL)], convert2[(int)(N5 & 0xFL)]};
    }

    private byte convertDigit(byte c) {
        if (c < 0) {
            return -1;
        }
        return conv_digit[c];
    }

    private boolean isSpace(int str) {
        byte c;
        if (str == this.end || (c = this.data[str]) < 0) {
            return false;
        }
        return space[c];
    }

    private boolean getSign() {
        boolean sign2 = true;
        if (this.beg < this.end) {
            if (this.data[this.beg] == 43) {
                ++this.beg;
            } else if (this.data[this.beg] == 45) {
                ++this.beg;
                sign2 = false;
            }
        }
        return sign2;
    }

    private void ignoreLeadingWhitespace() {
        while (this.isSpace(this.beg)) {
            ++this.beg;
        }
    }

    private void figureOutBase() {
        if (this.base <= 0) {
            if (this.beg < this.end && this.data[this.beg] == 48) {
                if (this.beg + 1 < this.end) {
                    switch (this.data[this.beg + 1]) {
                        case 88: 
                        case 120: {
                            this.base = 16;
                            break;
                        }
                        case 66: 
                        case 98: {
                            this.base = 2;
                            break;
                        }
                        case 79: 
                        case 111: {
                            this.base = 8;
                            break;
                        }
                        case 68: 
                        case 100: {
                            this.base = 10;
                            break;
                        }
                        default: {
                            this.base = 8;
                            break;
                        }
                    }
                } else {
                    this.base = 8;
                }
            } else {
                this.base = this.base < -1 ? -this.base : 10;
            }
        }
    }

    private int calculateLength() {
        int len;
        int second2 = this.beg + 1 < this.end && this.data[this.beg] == 48 ? this.data[this.beg + 1] : 0;
        switch (this.base) {
            case 2: {
                len = 1;
                if (second2 != 98 && second2 != 66) break;
                this.beg += 2;
                break;
            }
            case 3: {
                len = 2;
                break;
            }
            case 8: {
                if (second2 == 111 || second2 == 79) {
                    this.beg += 2;
                }
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                len = 3;
                break;
            }
            case 10: {
                if (second2 == 100 || second2 == 68) {
                    this.beg += 2;
                }
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                len = 4;
                break;
            }
            case 16: {
                len = 4;
                if (second2 != 120 && second2 != 88) break;
                this.beg += 2;
                break;
            }
            default: {
                if (this.base < 2 || 36 < this.base) {
                    throw this.runtime.newArgumentError("illegal radix " + this.base);
                }
                len = this.base <= 32 ? 5 : 6;
            }
        }
        return len;
    }

    private void squeezeZeroes() {
        if (this.beg < this.end && this.data[this.beg] == 48) {
            byte c;
            ++this.beg;
            int us = 0;
            while (this.beg < this.end && ((c = this.data[this.beg]) == 48 || c == 95)) {
                if (c == 95) {
                    if (++us >= 2) {
                        break;
                    }
                } else {
                    us = 0;
                }
                ++this.beg;
            }
            if (this.beg == this.end || this.isSpace(this.beg)) {
                --this.beg;
            }
        }
    }

    private long stringToLong(int nptr, int[] endptr, int base) {
        if (base < 0 || base == 1 || base > 36) {
            return 0L;
        }
        int save = nptr;
        int s2 = nptr;
        boolean overflow = false;
        while (this.isSpace(s2)) {
            ++s2;
        }
        if (s2 != this.end) {
            byte c;
            boolean negative = false;
            if (this.data[s2] == 45) {
                negative = true;
                ++s2;
            } else if (this.data[s2] == 43) {
                negative = false;
                ++s2;
            }
            save = s2;
            long i2 = 0L;
            long cutoff = Long.MAX_VALUE / (long)base;
            long cutlim = Long.MAX_VALUE % (long)base;
            while (s2 < this.end && (c = this.convertDigit(this.data[s2])) != -1 && c < base) {
                ++s2;
                if (i2 > cutoff || i2 == cutoff && (long)c > cutlim) {
                    overflow = true;
                    continue;
                }
                i2 *= (long)base;
                i2 += (long)c;
            }
            if (s2 != save) {
                if (endptr != null) {
                    endptr[0] = s2;
                }
                if (overflow) {
                    throw new ERange(negative ? ERange.Kind.Underflow : ERange.Kind.Overflow);
                }
                if (negative) {
                    return -i2;
                }
                return i2;
            }
        }
        if (endptr != null) {
            endptr[0] = save - nptr >= 2 && (this.data[save - 1] == 120 || this.data[save - 1] == 88) && this.data[save - 2] == 48 ? save - 1 : nptr;
        }
        return 0L;
    }

    public IRubyObject byteListToInum(boolean exception2) {
        if (this.str == null) {
            if (this.badcheck) {
                if (!exception2) {
                    return this.runtime.getNil();
                }
                this.invalidString("Integer");
            }
            return RubyFixnum.zero(this.runtime);
        }
        this.ignoreLeadingWhitespace();
        boolean sign2 = this.getSign();
        if (this.beg < this.end && (this.data[this.beg] == 43 || this.data[this.beg] == 45)) {
            if (this.badcheck) {
                if (!exception2) {
                    return this.runtime.getNil();
                }
                this.invalidString("Integer");
            }
            return RubyFixnum.zero(this.runtime);
        }
        this.figureOutBase();
        int len = this.calculateLength();
        this.squeezeZeroes();
        int c = 0;
        if (this.beg < this.end) {
            c = this.data[this.beg];
        }
        if ((c = this.convertDigit((byte)c)) < 0 || c >= this.base) {
            if (this.badcheck) {
                if (!exception2) {
                    return this.runtime.getNil();
                }
                this.invalidString("Integer");
            }
            return RubyFixnum.zero(this.runtime);
        }
        len = this.base <= 10 ? (len *= this.trailingLength()) : (len *= this.end - this.beg);
        if (len < 63) {
            int[] endPlace = new int[]{this.beg};
            long val = this.stringToLong(this.beg, endPlace, this.base);
            if (endPlace[0] < this.end && this.data[endPlace[0]] == 95) {
                return this.bigParse(len, sign2, exception2);
            }
            if (this.badcheck) {
                if (endPlace[0] == this.beg) {
                    if (!exception2) {
                        return this.runtime.getNil();
                    }
                    this.invalidString("Integer");
                }
                while (this.isSpace(endPlace[0])) {
                    endPlace[0] = endPlace[0] + 1;
                }
                if (endPlace[0] < this.end) {
                    if (!exception2) {
                        return this.runtime.getNil();
                    }
                    this.invalidString("Integer");
                }
            }
            return sign2 ? this.runtime.newFixnum(val) : this.runtime.newFixnum(-val);
        }
        return this.bigParse(len, sign2, exception2);
    }

    private int trailingLength() {
        int newLen = 0;
        for (int i2 = this.beg; i2 < this.end; ++i2) {
            if (Character.isDigit(this.data[i2])) {
                ++newLen;
                continue;
            }
            return newLen;
        }
        return newLen;
    }

    private IRubyObject bigParse(int len, boolean sign2, boolean exception2) {
        BigInteger z;
        if (this.badcheck && this.beg < this.end && this.data[this.beg] == 95) {
            if (!exception2) {
                return this.runtime.getNil();
            }
            this.invalidString("Integer");
        }
        char[] result2 = new char[this.end - this.beg];
        int resultIndex = 0;
        int nondigit = -1;
        while (this.beg < this.end) {
            int c = this.data[this.beg++];
            char cx = (char)c;
            if (c == 95) {
                if (nondigit != -1) {
                    if (!this.badcheck) break;
                    if (!exception2) {
                        return this.runtime.getNil();
                    }
                    this.invalidString("Integer");
                    break;
                }
                nondigit = c;
                continue;
            }
            byte by = this.convertDigit((byte)c);
            c = by;
            if (by < 0 || c >= this.base) break;
            nondigit = -1;
            result2[resultIndex++] = cx;
        }
        if (resultIndex == 0) {
            return RubyFixnum.zero(this.runtime);
        }
        int tmpStr = this.beg;
        if (this.badcheck) {
            if (this.str.getBegin() + 1 < tmpStr && this.data[tmpStr - 1] == 95) {
                this.invalidString("Integer");
            }
            while (tmpStr < this.end && Character.isWhitespace(this.data[tmpStr])) {
                ++tmpStr;
            }
            if (tmpStr < this.end) {
                if (!exception2) {
                    return this.runtime.getNil();
                }
                this.invalidString("Integer");
            }
        }
        String s2 = new String(result2, 0, resultIndex);
        BigInteger bigInteger = z = this.base == 10 ? this.stringToBig(s2) : new BigInteger(s2, this.base);
        if (!sign2) {
            z = z.negate();
        }
        if (this.badcheck) {
            if (this.str.getBegin() + 1 < this.beg && this.data[this.beg - 1] == 95) {
                if (!exception2) {
                    return this.runtime.getNil();
                }
                this.invalidString("Integer");
            }
            while (this.beg < this.end && this.isSpace(this.beg)) {
                ++this.beg;
            }
            if (this.beg < this.end) {
                if (!exception2) {
                    return this.runtime.getNil();
                }
                this.invalidString("Integer");
            }
        }
        return RubyBignum.bignorm(this.runtime, z);
    }

    private BigInteger stringToBig(String str) {
        int nDigits;
        int size2 = (str = StringSupport.delete(str, '_')).length();
        if (size2 < (nDigits = 512)) {
            nDigits = size2;
        }
        int j = size2 - 1;
        int i2 = j - nDigits + 1;
        BigInteger[] digits2 = new BigInteger[j / nDigits + 1];
        int z = 0;
        while (j >= 0) {
            digits2[z] = new BigInteger(str.substring(i2, j + 1).trim());
            j = i2 - 1;
            if ((i2 = j - nDigits + 1) < 0) {
                i2 = 0;
            }
            ++z;
        }
        BigInteger b10x = BigInteger.TEN.pow(nDigits);
        int n = digits2.length;
        while (n > 1) {
            i2 = 0;
            j = 0;
            while (i2 < n / 2) {
                digits2[i2] = digits2[j].add(digits2[j + 1].multiply(b10x));
                ++i2;
                j += 2;
            }
            if (j == n - 1) {
                digits2[i2] = digits2[j];
            }
            n = ++i2;
            b10x = b10x.multiply(b10x);
        }
        return digits2[0];
    }

    private void invalidString(String type2) {
        IRubyObject s2 = RubyString.newString(this.runtime, this.str).inspect(this.runtime.getCurrentContext());
        throw this.runtime.newArgumentError("invalid value for " + type2 + "(): " + String.valueOf(s2));
    }

    static {
        int c;
        int i2;
        ZERO_BYTES = new byte[]{48};
        MIN_VALUE_BYTES = new byte[37][];
        for (i2 = 2; i2 <= 36; ++i2) {
            ConvertBytes.MIN_VALUE_BYTES[i2] = ByteList.plain(Long.toString(Long.MIN_VALUE, i2));
        }
        MIN_VALUE_BYTES_RADIX_10 = MIN_VALUE_BYTES[10];
        MIN_VALUE_BYTES_RADIX_10_LENGTH = MIN_VALUE_BYTES_RADIX_10.length;
        LOWER_DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
        UPPER_DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90};
        conv_digit = new byte[128];
        digit = new boolean[128];
        space = new boolean[128];
        spaceOrUnderscore = new boolean[128];
        Arrays.fill(conv_digit, (byte)-1);
        Arrays.fill(digit, false);
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            ConvertBytes.conv_digit[c] = (byte)(c - 48);
            ConvertBytes.digit[c] = true;
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            ConvertBytes.conv_digit[c] = (byte)(c - 97 + 10);
        }
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            ConvertBytes.conv_digit[c] = (byte)(c - 65 + 10);
        }
        Arrays.fill(space, false);
        ConvertBytes.space[9] = true;
        ConvertBytes.space[10] = true;
        ConvertBytes.space[11] = true;
        ConvertBytes.space[12] = true;
        ConvertBytes.space[13] = true;
        ConvertBytes.space[32] = true;
        Arrays.fill(spaceOrUnderscore, false);
        ConvertBytes.spaceOrUnderscore[9] = true;
        ConvertBytes.spaceOrUnderscore[10] = true;
        ConvertBytes.spaceOrUnderscore[11] = true;
        ConvertBytes.spaceOrUnderscore[12] = true;
        ConvertBytes.spaceOrUnderscore[13] = true;
        ConvertBytes.spaceOrUnderscore[32] = true;
        ConvertBytes.spaceOrUnderscore[95] = true;
        BYTE_RANGE_STRINGS = new ByteList[512];
        for (i2 = -256; i2 < 256; ++i2) {
            ByteList bytes2;
            ConvertBytes.BYTE_RANGE_STRINGS[i2 + 256] = bytes2 = new ByteList(ConvertBytes.longToCharBytes(i2), (Encoding)USASCIIEncoding.INSTANCE, false);
        }
    }

    public static class ERange
    extends RuntimeException {
        private final Kind kind;

        public ERange(Kind kind) {
            this.kind = kind;
        }

        public Kind getKind() {
            return this.kind;
        }

        public static enum Kind {
            Overflow,
            Underflow;

        }
    }
}

