/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets.simple;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyHash;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.targets.ClassData;
import org.jruby.ir.targets.DynamicValueCompiler;
import org.jruby.ir.targets.IRBytecodeAdapter;
import org.jruby.ir.targets.JVM;
import org.jruby.ir.targets.indy.DRegexpObjectSite;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;
import org.jruby.util.RegexpOptions;
import org.objectweb.asm.Label;

public class NormalDynamicValueCompiler
implements DynamicValueCompiler {
    private final IRBytecodeAdapter compiler;

    public NormalDynamicValueCompiler(IRBytecodeAdapter compiler) {
        this.compiler = compiler;
    }

    @Override
    public void pushDRegexp(Runnable callback, RegexpOptions options2, int arity2) {
        if (arity2 > 250) {
            throw new NotCompilableException("dynamic regexp has more than 250 elements");
        }
        String cacheField = null;
        Label done = null;
        if (options2.isOnce()) {
            cacheField = "dregexp" + this.compiler.getClassData().cacheFieldCount.getAndIncrement();
            done = new Label();
            this.compiler.adapter.getClassVisitor().visitField(10, cacheField, CodegenUtils.ci(RubyRegexp.class), null, null).visitEnd();
            this.compiler.adapter.getstatic(this.compiler.getClassData().clsName, cacheField, CodegenUtils.ci(RubyRegexp.class));
            this.compiler.adapter.dup();
            this.compiler.adapter.ifnonnull(done);
            this.compiler.adapter.pop();
        }
        callback.run();
        this.compiler.adapter.invokedynamic("dregexp", CodegenUtils.sig(RubyRegexp.class, CodegenUtils.params(ThreadContext.class, RubyString.class, arity2)), DRegexpObjectSite.BOOTSTRAP, options2.toEmbeddedOptions());
        if (done != null) {
            this.compiler.adapter.dup();
            this.compiler.adapter.putstatic(this.compiler.getClassData().clsName, cacheField, CodegenUtils.ci(RubyRegexp.class));
            this.compiler.adapter.label(done);
        }
    }

    @Override
    public void array(int length2) {
        if (length2 > 250) {
            throw new NotCompilableException("literal array has more than 250 elements");
        }
        if (length2 <= 2) {
            this.compiler.invokeIRHelper("newArray", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, length2)));
            return;
        }
        String incomingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, length2));
        String methodName = "array:" + length2;
        ClassData classData = this.compiler.getClassData();
        if (!classData.arrayMethodsDefined.containsKey(length2)) {
            SkinnyMethodAdapter adapter2 = new SkinnyMethodAdapter(this.compiler.adapter.getClassVisitor(), 4106, methodName, incomingSig, null, null);
            adapter2.aload(0);
            adapter2.getfield(CodegenUtils.p(ThreadContext.class), "runtime", CodegenUtils.ci(Ruby.class));
            IRBytecodeAdapter.buildArrayFromLocals(adapter2, 1, length2);
            adapter2.invokevirtual(CodegenUtils.p(Ruby.class), "newArrayNoCopy", CodegenUtils.sig(RubyArray.class, IRubyObject[].class));
            adapter2.areturn();
            adapter2.end();
            classData.arrayMethodsDefined.put(length2, null);
        }
        this.compiler.adapter.invokestatic(classData.clsName, methodName, incomingSig);
    }

    @Override
    public void hash(int length2) {
        if (length2 > 125) {
            throw new NotCompilableException("literal hash has more than 125 pairs");
        }
        String incomingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, length2 * 2));
        String methodName = "hash:" + length2;
        ClassData classData = this.compiler.getClassData();
        if (!classData.hashMethodsDefined.containsKey(length2)) {
            SkinnyMethodAdapter adapter2 = new SkinnyMethodAdapter(this.compiler.adapter.getClassVisitor(), 4106, methodName, incomingSig, null, null);
            adapter2.aload(0);
            IRBytecodeAdapter.buildArrayFromLocals(adapter2, 1, length2 * 2);
            adapter2.invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "constructHashFromArray", CodegenUtils.sig(RubyHash.class, ThreadContext.class, IRubyObject[].class));
            adapter2.areturn();
            adapter2.end();
            classData.hashMethodsDefined.put(length2, null);
        }
        this.compiler.adapter.invokestatic(classData.clsName, methodName, incomingSig);
    }
}

