/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets.indy;

import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;
import org.jruby.RubyClass;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.targets.indy.ClassSuperInvokeSite;
import org.jruby.ir.targets.indy.ClassSuperIterInvokeSite;
import org.jruby.ir.targets.indy.InstanceSuperInvokeSite;
import org.jruby.ir.targets.indy.InstanceSuperIterInvokeSite;
import org.jruby.ir.targets.indy.InvokeSite;
import org.jruby.ir.targets.indy.SelfInvokeSite;
import org.jruby.ir.targets.indy.UnresolvedSuperInvokeSite;
import org.jruby.ir.targets.indy.UnresolvedSuperIterInvokeSite;
import org.jruby.ir.targets.indy.ZSuperInvokeSite;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JavaNameMangler;
import org.jruby.util.StringSupport;
import org.objectweb.asm.Handle;

public abstract class SuperInvokeSite
extends SelfInvokeSite {
    protected final String superName;
    protected final boolean[] splatMap;
    public static final Handle BOOTSTRAP = new Handle(6, CodegenUtils.p(SuperInvokeSite.class), "bootstrap", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class, Integer.TYPE, String.class, Integer.TYPE), false);

    public SuperInvokeSite(MethodType type2, String superName, String splatmapString, int flags2, String file2, int line) {
        super(type2, superName, CallType.SUPER, flags2, file2, line);
        this.superName = superName;
        this.splatMap = IRRuntimeHelpers.decodeSplatmap(splatmapString);
    }

    public static CallSite bootstrap(MethodHandles.Lookup lookup, String name2, MethodType type2, String splatmapString, int flags2, String file2, int line) {
        List<String> targetAndMethod = StringSupport.split(name2, ':');
        String superName = JavaNameMangler.demangleMethodName(targetAndMethod.get(1));
        return InvokeSite.bootstrap(switch (targetAndMethod.get(0)) {
            case "invokeInstanceSuper" -> new InstanceSuperInvokeSite(type2, superName, splatmapString, flags2, file2, line);
            case "invokeInstanceSuperIter" -> new InstanceSuperIterInvokeSite(type2, superName, splatmapString, flags2, file2, line);
            case "invokeClassSuper" -> new ClassSuperInvokeSite(type2, superName, splatmapString, flags2, file2, line);
            case "invokeClassSuperIter" -> new ClassSuperIterInvokeSite(type2, superName, splatmapString, flags2, file2, line);
            case "invokeUnresolvedSuper" -> new UnresolvedSuperInvokeSite(type2, superName, splatmapString, flags2, file2, line);
            case "invokeUnresolvedSuperIter" -> new UnresolvedSuperIterInvokeSite(type2, superName, splatmapString, flags2, file2, line);
            case "invokeZSuper" -> new ZSuperInvokeSite(type2, superName, splatmapString, flags2, file2, line);
            default -> throw new RuntimeException("invalid super call: " + name2);
        }, lookup);
    }

    public abstract IRubyObject invoke(ThreadContext var1, IRubyObject var2, IRubyObject var3, RubyClass var4, IRubyObject[] var5, Block var6) throws Throwable;

    public abstract IRubyObject fail(ThreadContext var1, IRubyObject var2, IRubyObject var3, RubyClass var4, IRubyObject[] var5, Block var6) throws Throwable;
}

