/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Closure;
import java.lang.ref.WeakReference;
import org.jruby.Ruby;
import org.jruby.RubyNumeric;
import org.jruby.RubyProc;
import org.jruby.api.Convert;
import org.jruby.api.Error;
import org.jruby.ext.ffi.ArrayMemoryIO;
import org.jruby.ext.ffi.CallbackInfo;
import org.jruby.ext.ffi.MappedType;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.Platform;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.Struct;
import org.jruby.ext.ffi.StructByValue;
import org.jruby.ext.ffi.Type;
import org.jruby.ext.ffi.Util;
import org.jruby.ext.ffi.jffi.BoundedNativeMemoryIO;
import org.jruby.ext.ffi.jffi.CodeMemoryIO;
import org.jruby.ext.ffi.jffi.FFIUtil;
import org.jruby.ext.ffi.jffi.Factory;
import org.jruby.ext.ffi.jffi.Function;
import org.jruby.ext.ffi.jffi.NativeFunctionInfo;
import org.jruby.ext.ffi.jffi.NativeMemoryIO;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.FunctionalCachingCallSite;

final class NativeClosureProxy
implements Closure {
    private static final int LONG_SIZE = Platform.getPlatform().longSize();
    protected final Ruby runtime;
    protected final NativeFunctionInfo closureInfo;
    private final WeakReference<Object> proc;
    private final CallSite callSite;

    NativeClosureProxy(Ruby runtime2, NativeFunctionInfo closureInfo, Object proc2) {
        this(runtime2, closureInfo, proc2, new FunctionalCachingCallSite("call"));
    }

    NativeClosureProxy(Ruby runtime2, NativeFunctionInfo closureInfo, Object proc2, CallSite callSite) {
        this.runtime = runtime2;
        this.closureInfo = closureInfo;
        this.proc = new WeakReference<Object>(proc2);
        this.callSite = callSite;
    }

    public void invoke(Closure.Buffer buffer) {
        Object recv2 = this.proc.get();
        if (recv2 == null) {
            buffer.setIntReturn(0);
            return;
        }
        this.invoke(buffer, recv2);
    }

    protected final void invoke(Closure.Buffer buffer, Object recv2) {
        ThreadContext context = this.runtime.getCurrentContext();
        IRubyObject[] params2 = new IRubyObject[this.closureInfo.parameterTypes.length];
        for (int i2 = 0; i2 < params2.length; ++i2) {
            params2[i2] = NativeClosureProxy.fromNative(context, this.closureInfo.parameterTypes[i2], buffer, i2);
        }
        IRubyObject retVal = recv2 instanceof Block ? ((Block)recv2).call(context, params2) : this.callSite.call(context, (IRubyObject)recv2, (IRubyObject)recv2, params2);
        NativeClosureProxy.setReturnValue(context, this.closureInfo.returnType, buffer, retVal);
    }

    private static final long longValue(ThreadContext context, IRubyObject value2) {
        long l;
        if (value2 instanceof RubyNumeric) {
            RubyNumeric num = (RubyNumeric)value2;
            l = num.asLong(context);
        } else {
            l = 0L;
        }
        return l;
    }

    private static final long addressValue(ThreadContext context, IRubyObject value2) {
        if (value2 instanceof RubyNumeric) {
            RubyNumeric num = (RubyNumeric)value2;
            return num.asLong(context);
        }
        if (value2 instanceof Pointer) {
            return ((Pointer)value2).getAddress();
        }
        return 0L;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final void setReturnValue(ThreadContext context, Type type2, Closure.Buffer buffer, IRubyObject value2) {
        if (type2 instanceof Type.Builtin) {
            switch (type2.getNativeType()) {
                case VOID: {
                    return;
                }
                case CHAR: 
                case UCHAR: {
                    buffer.setByteReturn((byte)NativeClosureProxy.longValue(context, value2));
                    return;
                }
                case SHORT: 
                case USHORT: {
                    buffer.setShortReturn((short)NativeClosureProxy.longValue(context, value2));
                    return;
                }
                case INT: 
                case UINT: {
                    buffer.setIntReturn((int)NativeClosureProxy.longValue(context, value2));
                    return;
                }
                case LONG_LONG: {
                    buffer.setLongReturn(Util.int64Value(value2));
                    return;
                }
                case ULONG_LONG: {
                    buffer.setLongReturn(Util.uint64Value(value2));
                    return;
                }
                case LONG: 
                case ULONG: {
                    if (LONG_SIZE == 32) {
                        buffer.setIntReturn((int)NativeClosureProxy.longValue(context, value2));
                        return;
                    }
                    buffer.setLongReturn(Util.int64Value(value2));
                    return;
                }
                case FLOAT: {
                    buffer.setFloatReturn((float)Convert.toDouble(context, value2));
                    return;
                }
                case DOUBLE: {
                    buffer.setDoubleReturn(Convert.toDouble(context, value2));
                    return;
                }
                case POINTER: {
                    buffer.setAddressReturn(NativeClosureProxy.addressValue(context, value2));
                    return;
                }
                case BOOL: {
                    buffer.setIntReturn(value2.isTrue() ? 1 : 0);
                    return;
                }
            }
            return;
        }
        if (type2 instanceof CallbackInfo) {
            if (!(value2 instanceof RubyProc) && !value2.respondsTo("call")) {
                buffer.setAddressReturn(0L);
                throw Error.typeError(context, "invalid callback return value, expected Proc or callable object");
            }
            Pointer cb = Factory.getInstance().getCallbackManager().getCallback(context, (CallbackInfo)type2, (Object)value2);
            buffer.setAddressReturn(NativeClosureProxy.addressValue(context, cb));
            return;
        }
        if (type2 instanceof StructByValue) {
            if (!(value2 instanceof Struct)) {
                if (!value2.isNil()) throw Error.typeError(context, value2, context.runtime.getFFI().structClass);
                buffer.setStructReturn(new byte[type2.getNativeSize()], 0);
                return;
            }
            Struct s2 = (Struct)value2;
            MemoryIO memory = s2.getMemory().getMemoryIO();
            if (memory.isDirect()) {
                long address2 = memory.address();
                if (address2 != 0L) {
                    buffer.setStructReturn(address2);
                    return;
                }
                buffer.setStructReturn(new byte[type2.getNativeSize()], 0);
                return;
            }
            if (!(memory instanceof ArrayMemoryIO)) throw Error.runtimeError(context, "struct return value has illegal backing memory");
            ArrayMemoryIO arrayMemory = (ArrayMemoryIO)memory;
            if (arrayMemory.arrayLength() < type2.getNativeSize()) {
                throw Error.runtimeError(context, "size of struct returned from callback too small");
            }
            buffer.setStructReturn(arrayMemory.array(), arrayMemory.arrayOffset());
            return;
        }
        if (type2 instanceof MappedType) {
            MappedType mappedType = (MappedType)type2;
            NativeClosureProxy.setReturnValue(context, mappedType.getRealType(), buffer, mappedType.toNative(context, value2));
            return;
        }
        buffer.setLongReturn(0L);
        throw Error.runtimeError(context, "unsupported return type from struct: " + String.valueOf(type2));
    }

    private static final IRubyObject fromNative(ThreadContext context, Type type2, Closure.Buffer buffer, int index2) {
        Ruby runtime2 = context.runtime;
        if (type2 instanceof Type.Builtin) {
            return switch (type2.getNativeType()) {
                case NativeType.VOID -> runtime2.getNil();
                case NativeType.CHAR -> Util.newSigned8(runtime2, buffer.getByte(index2));
                case NativeType.UCHAR -> Util.newUnsigned8(runtime2, buffer.getByte(index2));
                case NativeType.SHORT -> Util.newSigned16(runtime2, buffer.getShort(index2));
                case NativeType.USHORT -> Util.newUnsigned16(runtime2, buffer.getShort(index2));
                case NativeType.INT -> Util.newSigned32(runtime2, buffer.getInt(index2));
                case NativeType.UINT -> Util.newUnsigned32(runtime2, buffer.getInt(index2));
                case NativeType.LONG_LONG -> Util.newSigned64(runtime2, buffer.getLong(index2));
                case NativeType.ULONG_LONG -> Util.newUnsigned64(runtime2, buffer.getLong(index2));
                case NativeType.LONG -> {
                    if (LONG_SIZE == 32) {
                        yield Util.newSigned32(runtime2, buffer.getInt(index2));
                    }
                    yield Util.newSigned64(runtime2, buffer.getLong(index2));
                }
                case NativeType.ULONG -> {
                    if (LONG_SIZE == 32) {
                        yield Util.newUnsigned32(runtime2, buffer.getInt(index2));
                    }
                    yield Util.newUnsigned64(runtime2, buffer.getLong(index2));
                }
                case NativeType.FLOAT -> runtime2.newFloat(buffer.getFloat(index2));
                case NativeType.DOUBLE -> runtime2.newFloat(buffer.getDouble(index2));
                case NativeType.POINTER -> new Pointer(runtime2, NativeMemoryIO.wrap(runtime2, buffer.getAddress(index2)));
                case NativeType.STRING, NativeType.TRANSIENT_STRING -> NativeClosureProxy.getStringParameter(runtime2, buffer, index2);
                case NativeType.BOOL -> Convert.asBoolean(context, buffer.getByte(index2) != 0);
                default -> throw Error.typeError(context, "invalid callback parameter type " + String.valueOf(type2));
            };
        }
        if (type2 instanceof CallbackInfo) {
            CallbackInfo cbInfo = (CallbackInfo)type2;
            long address2 = buffer.getAddress(index2);
            return address2 != 0L ? new Function(runtime2, cbInfo.getMetaClass(), new CodeMemoryIO(runtime2, address2), cbInfo.getReturnType(), cbInfo.getParameterTypes(), cbInfo.isStdcall() ? CallingConvention.STDCALL : CallingConvention.DEFAULT, runtime2.getNil(), false) : runtime2.getNil();
        }
        if (type2 instanceof StructByValue) {
            StructByValue sbv = (StructByValue)type2;
            long address3 = buffer.getStruct(index2);
            MemoryIO memory = address3 != 0L ? new BoundedNativeMemoryIO(runtime2, address3, type2.getNativeSize()) : runtime2.getFFI().getNullMemoryIO();
            return sbv.getStructClass().newInstance(runtime2.getCurrentContext(), new IRubyObject[]{new Pointer(runtime2, memory)}, Block.NULL_BLOCK);
        }
        if (type2 instanceof MappedType) {
            MappedType mappedType = (MappedType)type2;
            return mappedType.fromNative(runtime2.getCurrentContext(), NativeClosureProxy.fromNative(context, mappedType.getRealType(), buffer, index2));
        }
        throw Error.typeError(context, "unsupported callback parameter type: " + String.valueOf(type2));
    }

    private static final IRubyObject getStringParameter(Ruby runtime2, Closure.Buffer buffer, int index2) {
        return FFIUtil.getString(runtime2, buffer.getAddress(index2));
    }
}

