/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.Ruby;
import org.jruby.ext.ffi.AllocatedDirectMemoryIO;
import org.jruby.ext.ffi.jffi.BoundedNativeMemoryIO;
import org.jruby.util.PhantomReferenceReaper;

final class AllocatedNativeMemoryIO
extends BoundedNativeMemoryIO
implements AllocatedDirectMemoryIO {
    private static final Map<AllocationGroup, Boolean> referenceSet = new ConcurrentHashMap<AllocationGroup, Boolean>();
    private static final ThreadLocal<Reference<AllocationGroup>> currentBucket = new ThreadLocal();
    private final MemoryAllocation allocation;
    private final Object sentinel;

    static final AllocatedNativeMemoryIO allocate(Ruby runtime2, int size2, boolean clear2) {
        return AllocatedNativeMemoryIO.allocateAligned(runtime2, size2, 1, clear2);
    }

    static AllocatedNativeMemoryIO allocateAligned(Ruby runtime2, int size2, int align, boolean clear2) {
        long address2;
        for (int i2 = 0; (address2 = IO.allocateMemory((long)(size2 + align - 1), clear2)) == 0L && i2 < 100; ++i2) {
            System.gc();
        }
        if (address2 == 0L) {
            throw runtime2.newRuntimeError("failed to allocate " + size2 + " bytes of native memory");
        }
        try {
            Object sentinel;
            Reference<AllocationGroup> allocationGroupReference = currentBucket.get();
            AllocationGroup allocationGroup = allocationGroupReference != null ? allocationGroupReference.get() : null;
            Object object = sentinel = allocationGroup != null ? allocationGroup.sentinel() : null;
            if (sentinel == null || !allocationGroup.canAccept(size2)) {
                sentinel = new Object();
                allocationGroup = new AllocationGroup(sentinel);
                referenceSet.put(allocationGroup, Boolean.TRUE);
                currentBucket.set(new SoftReference<AllocationGroup>(allocationGroup));
            }
            AllocatedNativeMemoryIO io2 = new AllocatedNativeMemoryIO(runtime2, sentinel, address2, size2, align);
            allocationGroup.add(io2.allocation, size2);
            return io2;
        }
        catch (Throwable t) {
            IO.freeMemory(address2);
            throw new RuntimeException(t);
        }
    }

    private AllocatedNativeMemoryIO(Ruby runtime2, Object sentinel, long address2, int size2, int align) {
        super(runtime2, (address2 - 1L & (long)(~(align - 1))) + (long)align, size2);
        this.sentinel = sentinel;
        this.allocation = new MemoryAllocation(address2);
    }

    @Override
    public void free() {
        if (this.allocation.released) {
            throw this.getRuntime().newRuntimeError("memory already freed");
        }
        this.allocation.free();
    }

    @Override
    public void setAutoRelease(boolean autorelease2) {
        if (!this.allocation.released) {
            this.allocation.unmanaged = !autorelease2;
        }
    }

    @Override
    public boolean isAutoRelease() {
        return !this.allocation.unmanaged;
    }

    private static final class AllocationGroup
    extends PhantomReferenceReaper<Object>
    implements Runnable {
        public static final int MAX_BYTES_PER_BUCKET = 4096;
        private final WeakReference<Object> weakref;
        private volatile MemoryAllocation head = null;
        private long bytesUsed = 0L;

        AllocationGroup(Object sentinel) {
            super(sentinel);
            this.weakref = new WeakReference<Object>(sentinel);
        }

        Object sentinel() {
            return this.weakref.get();
        }

        void add(MemoryAllocation m, int size2) {
            this.bytesUsed += (long)size2;
            m.next = this.head;
            this.head = m;
        }

        boolean canAccept(int size2) {
            return this.bytesUsed + (long)size2 < 4096L;
        }

        @Override
        public final void run() {
            referenceSet.remove(this);
            MemoryAllocation m = this.head;
            while (m != null) {
                if (!m.unmanaged) {
                    m.dispose();
                }
                m = m.next;
            }
        }
    }

    private static final class MemoryAllocation {
        private final long address;
        volatile boolean released;
        volatile boolean unmanaged;
        volatile MemoryAllocation next;

        MemoryAllocation(long address2) {
            this.address = address2;
        }

        final void dispose() {
            BoundedNativeMemoryIO.IO.freeMemory(this.address);
        }

        final void free() {
            if (!this.released) {
                this.released = true;
                this.unmanaged = true;
                this.dispose();
            }
        }
    }
}

