/*
 * Decompiled with CFR 0.152.
 */
package jnr.netdb;

import com.kenai.jaffl.CallingConvention;
import com.kenai.jaffl.Library;
import com.kenai.jaffl.LibraryOption;
import com.kenai.jaffl.MemoryIO;
import com.kenai.jaffl.NativeLong;
import com.kenai.jaffl.Platform;
import com.kenai.jaffl.Pointer;
import com.kenai.jaffl.annotations.Direct;
import com.kenai.jaffl.annotations.Out;
import com.kenai.jaffl.struct.Struct;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jnr.netdb.Service;
import jnr.netdb.ServicesDB;
import jnr.netdb.StringUtil;

abstract class NativeServicesDB
implements ServicesDB {
    protected final LibServices lib;

    public NativeServicesDB(LibServices lib) {
        this.lib = lib;
    }

    public static final NativeServicesDB getInstance() {
        return SingletonHolder.INSTANCE;
    }

    static final NativeServicesDB load() {
        try {
            NativeServicesDB services;
            LibServices lib;
            Platform.OS os = Platform.getPlatform().getOS();
            if (!(os.equals((Object)Platform.OS.DARWIN) || os.equals((Object)Platform.OS.WINDOWS) && Platform.getPlatform().getCPU() == Platform.CPU.I386 || os.equals((Object)Platform.OS.LINUX) || os.equals((Object)Platform.OS.SOLARIS) || os.equals((Object)Platform.OS.FREEBSD) || os.equals((Object)Platform.OS.NETBSD))) {
                return null;
            }
            if (os.equals((Object)Platform.OS.WINDOWS)) {
                HashMap<LibraryOption, CallingConvention> options = new HashMap<LibraryOption, CallingConvention>();
                options.put(LibraryOption.CallingConvention, CallingConvention.STDCALL);
                lib = (LibServices)Library.loadLibrary(LibServices.class, options, (String[])new String[]{"Ws2_32"});
            } else {
                String[] stringArray;
                if (os.equals((Object)Platform.OS.SOLARIS)) {
                    String[] stringArray2 = new String[3];
                    stringArray2[0] = "socket";
                    stringArray2[1] = "nsl";
                    stringArray = stringArray2;
                    stringArray2[2] = "c";
                } else {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = "c";
                }
                String[] libnames = stringArray;
                lib = os.equals((Object)Platform.OS.LINUX) ? (LibServices)Library.loadLibrary(LinuxLibServices.class, (String[])libnames) : (LibServices)Library.loadLibrary(LibServices.class, (String[])libnames);
            }
            NativeServicesDB nativeServicesDB = services = os.equals((Object)Platform.OS.LINUX) ? new LinuxServicesDB(lib) : new DefaultNativeServicesDB(lib);
            if (services.getServiceByName("comsat", "udp") == null) {
                return null;
            }
            services.getServiceByName("bootps", "udp");
            services.getServiceByPort(67, "udp");
            return services;
        }
        catch (Throwable t) {
            Logger.getLogger(NativeServicesDB.class.getName()).log(Level.WARNING, "Failed to load native services db", t);
            return null;
        }
    }

    static int ntohs(int value) {
        int hostValue;
        int n = hostValue = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN) ? (int)Short.reverseBytes((short)value) : value;
        if (hostValue < 0) {
            hostValue = (hostValue & Short.MAX_VALUE) + 32768;
        }
        return hostValue;
    }

    static int htons(int value) {
        return ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN) ? (int)Short.reverseBytes((short)value) : value;
    }

    static Service serviceFromNative(UnixServent s) {
        if (s == null) {
            return null;
        }
        List emptyAliases = Collections.emptyList();
        Pointer ptr = s.aliases.get();
        List<String> aliases = ptr != null ? StringUtil.getNullTerminatedStringArray(ptr) : emptyAliases;
        return new Service(s.name.get(), NativeServicesDB.ntohs(s.port.get()), s.proto.get(), aliases);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class LinuxServicesDB
    extends NativeServicesDB {
        private static final int BUFLEN = 4096;
        private final LinuxLibServices lib;
        private final Pointer buf;

        LinuxServicesDB(LibServices lib) {
            super(lib);
            this.lib = (LinuxLibServices)lib;
            this.buf = MemoryIO.allocateDirect((int)4096);
        }

        @Override
        public synchronized Service getServiceByName(String name, String proto) {
            UnixServent servent = new UnixServent();
            MemoryIO result = MemoryIO.allocateDirect((int)8);
            if (this.lib.getservbyname_r(name, proto, servent, this.buf, new NativeLong(4096L), (Pointer)result) == 0) {
                return result.getPointer(0L) != null ? LinuxServicesDB.serviceFromNative(servent) : null;
            }
            throw new RuntimeException("getservbyname_r failed");
        }

        @Override
        public synchronized Service getServiceByPort(Integer port, String proto) {
            UnixServent servent = new UnixServent();
            MemoryIO result = MemoryIO.allocateDirect((int)8);
            if (this.lib.getservbyport_r(LinuxServicesDB.htons(port), proto, servent, this.buf, new NativeLong(4096L), (Pointer)result) == 0) {
                return result.getPointer(0L) != null ? LinuxServicesDB.serviceFromNative(servent) : null;
            }
            throw new RuntimeException("getservbyport_r failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized Collection<Service> getAllServices() {
            UnixServent s = new UnixServent();
            ArrayList<Service> allServices = new ArrayList<Service>();
            MemoryIO result = MemoryIO.allocateDirect((int)8);
            NativeLong buflen = new NativeLong(4096L);
            try {
                while (this.lib.getservent_r(s, this.buf, buflen, (Pointer)result) == 0 && result.getPointer(0L) != null) {
                    allServices.add(LinuxServicesDB.serviceFromNative(s));
                }
            }
            finally {
                this.lib.endservent();
            }
            return allServices;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class DefaultNativeServicesDB
    extends NativeServicesDB {
        DefaultNativeServicesDB(LibServices lib) {
            super(lib);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<Service> getAllServices() {
            ArrayList<Service> allServices = new ArrayList<Service>();
            try {
                UnixServent s;
                while ((s = this.lib.getservent()) != null) {
                    allServices.add(DefaultNativeServicesDB.serviceFromNative(s));
                }
            }
            finally {
                this.lib.endservent();
            }
            return allServices;
        }

        @Override
        public Service getServiceByName(String name, String proto) {
            return DefaultNativeServicesDB.serviceFromNative(this.lib.getservbyname(name, proto));
        }

        @Override
        public Service getServiceByPort(Integer port, String proto) {
            return DefaultNativeServicesDB.serviceFromNative(this.lib.getservbyport(DefaultNativeServicesDB.htons(port), proto));
        }
    }

    public static interface LinuxLibServices
    extends LibServices {
        public int getservbyname_r(String var1, String var2, @Direct UnixServent var3, Pointer var4, NativeLong var5, @Out Pointer var6);

        public int getservbyport_r(Integer var1, String var2, @Direct UnixServent var3, Pointer var4, NativeLong var5, @Out Pointer var6);

        public int getservent_r(@Direct UnixServent var1, Pointer var2, NativeLong var3, Pointer var4);
    }

    public static interface LibServices {
        public UnixServent getservbyname(String var1, String var2);

        public UnixServent getservbyport(Integer var1, String var2);

        public UnixServent getservent();

        public void endservent();
    }

    public static class LinuxServent
    extends UnixServent {
        public static final int BUFLEN = 4096;
        public final MemoryIO buf = MemoryIO.allocateDirect((int)4096, (boolean)true);
    }

    public static class UnixServent
    extends Struct {
        public final Struct.String name = new Struct.UTF8StringRef((Struct)this);
        public final Struct.Pointer aliases = new Struct.Pointer((Struct)this);
        public final Struct.Signed32 port = new Struct.Signed32((Struct)this);
        public final Struct.String proto = new Struct.UTF8StringRef((Struct)this);
    }

    private static final class SingletonHolder {
        public static final NativeServicesDB INSTANCE = NativeServicesDB.load();

        private SingletonHolder() {
        }
    }
}

