/*
 * Decompiled with CFR 0.152.
 */
package jnr.netdb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jnr.netdb.IANAServices;
import jnr.netdb.NativeServicesDB;
import jnr.netdb.ServicesDB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Service {
    private final String serviceName;
    private final int port;
    private final String proto;
    private final List<String> aliases;

    Service(String name, int port, String proto, Collection<String> aliases) {
        this.serviceName = name;
        this.port = port;
        this.proto = proto;
        this.aliases = Collections.unmodifiableList(new ArrayList<String>(aliases));
    }

    public static final Service getServiceByName(String name, String proto) {
        return Service.getServicesDB().getServiceByName(name, proto);
    }

    public static final Service getServiceByPort(int port, String proto) {
        return Service.getServicesDB().getServiceByPort(port, proto);
    }

    public static final Collection<Service> getAllServices() {
        return Collections.EMPTY_LIST;
    }

    public final String getName() {
        return this.serviceName;
    }

    public final int getPort() {
        return this.port;
    }

    public final Collection<String> getAliases() {
        return this.aliases;
    }

    private static final ServicesDB getServicesDB() {
        return ServicesDBSingletonHolder.INSTANCE;
    }

    private static final class ServicesDBSingletonHolder {
        static final ServicesDB INSTANCE = ServicesDBSingletonHolder.load();

        private ServicesDBSingletonHolder() {
        }

        private static final ServicesDB load() {
            ServicesDB db = NativeServicesDB.load();
            return db != null ? db : IANAServices.getInstance();
        }
    }
}

