/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Closure;
import com.kenai.jffi.Foreign;
import com.kenai.jffi.MemoryIO;
import com.kenai.jffi.Platform;
import com.kenai.jffi.Type;
import java.lang.reflect.Method;

public class ClosureManager {
    private static final long ADDRESS_MASK = Platform.getPlatform().addressMask();

    public static final ClosureManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private ClosureManager() {
    }

    public final Closure.Handle newClosure(Closure closure, Type returnType, Type[] parameterTypes, CallingConvention convention) {
        Proxy proxy = new Proxy(closure, returnType, parameterTypes);
        long handle = Foreign.getInstance().newClosure(proxy, Proxy.METHOD, returnType.handle(), Type.nativeHandles(parameterTypes), 0);
        if (handle == 0L) {
            throw new RuntimeException("Failed to create native closure");
        }
        return new Handle(handle, returnType, parameterTypes);
    }

    private static final class NativeWordIO64
    extends NativeWordIO {
        private static final MemoryIO IO = MemoryIO.getInstance();
        static final NativeWordIO INSTANCE = new NativeWordIO64();

        private NativeWordIO64() {
        }

        void put(long address, int value) {
            IO.putLong(address, value);
        }

        int get(long address) {
            return (int)IO.getLong(address);
        }
    }

    private static final class NativeWordIO32
    extends NativeWordIO {
        private static final MemoryIO IO = MemoryIO.getInstance();
        static final NativeWordIO INSTANCE = new NativeWordIO32();

        private NativeWordIO32() {
        }

        void put(long address, int value) {
            IO.putInt(address, value);
        }

        int get(long address) {
            return IO.getInt(address);
        }
    }

    private static abstract class NativeWordIO {
        private NativeWordIO() {
        }

        public static final NativeWordIO getInstance() {
            return Platform.getPlatform().addressSize() == 32 ? NativeWordIO32.INSTANCE : NativeWordIO64.INSTANCE;
        }

        abstract void put(long var1, int var3);

        abstract int get(long var1);
    }

    private static final class DirectBuffer
    implements Closure.Buffer {
        private static final MemoryIO IO = MemoryIO.getInstance();
        private static final NativeWordIO WordIO = NativeWordIO.getInstance();
        private static final int PARAM_SIZE = Platform.getPlatform().addressSize() / 8;
        private final long retval;
        private final long parameters;
        private final Type returnType;
        private final Type[] parameterTypes;

        public DirectBuffer(Type returnType, Type[] parameterTypes, long retval, long parameters) {
            this.returnType = returnType;
            this.parameterTypes = parameterTypes;
            this.retval = retval;
            this.parameters = parameters;
        }

        public final byte getByte(int index) {
            return IO.getByte(IO.getAddress(this.parameters + (long)(index * PARAM_SIZE)));
        }

        public final short getShort(int index) {
            return IO.getShort(IO.getAddress(this.parameters + (long)(index * PARAM_SIZE)));
        }

        public final int getInt(int index) {
            return IO.getInt(IO.getAddress(this.parameters + (long)(index * PARAM_SIZE)));
        }

        public final long getLong(int index) {
            return IO.getLong(IO.getAddress(this.parameters + (long)(index * PARAM_SIZE)));
        }

        public final float getFloat(int index) {
            return IO.getFloat(IO.getAddress(this.parameters + (long)(index * PARAM_SIZE)));
        }

        public final double getDouble(int index) {
            return IO.getDouble(IO.getAddress(this.parameters + (long)(index * PARAM_SIZE)));
        }

        public final long getAddress(int index) {
            return IO.getAddress(IO.getAddress(this.parameters + (long)(index * PARAM_SIZE))) & ADDRESS_MASK;
        }

        public final long getStruct(int index) {
            return IO.getAddress(this.parameters + (long)(index * PARAM_SIZE));
        }

        public final void setByteReturn(byte value) {
            WordIO.put(this.retval, value);
        }

        public final void setShortReturn(short value) {
            WordIO.put(this.retval, value);
        }

        public final void setIntReturn(int value) {
            WordIO.put(this.retval, value);
        }

        public final void setLongReturn(long value) {
            IO.putLong(this.retval, value);
        }

        public final void setFloatReturn(float value) {
            IO.putFloat(this.retval, value);
        }

        public final void setDoubleReturn(double value) {
            IO.putDouble(this.retval, value);
        }

        public final void setAddressReturn(long address) {
            IO.putAddress(this.retval, address);
        }

        public void setStructReturn(long value) {
            IO.copyMemory(value, this.retval, this.returnType.size());
        }

        public void setStructReturn(byte[] data, int offset) {
            IO.putByteArray(this.retval, data, offset, this.returnType.size());
        }
    }

    private static final class Proxy {
        static final Method METHOD = Proxy.getMethod();
        final Closure closure;
        final Type returnType;
        final Type[] parameterTypes;

        private static final Method getMethod() {
            try {
                return Proxy.class.getDeclaredMethod("invoke", Long.TYPE, Long.TYPE);
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }

        Proxy(Closure closure, Type returnType, Type[] parameterTypes) {
            this.closure = closure;
            this.returnType = returnType;
            this.parameterTypes = (Type[])parameterTypes.clone();
        }

        void invoke(long retvalAddress, long paramAddress) {
            this.closure.invoke(new DirectBuffer(this.returnType, this.parameterTypes, retvalAddress, paramAddress));
        }
    }

    private static final class Handle
    implements Closure.Handle {
        private static final MemoryIO IO = MemoryIO.getInstance();
        final long handle;
        final long cbAddress;
        private final Type returnType;
        private final Type[] parameterTypes;

        Handle(long handle, Type returnType, Type[] parameterTypes) {
            this.handle = handle;
            this.cbAddress = IO.getAddress(handle);
            this.returnType = returnType;
            this.parameterTypes = (Type[])parameterTypes.clone();
        }

        public long getAddress() {
            return this.cbAddress;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                Foreign.getInstance().freeClosure(this.handle);
            }
            finally {
                super.finalize();
            }
        }
    }

    private static final class SingletonHolder {
        static final ClosureManager INSTANCE = new ClosureManager();

        private SingletonHolder() {
        }
    }
}

