/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Platform;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;

final class Init {
    Init() {
    }

    static final void init() {
    }

    private static final void load() {
        String libName = Platform.getPlatform().getStubLibraryName();
        String bootPath = System.getProperty("jffi.boot.library.path");
        if (bootPath != null) {
            String[] dirs = bootPath.split(File.pathSeparator);
            for (int i = 0; i < dirs.length; ++i) {
                String path = new File(new File(dirs[i]), System.mapLibraryName(libName)).getAbsolutePath();
                try {
                    System.load(path);
                    return;
                }
                catch (UnsatisfiedLinkError ex) {
                    String ext;
                    String orig;
                    if (Platform.getPlatform().getOS() != Platform.OS.DARWIN) continue;
                    if (path.endsWith("dylib")) {
                        orig = "dylib";
                        ext = "jnilib";
                    } else {
                        orig = "jnilib";
                        ext = "dylib";
                    }
                    try {
                        System.load(path.substring(0, path.lastIndexOf(orig)) + ext);
                        return;
                    }
                    catch (UnsatisfiedLinkError ex2) {
                        // empty catch block
                    }
                    continue;
                }
            }
        }
        try {
            System.loadLibrary(libName);
            return;
        }
        catch (UnsatisfiedLinkError ex) {
            InputStream is = Platform.getPlatform().getStubLibraryStream();
            if (is == null) {
                throw new UnsatisfiedLinkError("Could not locate " + libName + " in jar file");
            }
            File dstFile = null;
            try {
                dstFile = File.createTempFile(libName, null);
                dstFile.deleteOnExit();
                FileChannel dstChannel = new FileOutputStream(dstFile).getChannel();
                ReadableByteChannel srcChannel = Channels.newChannel(is);
                long pos = 0L;
                while (is.available() > 0) {
                    pos += dstChannel.transferFrom(srcChannel, pos, Math.max(4096, is.available()));
                }
                dstChannel.close();
                System.load(dstFile.getAbsolutePath());
            }
            catch (IOException ex3) {
                throw new UnsatisfiedLinkError(ex3.getMessage());
            }
            return;
        }
    }

    static {
        Init.load();
    }
}

