/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Address;
import com.kenai.jffi.Foreign;

public final class Library {
    private static final Object lock = new Object();
    private static final ThreadLocal<String> lastError = new ThreadLocal();
    public static final int LAZY = 1;
    public static final int NOW = 2;
    public static final int LOCAL = 4;
    public static final int GLOBAL = 8;
    private final Address handle;

    Library(Address handle) {
        this.handle = handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Library(String name, int flags) {
        long address;
        Foreign foreign = Foreign.getInstance();
        Object object = lock;
        synchronized (object) {
            address = foreign.dlopen(name, flags);
            if (address == 0L) {
                String error = String.format("Could not open [%s]: %s", name, foreign.dlerror());
                throw new UnsatisfiedLinkError(error);
            }
        }
        this.handle = new Address(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Address findSymbol(String name) {
        long address;
        Foreign foreign = Foreign.getInstance();
        Object object = lock;
        synchronized (object) {
            address = foreign.dlsym(this.handle.nativeAddress(), name);
            if (address == 0L) {
                lastError.set(Foreign.getInstance().dlerror());
                return null;
            }
        }
        return new Address(address);
    }

    public static final String lastError() {
        String error = lastError.get();
        return error != null ? error : "unknown";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (!this.handle.isNull()) {
                Foreign.getInstance().dlclose(this.handle.longValue());
            }
        }
        finally {
            super.finalize();
        }
    }
}

