/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider;

import com.kenai.jaffl.LibraryOption;
import com.kenai.jaffl.Platform;
import com.kenai.jaffl.provider.Invoker;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Library {
    public abstract Invoker getInvoker(Method var1, Map<LibraryOption, ?> var2);

    public abstract Object libraryLock();

    public static String locateLibrary(String libraryName) {
        if (new File(libraryName).isAbsolute()) {
            return libraryName;
        }
        LinkedList<String> searchPath = new LinkedList<String>();
        searchPath.addAll(0, com.kenai.jaffl.Library.getLibraryPath(libraryName));
        searchPath.addAll(StaticDataHolder.userLibraryPath);
        String path = Platform.getPlatform().locateLibrary(libraryName, searchPath);
        return path != null ? path : null;
    }

    private static final List<String> getPropertyPaths(String propName) {
        String value = System.getProperty(propName);
        if (value != null) {
            String[] paths = value.split(File.pathSeparator);
            return new ArrayList<String>(Arrays.asList(paths));
        }
        return Collections.emptyList();
    }

    private static final class StaticDataHolder {
        private static final List<String> userLibraryPath = new CopyOnWriteArrayList<String>();

        private StaticDataHolder() {
        }

        static {
            userLibraryPath.addAll(Library.getPropertyPaths("jaffl.library.path"));
            userLibraryPath.addAll(Library.getPropertyPaths("jna.library.path"));
        }
    }
}

