/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider.jffi;

import com.kenai.jaffl.MemoryIO;
import com.kenai.jaffl.Pointer;
import com.kenai.jaffl.provider.AbstractBufferMemoryIO;
import com.kenai.jaffl.provider.NullMemoryIO;
import com.kenai.jaffl.provider.jffi.BoundedDirectMemoryIO;
import com.kenai.jaffl.provider.jffi.DirectMemoryIO;
import com.kenai.jaffl.provider.jffi.JFFIPointer;
import java.nio.ByteBuffer;

public class ByteBufferMemoryIO
extends AbstractBufferMemoryIO {
    public ByteBufferMemoryIO(ByteBuffer buffer) {
        super(buffer);
    }

    public MemoryIO getMemoryIO(long offset) {
        long address = this.getAddress(offset);
        return address != 0L ? new DirectMemoryIO(address) : new NullMemoryIO();
    }

    public MemoryIO getMemoryIO(long offset, long size) {
        long address = this.getAddress(offset);
        return address != 0L ? new BoundedDirectMemoryIO(new DirectMemoryIO(address), 0L, size) : new NullMemoryIO();
    }

    public Pointer getPointer(long offset) {
        long ptr = this.getAddress(offset);
        return ptr != 0L ? new JFFIPointer(ptr) : null;
    }

    public void putPointer(long offset, Pointer value) {
        if (value == null) {
            this.putAddress(offset, 0L);
        } else if (value instanceof JFFIPointer) {
            this.putAddress(offset, ((JFFIPointer)value).address);
        }
        throw new IllegalArgumentException("Invalid Pointer");
    }
}

