/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Platform {
    private final OS os;
    private final CPU cpu;
    private final int addressSize;
    private final long addressMask;
    private final int javaVersionMajor;
    protected final Pattern libPattern;

    private static final OS determineOS() {
        String osName = System.getProperty("os.name").split(" ")[0].toLowerCase();
        if (osName.startsWith("mac") || osName.startsWith("darwin")) {
            return OS.DARWIN;
        }
        if (osName.startsWith("linux")) {
            return OS.LINUX;
        }
        if (osName.startsWith("sunos") || osName.startsWith("solaris")) {
            return OS.SOLARIS;
        }
        if (osName.startsWith("aix")) {
            return OS.AIX;
        }
        if (osName.startsWith("openbsd")) {
            return OS.OPENBSD;
        }
        if (osName.startsWith("freebsd")) {
            return OS.FREEBSD;
        }
        if (osName.startsWith("windows")) {
            return OS.WINDOWS;
        }
        return OS.UNKNOWN;
    }

    private static final Platform determinePlatform(OS os) {
        switch (os) {
            case DARWIN: {
                return new Darwin();
            }
            case LINUX: {
                return new Linux();
            }
            case WINDOWS: {
                return new Windows();
            }
            case UNKNOWN: {
                return new Unsupported(os);
            }
        }
        return new Default(os);
    }

    private static final CPU determineCPU() {
        String archString = System.getProperty("os.arch").toLowerCase();
        if ("x86".equals(archString) || "i386".equals(archString) || "i86pc".equals(archString)) {
            return CPU.I386;
        }
        if ("x86_64".equals(archString) || "amd64".equals(archString)) {
            return CPU.X86_64;
        }
        if ("ppc".equals(archString) || "powerpc".equals(archString)) {
            return CPU.PPC;
        }
        try {
            return CPU.valueOf(archString.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            return CPU.UNKNOWN;
        }
    }

    private Platform(OS os) {
        this.os = os;
        this.cpu = Platform.determineCPU();
        int dataModel = Integer.getInteger("sun.arch.data.model");
        if (dataModel != 32 && dataModel != 64) {
            switch (this.cpu) {
                case I386: 
                case PPC: 
                case SPARC: {
                    dataModel = 32;
                    break;
                }
                case X86_64: 
                case PPC64: 
                case SPARCV9: 
                case S390X: {
                    dataModel = 64;
                    break;
                }
                default: {
                    throw new ExceptionInInitializerError("Cannot determine cpu address size");
                }
            }
        }
        this.addressSize = dataModel;
        this.addressMask = this.addressSize == 32 ? 0xFFFFFFFFL : -1L;
        int version = 5;
        try {
            String versionString = System.getProperty("java.version");
            if (versionString != null) {
                String[] v = versionString.split("\\.");
                version = Integer.valueOf(v[1]);
            }
        }
        catch (Exception ex) {
            throw new ExceptionInInitializerError("Could not determine java version");
        }
        this.javaVersionMajor = version;
        String libpattern = null;
        switch (os) {
            case WINDOWS: {
                libpattern = ".*\\.dll$";
                break;
            }
            case DARWIN: {
                libpattern = "lib.*\\.(dylib|jnilib)$";
                break;
            }
            default: {
                libpattern = "lib.*\\.so.*$";
            }
        }
        this.libPattern = Pattern.compile(libpattern);
    }

    public static final Platform getPlatform() {
        return SingletonHolder.PLATFORM;
    }

    public final OS getOS() {
        return this.os;
    }

    public final CPU getCPU() {
        return this.cpu;
    }

    public final int getJavaMajorVersion() {
        return this.javaVersionMajor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isBSD() {
        if (this.os == OS.FREEBSD) return true;
        if (this.os == OS.OPENBSD) return true;
        if (this.os == OS.NETBSD) return true;
        if (this.os != OS.DARWIN) return false;
        return true;
    }

    public final boolean isUnix() {
        return this.os != OS.WINDOWS;
    }

    public final int longSize() {
        return this.addressSize;
    }

    public final int addressSize() {
        return this.addressSize;
    }

    public final long addressMask() {
        return this.addressMask;
    }

    public String getName() {
        return (Object)((Object)this.cpu) + "-" + (Object)((Object)this.os);
    }

    public String mapLibraryName(String libName) {
        if (this.libPattern.matcher(libName).find()) {
            return libName;
        }
        return System.mapLibraryName(libName);
    }

    public String locateLibrary(String libName, List<String> libraryPath) {
        String mappedName = this.mapLibraryName(libName);
        for (String path : libraryPath) {
            File libFile = new File(path, mappedName);
            if (!libFile.exists()) continue;
            return libFile.getAbsolutePath();
        }
        return mappedName;
    }

    static /* synthetic */ OS access$000() {
        return Platform.determineOS();
    }

    static /* synthetic */ Platform access$100(OS x0) {
        return Platform.determinePlatform(x0);
    }

    private static class Windows
    extends Supported {
        public Windows() {
            super(OS.WINDOWS);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Linux
    extends Supported {
        public Linux() {
            super(OS.LINUX);
        }

        @Override
        public String locateLibrary(final String libName, List<String> libraryPath) {
            FilenameFilter filter = new FilenameFilter(){
                Pattern p;
                String exact;
                {
                    this.p = Pattern.compile("lib" + libName + "\\.so\\.[0-9]+$");
                    this.exact = "lib" + libName + ".so";
                }

                public boolean accept(File dir, String name) {
                    return this.p.matcher(name).matches() || this.exact.equals(name);
                }
            };
            LinkedList<File> matches = new LinkedList<File>();
            for (String path : libraryPath) {
                File[] files = new File(path).listFiles(filter);
                if (files == null || files.length <= 0) continue;
                matches.addAll(Arrays.asList(files));
            }
            int version = 0;
            String bestMatch = null;
            for (File file : matches) {
                String path = file.getAbsolutePath();
                if (bestMatch == null && path.endsWith(".so")) {
                    bestMatch = path;
                    version = 0;
                    continue;
                }
                String num = path.substring(path.lastIndexOf(".so.") + 4);
                try {
                    if (Integer.parseInt(num) < version) continue;
                    bestMatch = path;
                }
                catch (NumberFormatException e) {}
            }
            return bestMatch != null ? bestMatch : this.mapLibraryName(libName);
        }

        @Override
        public String mapLibraryName(String libName) {
            return "c".equals(libName) || "libc.so".equals(libName) ? "libc.so.6" : super.mapLibraryName(libName);
        }
    }

    private static final class Darwin
    extends Supported {
        public Darwin() {
            super(OS.DARWIN);
        }

        public String mapLibraryName(String libName) {
            if (this.libPattern.matcher(libName).find()) {
                return libName;
            }
            return "lib" + libName + ".dylib";
        }

        public String getName() {
            return "Darwin";
        }
    }

    private static final class Default
    extends Supported {
        public Default(OS os) {
            super(os);
        }
    }

    private static class Unsupported
    extends Platform {
        public Unsupported(OS os) {
            super(os);
        }
    }

    private static class Supported
    extends Platform {
        public Supported(OS os) {
            super(os);
        }
    }

    private static final class SingletonHolder {
        static final Platform PLATFORM = Platform.access$100(Platform.access$000());

        private SingletonHolder() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CPU {
        I386,
        X86_64,
        PPC,
        PPC64,
        SPARC,
        SPARCV9,
        S390X,
        UNKNOWN;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OS {
        DARWIN,
        FREEBSD,
        NETBSD,
        OPENBSD,
        LINUX,
        SOLARIS,
        WINDOWS,
        AIX,
        ZLINUX,
        UNKNOWN;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

