/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * Copyright 2020-2025 The JReleaser authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jreleaser.gradle.plugin.dsl.announce

import groovy.transform.CompileStatic
import org.gradle.api.Action
import org.gradle.api.file.DirectoryProperty
import org.jreleaser.gradle.plugin.dsl.common.Artifact
import org.jreleaser.gradle.plugin.dsl.common.CommitAuthor
import org.jreleaser.gradle.plugin.dsl.packagers.Tap

/**
 *
 * @author Andres Almiray
 * @since 0.6.0
 */
@CompileStatic
interface ArticleAnnouncer extends Announcer {
    DirectoryProperty getTemplateDirectory()

    void setTemplateDirectory(String templateDirectory)

    CommitAuthor getCommitAuthor()

    Tap getRepository()

    void commitAuthor(Action<? super CommitAuthor> action)

    void file(Action<? super Artifact> action)

    void repository(Action<? super Tap> repository)
}