/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.jprocesses.info;

import com.profesorfalken.wmi4java.WMI4Java;
import com.profesorfalken.wmi4java.WMIClass;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jutils.jprocesses.info.AbstractProcessesService;
import org.jutils.jprocesses.info.VBScriptHelper;
import org.jutils.jprocesses.model.JProcessesResponse;
import org.jutils.jprocesses.model.ProcessInfo;
import org.jutils.jprocesses.util.ProcessesUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WindowsProcessesService
extends AbstractProcessesService {
    private final Map<String, String> userData = new HashMap<String, String>();
    private final Map<String, String> cpuData = new HashMap<String, String>();
    private String nameFilter = null;

    WindowsProcessesService() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected List<Map<String, String>> parseList(String rawData) {
        void var7_9;
        ArrayList<Map<String, String>> processesDataList = new ArrayList<Map<String, String>>();
        String[] dataStringLines = rawData.split("\\r?\\n");
        HashMap<String, String> processMap = null;
        String[] stringArray = dataStringLines;
        int n = stringArray.length;
        boolean bl = false;
        while (var7_9 < n) {
            String dataLine = stringArray[var7_9];
            if (dataLine.trim().length() > 0) {
                String[] dataStringInfo;
                if (dataLine.startsWith("Caption")) {
                    if (processMap != null && processMap.size() > 0) {
                        processesDataList.add(processMap);
                    }
                    processMap = new HashMap<String, String>();
                }
                if (processMap != null && (dataStringInfo = dataLine.split(":")).length == 2) {
                    processMap.put(this.normalizeKey(dataStringInfo[0].trim()), this.normalizeValue(dataStringInfo[0].trim(), dataStringInfo[1].trim()));
                    if ("ProcessId".equals(dataStringInfo[0].trim())) {
                        processMap.put("user", this.userData.get(dataStringInfo[1].trim()));
                        processMap.put("cpu_usage", this.cpuData.get(dataStringInfo[1].trim()));
                    }
                }
            }
            ++var7_9;
        }
        if (this.nameFilter != null) {
            ArrayList<Map> processesToRemove = new ArrayList<Map>();
            for (Map map : processesDataList) {
                if (this.nameFilter.equals(map.get("proc_name"))) continue;
                processesToRemove.add(map);
            }
            processesDataList.removeAll(processesToRemove);
        }
        return processesDataList;
    }

    @Override
    protected String getProcessesData(String name) {
        this.fillExtraProcessData();
        if (name != null) {
            this.nameFilter = name;
        }
        return WMI4Java.get().VBSEngine().getRawWMIObjectOutput(WMIClass.WIN32_PROCESS);
    }

    @Override
    protected JProcessesResponse kill(int pid) {
        JProcessesResponse response = new JProcessesResponse();
        if (ProcessesUtils.executeCommandAndGetCode("taskkill", "/PID", String.valueOf(pid), "/F") == 0) {
            response.setSuccess(true);
        }
        return response;
    }

    private String normalizeKey(String origKey) {
        if ("Name".equals(origKey)) {
            return "proc_name";
        }
        if ("ProcessId".equals(origKey)) {
            return "pid";
        }
        if ("UserModeTime".equals(origKey)) {
            return "proc_time";
        }
        if ("Priority".equals(origKey)) {
            return "priority";
        }
        if ("VirtualSize".equals(origKey)) {
            return "virtual_memory";
        }
        if ("WorkingSetSize".equals(origKey)) {
            return "physical_memory";
        }
        if ("CommandLine".equals(origKey)) {
            return "command";
        }
        if ("CreationDate".equals(origKey)) {
            return "start_time";
        }
        return origKey;
    }

    private String normalizeValue(String origKey, String origValue) {
        if ("UserModeTime".equals(origKey)) {
            long longOrigValue = Long.valueOf(origValue);
            long seconds = longOrigValue * 100L / 1000000L / 1000L;
            return this.nomalizeTime(seconds);
        }
        if (("VirtualSize".equals(origKey) || "WorkingSetSize".equals(origKey)) && !origValue.isEmpty()) {
            return String.valueOf(Integer.valueOf(origValue) / 1024);
        }
        if ("CreationDate".equals(origKey) && !origValue.isEmpty()) {
            String hour = origValue.substring(8, 10);
            String minutes = origValue.substring(10, 12);
            String seconds = origValue.substring(12, 14);
            return hour + ":" + minutes + ":" + seconds;
        }
        return origValue;
    }

    private String nomalizeTime(long seconds) {
        long hours = seconds / 3600L;
        long minutes = seconds % 3600L / 60L;
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }

    private void fillExtraProcessData() {
        String perfData = WMI4Java.get().VBSEngine().getRawWMIObjectOutput(WMIClass.WIN32_PERFFORMATTEDDATA_PERFPROC_PROCESS);
        String[] dataStringLines = perfData.split("\\r?\\n");
        String pid = null;
        String cpuUsage = null;
        for (String dataLine : dataStringLines) {
            String[] dataStringInfo;
            if (dataLine.trim().length() <= 0) continue;
            if (dataLine.startsWith("Caption")) {
                if (pid == null || cpuUsage == null) continue;
                this.cpuData.put(pid, cpuUsage);
                continue;
            }
            if (dataLine.startsWith("IDProcess")) {
                dataStringInfo = dataLine.split(":");
                if (dataStringInfo.length != 2) continue;
                pid = dataStringInfo[1].trim();
                continue;
            }
            if (!dataLine.startsWith("PercentProcessorTime") || (dataStringInfo = dataLine.split(":")).length != 2) continue;
            cpuUsage = dataStringInfo[1].trim();
        }
        String processesData = VBScriptHelper.getProcessesOwner();
        if (processesData != null) {
            for (String dataLine : dataStringLines = processesData.split("\\r?\\n")) {
                String[] dataStringInfo = dataLine.split(":");
                if (dataStringInfo.length != 2) continue;
                this.userData.put(dataStringInfo[0].trim(), dataStringInfo[1].trim());
            }
        }
    }

    @Override
    public JProcessesResponse changePriority(int pid, int priority) {
        JProcessesResponse response = new JProcessesResponse();
        String message = VBScriptHelper.changePriority(pid, priority);
        if (message.isEmpty()) {
            response.setSuccess(true);
        } else {
            response.setMessage(message);
        }
        return response;
    }

    @Override
    public ProcessInfo getProcess(int pid) {
        List<Map<String, String>> allProcesses = this.parseList(this.getProcessesData(null));
        for (Map<String, String> process : allProcesses) {
            if (!String.valueOf(pid).equals(process.get("pid"))) continue;
            ProcessInfo info = new ProcessInfo();
            info.setPid(process.get("pid"));
            info.setName(process.get("proc_name"));
            info.setTime(process.get("proc_time"));
            info.setCommand(process.get("command"));
            info.setCpuUsage(process.get("cpu_usage"));
            info.setPhysicalMemory(process.get("physical_memory"));
            info.setStartTime(process.get("start_time"));
            info.setUser(process.get("user"));
            info.setVirtualMemory(process.get("virtual_memory"));
            info.setPriority(process.get("priority"));
            return info;
        }
        return null;
    }
}

