/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.jprocesses.info;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jutils.jprocesses.info.AbstractProcessesService;
import org.jutils.jprocesses.util.ProcessesUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnixProcessesService
extends AbstractProcessesService {
    @Override
    protected List<Map<String, String>> parseList(String rawData) {
        String[] dataStringLines;
        ArrayList<Map<String, String>> processesDataList = new ArrayList<Map<String, String>>();
        for (String dataLine : dataStringLines = rawData.split("\\r?\\n")) {
            if (dataLine.trim().startsWith("PID")) continue;
            HashMap<String, String> element = new HashMap<String, String>();
            String[] elements = dataLine.split("\\s+");
            if (elements.length <= 4) continue;
            element.put("pid", elements[1]);
            element.put("proc_time", elements[3]);
            element.put("proc_name", elements[4]);
            processesDataList.add(element);
        }
        return processesDataList;
    }

    @Override
    protected String getProcessesData() {
        return ProcessesUtils.executeCommand("ps", "-e");
    }

    @Override
    protected int kill(int pid) {
        return ProcessesUtils.executeCommandAndGetCode("kill", "-9", String.valueOf(pid));
    }
}

