/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xjc;

import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAnnotationValue;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JGenerable;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JJavaName;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JMods;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JStringLiteral;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.model.CAttributePropertyInfo;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CClassInfoParent;
import com.sun.tools.xjc.model.CCustomizable;
import com.sun.tools.xjc.model.CDefaultValue;
import com.sun.tools.xjc.model.CElementPropertyInfo;
import com.sun.tools.xjc.model.CPluginCustomization;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.CReferencePropertyInfo;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.EnumOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlElementRefs;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.xml.namespace.QName;
import org.eclipse.persistence.oxm.annotations.XmlValueExtension;
import org.glassfish.jaxb.core.api.impl.NameConverter;
import org.glassfish.jaxb.core.v2.model.core.WildcardMode;
import org.jpmml.xjc.AnnotatePlugin;
import org.jpmml.xjc.CodeModelUtil;
import org.jpmml.xjc.ComplexPlugin;
import org.jpmml.xjc.CustomizationUtil;
import org.jpmml.xjc.OutlineUtil;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;

public class PMMLPlugin
extends ComplexPlugin {
    public static final String NAMESPACE_URI = "http://jpmml.org/jpmml-model";
    public static final QName SERIALVERSIONUID_ELEMENT_NAME = new QName("http://jpmml.org/jpmml-model", "serialVersionUID");
    public static final QName SUBPACKAGE_ELEMENT_NAME = new QName("http://jpmml.org/jpmml-model", "subpackage");

    public String getOptionName() {
        return "Xpmml";
    }

    public String getUsage() {
        return null;
    }

    @Override
    public List<QName> getCustomizationElementNames() {
        return Arrays.asList(SERIALVERSIONUID_ELEMENT_NAME, SUBPACKAGE_ELEMENT_NAME);
    }

    public void postProcessModel(Model model, ErrorHandler errorHandler) {
        super.postProcessModel(model, errorHandler);
        JCodeModel codeModel = model.codeModel;
        JClass measureClass = codeModel.ref("org.dmg.pmml.Measure");
        JClass nodeClass = codeModel.ref("org.dmg.pmml.tree.Node");
        JClass pmmlObjectClass = codeModel.ref("org.dmg.pmml.PMMLObject");
        JClass scoreDistributionClass = codeModel.ref("org.dmg.pmml.ScoreDistribution");
        Comparator<CPropertyInfo> comparator = new Comparator<CPropertyInfo>(){

            @Override
            public int compare(CPropertyInfo left, CPropertyInfo right) {
                boolean leftAttribute = left instanceof CAttributePropertyInfo;
                boolean rightAttribute = right instanceof CAttributePropertyInfo;
                if (leftAttribute && !rightAttribute) {
                    return -1;
                }
                if (!leftAttribute && rightAttribute) {
                    return 1;
                }
                return 0;
            }
        };
        CPluginCustomization serialVersionUIDCustomization = CustomizationUtil.findCustomization((CCustomizable)model, SERIALVERSIONUID_ELEMENT_NAME);
        if (serialVersionUIDCustomization != null) {
            Element element = serialVersionUIDCustomization.element;
            if (model.serialVersionUID != null) {
                throw new RuntimeException();
            }
            int major = PMMLPlugin.parseVersion(element.getAttribute("major"));
            int minor = PMMLPlugin.parseVersion(element.getAttribute("minor"));
            int patch = PMMLPlugin.parseVersion(element.getAttribute("patch"));
            int implementation = PMMLPlugin.parseVersion(element.getAttribute("implementation"));
            model.serialVersionUID = major << 24 | minor << 16 | patch << 8 | implementation;
        }
        Map beans = model.beans();
        Collection classInfos = beans.values();
        for (CClassInfo classInfo : classInfos) {
            CPluginCustomization subpackageCustomization = CustomizationUtil.findCustomization((CCustomizable)classInfo, SUBPACKAGE_ELEMENT_NAME);
            if (subpackageCustomization != null) {
                CClassInfoParent.Package packageParent = (CClassInfoParent.Package)classInfo.parent();
                Element element = subpackageCustomization.element;
                String name = element.getAttribute("name");
                if (name == null) {
                    throw new RuntimeException();
                }
                try {
                    Field pkgField = CClassInfoParent.Package.class.getDeclaredField("pkg");
                    CodeModelUtil.ensureAccessible(pkgField);
                    JPackage subPackage = packageParent.pkg.subPackage(name);
                    pkgField.set(packageParent, subPackage);
                }
                catch (ReflectiveOperationException roe) {
                    throw new RuntimeException(roe);
                }
            }
            if (classInfo.shortName.equals("ComplexNode") || classInfo.shortName.equals("ComplexScoreDistribution")) {
                String name = classInfo.shortName.replace("Complex", "");
                try {
                    Field elementNameField = CClassInfo.class.getDeclaredField("elementName");
                    CodeModelUtil.ensureAccessible(elementNameField);
                    elementNameField.set(classInfo, new QName("http://www.dmg.org/PMML-4_4", name));
                }
                catch (ReflectiveOperationException roe) {
                    throw new RuntimeException(roe);
                }
            }
            List propertyInfos = classInfo.getProperties();
            propertyInfos.sort(comparator);
            for (CPropertyInfo propertyInfo : propertyInfos) {
                CDefaultValue defaultValue;
                Object publicName = propertyInfo.getName(true);
                Object privateName = propertyInfo.getName(false);
                if (propertyInfo instanceof CReferencePropertyInfo) {
                    CReferencePropertyInfo referencePropertyInfo = (CReferencePropertyInfo)propertyInfo;
                    referencePropertyInfo.setWildcard(WildcardMode.LAX);
                }
                if (propertyInfo.isCollection()) {
                    if (classInfo.shortName.equals("ComplexNode") && ((String)privateName).equals("node")) {
                        propertyInfo.baseType = nodeClass;
                    } else if ((classInfo.shortName.equals("ComplexNode") || classInfo.shortName.equals("RuleSet") || classInfo.shortName.equals("SimpleRule")) && ((String)privateName).equals("scoreDistribution")) {
                        propertyInfo.baseType = scoreDistributionClass;
                    } else if (classInfo.shortName.equals("VectorFields") && ((String)privateName).equals("fieldRefOrCategoricalPredictor")) {
                        propertyInfo.baseType = pmmlObjectClass;
                    }
                    if (((String)privateName).contains("And") || ((String)privateName).contains("Or") || ((String)privateName).equalsIgnoreCase("content")) {
                        propertyInfo.setName(true, "Content");
                        propertyInfo.setName(false, "content");
                        continue;
                    }
                    if (((String)privateName).endsWith("array") || ((String)privateName).endsWith("Array")) {
                        publicName = (String)publicName + "s";
                        privateName = (String)privateName + "s";
                    } else if (((String)privateName).endsWith("ref") || ((String)privateName).endsWith("Ref")) {
                        publicName = (String)publicName + "s";
                        privateName = (String)privateName + "s";
                    } else {
                        publicName = JJavaName.getPluralForm((String)publicName);
                        privateName = JJavaName.getPluralForm((String)privateName);
                    }
                    propertyInfo.setName(true, (String)publicName);
                    propertyInfo.setName(false, (String)privateName);
                    continue;
                }
                if (classInfo.shortName.equals("ComparisonMeasure") && ((String)privateName).equals("measure")) {
                    propertyInfo.baseType = measureClass;
                } else if (classInfo.shortName.equals("DecisionTree") && ((String)privateName).equals("missingValueStrategy")) {
                    propertyInfo.baseType = codeModel.directClass("org.dmg.pmml.tree.TreeModel.MissingValueStrategy");
                    propertyInfo.defaultValue = new CEnumConstantDefaultValue(propertyInfo, propertyInfo.defaultValue);
                } else if (classInfo.shortName.equals("DecisionTree") && ((String)privateName).equals("node")) {
                    propertyInfo.baseType = nodeClass;
                } else if (classInfo.shortName.equals("DecisionTree") && ((String)privateName).equals("noTrueChildStrategy")) {
                    propertyInfo.baseType = codeModel.directClass("org.dmg.pmml.tree.TreeModel.NoTrueChildStrategy");
                    propertyInfo.defaultValue = new CEnumConstantDefaultValue(propertyInfo, propertyInfo.defaultValue);
                } else if (classInfo.shortName.equals("DecisionTree") && ((String)privateName).equals("splitCharacteristic")) {
                    propertyInfo.baseType = codeModel.directClass("org.dmg.pmml.tree.TreeModel.SplitCharacteristic");
                    propertyInfo.defaultValue = new CEnumConstantDefaultValue(propertyInfo, propertyInfo.defaultValue);
                } else if (classInfo.shortName.equals("NeuralLayer") && ((String)privateName).equals("activationFunction")) {
                    propertyInfo.baseType = codeModel.directClass("org.dmg.pmml.neural_network.NeuralNetwork.ActivationFunction");
                } else if (classInfo.shortName.equals("NeuralLayer") && ((String)privateName).equals("normalizationMethod")) {
                    propertyInfo.baseType = codeModel.directClass("org.dmg.pmml.neural_network.NeuralNetwork.NormalizationMethod");
                } else if (classInfo.shortName.equals("Regression") && ((String)privateName).equals("normalizationMethod")) {
                    propertyInfo.baseType = codeModel.directClass("org.dmg.pmml.regression.RegressionModel.NormalizationMethod");
                    propertyInfo.defaultValue = new CEnumConstantDefaultValue(propertyInfo, propertyInfo.defaultValue);
                } else if (classInfo.shortName.equals("TreeModel") && ((String)privateName).equals("node")) {
                    propertyInfo.baseType = nodeClass;
                }
                if (((String)privateName).equals("functionName")) {
                    propertyInfo.setName(true, "MiningFunction");
                    propertyInfo.setName(false, "miningFunction");
                }
                if ((defaultValue = propertyInfo.defaultValue) == null) continue;
                propertyInfo.defaultValue = new CShareableDefaultValue(propertyInfo, propertyInfo.defaultValue);
            }
        }
    }

    public boolean run(Outline outline, Options options, ErrorHandler errorHandler) {
        JAnnotationUse xmlType;
        Model model = outline.getModel();
        JCodeModel codeModel = model.codeModel;
        JClass iterableInterface = codeModel.ref("java.lang.Iterable");
        JClass iteratorInterface = codeModel.ref("java.util.Iterator");
        JClass hasExtensionsInterface = codeModel.ref("org.dmg.pmml.HasExtensions");
        JClass namespaceUrisInterface = codeModel.ref("org.dmg.pmml.NamespaceURIs");
        JClass stringValueInterface = codeModel.ref("org.dmg.pmml.StringValue");
        JClass stringClass = codeModel.ref("java.lang.String");
        JClass arraysClass = codeModel.ref("java.util.Arrays");
        JClass missingAttributeExceptionClass = codeModel.ref("org.jpmml.model.MissingAttributeException");
        JClass missingElementExceptionClass = codeModel.ref("org.jpmml.model.MissingElementException");
        JClass propertyAnnotation = codeModel.ref("org.jpmml.model.annotations.Property");
        JFieldRef pmmlLatestExpr = namespaceUrisInterface.staticRef("PMML_LATEST");
        ArrayList classOutlines = new ArrayList(outline.getClasses());
        classOutlines.sort((left, right) -> left.implClass.name().compareToIgnoreCase(right.implClass.name()));
        for (ClassOutline classOutline : classOutlines) {
            String[][][] markerInterfaceInfos;
            String[][][] baseClassInfos;
            FieldOutline extensionsFieldOutline;
            FieldOutline[] fieldOutlines;
            JDefinedClass beanClazz = classOutline.implClass;
            List<JAnnotationUse> beanClazzAnnotations = CodeModelUtil.getAnnotations((JAnnotatable)beanClazz);
            JAnnotationUse xmlAccessorType = CodeModelUtil.findAnnotation(beanClazzAnnotations, XmlAccessorType.class);
            if (xmlAccessorType != null) {
                beanClazzAnnotations.remove(xmlAccessorType);
            }
            if ((xmlType = CodeModelUtil.findAnnotation(beanClazzAnnotations, XmlType.class)) == null) {
                throw new RuntimeException();
            }
            beanClazzAnnotations.remove(xmlType);
            beanClazzAnnotations.add(0, xmlType);
            JAnnotationUse xmlRootElement = CodeModelUtil.findAnnotation(beanClazzAnnotations, XmlRootElement.class);
            if (xmlRootElement == null) {
                String elementName = PMMLPlugin.getElementName(beanClazz.name());
                beanClazz.annotate(XmlRootElement.class).param("name", elementName).param("namespace", (JExpression)pmmlLatestExpr);
            }
            if ((xmlRootElement = CodeModelUtil.findAnnotation(beanClazzAnnotations, XmlRootElement.class)) == null) {
                throw new RuntimeException();
            }
            beanClazzAnnotations.remove(xmlRootElement);
            beanClazzAnnotations.add(0, xmlRootElement);
            PMMLPlugin.updateNamespace(xmlRootElement, (JExpression)pmmlLatestExpr);
            Map fieldVars = beanClazz.fields();
            for (FieldOutline fieldOutline : fieldOutlines = classOutline.getDeclaredFields()) {
                JAnnotationUse xmlElement;
                JMethod requireMethod;
                JFieldRef fieldRef;
                JClass boxifiedReturnType;
                JType returnType;
                CPropertyInfo propertyInfo = fieldOutline.getPropertyInfo();
                String publicName = propertyInfo.getName(true);
                String privateName = propertyInfo.getName(false);
                JFieldVar fieldVar = (JFieldVar)fieldVars.get(privateName);
                String name = fieldVar.name();
                JMods modifiers = fieldVar.mods();
                if ((modifiers.getValue() & 4) != 4) {
                    modifiers.setPrivate();
                }
                JType type = fieldVar.type();
                CShareableDefaultValue defaultValue = (CShareableDefaultValue)propertyInfo.defaultValue;
                if (defaultValue != null && defaultValue.isShared()) {
                    beanClazz.field(28, type, defaultValue.getField(), defaultValue.computeInit(outline));
                }
                JMethod getterMethod = beanClazz.getMethod("get" + publicName, new JType[0]);
                JMethod setterMethod = beanClazz.getMethod("set" + publicName, new JType[]{type});
                if (getterMethod != null && (returnType = getterMethod.type()).isPrimitive() && !type.isPrimitive() && (boxifiedReturnType = returnType.boxify()).equals(type)) {
                    getterMethod.type((JType)boxifiedReturnType);
                }
                if (setterMethod != null) {
                    setterMethod.type((JType)beanClazz);
                    JVar param = (JVar)setterMethod.params().get(0);
                    param.name(name);
                    param.annotate(propertyAnnotation).param("value", name);
                    setterMethod.body()._return(JExpr._this());
                }
                if (propertyInfo.isCollection()) {
                    JType elementType = CodeModelUtil.getElementType(type);
                    JFieldRef fieldRef2 = JExpr.refthis((String)name);
                    JMethod getElementsMethod = beanClazz.getMethod("get" + publicName, new JType[0]);
                    JMethod hasElementsMethod = beanClazz.method(1, Boolean.TYPE, "has" + publicName);
                    hasElementsMethod.body()._return(fieldRef2.ne(JExpr._null()).cand(fieldRef2.invoke("isEmpty").not()));
                    PMMLPlugin.moveBefore(beanClazz, hasElementsMethod, getElementsMethod);
                    JMethod addElementsMethod = beanClazz.method(1, (JType)beanClazz, "add" + publicName);
                    String param = addElementsMethod.varParam(elementType, name);
                    addElementsMethod.body().add((JStatement)JExpr.invoke((JMethod)getterMethod).invoke("addAll").arg((JExpression)arraysClass.staticInvoke("asList").arg((JExpression)param)));
                    addElementsMethod.body()._return(JExpr._this());
                    PMMLPlugin.moveAfter(beanClazz, addElementsMethod, getElementsMethod);
                }
                boolean required = OutlineUtil.isRequired(beanClazz, propertyInfo);
                List<CPluginCustomization> propertyCustomizations = CustomizationUtil.findPropertyCustomizationsInProperty(propertyInfo, AnnotatePlugin.ANNOTATE_PROPERTY_QNAME);
                for (CPluginCustomization propertyCustomization : propertyCustomizations) {
                    String[] classAndValue = AnnotatePlugin.parseCustomization(propertyCustomization);
                    switch (classAndValue[0]) {
                        case "org.jpmml.model.annotations.NullSafeGetter": {
                            required |= true;
                            break;
                        }
                    }
                }
                if (propertyInfo instanceof CAttributePropertyInfo) {
                    CAttributePropertyInfo attributePropertyInfo = (CAttributePropertyInfo)propertyInfo;
                    JFieldVar attributeVar = PMMLPlugin.declareAttributeField(beanClazz, fieldVar);
                    if (required) {
                        fieldRef = JExpr.refthis((String)fieldVar.name());
                        requireMethod = beanClazz.method(1, getterMethod.type(), "require" + publicName);
                        requireMethod.body()._if(fieldRef.eq(JExpr._null()))._then()._throw((JExpression)JExpr._new((JClass)missingAttributeExceptionClass).arg(JExpr._this()).arg(PMMLPlugin.constantExpr(attributeVar)));
                        requireMethod.body()._return((JExpression)fieldRef);
                        PMMLPlugin.moveBefore(beanClazz, requireMethod, getterMethod);
                    }
                } else if (propertyInfo instanceof CElementPropertyInfo) {
                    CElementPropertyInfo elementPropertyInfo = (CElementPropertyInfo)propertyInfo;
                    JFieldVar elementVar = PMMLPlugin.declareElementField(beanClazz, fieldVar);
                    if (required) {
                        fieldRef = JExpr.refthis((String)fieldVar.name());
                        requireMethod = beanClazz.method(1, getterMethod.type(), "require" + publicName);
                        JExpression testExpr = fieldRef.eq(JExpr._null());
                        if (elementPropertyInfo.isCollection()) {
                            testExpr = testExpr.cor((JExpression)fieldRef.invoke("isEmpty"));
                        }
                        requireMethod.body()._if(testExpr)._then()._throw((JExpression)JExpr._new((JClass)missingElementExceptionClass).arg(JExpr._this()).arg(PMMLPlugin.constantExpr(elementVar)));
                        requireMethod.body()._return((JExpression)fieldRef);
                        PMMLPlugin.moveBefore(beanClazz, requireMethod, getterMethod);
                    }
                }
                List<JAnnotationUse> fieldVarAnnotations = CodeModelUtil.getAnnotations((JAnnotatable)fieldVar);
                if ("node".equals(name) || "nodes".equals(name) || "scoreDistributions".equals(name)) {
                    xmlElement = CodeModelUtil.findAnnotation(fieldVarAnnotations, XmlElement.class);
                    fieldVarAnnotations.remove(xmlElement);
                    JAnnotationUse xmlElements = fieldVar.annotate(XmlElements.class);
                    JAnnotationArrayMember valueArray = xmlElements.paramArray("value");
                    JAnnotationUse valueXmlElement = valueArray.annotate(XmlElement.class);
                    PMMLPlugin.addValues(valueXmlElement, xmlElement.getAnnotationMembers());
                    fieldVarAnnotations.remove(xmlElements);
                    fieldVarAnnotations.add(0, xmlElements);
                }
                if (CodeModelUtil.hasAnnotation(fieldVarAnnotations, XmlValue.class)) {
                    fieldVar.annotate(XmlValueExtension.class);
                }
                if (CodeModelUtil.hasAnnotation(fieldVarAnnotations, XmlElement.class)) {
                    xmlElement = CodeModelUtil.findAnnotation(fieldVarAnnotations, XmlElement.class);
                    PMMLPlugin.updateNamespace(xmlElement, (JExpression)pmmlLatestExpr);
                }
                if (CodeModelUtil.hasAnnotation(fieldVarAnnotations, XmlElements.class)) {
                    JAnnotationUse xmlElements = CodeModelUtil.findAnnotation(fieldVarAnnotations, XmlElements.class);
                    PMMLPlugin.updateNamespaceArray(xmlElements, (JExpression)pmmlLatestExpr);
                }
                if (CodeModelUtil.hasAnnotation(fieldVarAnnotations, XmlElementRef.class)) {
                    JAnnotationUse xmlElementRef = CodeModelUtil.findAnnotation(fieldVarAnnotations, XmlElementRef.class);
                    PMMLPlugin.updateNamespace(xmlElementRef, (JExpression)pmmlLatestExpr);
                }
                if (!CodeModelUtil.hasAnnotation(fieldVarAnnotations, XmlElementRefs.class)) continue;
                JAnnotationUse xmlElementRefs = CodeModelUtil.findAnnotation(fieldVarAnnotations, XmlElementRefs.class);
                PMMLPlugin.updateNamespaceArray(xmlElementRefs, (JExpression)pmmlLatestExpr);
            }
            FieldOutline contentFieldOutline = PMMLPlugin.getContentField(classOutline);
            if (contentFieldOutline != null) {
                CPropertyInfo propertyInfo = contentFieldOutline.getPropertyInfo();
                String publicName = propertyInfo.getName(true);
                String[][][] privateName = propertyInfo.getName(false);
                JFieldVar fieldVar = (JFieldVar)fieldVars.get(privateName);
                JType elementType = CodeModelUtil.getElementType(fieldVar.type());
                beanClazz._implements(iterableInterface.narrow(elementType));
                JMethod hasElementsMethod = beanClazz.getMethod("has" + publicName, new JType[0]);
                JMethod requireElementsMethod = beanClazz.getMethod("require" + publicName, new JType[0]);
                JMethod iteratorMethod = beanClazz.method(1, (JType)iteratorInterface.narrow(elementType), "iterator");
                iteratorMethod.annotate(Override.class);
                iteratorMethod.body()._return((JExpression)JExpr.invoke((JMethod)requireElementsMethod).invoke("iterator"));
                PMMLPlugin.moveBefore(beanClazz, iteratorMethod, hasElementsMethod);
            }
            if ((extensionsFieldOutline = PMMLPlugin.getExtensionsField(classOutline)) != null) {
                beanClazz._implements(hasExtensionsInterface.narrow((JClass)beanClazz));
            }
            if (PMMLPlugin.checkType((JType)beanClazz, "org.dmg.pmml.TextIndex")) {
                PMMLPlugin.createGetterProxy(beanClazz, (JType)stringClass, "getField", "getTextField");
                PMMLPlugin.createGetterProxy(beanClazz, (JType)stringClass, "requireField", "requireTextField");
                PMMLPlugin.createSetterProxy(beanClazz, (JType)stringClass, "field", "setField", "setTextField");
            } else if (PMMLPlugin.checkType((JType)beanClazz, "org.dmg.pmml.MiningField")) {
                PMMLPlugin.createGetterProxy(beanClazz, (JType)stringClass, "getField", "getName");
                PMMLPlugin.createGetterProxy(beanClazz, (JType)stringClass, "requireField", "requireName");
                PMMLPlugin.createSetterProxy(beanClazz, (JType)stringClass, "field", "setField", "setName");
            }
            if (PMMLPlugin.checkType((JType)beanClazz, "org.dmg.pmml.MiningField")) {
                PMMLPlugin.createGetterProxy(beanClazz, (JType)stringClass, "getKey", "requireName");
            } else if (PMMLPlugin.checkType((JType)beanClazz, "org.dmg.pmml.VerificationField") || PMMLPlugin.checkType((JType)beanClazz, "org.dmg.pmml.nearest_neighbor.InstanceField")) {
                PMMLPlugin.createGetterProxy(beanClazz, (JType)stringClass, "getKey", "requireField");
            } else if (PMMLPlugin.checkType((JType)beanClazz, "org.dmg.pmml.regression.RegressionTable") || PMMLPlugin.checkType((JType)beanClazz, "org.dmg.pmml.Target")) {
                PMMLPlugin.createGetterProxy(beanClazz, (JType)stringClass, "getKey", "getTargetField");
            }
            if (PMMLPlugin.checkType((JType)beanClazz, "org.dmg.pmml.False") || PMMLPlugin.checkType((JType)beanClazz, "org.dmg.pmml.True")) {
                beanClazz.field(25, (JType)beanClazz, "INSTANCE", (JExpression)JExpr._new((JClass)beanClazz));
            }
            if (model.serialVersionUID != null) {
                beanClazz.field(28, Long.TYPE, "serialVersionUID", JExpr.lit((long)model.serialVersionUID));
            }
            for (String[][] baseClassInfo : baseClassInfos = new String[][][]{{{"ComparisonField"}, {"getCompareFunction", "setCompareFunction", "getFieldWeight", "setFieldWeight", "getSimilarityScale", "setSimilarityScale"}}, {{"EmbeddedModel"}, {"getAlgorithmName", "setAlgorithmName", "getLocalTransformations", "setLocalTransformations", "getMiningFunction", "requireMiningFunction", "setMiningFunction", "getModelName", "setModelName", "getModelStats", "setModelStats", "getOutput", "setOutput", "getTargets", "setTargets"}}, {{"Field"}, {"requireName"}}, {{"Kernel"}, {"getDescription", "setDescription"}}, {{"Model"}, {"getAlgorithmName", "setAlgorithmName", "getLocalTransformations", "setLocalTransformations", "getMathContext", "setMathContext", "getMiningFunction", "requireMiningFunction", "setMiningFunction", "getMiningSchema", "requireMiningSchema", "setMiningSchema", "getModelExplanation", "setModelExplanation", "getModelName", "setModelName", "getModelStats", "setModelStats", "getModelVerification", "setModelVerification", "getOutput", "setOutput", "isScorable", "setScorable", "getTargets", "setTargets"}}, {{"ModelQuality"}, {"getDataName", "setDataName"}}, {{"NeuralEntity"}, {"requireId"}}, {{"Node"}, {"requireDefaultChild"}}, {{"ParameterCell"}, {"getParameterName", "requireParameterName", "setParameterName", "getTargetCategory", "setTargetCategory"}}, {{"PredictorList"}, {"hasPredictors", "getPredictors", "addPredictors"}}, {{"ScoreDistribution"}, {"getConfidence", "setConfidence", "getProbability", "requireProbability", "setProbability", "requireRecordCount"}}, {{"SparseArray"}, {"getDefaultValue", "setDefaultValue", "hasEntries", "getEntries", "addEntries", "hasIndices", "getIndices", "addIndices", "getN", "setN"}}, {{"Term"}, {"getCoefficient", "requireCoefficient", "setCoefficient"}}}) {
                PMMLPlugin.addOverrideAnnotations(beanClazz, baseClassInfo);
            }
            for (String[][] markerInterfaceInfo : markerInterfaceInfos = new String[][][]{{{"HasActivationFunction"}, {"getActivationFunction", "setActivationFunction", "getAltitude", "setAltitude", "getLeakage", "setLeakage", "getThreshold", "setThreshold", "getWidth", "setWidth"}}, {{"HasAR"}, {"getAR", "getP", "setAR", "setP"}}, {{"HasARIMA"}, {"getAR", "getMA", "getD", "getP", "getQ", "setAR", "setMA", "setD", "setP", "setQ"}}, {{"HasARMA"}, {"getAR", "getMA", "getP", "getQ", "setAR", "setMA", "setP", "setQ"}}, {{"HasArray"}, {"getArray", "setArray"}}, {{"HasArrays"}, {"hasArrays", "getArrays", "addArrays"}}, {{"HasBaselineScore"}, {"getBaselineScore", "setBaselineScore"}}, {{"HasContinuousDomain"}, {"hasIntervals", "getIntervals", "addIntervals"}}, {{"HasDataType", "Field"}, {"getDataType", "setDataType"}}, {{"HasDefaultValue"}, {"getDefaultValue", "setDefaultValue"}}, {{"HasDerivedFields"}, {"hasDerivedFields", "getDerivedFields", "addDerivedFields"}}, {{"HasDiscreteDomain"}, {"hasValues", "getValues", "addValues"}}, {{"HasDisplayName", "Field"}, {"getDisplayName", "setDisplayName"}}, {{"HasDisplayValue"}, {"getDisplayValue", "setDisplayValue"}}, {{"HasDynamicRegressors"}, {"hasDynamicRegressors", "getDynamicRegressors", "addDynamicRegressors"}}, {{"HasExpression"}, {"getExpression", "requireExpression", "setExpression"}}, {{"HasExtensions"}, {"hasExtensions", "getExtensions", "addExtensions"}}, {{"HasFieldReference", "ComparisonField"}, {"getField", "requireField", "setField"}}, {{"HasId", "Entity", "NeuralEntity", "Node", "Rule"}, {"getId", "setId"}}, {{"HasInvalidValueTreatment"}, {"getInvalidValueTreatment", "setInvalidValueTreatment"}}, {{"HasLocator"}, {"getLocator", "setLocator"}}, {{"HasMA"}, {"getMA", "getQ", "setMA", "setQ"}}, {{"HasMapMissingTo"}, {"getMapMissingTo", "setMapMissingTo"}}, {{"HasMatrix"}, {"getMatrix", "setMatrix"}}, {{"HasMixedContent"}, {"hasContent", "getContent", "addContent"}}, {{"HasMissingValueTreatment"}, {"getMissingValueTreatment", "setMissingValueTreatment"}}, {{"HasModel"}, {"getModel", "requireModel", "setModel"}}, {{"HasName", "Field"}, {"getName", "setName"}}, {{"HasNode"}, {"getMissingValueStrategy", "setMissingValueStrategy", "getMissingValuePenalty", "setMissingValuePenalty", "getNoTrueChildStrategy", "setNoTrueChildStrategy", "getSplitCharacteristic", "setSplitCharacteristic", "getNode", "setNode"}}, {{"HasNormalizationMethod"}, {"getNormalizationMethod", "setNormalizationMethod"}}, {{"HasOpType", "Field"}, {"getOpType", "setOpType"}}, {{"HasOutlierTreatment"}, {"getOutlierTreatment", "setOutlierTreatment"}}, {{"HasPredicate", "Node", "Rule"}, {"getPredicate", "requirePredicate", "setPredicate"}}, {{"HasReasonCode"}, {"getReasonCode", "setReasonCode"}}, {{"HasRecordCount", "Node", "ScoreDistribution"}, {"getRecordCount", "setRecordCount"}}, {{"HasRegressionTables"}, {"getNormalizationMethod", "setNormalizationMethod", "hasRegressionTables", "getRegressionTables", "requireRegressionTables", "addRegressionTables"}}, {{"HasRequiredAR"}, {"getAR", "getP", "requireAR", "requireP", "setAR", "setP"}}, {{"HasRequiredARMA"}, {"getAR", "getMA", "getP", "getQ", "requireAR", "requireMA", "requireP", "requireQ", "setAR", "setMA", "setP", "setQ"}}, {{"HasRequiredArray"}, {"getArray", "requireArray", "setArray"}}, {{"HasRequiredDataType", "Field"}, {"getDataType", "requireDataType", "setDataType"}}, {{"HasRequiredId"}, {"getId", "requireId", "setId"}}, {{"HasRequiredMA"}, {"getMA", "getQ", "requireMA", "requireQ", "setMA", "setQ"}}, {{"HasRequiredMatrix"}, {"getMatrix", "requireMatrix", "setMatrix"}}, {{"HasRequiredName", "Field"}, {"getName", "requireName", "setName"}}, {{"HasRequiredOpType", "Field"}, {"getOpType", "requireOpType", "setOpType"}}, {{"HasRequiredType"}, {"getDataType", "requireDataType", "setDataType", "getOpType", "requireOpType", "setOpType"}}, {{"HasScore", "Node", "Rule"}, {"getScore", "setScore"}}, {{"HasScoreDistributions", "Node", "Rule"}, {"requireScore", "hasScoreDistributions", "getScoreDistributions", "addScoreDistributions"}}, {{"HasTable"}, {"getTableLocator", "setTableLocator", "getInlineTable", "setInlineTable"}}, {{"HasTargetFieldReference"}, {"getTargetField", "setTargetField"}}, {{"HasType"}, {"getDataType", "setDataType", "getOpType", "setOpType"}}, {{"HasValue", "ScoreDistribution"}, {"getValue", "requireValue", "setValue"}}, {{"HasValueSet"}, {"getArray", "requireArray", "setArray"}}}) {
                PMMLPlugin.addOverrideAnnotations(beanClazz, markerInterfaceInfo);
            }
        }
        ArrayList enumOutlines = new ArrayList(outline.getEnums());
        enumOutlines.sort((left, right) -> left.clazz.name().compareToIgnoreCase(right.clazz.name()));
        for (EnumOutline enumOutline : enumOutlines) {
            JDefinedClass clazz = enumOutline.clazz;
            clazz._implements(stringValueInterface.narrow((JClass)clazz));
            List<JAnnotationUse> clazzAnnotations = CodeModelUtil.getAnnotations((JAnnotatable)clazz);
            xmlType = CodeModelUtil.findAnnotation(clazzAnnotations, XmlType.class);
            if (xmlType != null) {
                PMMLPlugin.updateNamespace(xmlType, (JExpression)pmmlLatestExpr);
            }
            JMethod valueMethod = clazz.getMethod("value", new JType[0]);
            valueMethod.annotate(Override.class);
            JMethod toStringMethod = clazz.method(1, String.class, "toString");
            toStringMethod.annotate(Override.class);
            toStringMethod.body()._return((JExpression)JExpr.invoke((JMethod)valueMethod));
        }
        if (model.serialVersionUID != null) {
            model.serialVersionUID = null;
        }
        return true;
    }

    private static void updateNamespace(JAnnotationUse annotation, final JExpression nsExpr) {
        Map<String, JAnnotationValue> memberValues = PMMLPlugin.getMemberValues(annotation);
        if (memberValues != null && memberValues.containsKey("namespace")) {
            JAnnotationValue nsValue = new JAnnotationValue(){

                public void generate(JFormatter f) {
                    f.g((JGenerable)nsExpr);
                }
            };
            memberValues.put("namespace", nsValue);
        }
    }

    private static void updateNamespaceArray(JAnnotationUse annotation, JExpression nsExpr) {
        Map<String, JAnnotationValue> memberValues = PMMLPlugin.getMemberValues(annotation);
        if (memberValues != null && memberValues.containsKey("value")) {
            JAnnotationArrayMember value = (JAnnotationArrayMember)memberValues.get("value");
            Collection elements = value.annotations();
            for (JAnnotationUse element : elements) {
                PMMLPlugin.updateNamespace(element, nsExpr);
            }
        }
    }

    private static Map<String, JAnnotationValue> getMemberValues(JAnnotationUse annotation) {
        try {
            Field memberValuesField = JAnnotationUse.class.getDeclaredField("memberValues");
            if (!memberValuesField.isAccessible()) {
                memberValuesField.setAccessible(true);
            }
            return (Map)memberValuesField.get(annotation);
        }
        catch (ReflectiveOperationException roe) {
            throw new RuntimeException(roe);
        }
    }

    private static String getElementName(String name) {
        switch (name) {
            case "Error": {
                return "X-Error";
            }
            case "CountTable": {
                return "COUNT-TABLE-TYPE";
            }
            case "ContinuousDistribution": {
                return name;
            }
            case "LognormalDistribution": 
            case "NormalDistribution": 
            case "TriangularDistribution": 
            case "UniformDistribution": {
                return name + "ForBN";
            }
            case "LinearKernel": 
            case "PolynomialKernel": 
            case "RadialBasisKernel": 
            case "SigmoidKernel": {
                return name + "Type";
            }
            case "TrendExpoSmooth": {
                return "Trend_ExpoSmooth";
            }
        }
        throw new IllegalArgumentException(name);
    }

    private static FieldOutline getExtensionsField(ClassOutline classOutline) {
        Predicate<FieldOutline> predicate = new Predicate<FieldOutline>(){

            @Override
            public boolean test(FieldOutline fieldOutline) {
                CPropertyInfo propertyInfo = fieldOutline.getPropertyInfo();
                if ("extensions".equals(propertyInfo.getName(false)) && propertyInfo.isCollection()) {
                    JType elementType = CodeModelUtil.getElementType(fieldOutline.getRawType());
                    return PMMLPlugin.checkType(elementType, "org.dmg.pmml.Extension");
                }
                return false;
            }
        };
        return Arrays.stream(classOutline.getDeclaredFields()).filter(predicate).findFirst().orElse(null);
    }

    private static FieldOutline getContentField(final ClassOutline classOutline) {
        Predicate<FieldOutline> predicate = new Predicate<FieldOutline>(){
            private String name;
            {
                this.name = classOutline.implClass.name();
            }

            @Override
            public boolean test(FieldOutline fieldOutline) {
                CPropertyInfo propertyInfo = fieldOutline.getPropertyInfo();
                if (propertyInfo.isCollection()) {
                    JType elementType = CodeModelUtil.getElementType(fieldOutline.getRawType());
                    String name = elementType.name();
                    return this.name.equals(name + "s") || this.name.equals(JJavaName.getPluralForm((String)name));
                }
                return false;
            }
        };
        return Arrays.stream(classOutline.getDeclaredFields()).filter(predicate).findFirst().orElse(null);
    }

    private static void addValues(JAnnotationUse annotationUse, Map<String, JAnnotationValue> memberValues) {
        try {
            Method addValueMethod = JAnnotationUse.class.getDeclaredMethod("addValue", String.class, JAnnotationValue.class);
            CodeModelUtil.ensureAccessible(addValueMethod);
            Set<Map.Entry<String, JAnnotationValue>> entries = memberValues.entrySet();
            for (Map.Entry entry : entries) {
                addValueMethod.invoke((Object)annotationUse, entry.getKey(), entry.getValue());
            }
        }
        catch (ReflectiveOperationException roe) {
            throw new RuntimeException(roe);
        }
    }

    private static void createGetterProxy(JDefinedClass beanClazz, JType type, String name, String getterName) {
        JMethod getterMethod = beanClazz.getMethod(getterName, new JType[0]);
        JMethod method = beanClazz.method(1, type, name);
        method.annotate(Override.class);
        method.body()._return((JExpression)JExpr.invoke((JMethod)getterMethod));
        PMMLPlugin.moveBefore(beanClazz, method, getterMethod);
    }

    public static void createSetterProxy(JDefinedClass beanClazz, JType type, String parameterName, String name, String setterName) {
        JMethod getterMethod = beanClazz.getMethod(setterName.replace("set", "get"), new JType[0]);
        JMethod method = beanClazz.method(1, (JType)beanClazz, name);
        method.annotate(Override.class);
        JVar nameParameter = method.param(type, parameterName);
        method.body()._return((JExpression)JExpr.invoke((String)setterName).arg((JExpression)nameParameter));
        PMMLPlugin.moveBefore(beanClazz, method, getterMethod);
    }

    private static JFieldVar declareAttributeField(JDefinedClass beanClazz, JFieldVar fieldVar) {
        JDefinedClass attributesInterface = PMMLPlugin.ensureInterface(beanClazz._package(), "PMMLAttributes");
        return PMMLPlugin.declareField(attributesInterface, beanClazz, fieldVar);
    }

    private static JFieldVar declareElementField(JDefinedClass beanClazz, JFieldVar fieldVar) {
        JDefinedClass elementsInterface = PMMLPlugin.ensureInterface(beanClazz._package(), "PMMLElements");
        return PMMLPlugin.declareField(elementsInterface, beanClazz, fieldVar);
    }

    private static JFieldVar declareField(JDefinedClass _interface, JDefinedClass beanClazz, JFieldVar fieldVar) {
        JCodeModel codeModel = _interface.owner();
        JInvocation initExpr = codeModel.ref("org.jpmml.model.ReflectionUtil").staticInvoke("getField").arg(beanClazz.dotclass()).arg(fieldVar.name());
        return _interface.field(0, Field.class, (beanClazz.name() + "_" + fieldVar.name()).toUpperCase(), (JExpression)initExpr);
    }

    private static JExpression constantExpr(JFieldVar fieldVar) {
        JDefinedClass owner;
        try {
            Field ownerField = JFieldVar.class.getDeclaredField("owner");
            CodeModelUtil.ensureAccessible(ownerField);
            owner = (JDefinedClass)ownerField.get(fieldVar);
        }
        catch (ReflectiveOperationException roe) {
            throw new RuntimeException(roe);
        }
        return owner.staticRef(fieldVar.name());
    }

    private static void addOverrideAnnotations(JDefinedClass beanClazz, String[][] typeMemberInfo) {
        LinkedHashSet<String> typeNames = new LinkedHashSet<String>(Arrays.asList(typeMemberInfo[0]));
        LinkedHashSet<String> methodNames = new LinkedHashSet<String>(Arrays.asList(typeMemberInfo[1]));
        boolean matches = false;
        JClass beanSuperClazz = beanClazz._extends();
        String name = beanSuperClazz.erasure().name();
        matches |= typeNames.contains(name);
        Iterator it = beanClazz._implements();
        while (it.hasNext()) {
            JClass _interface = (JClass)it.next();
            String name2 = _interface.erasure().name();
            matches |= typeNames.contains(name2);
        }
        if (!matches) {
            return;
        }
        Collection methods = beanClazz.methods();
        for (JMethod method : methods) {
            String name3 = method.name();
            if (!methodNames.contains(name3)) continue;
            List params = method.params();
            if ((name3.startsWith("has") || name3.startsWith("is") || name3.startsWith("get") || name3.startsWith("require")) && params.size() == 0) {
                if (CodeModelUtil.hasAnnotation(method.annotations(), Override.class)) continue;
                method.annotate(Override.class);
                continue;
            }
            if (name3.startsWith("add") && params.size() == 0 && method.hasVarArgs()) {
                method.annotate(Override.class);
                continue;
            }
            if (name3.startsWith("set") && params.size() == 1) {
                if (CodeModelUtil.hasAnnotation(method.annotations(), Override.class)) continue;
                method.annotate(Override.class);
                continue;
            }
            throw new RuntimeException();
        }
    }

    private static JDefinedClass ensureInterface(JPackage _package, String name) {
        try {
            return _package._interface(name);
        }
        catch (JClassAlreadyExistsException jcaee) {
            return jcaee.getExistingClass();
        }
    }

    private static void moveBefore(JDefinedClass beanClazz, JMethod method, JMethod referenceMethod) {
        List methods = (List)beanClazz.methods();
        int index = methods.indexOf(referenceMethod);
        if (index < 0) {
            throw new RuntimeException();
        }
        methods.remove(method);
        methods.add(index, method);
    }

    private static void moveAfter(JDefinedClass beanClazz, JMethod method, JMethod referenceMethod) {
        List methods = (List)beanClazz.methods();
        int index = methods.indexOf(referenceMethod);
        if (index < 0) {
            throw new RuntimeException();
        }
        methods.remove(method);
        methods.add(index + 1, method);
    }

    private static boolean checkType(JType type, String fullName) {
        return type.fullName().equals(fullName);
    }

    private static int parseVersion(String version) {
        if (version == null) {
            throw new RuntimeException();
        }
        int value = Integer.parseInt(version);
        if (value < 0 || value > 255) {
            throw new RuntimeException();
        }
        return value;
    }

    private static class CShareableDefaultValue
    extends CDefaultValue {
        private CPropertyInfo propertyInfo = null;
        private CDefaultValue parent = null;
        private String field = null;

        private CShareableDefaultValue(CPropertyInfo propertyInfo, CDefaultValue parent) {
            this.setPropertyInfo(propertyInfo);
            this.setParent(parent);
            this.setField(CShareableDefaultValue.formatField(propertyInfo.getName(false)));
        }

        public JExpression compute(Outline outline) {
            JExpression expression = this.computeInit(outline);
            if (expression instanceof JFieldRef || expression instanceof JStringLiteral) {
                this.setField(null);
                return expression;
            }
            return JExpr.ref((String)this.getField());
        }

        public JExpression computeInit(Outline outline) {
            CDefaultValue parent = this.getParent();
            return parent.compute(outline);
        }

        public boolean isShared() {
            String field = this.getField();
            return field != null;
        }

        public CPropertyInfo getPropertyInfo() {
            return this.propertyInfo;
        }

        private void setPropertyInfo(CPropertyInfo propertyInfo) {
            this.propertyInfo = propertyInfo;
        }

        public CDefaultValue getParent() {
            return this.parent;
        }

        private void setParent(CDefaultValue parent) {
            this.parent = parent;
        }

        public String getField() {
            return this.field;
        }

        private void setField(String field) {
            this.field = field;
        }

        private static String formatField(String string) {
            StringBuilder sb = new StringBuilder();
            sb.append("DEFAULT_");
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (Character.isUpperCase(c)) {
                    sb.append('_');
                }
                sb.append(Character.toUpperCase(c));
            }
            return sb.toString();
        }
    }

    private static class CEnumConstantDefaultValue
    extends CDefaultValue {
        private CPropertyInfo propertyInfo = null;
        private CDefaultValue parent = null;

        private CEnumConstantDefaultValue(CPropertyInfo propertyInfo, CDefaultValue parent) {
            this.setPropertyInfo(propertyInfo);
            this.setParent(parent);
        }

        public JExpression compute(Outline outline) {
            CPropertyInfo propertyInfo = this.getPropertyInfo();
            CDefaultValue parent = this.getParent();
            JStringLiteral stringLiteral = (JStringLiteral)parent.compute(outline);
            String name = NameConverter.standard.toConstantName(stringLiteral.str);
            return ((JClass)propertyInfo.baseType).staticRef(name);
        }

        public CPropertyInfo getPropertyInfo() {
            return this.propertyInfo;
        }

        private void setPropertyInfo(CPropertyInfo propertyInfo) {
            this.propertyInfo = propertyInfo;
        }

        public CDefaultValue getParent() {
            return this.parent;
        }

        private void setParent(CDefaultValue parent) {
            this.parent = parent;
        }
    }
}

