/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xjc;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.model.CClass;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CClassRef;
import com.sun.tools.xjc.model.CCustomizable;
import com.sun.tools.xjc.model.CPluginCustomization;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.CustomizableOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.BIClass;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlValue;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.jpmml.xjc.ComplexPlugin;
import org.jpmml.xjc.CustomizationUtil;
import org.xml.sax.ErrorHandler;

public class InheritancePlugin
extends ComplexPlugin {
    public static final String NAMESPACE_URI = "http://jaxb2-commons.dev.java.net/basic/inheritance";
    public static final QName EXTENDS_ELEMENT_NAME = new QName("http://jaxb2-commons.dev.java.net/basic/inheritance", "extends");
    public static final QName IMPLEMENTS_ELEMENT_NAME = new QName("http://jaxb2-commons.dev.java.net/basic/inheritance", "implements");
    private static final JAXBContext context;

    public String getOptionName() {
        return "Xinheritance";
    }

    public String getUsage() {
        return null;
    }

    @Override
    public List<QName> getCustomizationElementNames() {
        return Arrays.asList(EXTENDS_ELEMENT_NAME, IMPLEMENTS_ELEMENT_NAME);
    }

    public void postProcessModel(Model model, ErrorHandler errorHandler) {
        super.postProcessModel(model, errorHandler);
        HashMap<String, CClassRef> classRefCache = new HashMap<String, CClassRef>();
        CClassRef defaultBaseClazz = InheritancePlugin.getClassRef(classRefCache, model, "org.dmg.pmml.PMMLObject");
        Collection classInfos = model.beans().values();
        for (CClassInfo classInfo : classInfos) {
            CClassRef baseClazz = defaultBaseClazz;
            CPluginCustomization extendsCustomization = CustomizationUtil.findCustomization((CCustomizable)classInfo, EXTENDS_ELEMENT_NAME);
            if (extendsCustomization != null) {
                ExtendsClass extendsClass = (ExtendsClass)InheritancePlugin.unmarshal(extendsCustomization);
                String name = extendsClass.className;
                int lt = name.indexOf(60);
                if (lt > -1) {
                    name = name.substring(0, lt);
                }
                baseClazz = InheritancePlugin.getClassRef(classRefCache, model, name);
            }
            classInfo.setBaseClass((CClass)baseClazz);
        }
    }

    public boolean run(Outline outline, Options options, ErrorHandler errorHandler) {
        JCodeModel codeModel = outline.getCodeModel();
        HashMap<String, JClass> typeCache = new HashMap<String, JClass>();
        Collection classOutlines = outline.getClasses();
        for (ClassOutline classOutline : classOutlines) {
            FieldOutline[] fieldOutlines;
            JDefinedClass beanClazz = classOutline.implClass;
            CPluginCustomization extendsCustomization = CustomizationUtil.findCustomization((CustomizableOutline)classOutline, EXTENDS_ELEMENT_NAME);
            if (extendsCustomization != null) {
                ExtendsClass extendsClass = (ExtendsClass)InheritancePlugin.unmarshal(extendsCustomization);
                JClass type = InheritancePlugin.parseType(typeCache, codeModel, extendsClass.className);
                beanClazz._extends(type);
            }
            List<CPluginCustomization> implementsCustomizations = CustomizationUtil.findCustomizations((CustomizableOutline)classOutline, IMPLEMENTS_ELEMENT_NAME);
            for (CPluginCustomization implementsCustomization : implementsCustomizations) {
                ImplementsInterface implementsInterface = (ImplementsInterface)InheritancePlugin.unmarshal(implementsCustomization);
                JClass type = InheritancePlugin.parseType(typeCache, codeModel, implementsInterface.interfaceName);
                beanClazz._implements(type);
            }
            for (FieldOutline fieldOutline : fieldOutlines = classOutline.getDeclaredFields()) {
                CPropertyInfo propertyInfo = fieldOutline.getPropertyInfo();
                CustomizationUtil.findPropertyCustomizationsInProperty(propertyInfo, EXTENDS_ELEMENT_NAME);
                CustomizationUtil.findPropertyCustomizationsInProperty(propertyInfo, IMPLEMENTS_ELEMENT_NAME);
            }
        }
        return true;
    }

    private static JClass parseType(Map<String, JClass> typeCache, JCodeModel codeModel, String name) {
        JClass type = typeCache.get(name);
        if (type == null) {
            type = (JClass)codeModel.parseType(name);
            typeCache.put(name, type);
        }
        return type;
    }

    private static CClassRef getClassRef(Map<String, CClassRef> classRefCache, Model model, String name) {
        CClassRef classRef = classRefCache.get(name);
        if (classRef == null) {
            classRef = new CClassRef(model, null, InheritancePlugin.createBIClass(name), null);
            classRefCache.put(name, classRef);
        }
        return classRef;
    }

    private static BIClass createBIClass(String name) {
        try {
            Constructor biClassConstructor = BIClass.class.getDeclaredConstructor(new Class[0]);
            if (!biClassConstructor.isAccessible()) {
                biClassConstructor.setAccessible(true);
            }
            BIClass biClass = (BIClass)biClassConstructor.newInstance(new Object[0]);
            Field refField = BIClass.class.getDeclaredField("ref");
            if (!refField.isAccessible()) {
                refField.setAccessible(true);
            }
            refField.set(biClass, name);
            return biClass;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Object unmarshal(CPluginCustomization customization) {
        try {
            Unmarshaller unmarshaller = context.createUnmarshaller();
            return unmarshaller.unmarshal((Source)new DOMSource(customization.element));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            context = JAXBContext.newInstance((Class[])new Class[]{ExtendsClass.class, ImplementsInterface.class});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @XmlRootElement(namespace="http://jaxb2-commons.dev.java.net/basic/inheritance", name="implements")
    public static class ImplementsInterface {
        @XmlValue
        public String interfaceName;
    }

    @XmlRootElement(namespace="http://jaxb2-commons.dev.java.net/basic/inheritance", name="extends")
    public static class ExtendsClass {
        @XmlValue
        public String className;
    }
}

