/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xjc;

import com.sun.tools.xjc.model.CCustomizable;
import com.sun.tools.xjc.model.CCustomizations;
import com.sun.tools.xjc.model.CPluginCustomization;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.outline.CustomizableOutline;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public class CustomizationUtil {
    private CustomizationUtil() {
    }

    public static CPluginCustomization findCustomization(CustomizableOutline customizableOutline, QName xmlName) {
        return CustomizationUtil.findCustomization(customizableOutline.getTarget(), xmlName);
    }

    public static CPluginCustomization findCustomization(CCustomizable customizable, QName xmlName) {
        CCustomizations customizations = customizable.getCustomizations();
        return customizations.stream().filter(customization -> CustomizationUtil.match(customization, xmlName)).findFirst().orElse(null);
    }

    public static List<CPluginCustomization> findCustomizations(CustomizableOutline customizableOutline, QName xmlName) {
        return CustomizationUtil.findCustomizations(customizableOutline.getTarget(), xmlName);
    }

    public static List<CPluginCustomization> findCustomizations(CCustomizable customizable, QName xmlName) {
        CCustomizations customizations = customizable.getCustomizations();
        return customizations.stream().filter(customization -> CustomizationUtil.match(customization, xmlName)).collect(Collectors.toList());
    }

    public static List<CPluginCustomization> findPropertyCustomizationsInProperty(CPropertyInfo propertyInfo, QName xmlName) {
        return CustomizationUtil.findCustomizations((CCustomizable)propertyInfo, xmlName);
    }

    public static boolean match(CPluginCustomization customization, QName xmlName) {
        boolean equals;
        Element element = customization.element;
        boolean bl = equals = Objects.equals(CustomizationUtil.fixNull(element.getNamespaceURI()), xmlName.getNamespaceURI()) && Objects.equals(CustomizationUtil.fixNull(element.getLocalName()), xmlName.getLocalPart());
        if (equals) {
            customization.markAsAcknowledged();
        }
        return equals;
    }

    private static String fixNull(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }
}

