/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xjc;

import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JFieldVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.model.CCustomizable;
import com.sun.tools.xjc.model.CPluginCustomization;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.CustomizableOutline;
import com.sun.tools.xjc.outline.EnumConstantOutline;
import com.sun.tools.xjc.outline.EnumOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.jpmml.xjc.CodeModelUtil;
import org.jpmml.xjc.ComplexPlugin;
import org.jpmml.xjc.CustomizationUtil;
import org.xml.sax.ErrorHandler;

public class AnnotatePlugin
extends ComplexPlugin {
    private static final Pattern PATTERN = Pattern.compile("(.+)\\((.+)\\)");
    public static final String NAMESPACE_URI = "http://annox.dev.java.net";
    public static final QName ANNOTATE_CLASS_QNAME = new QName("http://annox.dev.java.net", "annotateClass");
    public static final QName ANNOTATE_ENUM_QNAME = new QName("http://annox.dev.java.net", "annotateEnum");
    public static final QName ANNOTATE_ENUM_CONSTANT_QNAME = new QName("http://annox.dev.java.net", "annotateEnumConstant");
    public static final QName ANNOTATE_PROPERTY_QNAME = new QName("http://annox.dev.java.net", "annotateProperty");

    public String getOptionName() {
        return "Xannotate";
    }

    public String getUsage() {
        return null;
    }

    @Override
    public List<QName> getCustomizationElementNames() {
        return Arrays.asList(ANNOTATE_CLASS_QNAME, ANNOTATE_ENUM_QNAME, ANNOTATE_ENUM_CONSTANT_QNAME, ANNOTATE_PROPERTY_QNAME);
    }

    public boolean run(Outline outline, Options options, ErrorHandler errorHandler) {
        JCodeModel codeModel = outline.getCodeModel();
        JClass collectionElementTypeAnnotation = codeModel.ref("org.jpmml.model.annotations.CollectionElementType");
        Collection classOutlines = outline.getClasses();
        for (ClassOutline classOutline : classOutlines) {
            JDefinedClass beanClazz = classOutline.implClass;
            List<CPluginCustomization> classCustomizations = CustomizationUtil.findCustomizations((CustomizableOutline)classOutline, ANNOTATE_CLASS_QNAME);
            for (CPluginCustomization classCustomization : classCustomizations) {
                AnnotatePlugin.annotate(codeModel, (JAnnotatable)beanClazz, classCustomization);
            }
            Map fieldVars = beanClazz.fields();
            FieldOutline[] fieldOutlines = classOutline.getDeclaredFields();
            for (FieldOutline fieldOutline : fieldOutlines) {
                CPropertyInfo propertyInfo = fieldOutline.getPropertyInfo();
                JFieldVar fieldVar = (JFieldVar)fieldVars.get(propertyInfo.getName(false));
                List<CPluginCustomization> propertyCustomizations = CustomizationUtil.findPropertyCustomizationsInProperty(propertyInfo, ANNOTATE_PROPERTY_QNAME);
                for (CPluginCustomization propertyCustomization : propertyCustomizations) {
                    AnnotatePlugin.annotate(codeModel, (JAnnotatable)fieldVar, propertyCustomization);
                }
                if (!propertyInfo.isCollection()) continue;
                JClass elementType = (JClass)CodeModelUtil.getElementType(fieldVar.type());
                JAnnotationUse jAnnotationUse = fieldVar.annotate(collectionElementTypeAnnotation).param("value", elementType.dotclass());
            }
        }
        Collection enumOutlines = outline.getEnums();
        for (EnumOutline enumOutline : enumOutlines) {
            JDefinedClass clazz = enumOutline.clazz;
            CPluginCustomization enumCustomization = CustomizationUtil.findCustomization((CustomizableOutline)enumOutline, ANNOTATE_ENUM_QNAME);
            if (enumCustomization != null) {
                AnnotatePlugin.annotate(codeModel, (JAnnotatable)clazz, enumCustomization);
            }
            List enumConstantOutlines = enumOutline.constants;
            for (EnumConstantOutline enumConstantOutline : enumConstantOutlines) {
                List<CPluginCustomization> enumConstantCustomizations = CustomizationUtil.findCustomizations((CCustomizable)enumConstantOutline.target, ANNOTATE_ENUM_CONSTANT_QNAME);
                for (CPluginCustomization enumConstantCustomization : enumConstantCustomizations) {
                    AnnotatePlugin.annotate(codeModel, (JAnnotatable)enumConstantOutline.constRef, enumConstantCustomization);
                }
            }
        }
        return true;
    }

    static void annotate(JCodeModel codeModel, JAnnotatable owner, CPluginCustomization customization) {
        String[] classAndValue = AnnotatePlugin.parseCustomization(customization);
        switch (classAndValue[0]) {
            case "org.jpmml.model.annotations.NullSafeGetter": 
            case "org.jpmml.model.annotations.ValueConstructorParameter": {
                return;
            }
        }
        JClass annotationClass = codeModel.ref(classAndValue[0]);
        JAnnotationUse annotationUse = owner.annotate(annotationClass);
        if (classAndValue.length > 1) {
            String[] params;
            for (String param : params = classAndValue[1].split(",")) {
                String value;
                String name;
                int index = param.indexOf(61);
                if (index < 0) {
                    name = "value";
                    value = param;
                } else {
                    name = param.substring(0, index).trim();
                    value = param.substring(index + 1).trim();
                }
                annotationUse = annotationUse.param(name, JExpr.direct((String)value));
            }
        }
    }

    static String[] parseCustomization(CPluginCustomization customization) {
        String content = customization.element.getTextContent();
        Matcher matcher = PATTERN.matcher(content);
        if (matcher.matches()) {
            return new String[]{matcher.group(1), matcher.group(2)};
        }
        return new String[]{content};
    }
}

