/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xjc;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAnnotationValue;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JEnumConstant;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JGenerable;
import com.sun.istack.build.NameConverter;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.model.CAttributePropertyInfo;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CElementPropertyInfo;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.CReferencePropertyInfo;
import com.sun.tools.xjc.model.CTypeRef;
import com.sun.tools.xjc.model.CValuePropertyInfo;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.EnumConstantOutline;
import com.sun.tools.xjc.outline.EnumOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jpmml.xjc.CodeModelUtil;
import org.xml.sax.ErrorHandler;

public class JacksonPlugin
extends Plugin {
    public String getOptionName() {
        return "Xjackson";
    }

    public String getUsage() {
        return null;
    }

    public boolean run(Outline outline, Options options, ErrorHandler errorHandler) {
        JCodeModel codeModel = outline.getCodeModel();
        Collection classOutlines = outline.getClasses();
        for (ClassOutline classOutline : classOutlines) {
            FieldOutline[] fieldOutlines;
            JDefinedClass beanClazz = classOutline.implClass;
            List<JAnnotationUse> beanClazzAnnotations = CodeModelUtil.getAnnotations((JAnnotatable)beanClazz);
            JAnnotationUse xmlRootElement = CodeModelUtil.findAnnotation(beanClazzAnnotations, XmlRootElement.class);
            if (xmlRootElement != null) {
                Map annotationMembers = xmlRootElement.getAnnotationMembers();
                JAnnotationValue nameValue = (JAnnotationValue)annotationMembers.get("name");
                JAnnotationUse jAnnotationUse = beanClazz.annotate(JsonRootName.class).param("value", CodeModelUtil.stringValue((JGenerable)nameValue));
            }
            if ((fieldOutlines = classOutline.getDeclaredFields()).length == 0) continue;
            Map fieldVars = beanClazz.fields();
            JAnnotationUse jsonPropertyOrder = beanClazz.annotate(JsonPropertyOrder.class);
            JAnnotationArrayMember fieldNameArray = jsonPropertyOrder.paramArray("value");
            for (FieldOutline fieldOutline : fieldOutlines) {
                JAnnotationUse jAnnotationUse;
                CPropertyInfo propertyInfo = fieldOutline.getPropertyInfo();
                JFieldVar fieldVar = (JFieldVar)fieldVars.get(propertyInfo.getName(false));
                String propertyName = fieldVar.name();
                fieldNameArray.param(propertyName);
                if (propertyInfo instanceof CAttributePropertyInfo) {
                    CAttributePropertyInfo attributePropertyInfo = (CAttributePropertyInfo)propertyInfo;
                    QName xmlName = attributePropertyInfo.getXmlName();
                    JAnnotationUse jAnnotationUse2 = fieldVar.annotate(JsonProperty.class).param("value", xmlName.getLocalPart());
                    continue;
                }
                if (propertyInfo instanceof CElementPropertyInfo) {
                    JAnnotationUse jAnnotationUse3;
                    JAnnotationUse jsonTypeInfo;
                    JAnnotationUse jsonProperty;
                    CElementPropertyInfo elementPropertyInfo = (CElementPropertyInfo)propertyInfo;
                    List types = elementPropertyInfo.getTypes();
                    if ("node".equals(propertyName) || "nodes".equals(propertyName)) {
                        jsonProperty = fieldVar.annotate(JsonProperty.class).param("value", "Node");
                        JClass complexNodeClass = codeModel.ref("org.dmg.pmml.tree.ComplexNode");
                        jsonTypeInfo = fieldVar.annotate(JsonTypeInfo.class).param("use", (Enum)JsonTypeInfo.Id.NONE).param("defaultImpl", JExpr.dotclass((JClass)complexNodeClass));
                        jAnnotationUse3 = fieldVar.annotate(JsonDeserialize.class).param("node".equals(propertyName) ? "as" : "contentAs", JExpr.dotclass((JClass)complexNodeClass));
                        continue;
                    }
                    if ("scoreDistributions".equals(propertyName)) {
                        jsonProperty = fieldVar.annotate(JsonProperty.class).param("value", "ScoreDistribution");
                        JClass complexScoreDistributionClass = codeModel.ref("org.dmg.pmml.ComplexScoreDistribution");
                        jsonTypeInfo = fieldVar.annotate(JsonTypeInfo.class).param("use", (Enum)JsonTypeInfo.Id.NONE).param("defaultImpl", JExpr.dotclass((JClass)complexScoreDistributionClass));
                        jAnnotationUse3 = fieldVar.annotate(JsonDeserialize.class).param("contentAs", JExpr.dotclass((JClass)complexScoreDistributionClass));
                        continue;
                    }
                    if (types.size() == 1) {
                        CTypeRef type = (CTypeRef)types.get(0);
                        QName xmlName = type.getTagName();
                        jsonTypeInfo = fieldVar.annotate(JsonProperty.class).param("value", xmlName.getLocalPart());
                        continue;
                    }
                    if (types.size() > 1) {
                        if (!propertyName.equals("content") && (propertyName = NameConverter.standard.toPropertyName(propertyName)).endsWith("s")) {
                            propertyName = propertyName.substring(0, propertyName.length() - 1);
                        }
                        jsonProperty = fieldVar.annotate(JsonProperty.class).param("value", propertyName);
                        JAnnotationUse jsonTypeInfo2 = fieldVar.annotate(JsonTypeInfo.class).param("include", (Enum)JsonTypeInfo.As.WRAPPER_OBJECT).param("use", (Enum)JsonTypeInfo.Id.NAME);
                        JAnnotationUse jsonSubTypes = fieldVar.annotate(JsonSubTypes.class);
                        JAnnotationArrayMember valueArray = jsonSubTypes.paramArray("value");
                        for (CTypeRef type : types) {
                            CClassInfo typeClassInfo = (CClassInfo)type.getTarget();
                            JClass clazz = codeModel.ref(typeClassInfo.fullName());
                            JAnnotationUse jAnnotationUse4 = valueArray.annotate(JsonSubTypes.Type.class).param("name", clazz.name()).param("value", JExpr.dotclass((JClass)clazz));
                        }
                        continue;
                    }
                    throw new RuntimeException();
                }
                if (propertyInfo instanceof CReferencePropertyInfo) {
                    CReferencePropertyInfo referencePropertyInfo = (CReferencePropertyInfo)propertyInfo;
                    jAnnotationUse = fieldVar.annotate(JsonProperty.class).param("value", "content");
                    continue;
                }
                if (propertyInfo instanceof CValuePropertyInfo) {
                    CValuePropertyInfo valuePropertyInfo = (CValuePropertyInfo)propertyInfo;
                    jAnnotationUse = fieldVar.annotate(JsonProperty.class).param("value", "value");
                    continue;
                }
                throw new RuntimeException();
            }
        }
        Collection enumOutlines = outline.getEnums();
        for (EnumOutline enumOutline : enumOutlines) {
            JDefinedClass clazz = enumOutline.clazz;
            List enumConstantOutlines = enumOutline.constants;
            for (EnumConstantOutline enumConstantOutline : enumConstantOutlines) {
                JEnumConstant enumConstant = enumConstantOutline.constRef;
                enumConstant.annotate(JsonProperty.class).param("value", enumConstantOutline.target.getLexicalValue());
            }
        }
        return true;
    }
}

