/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xjc;

import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JGenerable;
import com.sun.codemodel.JType;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;

public class CodeModelUtil {
    private CodeModelUtil() {
    }

    public static JType getElementType(JType collectionType) {
        JClass collectionClazz = (JClass)collectionType;
        List elementTypes = collectionClazz.getTypeParameters();
        if (elementTypes.size() != 1) {
            throw new IllegalArgumentException();
        }
        return (JType)elementTypes.get(0);
    }

    public static boolean hasAnnotation(Collection<JAnnotationUse> annotations, Class<?> clazz) {
        JAnnotationUse annotation = CodeModelUtil.findAnnotation(annotations, clazz);
        return annotation != null;
    }

    public static JAnnotationUse findAnnotation(Collection<JAnnotationUse> annotations, Class<?> clazz) {
        String fullName = clazz.getName();
        for (JAnnotationUse annotation : annotations) {
            JClass type = annotation.getAnnotationClass();
            if (!type.fullName().equals(fullName)) continue;
            return annotation;
        }
        return null;
    }

    public static List<JAnnotationUse> getAnnotations(JAnnotatable annotatable) {
        try {
            Field annotationsField;
            Class<?> clazz = annotatable.getClass();
            while (true) {
                try {
                    annotationsField = clazz.getDeclaredField("annotations");
                }
                catch (NoSuchFieldException nsfe) {
                    if ((clazz = clazz.getSuperclass()) != null) continue;
                    throw nsfe;
                }
                break;
            }
            CodeModelUtil.ensureAccessible(annotationsField);
            return (List)annotationsField.get(annotatable);
        }
        catch (ReflectiveOperationException roe) {
            throw new RuntimeException(roe);
        }
    }

    public static String stringValue(JGenerable generable) {
        String result;
        try (StringWriter writer = new StringWriter();){
            generable.generate(new JFormatter((Writer)writer));
            result = writer.toString();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        if (result.length() < 2 || !result.startsWith("\"") || !result.endsWith("\"")) {
            throw new RuntimeException();
        }
        result = result.substring(1, result.length() - 1);
        return result;
    }

    static void ensureAccessible(AccessibleObject accessibleObject) {
        if (!accessibleObject.isAccessible()) {
            accessibleObject.setAccessible(true);
        }
    }
}

