/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xjc;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JOp;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.model.CAdapter;
import com.sun.tools.xjc.model.CPluginCustomization;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.jpmml.xjc.AnnotatePlugin;
import org.jpmml.xjc.CustomizationUtil;
import org.jpmml.xjc.OutlineUtil;
import org.xml.sax.ErrorHandler;

public class ValueConstructorPlugin
extends Plugin {
    public String getOptionName() {
        return "XvalueConstructor";
    }

    public String getUsage() {
        return null;
    }

    public boolean run(Outline outline, Options options, ErrorHandler errorHandler) {
        JCodeModel codeModel = outline.getCodeModel();
        JClass alternateValueConstructorAnnotation = codeModel.ref("org.jpmml.model.annotations.AlternateValueConstructor");
        JClass propertyAnnotation = codeModel.ref("org.jpmml.model.annotations.Property");
        JClass valueConstructorAnnotation = codeModel.ref("org.jpmml.model.annotations.ValueConstructor");
        JClass objectClass = codeModel.ref(Object.class);
        JClass fieldClass = codeModel.ref("org.dmg.pmml.Field").narrow(objectClass.wildcard());
        Collection classOutlines = outline.getClasses();
        for (ClassOutline classOutline : classOutlines) {
            JClass beanSuperClazz;
            JDefinedClass beanClazz = classOutline.implClass;
            Map fieldVars = beanClazz.fields();
            FieldOutline[] fieldOutlines = ValueConstructorPlugin.getRequiredFields(beanClazz, classOutline);
            if (fieldOutlines.length == 0) continue;
            JMethod defaultConstructor = beanClazz.getConstructor(new JType[0]);
            if (defaultConstructor == null) {
                defaultConstructor = beanClazz.constructor(1);
            }
            JMethod valueConstructor = beanClazz.constructor(1);
            valueConstructor.annotate(valueConstructorAnnotation);
            boolean hasFieldName = false;
            for (FieldOutline fieldOutline : fieldOutlines) {
                CPropertyInfo propertyInfo = fieldOutline.getPropertyInfo();
                hasFieldName |= ValueConstructorPlugin.isFieldName(outline, propertyInfo);
                JFieldVar fieldVar = (JFieldVar)fieldVars.get(propertyInfo.getName(false));
                JVar param = valueConstructor.param(fieldVar.type(), fieldVar.name());
                param.annotate(propertyAnnotation).param("value", fieldVar.name());
                valueConstructor.body().assign((JAssignmentTarget)JExpr.refthis((String)fieldVar.name()), (JExpression)param);
            }
            if (!hasFieldName || ValueConstructorPlugin.checkType((JType)(beanSuperClazz = beanClazz._extends()).erasure(), "org.dmg.pmml.Field")) continue;
            JMethod alternateValueConstructor = beanClazz.constructor(1);
            alternateValueConstructor.annotate(alternateValueConstructorAnnotation);
            JInvocation invocation = alternateValueConstructor.body().invoke("this");
            for (FieldOutline fieldOutline : fieldOutlines) {
                CPropertyInfo propertyInfo = fieldOutline.getPropertyInfo();
                JFieldVar fieldVar = (JFieldVar)fieldVars.get(propertyInfo.getName(false));
                if (ValueConstructorPlugin.isFieldName(outline, propertyInfo)) {
                    String name = fieldVar.name();
                    if (!name.equals("field") && !name.endsWith("Field")) {
                        name = name + "Field";
                    }
                    JVar param = alternateValueConstructor.param((JType)fieldClass, name);
                    invocation.arg(JOp.cond((JExpression)param.ne(JExpr._null()), (JExpression)param.invoke("requireName"), (JExpression)JExpr._null()));
                    continue;
                }
                JVar param = alternateValueConstructor.param(fieldVar.type(), fieldVar.name());
                invocation.arg((JExpression)param);
            }
        }
        return true;
    }

    private static FieldOutline[] getRequiredFields(final JDefinedClass beanClazz, ClassOutline classOutline) {
        Predicate<FieldOutline> predicate = new Predicate<FieldOutline>(){

            @Override
            public boolean test(FieldOutline fieldOutline) {
                CPropertyInfo propertyInfo = fieldOutline.getPropertyInfo();
                boolean required = OutlineUtil.isRequired(beanClazz, propertyInfo);
                List<CPluginCustomization> propertyCustomizations = CustomizationUtil.findPropertyCustomizationsInProperty(propertyInfo, AnnotatePlugin.ANNOTATE_PROPERTY_QNAME);
                for (CPluginCustomization propertyCustomization : propertyCustomizations) {
                    String[] classAndValue = AnnotatePlugin.parseCustomization(propertyCustomization);
                    switch (classAndValue[0]) {
                        case "org.jpmml.model.annotations.ValueConstructorParameter": {
                            if (classAndValue.length > 1) {
                                switch (classAndValue[1]) {
                                    case "false": {
                                        return false;
                                    }
                                    case "true": {
                                        break;
                                    }
                                    default: {
                                        throw new IllegalArgumentException();
                                    }
                                }
                            }
                            required |= true;
                            break;
                        }
                    }
                }
                return required;
            }
        };
        return (FieldOutline[])Arrays.stream(classOutline.getDeclaredFields()).filter(predicate).toArray(FieldOutline[]::new);
    }

    private static boolean isFieldName(Outline outline, CPropertyInfo propertyInfo) {
        CAdapter adapter = propertyInfo.getAdapter();
        if (adapter != null) {
            JClass adapterClass = adapter.getAdapterClass(outline);
            return ValueConstructorPlugin.checkType((JType)adapterClass, "org.dmg.pmml.adapters.FieldNameAdapter");
        }
        return false;
    }

    private static boolean checkType(JType type, String fullName) {
        return type.fullName().equals(fullName);
    }
}

