/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xjc;

import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocCommentable;
import com.sun.codemodel.JMethod;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.EnumOutline;
import com.sun.tools.xjc.outline.Outline;
import java.lang.reflect.Field;
import java.util.Collection;
import org.xml.sax.ErrorHandler;

public class NoJavadocPlugin
extends Plugin {
    public String getOptionName() {
        return "Xno-javadoc";
    }

    public String getUsage() {
        return null;
    }

    public boolean run(Outline outline, Options options, ErrorHandler errorHandler) {
        JCodeModel codeModel = outline.getCodeModel();
        Collection classOutlines = outline.getClasses();
        for (ClassOutline classOutline : classOutlines) {
            JDefinedClass beanClazz = classOutline.implClass;
            NoJavadocPlugin.nullifyJavadoc(beanClazz);
        }
        Collection enumOutlines = outline.getEnums();
        for (EnumOutline enumOutline : enumOutlines) {
            JDefinedClass clazz = enumOutline.clazz;
            NoJavadocPlugin.nullifyJavadoc(clazz);
        }
        return true;
    }

    private static void nullifyJavadoc(JDefinedClass clazz) {
        NoJavadocPlugin.nullifyJavadoc((JDocCommentable)clazz);
        Collection methods = clazz.methods();
        for (JMethod method : methods) {
            NoJavadocPlugin.nullifyJavadoc((JDocCommentable)method);
        }
    }

    private static void nullifyJavadoc(JDocCommentable commentable) {
        Class<?> clazz = commentable.getClass();
        try {
            Field jdocField = clazz.getDeclaredField("jdoc");
            if (!jdocField.isAccessible()) {
                jdocField.setAccessible(true);
            }
            jdocField.set(commentable, null);
        }
        catch (ReflectiveOperationException roe) {
            throw new RuntimeException(roe);
        }
    }
}

