/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xjc;

import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JFieldVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.model.CCustomizations;
import com.sun.tools.xjc.model.CPluginCustomization;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.EnumConstantOutline;
import com.sun.tools.xjc.outline.EnumOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.jvnet.jaxb2_commons.plugin.AbstractParameterizablePlugin;
import org.jvnet.jaxb2_commons.util.CustomizationUtils;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;

public class AnnotatePlugin
extends AbstractParameterizablePlugin {
    private static final Pattern PATTERN = Pattern.compile("(.+)\\((.+)\\)");
    private static final String NAMESPACE_URI = "http://annox.dev.java.net";
    private static final QName ANNOTATE_CLASS_QNAME = new QName("http://annox.dev.java.net", "annotateClass");
    private static final QName ANNOTATE_ENUM_QNAME = new QName("http://annox.dev.java.net", "annotateEnum");
    private static final QName ANNOTATE_ENUM_CONSTANT_QNAME = new QName("http://annox.dev.java.net", "annotateEnumConstant");
    private static final QName ANNOTATE_PROPERTY_QNAME = new QName("http://annox.dev.java.net", "annotateProperty");

    public String getOptionName() {
        return "Xannotate";
    }

    public String getUsage() {
        return null;
    }

    public Collection<QName> getCustomizationElementNames() {
        return Arrays.asList(ANNOTATE_CLASS_QNAME, ANNOTATE_ENUM_QNAME, ANNOTATE_ENUM_CONSTANT_QNAME, ANNOTATE_PROPERTY_QNAME);
    }

    public boolean run(Outline outline, Options options, ErrorHandler errorHandler) {
        JCodeModel codeModel = outline.getCodeModel();
        Collection classOutlines = outline.getClasses();
        for (ClassOutline classOutline : classOutlines) {
            JDefinedClass beanClazz = classOutline.implClass;
            CPluginCustomization classCustomization = CustomizationUtils.findCustomization((ClassOutline)classOutline, (QName)ANNOTATE_CLASS_QNAME);
            if (classCustomization != null) {
                AnnotatePlugin.annotate(codeModel, (JAnnotatable)beanClazz, classCustomization);
            }
            Map fieldVars = beanClazz.fields();
            FieldOutline[] fieldOutlines = classOutline.getDeclaredFields();
            for (FieldOutline fieldOutline : fieldOutlines) {
                CPropertyInfo propertyInfo = fieldOutline.getPropertyInfo();
                List propertyCustomizations = CustomizationUtils.findPropertyCustomizationsInProperty((CPropertyInfo)propertyInfo, (QName)ANNOTATE_PROPERTY_QNAME);
                for (CPluginCustomization propertyCustomization : propertyCustomizations) {
                    JFieldVar fieldVar = (JFieldVar)fieldVars.get(propertyInfo.getName(false));
                    AnnotatePlugin.annotate(codeModel, (JAnnotatable)fieldVar, propertyCustomization);
                }
            }
        }
        Collection enumOutlines = outline.getEnums();
        for (EnumOutline enumOutline : enumOutlines) {
            JDefinedClass clazz = enumOutline.clazz;
            CPluginCustomization enumCustomization = CustomizationUtils.findCustomization((EnumOutline)enumOutline, (QName)ANNOTATE_ENUM_QNAME);
            if (enumCustomization != null) {
                AnnotatePlugin.annotate(codeModel, (JAnnotatable)clazz, enumCustomization);
            }
            List enumConstantOutlines = enumOutline.constants;
            for (EnumConstantOutline enumConstantOutline : enumConstantOutlines) {
                CCustomizations enumConstantCustomizations = enumConstantOutline.target.getCustomizations();
                for (CPluginCustomization enumConstantCustomization : enumConstantCustomizations) {
                    Element element = enumConstantCustomization.element;
                    if (!ANNOTATE_ENUM_CONSTANT_QNAME.getNamespaceURI().equals(element.getNamespaceURI()) || !ANNOTATE_ENUM_CONSTANT_QNAME.getLocalPart().equals(element.getLocalName())) continue;
                    AnnotatePlugin.annotate(codeModel, (JAnnotatable)enumConstantOutline.constRef, enumConstantCustomization);
                    enumConstantCustomization.markAsAcknowledged();
                }
            }
        }
        return true;
    }

    private static JAnnotationUse annotate(JCodeModel codeModel, JAnnotatable owner, CPluginCustomization customization) {
        String content = customization.element.getTextContent();
        Matcher matcher = PATTERN.matcher(content);
        if (matcher.matches()) {
            JClass annotationClass = codeModel.ref(matcher.group(1));
            return owner.annotate(annotationClass).param("value", JExpr.direct((String)matcher.group(2)));
        }
        JClass annotationClass = codeModel.ref(content);
        return owner.annotate(annotationClass);
    }
}

