/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xjc;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JEnumConstant;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JFieldVar;
import com.sun.istack.build.NameConverter;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.model.CAttributePropertyInfo;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CElementPropertyInfo;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.CReferencePropertyInfo;
import com.sun.tools.xjc.model.CTypeRef;
import com.sun.tools.xjc.model.CValuePropertyInfo;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.EnumConstantOutline;
import com.sun.tools.xjc.outline.EnumOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jvnet.jaxb2_commons.plugin.AbstractParameterizablePlugin;
import org.xml.sax.ErrorHandler;

public class JacksonPlugin
extends AbstractParameterizablePlugin {
    public String getOptionName() {
        return "Xjackson";
    }

    public String getUsage() {
        return null;
    }

    public boolean run(Outline outline, Options options, ErrorHandler errorHandler) {
        JCodeModel codeModel = outline.getCodeModel();
        Collection classOutlines = outline.getClasses();
        for (ClassOutline classOutline : classOutlines) {
            JDefinedClass beanClazz = classOutline.implClass;
            JAnnotationUse jsonAutoDetect = beanClazz.annotate(JsonAutoDetect.class).param("fieldVisibility", (Enum)JsonAutoDetect.Visibility.ANY).param("getterVisibility", (Enum)JsonAutoDetect.Visibility.NONE).param("isGetterVisibility", (Enum)JsonAutoDetect.Visibility.NONE).param("setterVisibility", (Enum)JsonAutoDetect.Visibility.NONE);
            JAnnotationUse jsonInclude = beanClazz.annotate(JsonInclude.class).param("value", (Enum)JsonInclude.Include.NON_EMPTY);
            FieldOutline[] fieldOutlines = classOutline.getDeclaredFields();
            if (fieldOutlines.length == 0) continue;
            Map fieldVars = beanClazz.fields();
            JAnnotationUse jsonPropertyOrder = beanClazz.annotate(JsonPropertyOrder.class);
            JAnnotationArrayMember fieldNameArray = jsonPropertyOrder.paramArray("value");
            for (FieldOutline fieldOutline : fieldOutlines) {
                JAnnotationUse jAnnotationUse;
                CPropertyInfo propertyInfo = fieldOutline.getPropertyInfo();
                JFieldVar fieldVar = (JFieldVar)fieldVars.get(propertyInfo.getName(false));
                String propertyName = fieldVar.name();
                fieldNameArray.param(propertyName);
                if (propertyInfo instanceof CAttributePropertyInfo) {
                    CAttributePropertyInfo attributePropertyInfo = (CAttributePropertyInfo)propertyInfo;
                    QName xmlName = attributePropertyInfo.getXmlName();
                    JAnnotationUse jAnnotationUse2 = fieldVar.annotate(JsonProperty.class).param("value", xmlName.getLocalPart());
                    continue;
                }
                if (propertyInfo instanceof CElementPropertyInfo) {
                    JAnnotationArrayMember valueArray;
                    JAnnotationUse jsonSubTypes;
                    JAnnotationUse jsonTypeInfo;
                    JAnnotationUse jsonProperty;
                    CElementPropertyInfo elementPropertyInfo = (CElementPropertyInfo)propertyInfo;
                    List types = elementPropertyInfo.getTypes();
                    if ("node".equals(propertyName) || "nodes".equals(propertyName)) {
                        jsonProperty = fieldVar.annotate(JsonProperty.class).param("value", "Node");
                        jsonTypeInfo = fieldVar.annotate(JsonTypeInfo.class).param("include", (Enum)JsonTypeInfo.As.WRAPPER_OBJECT).param("use", (Enum)JsonTypeInfo.Id.NAME);
                        jsonSubTypes = fieldVar.annotate(JsonSubTypes.class);
                        valueArray = jsonSubTypes.paramArray("value");
                        JClass complexNodeClass = codeModel.ref("org.dmg.pmml.tree.ComplexNode");
                        JAnnotationUse jsonSubTypesType = jsonSubTypes.annotate(JsonSubTypes.Type.class).param("name", "Node").param("value", JExpr.dotclass((JClass)complexNodeClass));
                        valueArray.param(jsonSubTypesType);
                        continue;
                    }
                    if (types.size() == 1) {
                        CTypeRef type = (CTypeRef)types.get(0);
                        QName xmlName = type.getTagName();
                        jsonSubTypes = fieldVar.annotate(JsonProperty.class).param("value", xmlName.getLocalPart());
                        continue;
                    }
                    if (types.size() > 1) {
                        if (!propertyName.equals("content") && (propertyName = NameConverter.standard.toPropertyName(propertyName)).endsWith("s")) {
                            propertyName = propertyName.substring(0, propertyName.length() - 1);
                        }
                        jsonProperty = fieldVar.annotate(JsonProperty.class).param("value", propertyName);
                        jsonTypeInfo = fieldVar.annotate(JsonTypeInfo.class).param("include", (Enum)JsonTypeInfo.As.WRAPPER_OBJECT).param("use", (Enum)JsonTypeInfo.Id.NAME);
                        jsonSubTypes = fieldVar.annotate(JsonSubTypes.class);
                        valueArray = jsonSubTypes.paramArray("value");
                        for (CTypeRef type : types) {
                            CClassInfo classInfo = (CClassInfo)type.getTarget();
                            JClass clazz = codeModel.ref(classInfo.fullName());
                            JAnnotationUse jsonSubTypesType = jsonSubTypes.annotate(JsonSubTypes.Type.class).param("name", clazz.name()).param("value", JExpr.dotclass((JClass)clazz));
                            valueArray.param(jsonSubTypesType);
                        }
                        continue;
                    }
                    throw new RuntimeException();
                }
                if (propertyInfo instanceof CReferencePropertyInfo) {
                    CReferencePropertyInfo referencePropertyInfo = (CReferencePropertyInfo)propertyInfo;
                    jAnnotationUse = fieldVar.annotate(JsonProperty.class).param("value", "content");
                    continue;
                }
                if (propertyInfo instanceof CValuePropertyInfo) {
                    CValuePropertyInfo valuePropertyInfo = (CValuePropertyInfo)propertyInfo;
                    jAnnotationUse = fieldVar.annotate(JsonProperty.class).param("value", "value");
                    continue;
                }
                throw new RuntimeException();
            }
        }
        Collection enumOutlines = outline.getEnums();
        for (EnumOutline enumOutline : enumOutlines) {
            JDefinedClass clazz = enumOutline.clazz;
            List enumConstantOutlines = enumOutline.constants;
            for (EnumConstantOutline enumConstantOutline : enumConstantOutlines) {
                JEnumConstant enumConstant = enumConstantOutline.constRef;
                enumConstant.annotate(JsonProperty.class).param("value", enumConstantOutline.target.getLexicalValue());
            }
        }
        return true;
    }
}

