/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xjc;

import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JCommentPart;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JJavaName;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JMods;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JStringLiteral;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.model.CAttributePropertyInfo;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CClassInfoParent;
import com.sun.tools.xjc.model.CDefaultValue;
import com.sun.tools.xjc.model.CPluginCustomization;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.namespace.QName;
import org.eclipse.persistence.oxm.annotations.XmlValueExtension;
import org.jpmml.xjc.CodeModelUtil;
import org.jvnet.jaxb2_commons.plugin.AbstractParameterizablePlugin;
import org.jvnet.jaxb2_commons.util.CustomizationUtils;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;

public class PMMLPlugin
extends AbstractParameterizablePlugin {
    public static QName SUBPACKAGE_ELEMENT_NAME = new QName("http://jpmml.org/jpmml-model", "subpackage");

    public String getOptionName() {
        return "Xpmml";
    }

    public String getUsage() {
        return null;
    }

    public Collection<QName> getCustomizationElementNames() {
        return Arrays.asList(SUBPACKAGE_ELEMENT_NAME);
    }

    public void postProcessModel(Model model, ErrorHandler errorHandler) {
        super.postProcessModel(model, errorHandler);
        JCodeModel codeModel = model.codeModel;
        JClass pmmlObjectClass = codeModel.ref("org.dmg.pmml.PMMLObject");
        JClass activationFunctionEnum = codeModel.directClass("org.dmg.pmml.neural_network.NeuralNetwork.ActivationFunction");
        JClass normalizationMethodEnum = codeModel.directClass("org.dmg.pmml.neural_network.NeuralNetwork.NormalizationMethod");
        Comparator<CPropertyInfo> comparator = new Comparator<CPropertyInfo>(){

            @Override
            public int compare(CPropertyInfo left, CPropertyInfo right) {
                boolean leftAttribute = left instanceof CAttributePropertyInfo;
                boolean rightAttribute = right instanceof CAttributePropertyInfo;
                if (leftAttribute && !rightAttribute) {
                    return -1;
                }
                if (!leftAttribute && rightAttribute) {
                    return 1;
                }
                return 0;
            }
        };
        Map beans = model.beans();
        Collection classInfos = beans.values();
        for (CClassInfo classInfo : classInfos) {
            CPluginCustomization subpackageCustomization = CustomizationUtils.findCustomization((CClassInfo)classInfo, (QName)SUBPACKAGE_ELEMENT_NAME);
            if (subpackageCustomization != null) {
                CClassInfoParent.Package packageParent = (CClassInfoParent.Package)classInfo.parent();
                Element element = subpackageCustomization.element;
                String name = element.getAttribute("name");
                if (name == null) {
                    throw new RuntimeException();
                }
                try {
                    Field field = CClassInfoParent.Package.class.getDeclaredField("pkg");
                    field.setAccessible(true);
                    JPackage subPackage = packageParent.pkg.subPackage(name);
                    field.set(packageParent, subPackage);
                }
                catch (ReflectiveOperationException roe) {
                    throw new RuntimeException(roe);
                }
            }
            List propertyInfos = classInfo.getProperties();
            Collections.sort(propertyInfos, comparator);
            for (CPropertyInfo propertyInfo : propertyInfos) {
                CDefaultValue defaultValue;
                String publicName = propertyInfo.getName(true);
                String privateName = propertyInfo.getName(false);
                if (propertyInfo.isCollection()) {
                    if (classInfo.shortName.equals("VectorFields") && privateName.equals("fieldRefOrCategoricalPredictor")) {
                        propertyInfo.baseType = pmmlObjectClass;
                    }
                    if (privateName.contains("And") || privateName.contains("Or") || privateName.equalsIgnoreCase("content")) {
                        propertyInfo.setName(true, "Content");
                        propertyInfo.setName(false, "content");
                        continue;
                    }
                    if (privateName.endsWith("array") || privateName.endsWith("Array")) {
                        publicName = publicName + "s";
                        privateName = privateName + "s";
                    } else if (privateName.endsWith("ref") || privateName.endsWith("Ref")) {
                        publicName = publicName + "s";
                        privateName = privateName + "s";
                    } else {
                        publicName = JJavaName.getPluralForm((String)publicName);
                        privateName = JJavaName.getPluralForm((String)privateName);
                    }
                    propertyInfo.setName(true, publicName);
                    propertyInfo.setName(false, privateName);
                    continue;
                }
                if (classInfo.shortName.equals("NeuralLayer") && privateName.equals("activationFunction")) {
                    propertyInfo.baseType = activationFunctionEnum;
                } else if (classInfo.shortName.equals("NeuralLayer") && privateName.equals("normalizationMethod")) {
                    propertyInfo.baseType = normalizationMethodEnum;
                }
                if (privateName.equals("isScorable")) {
                    propertyInfo.setName(true, "Scorable");
                    propertyInfo.setName(false, "scorable");
                } else if (privateName.equals("functionName")) {
                    propertyInfo.setName(true, "MiningFunction");
                    propertyInfo.setName(false, "miningFunction");
                }
                if ((defaultValue = propertyInfo.defaultValue) == null) continue;
                propertyInfo.defaultValue = new CShareableDefaultValue(propertyInfo, propertyInfo.defaultValue);
            }
        }
    }

    public boolean run(Outline outline, Options options, ErrorHandler errorHandler) {
        Model model = outline.getModel();
        JCodeModel codeModel = model.codeModel;
        JClass iterableInterface = codeModel.ref("java.lang.Iterable");
        JClass iteratorInterface = codeModel.ref("java.util.Iterator");
        JClass hasExtensionsInterface = codeModel.ref("org.dmg.pmml.HasExtensions");
        JClass arraysClass = codeModel.ref("java.util.Arrays");
        JClass fieldNameClass = codeModel.ref("org.dmg.pmml.FieldName");
        Collection clazzes = outline.getClasses();
        for (ClassOutline clazz : clazzes) {
            FieldOutline[] fields;
            FieldOutline extensionsField;
            JMethod keyMethod;
            JMethod fieldMethod;
            JDefinedClass beanClazz = clazz.implClass;
            if (PMMLPlugin.checkType((JType)beanClazz, "org.dmg.pmml.general_regression.PPCell")) {
                fieldMethod = beanClazz.method(1, (JType)fieldNameClass, "getField");
                fieldMethod.annotate(Override.class);
                fieldMethod.body()._return((JExpression)JExpr.invoke((String)"getPredictorName"));
            } else if (PMMLPlugin.checkType((JType)beanClazz, "org.dmg.pmml.regression.CategoricalPredictor")) {
                fieldMethod = beanClazz.method(1, (JType)fieldNameClass, "getField");
                fieldMethod.annotate(Override.class);
                fieldMethod.body()._return((JExpression)JExpr.invoke((String)"getName"));
            }
            if (PMMLPlugin.checkType((JType)beanClazz, "org.dmg.pmml.DefineFunction") || PMMLPlugin.checkType((JType)beanClazz, "org.dmg.pmml.general_regression.Parameter")) {
                keyMethod = beanClazz.method(1, String.class, "getKey");
                keyMethod.annotate(Override.class);
                keyMethod.body()._return((JExpression)JExpr.invoke((String)"getName"));
            } else if (PMMLPlugin.checkType((JType)beanClazz, "org.dmg.pmml.MiningField")) {
                keyMethod = beanClazz.method(1, (JType)fieldNameClass, "getKey");
                keyMethod.annotate(Override.class);
                keyMethod.body()._return((JExpression)JExpr.invoke((String)"getName"));
            } else if (PMMLPlugin.checkType((JType)beanClazz, "org.dmg.pmml.Target") || PMMLPlugin.checkType((JType)beanClazz, "org.dmg.pmml.VerificationField") || PMMLPlugin.checkType((JType)beanClazz, "org.dmg.pmml.nearest_neighbor.InstanceField")) {
                keyMethod = beanClazz.method(1, (JType)fieldNameClass, "getKey");
                keyMethod.annotate(Override.class);
                keyMethod.body()._return((JExpression)JExpr.invoke((String)"getField"));
            } else if (PMMLPlugin.checkType((JType)beanClazz, "org.dmg.pmml.Value")) {
                keyMethod = beanClazz.method(1, String.class, "getKey");
                keyMethod.annotate(Override.class);
                keyMethod.body()._return((JExpression)JExpr.invoke((String)"getValue"));
            } else if (PMMLPlugin.checkType((JType)beanClazz, "org.dmg.pmml.association.Item") || PMMLPlugin.checkType((JType)beanClazz, "org.dmg.pmml.association.Itemset") || PMMLPlugin.checkType((JType)beanClazz, "org.dmg.pmml.sequence.Sequence") || PMMLPlugin.checkType((JType)beanClazz, "org.dmg.pmml.support_vector_machine.VectorInstance") || PMMLPlugin.checkType((JType)beanClazz, "org.dmg.pmml.text.TextDocument")) {
                keyMethod = beanClazz.method(1, String.class, "getKey");
                keyMethod.annotate(Override.class);
                keyMethod.body()._return((JExpression)JExpr.invoke((String)"getId"));
            }
            if (PMMLPlugin.checkType((JType)beanClazz, "org.dmg.pmml.tree.Node")) {
                JMethod hasScoreMethod = beanClazz.method(1, Boolean.TYPE, "hasScore");
                hasScoreMethod.body()._return(JExpr.refthis((String)"score").ne(JExpr._null()));
            }
            Map fieldVars = beanClazz.fields();
            FieldOutline contentField = PMMLPlugin.getContentField(clazz);
            if (contentField != null) {
                CPropertyInfo propertyInfo = contentField.getPropertyInfo();
                JFieldVar fieldVar = (JFieldVar)fieldVars.get(propertyInfo.getName(false));
                JType elementType = CodeModelUtil.getElementType(fieldVar.type());
                beanClazz._implements(iterableInterface.narrow(elementType));
                JMethod iteratorMethod = beanClazz.method(1, (JType)iteratorInterface.narrow(elementType), "iterator");
                iteratorMethod.body()._return((JExpression)JExpr.invoke((String)("get" + propertyInfo.getName(true))).invoke("iterator"));
            }
            if ((extensionsField = PMMLPlugin.getExtensionsField(clazz)) != null) {
                beanClazz._implements(hasExtensionsInterface);
            }
            for (FieldOutline field : fields = clazz.getDeclaredFields()) {
                Collection annotations;
                JClass boxifiedReturnType;
                JType returnType;
                CPropertyInfo propertyInfo = field.getPropertyInfo();
                JFieldVar fieldVar = (JFieldVar)fieldVars.get(propertyInfo.getName(false));
                JMods modifiers = fieldVar.mods();
                if ((modifiers.getValue() & 4) != 4) {
                    modifiers.setPrivate();
                }
                JType type = fieldVar.type();
                CShareableDefaultValue defaultValue = (CShareableDefaultValue)propertyInfo.defaultValue;
                if (defaultValue != null && defaultValue.isShared()) {
                    beanClazz.field(28, fieldVar.type(), defaultValue.getField(), defaultValue.computeInit(outline));
                }
                JMethod getterMethod = beanClazz.getMethod("get" + propertyInfo.getName(true), new JType[0]);
                JMethod setterMethod = beanClazz.getMethod("set" + propertyInfo.getName(true), new JType[]{type});
                if (getterMethod != null && (returnType = getterMethod.type()).isPrimitive() && !type.isPrimitive() && (boxifiedReturnType = returnType.boxify()).equals(type)) {
                    getterMethod.type((JType)boxifiedReturnType);
                }
                if (setterMethod != null) {
                    setterMethod.type((JType)beanClazz);
                    JVar param = (JVar)setterMethod.params().get(0);
                    String paramName = param.name();
                    param.name(fieldVar.name());
                    JDocComment javadoc = setterMethod.javadoc();
                    try {
                        Map atParams;
                        JCommentPart paramComment;
                        Field atParamsField = JDocComment.class.getDeclaredField("atParams");
                        if (!atParamsField.isAccessible()) {
                            atParamsField.setAccessible(true);
                        }
                        if ((paramComment = (JCommentPart)(atParams = (Map)atParamsField.get(javadoc)).remove(paramName)) != null) {
                            atParams.put(fieldVar.name(), paramComment);
                        }
                    }
                    catch (ReflectiveOperationException roe) {
                        throw new RuntimeException(roe);
                    }
                    setterMethod.body()._return(JExpr._this());
                }
                if (propertyInfo.isCollection()) {
                    JType elementType = CodeModelUtil.getElementType(type);
                    JFieldRef fieldRef = JExpr.refthis((String)fieldVar.name());
                    JMethod hasElementsMethod = beanClazz.method(1, Boolean.TYPE, "has" + propertyInfo.getName(true));
                    hasElementsMethod.body()._return(fieldRef.ne(JExpr._null()).cand(fieldRef.invoke("size").gt(JExpr.lit((int)0))));
                    JMethod addElementsMethod = beanClazz.method(1, (JType)beanClazz, "add" + propertyInfo.getName(true));
                    JVar param = addElementsMethod.varParam(elementType, fieldVar.name());
                    addElementsMethod.body().add((JStatement)JExpr.invoke((JMethod)getterMethod).invoke("addAll").arg((JExpression)arraysClass.staticInvoke("asList").arg((JExpression)param)));
                    addElementsMethod.body()._return(JExpr._this());
                }
                if (!PMMLPlugin.hasAnnotation(annotations = fieldVar.annotations(), XmlValue.class)) continue;
                fieldVar.annotate(XmlValueExtension.class);
            }
        }
        return true;
    }

    private static FieldOutline getExtensionsField(ClassOutline clazz) {
        FieldFilter filter = new FieldFilter(){

            @Override
            public boolean accept(CPropertyInfo propertyInfo, JType type) {
                if ("extensions".equals(propertyInfo.getName(false)) && propertyInfo.isCollection()) {
                    JType elementType = CodeModelUtil.getElementType(type);
                    return PMMLPlugin.checkType(elementType, "org.dmg.pmml.Extension");
                }
                return false;
            }
        };
        return PMMLPlugin.findField(clazz, filter);
    }

    private static FieldOutline getContentField(final ClassOutline clazz) {
        FieldFilter filter = new FieldFilter(){
            private String name;
            {
                this.name = clazz.implClass.name();
            }

            @Override
            public boolean accept(CPropertyInfo propertyInfo, JType type) {
                if (propertyInfo.isCollection()) {
                    JType elementType = CodeModelUtil.getElementType(type);
                    String name = elementType.name();
                    return this.name.equals(name + "s") || this.name.equals(JJavaName.getPluralForm((String)name));
                }
                return false;
            }
        };
        return PMMLPlugin.findField(clazz, filter);
    }

    private static FieldOutline findField(ClassOutline clazz, FieldFilter filter) {
        FieldOutline[] fields;
        for (FieldOutline field : fields = clazz.getDeclaredFields()) {
            JType type;
            CPropertyInfo propertyInfo = field.getPropertyInfo();
            if (!filter.accept(propertyInfo, type = field.getRawType())) continue;
            return field;
        }
        return null;
    }

    private static boolean hasAnnotation(Collection<JAnnotationUse> annotations, Class<?> clazz) {
        JAnnotationUse annotation = PMMLPlugin.findAnnotation(annotations, clazz);
        return annotation != null;
    }

    private static JAnnotationUse findAnnotation(Collection<JAnnotationUse> annotations, Class<?> clazz) {
        String fullName = clazz.getName();
        for (JAnnotationUse annotation : annotations) {
            JClass type = annotation.getAnnotationClass();
            if (!PMMLPlugin.checkType((JType)type, fullName)) continue;
            return annotation;
        }
        return null;
    }

    private static boolean checkType(JType type, String fullName) {
        return type.fullName().equals(fullName);
    }

    private static class CShareableDefaultValue
    extends CDefaultValue {
        private CDefaultValue parent = null;
        private String field = null;

        private CShareableDefaultValue(CPropertyInfo propertyInfo, CDefaultValue parent) {
            this.setParent(parent);
            this.setField(CShareableDefaultValue.formatField(propertyInfo.getName(false)));
        }

        public JExpression compute(Outline outline) {
            JExpression expression = this.computeInit(outline);
            if (expression instanceof JFieldRef || expression instanceof JStringLiteral) {
                this.setField(null);
                return expression;
            }
            return JExpr.ref((String)this.getField());
        }

        public JExpression computeInit(Outline outline) {
            CDefaultValue parent = this.getParent();
            return parent.compute(outline);
        }

        public boolean isShared() {
            String field = this.getField();
            return field != null;
        }

        public CDefaultValue getParent() {
            return this.parent;
        }

        private void setParent(CDefaultValue parent) {
            this.parent = parent;
        }

        public String getField() {
            return this.field;
        }

        private void setField(String field) {
            this.field = field;
        }

        private static String formatField(String string) {
            StringBuilder sb = new StringBuilder();
            sb.append("DEFAULT_");
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (Character.isUpperCase(c)) {
                    sb.append('_');
                }
                sb.append(Character.toUpperCase(c));
            }
            return sb.toString();
        }
    }

    private static interface FieldFilter {
        public boolean accept(CPropertyInfo var1, JType var2);
    }
}

