/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xjc;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JMods;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.model.CAttributePropertyInfo;
import com.sun.tools.xjc.model.CElementPropertyInfo;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.CValuePropertyInfo;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jvnet.jaxb2_commons.plugin.AbstractParameterizablePlugin;
import org.xml.sax.ErrorHandler;

public class ValueConstructorPlugin
extends AbstractParameterizablePlugin {
    private boolean ignoreAttributes = false;
    private boolean ignoreElements = false;
    private boolean ignoreValues = false;

    public String getOptionName() {
        return "XvalueConstructor";
    }

    public String getUsage() {
        return null;
    }

    public boolean run(Outline outline, Options options, ErrorHandler errorHandler) {
        Collection clazzes = outline.getClasses();
        for (ClassOutline clazz : clazzes) {
            JVar param;
            CPropertyInfo propertyInfo;
            JDefinedClass beanClazz = clazz.implClass;
            Map fieldVars = beanClazz.fields();
            List<FieldOutline> superClassFields = this.getSuperClassFields(clazz);
            List<FieldOutline> classFields = this.getClassFields(clazz);
            if (superClassFields.size() <= 0 && classFields.size() <= 0) continue;
            JMethod defaultConstructor = beanClazz.constructor(1);
            JInvocation defaultSuperInvocation = defaultConstructor.body().invoke("super");
            JMethod valueConstructor = beanClazz.constructor(1);
            JInvocation valueSuperInvocation = valueConstructor.body().invoke("super");
            for (FieldOutline superClassField : superClassFields) {
                propertyInfo = superClassField.getPropertyInfo();
                JFieldVar superClassFieldVar = (JFieldVar)fieldVars.get(propertyInfo.getName(false));
                param = valueConstructor.param(8, superClassFieldVar.type(), superClassFieldVar.name());
                valueSuperInvocation.arg((JExpression)param);
            }
            for (FieldOutline classField : classFields) {
                propertyInfo = classField.getPropertyInfo();
                JFieldVar fieldVar = (JFieldVar)fieldVars.get(propertyInfo.getName(false));
                param = valueConstructor.param(8, fieldVar.type(), fieldVar.name());
                valueConstructor.body().assign((JAssignmentTarget)JExpr.refthis((String)fieldVar.name()), (JExpression)param);
            }
        }
        return true;
    }

    private List<FieldOutline> getSuperClassFields(ClassOutline clazz) {
        ArrayList<FieldOutline> result = new ArrayList<FieldOutline>();
        for (ClassOutline superClazz = clazz.getSuperClass(); superClazz != null; superClazz = superClazz.getSuperClass()) {
            result.addAll(0, this.getValueFields(superClazz));
        }
        return result;
    }

    private List<FieldOutline> getClassFields(ClassOutline clazz) {
        return this.getValueFields(clazz);
    }

    private List<FieldOutline> getValueFields(ClassOutline clazz) {
        FieldOutline[] fields;
        ArrayList<FieldOutline> result = new ArrayList<FieldOutline>();
        JDefinedClass beanClazz = clazz.implClass;
        Map fieldVars = beanClazz.fields();
        for (FieldOutline field : fields = clazz.getDeclaredFields()) {
            CElementPropertyInfo elementPropertyInfo;
            CAttributePropertyInfo attributePropertyInfo;
            CPropertyInfo propertyInfo = field.getPropertyInfo();
            JFieldVar fieldVar = (JFieldVar)fieldVars.get(propertyInfo.getName(false));
            JMods modifiers = fieldVar.mods();
            if ((modifiers.getValue() & 0x10) == 16) continue;
            if (propertyInfo instanceof CAttributePropertyInfo && !this.getIgnoreAttributes() && (attributePropertyInfo = (CAttributePropertyInfo)propertyInfo).isRequired()) {
                result.add(field);
            }
            if (propertyInfo instanceof CElementPropertyInfo && !this.getIgnoreElements() && (elementPropertyInfo = (CElementPropertyInfo)propertyInfo).isRequired()) {
                result.add(field);
            }
            if (!(propertyInfo instanceof CValuePropertyInfo) || this.getIgnoreValues()) continue;
            result.add(field);
        }
        return result;
    }

    public boolean getIgnoreAttributes() {
        return this.ignoreAttributes;
    }

    public void setIgnoreAttributes(boolean ignoreAttributes) {
        this.ignoreAttributes = ignoreAttributes;
    }

    public boolean getIgnoreElements() {
        return this.ignoreElements;
    }

    public void setIgnoreElements(boolean ignoreElements) {
        this.ignoreElements = ignoreElements;
    }

    public boolean getIgnoreValues() {
        return this.ignoreValues;
    }

    public void setIgnoreValues(boolean ignoreValues) {
        this.ignoreValues = ignoreValues;
    }
}

