/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xjc;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.model.CCustomizable;
import com.sun.tools.xjc.model.CPluginCustomization;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import com.sun.xml.bind.api.impl.NameConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jpmml.xjc.PluginUtil;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;

public class UnsupportedPropertyPlugin
extends Plugin {
    private static final String JAVA_URI = "http://java.sun.com/java";

    public String getOptionName() {
        return "XunsupportedProperty";
    }

    public String getUsage() {
        return null;
    }

    public List<String> getCustomizationURIs() {
        return Collections.singletonList(JAVA_URI);
    }

    public boolean isCustomizationTagName(String nsUri, String localName) {
        return nsUri.equals(JAVA_URI) && localName.equals("unsupportedProperty");
    }

    public boolean run(Outline outline, Options options, ErrorHandler errorHandler) {
        Model model = outline.getModel();
        JCodeModel codeModel = model.codeModel;
        JClass exceptionClazz = codeModel.ref(UnsupportedOperationException.class);
        Collection clazzes = outline.getClasses();
        for (ClassOutline clazz : clazzes) {
            JDefinedClass beanClazz = clazz.implClass;
            List<CPluginCustomization> customizations = PluginUtil.getAllCustomizations((CCustomizable)clazz.target, this);
            for (CPluginCustomization customization : customizations) {
                Element element = customization.element;
                String property = element.getAttribute("property");
                if (property == null) {
                    throw new IllegalArgumentException();
                }
                String propertyName = NameConverter.standard.toPropertyName(property);
                String name = element.getAttribute("name");
                if (name == null) {
                    throw new IllegalArgumentException();
                }
                JClass nameClazz = codeModel.ref(name);
                JMethod getterMethod = beanClazz.method(1, (JType)nameClazz, "get" + propertyName);
                getterMethod.javadoc().append((Object)("Gets the value of the " + property + " property.")).addThrows(exceptionClazz).append((Object)"Always.");
                getterMethod.annotate(Override.class);
                getterMethod.body()._throw((JExpression)JExpr._new((JClass)exceptionClazz));
                JMethod setterMethod = beanClazz.method(1, (JType)beanClazz, "set" + propertyName);
                setterMethod.javadoc().append((Object)("Sets the value of the " + property + " property.")).addThrows(exceptionClazz).append((Object)"Always.");
                setterMethod.annotate(Override.class);
                setterMethod.param((JType)nameClazz, property);
                setterMethod.body()._throw((JExpression)JExpr._new((JClass)exceptionClazz));
                customization.markAsAcknowledged();
            }
        }
        return true;
    }
}

